/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import com.devexperts.logging.Logging;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.Pair;
import com.rusefi.core.ResponseBuffer;
import com.rusefi.io.LinkDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class EngineState {
    private static final Logging log = Logging.getLogging(EngineState.class);
    public static final String PACKING_DELIMITER = ":";
    public static final Class<EngineState> ENGINE_STATE_CLASS = EngineState.class;
    private final Object lock = new Object();
    private final ResponseBuffer buffer;
    private final List<StringActionPair> actions = new ArrayList<StringActionPair>();
    private final Set<String> keys = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    public void replaceStringValueAction(String key, ValueCallback<String> callback) {
        this.removeAction(key);
        this.registerStringValueAction(key, callback);
    }

    public EngineState(final @NotNull EngineStateListener listener) {
        this.buffer = new ResponseBuffer(new ResponseBuffer.ResponseListener(){

            @Override
            public void onResponse(String response) {
                if (response != null) {
                    int i = response.indexOf("<EOT>: ");
                    if (i != -1) {
                        response = response.substring(i + "<EOT>: ".length());
                    }
                    String copy = response;
                    listener.beforeLine(response);
                    while (!response.isEmpty()) {
                        response = EngineState.this.handleResponse(response, listener);
                    }
                    listener.afterLine(copy);
                }
            }
        });
        this.registerStringValueAction("msg", value -> MessagesCentral.getInstance().postMessage(ENGINE_STATE_CLASS, (String)value));
    }

    public static String packString(String a) {
        return "line:" + a.length() + PACKING_DELIMITER + a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleResponse(String response, EngineStateListener listener) {
        String originalResponse = response;
        Object object = this.lock;
        synchronized (object) {
            for (StringActionPair pair : this.actions) {
                response = EngineState.handleStringActionPair(response, pair, listener);
            }
        }
        if (originalResponse.length() == response.length()) {
            log.info("EngineState.unknown: " + response);
            int keyEnd = response.indexOf("`");
            if (keyEnd == -1) {
                return "";
            }
            String unknownKey = response.substring(0, keyEnd);
            int valueEnd = response.indexOf("`", keyEnd + 1);
            if (valueEnd == -1) {
                return "";
            }
            String value = response.substring(keyEnd, valueEnd);
            log.info("Invalid key [" + unknownKey + "] value [" + value + "]");
            response = response.substring(valueEnd + "`".length());
        }
        return response;
    }

    public static String skipToken(String string) {
        int keyEnd = string.indexOf("`");
        if (keyEnd == -1) {
            return "";
        }
        return string.substring(keyEnd + "`".length());
    }

    public static String handleStringActionPair(String response, StringActionPair pair, EngineStateListener listener) {
        if (EngineState.startWithIgnoreCase(response, pair.prefix)) {
            String key = (String)pair.first;
            int beginIndex = key.length() + 1;
            int endIndex = response.indexOf("`", beginIndex);
            if (endIndex == -1) {
                endIndex = response.length();
            }
            String strValue = response.substring(beginIndex, endIndex);
            ((ValueCallback)pair.second).onUpdate(strValue);
            if (listener != null) {
                listener.onKeyValue(key, strValue);
            }
            if (!(response = response.substring(endIndex)).isEmpty()) {
                response = response.substring(1);
            }
            return response;
        }
        return response;
    }

    public static boolean startWithIgnoreCase(String line, String prefix) {
        int pLen = prefix.length();
        if (line.length() < pLen) {
            return false;
        }
        for (int i = 0; i < pLen; ++i) {
            char lineChar = Character.toLowerCase(line.charAt(i));
            char prefixChar = prefix.charAt(i);
            if (Character.isLetter(prefixChar) && !Character.isLowerCase(prefixChar)) {
                throw new IllegalStateException("Not lower: " + prefix);
            }
            if (lineChar == prefixChar) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStringValueAction(String key, ValueCallback<String> callback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.keys.contains(key)) {
                throw new IllegalStateException("Already registered: " + key);
            }
            this.keys.add(key);
            this.actions.add(new StringActionPair(key, callback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAction(String key) {
        Object object = this.lock;
        synchronized (object) {
            this.keys.remove(key);
            Iterator<StringActionPair> it = this.actions.iterator();
            while (it.hasNext()) {
                if (!((String)it.next().first).equals(key)) continue;
                it.remove();
                break;
            }
        }
    }

    public void processNewData(String append, LinkDecoder decoder) {
        this.buffer.append(append, decoder);
    }

    public static class EngineStateListenerImpl
    implements EngineStateListener {
        @Override
        public void beforeLine(String fullLine) {
        }

        @Override
        public void onKeyValue(String key, String value) {
        }

        @Override
        public void afterLine(String fullLine) {
        }
    }

    public static interface EngineStateListener {
        public void beforeLine(String var1);

        public void onKeyValue(String var1, String var2);

        public void afterLine(String var1);
    }

    public static interface ValueCallback<V> {
        public static final ValueCallback<?> VOID = new ValueCallback(){

            public void onUpdate(Object value) {
            }
        };

        public void onUpdate(V var1);
    }

    public static class StringActionPair
    extends Pair<String, ValueCallback<String>> {
        public final String prefix;

        public StringActionPair(String key, ValueCallback<String> second) {
            super(key, second);
            this.prefix = key.toLowerCase() + "`";
        }

        @Override
        public String toString() {
            return "Pair(" + (String)this.first + "," + this.second + "}";
        }
    }
}

