/*
 * Decompiled with CFR 0.152.
 */
package cz.jaybee.intelhex;

import cz.jaybee.intelhex.Region;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MemoryRegions {
    private final List<Region> regions = new ArrayList<Region>();

    public void add(long start, long length) {
        Region prevRegion;
        long nextAddress;
        if (this.regions.size() > 0 && (nextAddress = (prevRegion = this.regions.get(this.regions.size() - 1)).getAddressStart() + prevRegion.getLength()) == start) {
            prevRegion.incLength(length);
            return;
        }
        this.regions.add(new Region(start, length));
    }

    public void compact() {
        Collections.sort(this.regions);
        Iterator<Region> iter = this.regions.iterator();
        Region prev = null;
        while (iter.hasNext()) {
            Region curr = iter.next();
            if (prev == null) {
                prev = curr;
                continue;
            }
            if (curr.getAddressStart() == prev.getAddressStart() + prev.getLength()) {
                prev.incLength(curr.getLength());
                iter.remove();
                continue;
            }
            prev = curr;
        }
    }

    public void clear() {
        this.regions.clear();
    }

    public int size() {
        return this.regions.size();
    }

    public Region get(int index) {
        return this.regions.get(index);
    }

    public Region getFullRangeRegion() {
        long start = 0L;
        long length = 0L;
        if (!this.regions.isEmpty()) {
            start = this.regions.get(0).getAddressStart();
            Region last = this.regions.get(this.regions.size() - 1);
            length = last.getAddressStart() + last.getLength() - start;
        }
        return new Region(start, length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Region r : this.regions) {
            sb.append(r).append("\r\n");
        }
        return sb.toString();
    }
}

