/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.rusefi.CompatibilityOptional;
import com.rusefi.ConnectivityContext;
import com.rusefi.PortResult;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.ui.basic.BasicButtonCoordinator;
import com.rusefi.ui.basic.EnableableControl;
import com.rusefi.ui.basic.ImportTuneFileChooser;
import com.rusefi.ui.basic.SingleAsyncJobExecutor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class ImportTuneControl
implements EnableableControl {
    private final JButton importTuneButton = new JButton("Load Tune From File...", AutoupdateUtil.loadIcon("writeconfig48.png"));
    private final ImportTuneFileChooser importTune;
    private final BasicButtonCoordinator basicButtonCoordinator;
    private final ConnectivityContext connectivityContext;
    private final AtomicReference<Optional<PortResult>> ecuPortToUse;

    public ImportTuneControl(SingleAsyncJobExecutor singleAsyncJobExecutor, BasicButtonCoordinator basicButtonCoordinator, ConnectivityContext connectivityContext, AtomicReference<Optional<PortResult>> ecuPortToUse) {
        this.basicButtonCoordinator = basicButtonCoordinator;
        this.connectivityContext = connectivityContext;
        this.ecuPortToUse = ecuPortToUse;
        this.importTuneButton.addActionListener(this::onImportTuneButtonClicked);
        this.importTune = new ImportTuneFileChooser(singleAsyncJobExecutor);
    }

    @Override
    public void setEnabled(boolean b) {
        this.importTuneButton.setEnabled(b);
    }

    public Component getContent() {
        return this.importTuneButton;
    }

    private void onImportTuneButtonClicked(ActionEvent actionEvent) {
        this.basicButtonCoordinator.disableButtons();
        CompatibilityOptional.ifPresentOrElse(this.ecuPortToUse.get(), port -> this.importTune.showFileChooserToImportTuneAction((PortResult)port, this.importTuneButton, this.connectivityContext), () -> JOptionPane.showMessageDialog(this.importTuneButton, "Device is not connected", "Error", 0));
        this.basicButtonCoordinator.refreshButtons();
    }
}

