/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.dfu.android;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import com.rusefi.dfu.DfuSeFlashDescriptor;
import com.rusefi.dfu.FlashRange;

public class DfuDeviceLocator {
    public static UsbDevice findDevice(UsbManager usbManager) {
        for (UsbDevice usbDevice : usbManager.getDeviceList().values()) {
            if (usbDevice.getVendorId() != 1155 || usbDevice.getProductId() != 57105) continue;
            return usbDevice;
        }
        return null;
    }

    public Result openDfu(UsbManager usbManager, UsbDevice dfuDevice) {
        for (int interfaceIndex = 0; interfaceIndex < dfuDevice.getInterfaceCount(); ++interfaceIndex) {
            UsbInterface usbInterface = dfuDevice.getInterface(interfaceIndex);
            String stringDescriptor = usbInterface.getName();
            if (usbInterface.getInterfaceClass() != 254 || usbInterface.getInterfaceSubclass() != 1 || !stringDescriptor.contains("Flash")) continue;
            FlashRange flashRange = DfuSeFlashDescriptor.parse(stringDescriptor);
            UsbDeviceConnection connection = usbManager.openDevice(dfuDevice);
            connection.claimInterface(usbInterface, true);
            byte[] rawDescs = connection.getRawDescriptors();
            if (rawDescs.length != 72) {
                throw new IllegalStateException("Unexpected RawDescriptors length");
            }
            if (rawDescs[64] != 33) {
                throw new IllegalStateException("Unexpected USB_DT_DFU");
            }
            int transferSize = rawDescs[69] * 256 + rawDescs[68];
            return new Result(connection, interfaceIndex, flashRange, transferSize);
        }
        return null;
    }

    public static class Result {
        private final UsbDeviceConnection connection;
        private final int interfaceIndex;
        private final FlashRange flashRange;
        private final int transferSize;

        public Result(UsbDeviceConnection connection, int interfaceIndex, FlashRange flashRange, int transferSize) {
            this.connection = connection;
            this.interfaceIndex = interfaceIndex;
            this.flashRange = flashRange;
            this.transferSize = transferSize;
        }

        public UsbDeviceConnection getConnection() {
            return this.connection;
        }

        public FlashRange getFlashRange() {
            return this.flashRange;
        }

        public int getInterfaceIndex() {
            return this.interfaceIndex;
        }

        public int getTransferSize() {
            return this.transferSize;
        }
    }
}

