/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.Shadow;
import eu.hansolo.steelseries.tools.SymbolType;
import eu.hansolo.steelseries.tools.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;

public enum SymbolImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private final Shadow SHADOW = Shadow.INSTANCE;
    private int widthBuffer = 0;
    private SymbolType symbolTypeBuffer = SymbolType.HORN;
    private ColorDef symbolColorBuffer = null;
    private CustomColorDef customSymbolColorBuffer = new CustomColorDef(Color.RED);
    private BufferedImage symbolImageBuffer = this.UTIL.createImage(1, 1, 3);
    private BufferedImage clipImageSymbol = this.UTIL.createImage(1, 1, 3);

    /*
     * Opcode count of 21105 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public BufferedImage createSymbol(int n, SymbolType symbolType, ColorDef colorDef, CustomColorDef customColorDef, boolean bl) {
        Color color;
        Color color2;
        Color color3;
        GeneralPath generalPath;
        if (n <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.widthBuffer == n && this.symbolTypeBuffer == symbolType && this.symbolColorBuffer == colorDef && this.customSymbolColorBuffer == customColorDef) {
            return this.symbolImageBuffer;
        }
        this.symbolImageBuffer.flush();
        this.symbolImageBuffer = this.UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = this.symbolImageBuffer.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = this.symbolImageBuffer.getWidth();
        int n3 = this.symbolImageBuffer.getHeight();
        switch (symbolType) {
            case FUEL: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.37383177570093457, (double)n3 * 0.32242990654205606);
                generalPath.curveTo((double)n2 * 0.37383177570093457, (double)n3 * 0.3130841121495327, (double)n2 * 0.37850467289719625, (double)n3 * 0.3037383177570093, (double)n2 * 0.3925233644859813, (double)n3 * 0.3037383177570093);
                generalPath.curveTo((double)n2 * 0.3925233644859813, (double)n3 * 0.3037383177570093, (double)n2 * 0.5327102803738317, (double)n3 * 0.3037383177570093, (double)n2 * 0.5327102803738317, (double)n3 * 0.3037383177570093);
                generalPath.curveTo((double)n2 * 0.5467289719626168, (double)n3 * 0.3037383177570093, (double)n2 * 0.5514018691588785, (double)n3 * 0.3130841121495327, (double)n2 * 0.5514018691588785, (double)n3 * 0.32242990654205606);
                generalPath.curveTo((double)n2 * 0.5514018691588785, (double)n3 * 0.32242990654205606, (double)n2 * 0.5514018691588785, (double)n3 * 0.4392523364485981, (double)n2 * 0.5514018691588785, (double)n3 * 0.4392523364485981);
                generalPath.curveTo((double)n2 * 0.5514018691588785, (double)n3 * 0.4532710280373832, (double)n2 * 0.5467289719626168, (double)n3 * 0.46261682242990654, (double)n2 * 0.5327102803738317, (double)n3 * 0.46261682242990654);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.46261682242990654, (double)n2 * 0.3925233644859813, (double)n3 * 0.46261682242990654, (double)n2 * 0.3925233644859813, (double)n3 * 0.46261682242990654);
                generalPath.curveTo((double)n2 * 0.37850467289719625, (double)n3 * 0.46261682242990654, (double)n2 * 0.37383177570093457, (double)n3 * 0.4532710280373832, (double)n2 * 0.37383177570093457, (double)n3 * 0.4392523364485981);
                generalPath.curveTo((double)n2 * 0.37383177570093457, (double)n3 * 0.4392523364485981, (double)n2 * 0.37383177570093457, (double)n3 * 0.32242990654205606, (double)n2 * 0.37383177570093457, (double)n3 * 0.32242990654205606);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.3364485981308411, (double)n3 * 0.3037383177570093);
                generalPath.curveTo((double)n2 * 0.3364485981308411, (double)n3 * 0.3037383177570093, (double)n2 * 0.3364485981308411, (double)n3 * 0.6869158878504673, (double)n2 * 0.3364485981308411, (double)n3 * 0.6869158878504673);
                generalPath.curveTo((double)n2 * 0.3364485981308411, (double)n3 * 0.6869158878504673, (double)n2 * 0.32710280373831774, (double)n3 * 0.6869158878504673, (double)n2 * 0.32710280373831774, (double)n3 * 0.6869158878504673);
                generalPath.curveTo((double)n2 * 0.3130841121495327, (double)n3 * 0.6869158878504673, (double)n2 * 0.3037383177570093, (double)n3 * 0.7009345794392523, (double)n2 * 0.3037383177570093, (double)n3 * 0.7102803738317757);
                generalPath.curveTo((double)n2 * 0.3037383177570093, (double)n3 * 0.7102803738317757, (double)n2 * 0.3037383177570093, (double)n3 * 0.7383177570093458, (double)n2 * 0.3037383177570093, (double)n3 * 0.7383177570093458);
                generalPath.lineTo((double)n2 * 0.3364485981308411, (double)n3 * 0.7383177570093458);
                generalPath.lineTo((double)n2 * 0.5887850467289719, (double)n3 * 0.7383177570093458);
                generalPath.lineTo((double)n2 * 0.6214953271028038, (double)n3 * 0.7383177570093458);
                generalPath.curveTo((double)n2 * 0.6214953271028038, (double)n3 * 0.7383177570093458, (double)n2 * 0.6214953271028038, (double)n3 * 0.7102803738317757, (double)n2 * 0.6214953271028038, (double)n3 * 0.7102803738317757);
                generalPath.curveTo((double)n2 * 0.6214953271028038, (double)n3 * 0.7009345794392523, (double)n2 * 0.6121495327102804, (double)n3 * 0.6869158878504673, (double)n2 * 0.5981308411214953, (double)n3 * 0.6869158878504673);
                generalPath.curveTo((double)n2 * 0.5981308411214953, (double)n3 * 0.6869158878504673, (double)n2 * 0.5887850467289719, (double)n3 * 0.6869158878504673, (double)n2 * 0.5887850467289719, (double)n3 * 0.6869158878504673);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.6869158878504673, (double)n2 * 0.5887850467289719, (double)n3 * 0.5420560747663551, (double)n2 * 0.5887850467289719, (double)n3 * 0.5420560747663551);
                generalPath.curveTo((double)n2 * 0.5934579439252337, (double)n3 * 0.5467289719626168, (double)n2 * 0.602803738317757, (double)n3 * 0.5467289719626168, (double)n2 * 0.6121495327102804, (double)n3 * 0.5514018691588785);
                generalPath.curveTo((double)n2 * 0.616822429906542, (double)n3 * 0.5560747663551402, (double)n2 * 0.6308411214953271, (double)n3 * 0.5654205607476636, (double)n2 * 0.6355140186915887, (double)n3 * 0.602803738317757);
                generalPath.curveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.6261682242990654, (double)n2 * 0.6308411214953271, (double)n3 * 0.6588785046728972, (double)n2 * 0.6401869158878505, (double)n3 * 0.6822429906542056);
                generalPath.curveTo((double)n2 * 0.6495327102803738, (double)n3 * 0.6962616822429907, (double)n2 * 0.6728971962616822, (double)n3 * 0.7102803738317757, (double)n2 * 0.6915887850467289, (double)n3 * 0.7102803738317757);
                generalPath.curveTo((double)n2 * 0.7242990654205608, (double)n3 * 0.7102803738317757, (double)n2 * 0.7383177570093458, (double)n3 * 0.6915887850467289, (double)n2 * 0.7476635514018691, (double)n3 * 0.6822429906542056);
                generalPath.curveTo((double)n2 * 0.7523364485981309, (double)n3 * 0.6635514018691588, (double)n2 * 0.7523364485981309, (double)n3 * 0.6495327102803738, (double)n2 * 0.7523364485981309, (double)n3 * 0.6401869158878505);
                generalPath.curveTo((double)n2 * 0.7476635514018691, (double)n3 * 0.6214953271028038, (double)n2 * 0.7429906542056075, (double)n3 * 0.5981308411214953, (double)n2 * 0.7336448598130841, (double)n3 * 0.5747663551401869);
                generalPath.curveTo((double)n2 * 0.7289719626168224, (double)n3 * 0.5607476635514018, (double)n2 * 0.719626168224299, (double)n3 * 0.5327102803738317, (double)n2 * 0.7149532710280374, (double)n3 * 0.5233644859813084);
                generalPath.curveTo((double)n2 * 0.7102803738317757, (double)n3 * 0.514018691588785, (double)n2 * 0.705607476635514, (double)n3 * 0.4953271028037383, (double)n2 * 0.705607476635514, (double)n3 * 0.48130841121495327);
                generalPath.curveTo((double)n2 * 0.705607476635514, (double)n3 * 0.4532710280373832, (double)n2 * 0.7149532710280374, (double)n3 * 0.4205607476635514, (double)n2 * 0.7149532710280374, (double)n3 * 0.4205607476635514);
                generalPath.lineTo((double)n2 * 0.7289719626168224, (double)n3 * 0.3878504672897196);
                generalPath.curveTo((double)n2 * 0.7289719626168224, (double)n3 * 0.3878504672897196, (double)n2 * 0.7429906542056075, (double)n3 * 0.3878504672897196, (double)n2 * 0.7476635514018691, (double)n3 * 0.38317757009345793);
                generalPath.curveTo((double)n2 * 0.7570093457943925, (double)n3 * 0.3691588785046729, (double)n2 * 0.7523364485981309, (double)n3 * 0.3598130841121495, (double)n2 * 0.7523364485981309, (double)n3 * 0.35046728971962615);
                generalPath.curveTo((double)n2 * 0.7476635514018691, (double)n3 * 0.3364485981308411, (double)n2 * 0.7242990654205608, (double)n3 * 0.308411214953271, (double)n2 * 0.7149532710280374, (double)n3 * 0.3037383177570093);
                generalPath.curveTo((double)n2 * 0.6962616822429907, (double)n3 * 0.2850467289719626, (double)n2 * 0.6448598130841121, (double)n3 * 0.27102803738317754, (double)n2 * 0.6448598130841121, (double)n3 * 0.27102803738317754);
                generalPath.lineTo((double)n2 * 0.6401869158878505, (double)n3 * 0.2897196261682243);
                generalPath.curveTo((double)n2 * 0.6401869158878505, (double)n3 * 0.2897196261682243, (double)n2 * 0.6542056074766355, (double)n3 * 0.29439252336448596, (double)n2 * 0.6682242990654206, (double)n3 * 0.3037383177570093);
                generalPath.curveTo((double)n2 * 0.6915887850467289, (double)n3 * 0.3177570093457944, (double)n2 * 0.705607476635514, (double)n3 * 0.3364485981308411, (double)n2 * 0.705607476635514, (double)n3 * 0.3411214953271028);
                generalPath.curveTo((double)n2 * 0.7102803738317757, (double)n3 * 0.35046728971962615, (double)n2 * 0.7102803738317757, (double)n3 * 0.3598130841121495, (double)n2 * 0.705607476635514, (double)n3 * 0.3691588785046729);
                generalPath.curveTo((double)n2 * 0.7009345794392523, (double)n3 * 0.38317757009345793, (double)n2 * 0.6915887850467289, (double)n3 * 0.40186915887850466, (double)n2 * 0.6915887850467289, (double)n3 * 0.40186915887850466);
                generalPath.curveTo((double)n2 * 0.6915887850467289, (double)n3 * 0.40186915887850466, (double)n2 * 0.6822429906542056, (double)n3 * 0.4252336448598131, (double)n2 * 0.6822429906542056, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.6822429906542056, (double)n3 * 0.48598130841121495, (double)n2 * 0.6822429906542056, (double)n3 * 0.514018691588785, (double)n2 * 0.705607476635514, (double)n3 * 0.5654205607476636);
                generalPath.curveTo((double)n2 * 0.7149532710280374, (double)n3 * 0.5887850467289719, (double)n2 * 0.719626168224299, (double)n3 * 0.602803738317757, (double)n2 * 0.7289719626168224, (double)n3 * 0.6542056074766355);
                generalPath.curveTo((double)n2 * 0.7289719626168224, (double)n3 * 0.6635514018691588, (double)n2 * 0.7289719626168224, (double)n3 * 0.6869158878504673, (double)n2 * 0.6915887850467289, (double)n3 * 0.6869158878504673);
                generalPath.curveTo((double)n2 * 0.6682242990654206, (double)n3 * 0.6869158878504673, (double)n2 * 0.6635514018691588, (double)n3 * 0.6495327102803738, (double)n2 * 0.6635514018691588, (double)n3 * 0.6495327102803738);
                generalPath.curveTo((double)n2 * 0.6635514018691588, (double)n3 * 0.6495327102803738, (double)n2 * 0.6542056074766355, (double)n3 * 0.6308411214953271, (double)n2 * 0.6588785046728972, (double)n3 * 0.5934579439252337);
                generalPath.curveTo((double)n2 * 0.6542056074766355, (double)n3 * 0.5747663551401869, (double)n2 * 0.6495327102803738, (double)n3 * 0.5607476635514018, (double)n2 * 0.6355140186915887, (double)n3 * 0.5420560747663551);
                generalPath.curveTo((double)n2 * 0.6308411214953271, (double)n3 * 0.5327102803738317, (double)n2 * 0.6121495327102804, (double)n3 * 0.5233644859813084, (double)n2 * 0.5981308411214953, (double)n3 * 0.5186915887850467);
                generalPath.curveTo((double)n2 * 0.5934579439252337, (double)n3 * 0.5186915887850467, (double)n2 * 0.5887850467289719, (double)n3 * 0.5186915887850467, (double)n2 * 0.5887850467289719, (double)n3 * 0.5186915887850467);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.5186915887850467, (double)n2 * 0.5887850467289719, (double)n3 * 0.3037383177570093, (double)n2 * 0.5887850467289719, (double)n3 * 0.3037383177570093);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.2850467289719626, (double)n2 * 0.5700934579439252, (double)n3 * 0.27102803738317754, (double)n2 * 0.5514018691588785, (double)n3 * 0.27102803738317754);
                generalPath.curveTo((double)n2 * 0.5514018691588785, (double)n3 * 0.27102803738317754, (double)n2 * 0.37383177570093457, (double)n3 * 0.27102803738317754, (double)n2 * 0.37383177570093457, (double)n3 * 0.27102803738317754);
                generalPath.curveTo((double)n2 * 0.35514018691588783, (double)n3 * 0.27102803738317754, (double)n2 * 0.3364485981308411, (double)n3 * 0.2850467289719626, (double)n2 * 0.3364485981308411, (double)n3 * 0.3037383177570093);
                generalPath.closePath();
                break;
            }
            case ENGINE: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.32710280373831774, (double)n3 * 0.397196261682243);
                generalPath.lineTo((double)n2 * 0.38317757009345793, (double)n3 * 0.3691588785046729);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.3691588785046729);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.35514018691588783);
                generalPath.lineTo((double)n2 * 0.4252336448598131, (double)n3 * 0.35514018691588783);
                generalPath.lineTo((double)n2 * 0.4252336448598131, (double)n3 * 0.32710280373831774);
                generalPath.lineTo((double)n2 * 0.602803738317757, (double)n3 * 0.32710280373831774);
                generalPath.lineTo((double)n2 * 0.602803738317757, (double)n3 * 0.35514018691588783);
                generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.35514018691588783);
                generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.3691588785046729);
                generalPath.lineTo((double)n2 * 0.616822429906542, (double)n3 * 0.3691588785046729);
                generalPath.lineTo((double)n2 * 0.6308411214953271, (double)n3 * 0.397196261682243);
                generalPath.lineTo((double)n2 * 0.6588785046728972, (double)n3 * 0.397196261682243);
                generalPath.lineTo((double)n2 * 0.6588785046728972, (double)n3 * 0.4439252336448598);
                generalPath.lineTo((double)n2 * 0.705607476635514, (double)n3 * 0.4439252336448598);
                generalPath.lineTo((double)n2 * 0.705607476635514, (double)n3 * 0.397196261682243);
                generalPath.lineTo((double)n2 * 0.7336448598130841, (double)n3 * 0.397196261682243);
                generalPath.lineTo((double)n2 * 0.7336448598130841, (double)n3 * 0.6308411214953271);
                generalPath.lineTo((double)n2 * 0.705607476635514, (double)n3 * 0.6308411214953271);
                generalPath.lineTo((double)n2 * 0.705607476635514, (double)n3 * 0.5887850467289719);
                generalPath.lineTo((double)n2 * 0.6588785046728972, (double)n3 * 0.5887850467289719);
                generalPath.lineTo((double)n2 * 0.6588785046728972, (double)n3 * 0.677570093457944);
                generalPath.lineTo((double)n2 * 0.4252336448598131, (double)n3 * 0.677570093457944);
                generalPath.lineTo((double)n2 * 0.3691588785046729, (double)n3 * 0.6308411214953271);
                generalPath.lineTo((double)n2 * 0.32710280373831774, (double)n3 * 0.6308411214953271);
                generalPath.lineTo((double)n2 * 0.32710280373831774, (double)n3 * 0.5280373831775701);
                generalPath.lineTo((double)n2 * 0.29439252336448596, (double)n3 * 0.5280373831775701);
                generalPath.lineTo((double)n2 * 0.29439252336448596, (double)n3 * 0.602803738317757);
                generalPath.lineTo((double)n2 * 0.26635514018691586, (double)n3 * 0.5841121495327103);
                generalPath.lineTo((double)n2 * 0.26635514018691586, (double)n3 * 0.4439252336448598);
                generalPath.lineTo((double)n2 * 0.29439252336448596, (double)n3 * 0.4252336448598131);
                generalPath.lineTo((double)n2 * 0.29439252336448596, (double)n3 * 0.514018691588785);
                generalPath.lineTo((double)n2 * 0.32710280373831774, (double)n3 * 0.514018691588785);
                generalPath.lineTo((double)n2 * 0.32710280373831774, (double)n3 * 0.397196261682243);
                generalPath.closePath();
                break;
            }
            case OIL: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.7149532710280374, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.7149532710280374, (double)n3 * 0.5046728971962616, (double)n2 * 0.7009345794392523, (double)n3 * 0.5280373831775701, (double)n2 * 0.6962616822429907, (double)n3 * 0.5514018691588785);
                generalPath.curveTo((double)n2 * 0.6962616822429907, (double)n3 * 0.5607476635514018, (double)n2 * 0.7009345794392523, (double)n3 * 0.5747663551401869, (double)n2 * 0.7149532710280374, (double)n3 * 0.5747663551401869);
                generalPath.curveTo((double)n2 * 0.7336448598130841, (double)n3 * 0.5747663551401869, (double)n2 * 0.7383177570093458, (double)n3 * 0.5607476635514018, (double)n2 * 0.7336448598130841, (double)n3 * 0.5467289719626168);
                generalPath.curveTo((double)n2 * 0.7289719626168224, (double)n3 * 0.5233644859813084, (double)n2 * 0.7149532710280374, (double)n3 * 0.5046728971962616, (double)n2 * 0.7149532710280374, (double)n3 * 0.5046728971962616);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.3130841121495327, (double)n3 * 0.4439252336448598);
                generalPath.lineTo((double)n2 * 0.32710280373831774, (double)n3 * 0.42990654205607476);
                generalPath.lineTo((double)n2 * 0.3130841121495327, (double)n3 * 0.4205607476635514);
                generalPath.lineTo((double)n2 * 0.26635514018691586, (double)n3 * 0.4672897196261682);
                generalPath.lineTo((double)n2 * 0.2803738317757009, (double)n3 * 0.48130841121495327);
                generalPath.lineTo((double)n2 * 0.29906542056074764, (double)n3 * 0.45794392523364486);
                generalPath.lineTo((double)n2 * 0.32242990654205606, (double)n3 * 0.48130841121495327);
                generalPath.lineTo((double)n2 * 0.32242990654205606, (double)n3 * 0.5887850467289719);
                generalPath.lineTo((double)n2 * 0.3317757009345794, (double)n3 * 0.5981308411214953);
                generalPath.lineTo((double)n2 * 0.5654205607476636, (double)n3 * 0.5981308411214953);
                generalPath.curveTo((double)n2 * 0.5654205607476636, (double)n3 * 0.5981308411214953, (double)n2 * 0.6261682242990654, (double)n3 * 0.46261682242990654, (double)n2 * 0.6682242990654206, (double)n3 * 0.45794392523364486);
                generalPath.curveTo((double)n2 * 0.6915887850467289, (double)n3 * 0.45794392523364486, (double)n2 * 0.705607476635514, (double)n3 * 0.48130841121495327, (double)n2 * 0.705607476635514, (double)n3 * 0.48130841121495327);
                generalPath.curveTo((double)n2 * 0.705607476635514, (double)n3 * 0.48130841121495327, (double)n2 * 0.7149532710280374, (double)n3 * 0.48130841121495327, (double)n2 * 0.719626168224299, (double)n3 * 0.4766355140186916);
                generalPath.curveTo((double)n2 * 0.7289719626168224, (double)n3 * 0.4719626168224299, (double)n2 * 0.7242990654205608, (double)n3 * 0.46261682242990654, (double)n2 * 0.7242990654205608, (double)n3 * 0.46261682242990654);
                generalPath.curveTo((double)n2 * 0.7242990654205608, (double)n3 * 0.46261682242990654, (double)n2 * 0.7009345794392523, (double)n3 * 0.4205607476635514, (double)n2 * 0.6728971962616822, (double)n3 * 0.4205607476635514);
                generalPath.curveTo((double)n2 * 0.5934579439252337, (double)n3 * 0.4205607476635514, (double)n2 * 0.5560747663551402, (double)n3 * 0.4953271028037383, (double)n2 * 0.5233644859813084, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5, (double)n2 * 0.48598130841121495, (double)n3 * 0.46261682242990654, (double)n2 * 0.48598130841121495, (double)n3 * 0.46261682242990654);
                generalPath.lineTo((double)n2 * 0.411214953271028, (double)n3 * 0.46261682242990654);
                generalPath.lineTo((double)n2 * 0.411214953271028, (double)n3 * 0.4205607476635514);
                generalPath.lineTo((double)n2 * 0.4392523364485981, (double)n3 * 0.4205607476635514);
                generalPath.lineTo((double)n2 * 0.42990654205607476, (double)n3 * 0.411214953271028);
                generalPath.lineTo((double)n2 * 0.37850467289719625, (double)n3 * 0.411214953271028);
                generalPath.lineTo((double)n2 * 0.3644859813084112, (double)n3 * 0.4205607476635514);
                generalPath.lineTo((double)n2 * 0.397196261682243, (double)n3 * 0.4205607476635514);
                generalPath.lineTo((double)n2 * 0.397196261682243, (double)n3 * 0.46261682242990654);
                generalPath.lineTo((double)n2 * 0.3317757009345794, (double)n3 * 0.46261682242990654);
                generalPath.lineTo((double)n2 * 0.3130841121495327, (double)n3 * 0.4439252336448598);
                generalPath.closePath();
                break;
            }
            case FULL_BEAM: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.4392523364485981);
                generalPath.curveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.4532710280373832, (double)n2 * 0.2850467289719626, (double)n3 * 0.4532710280373832, (double)n2 * 0.2850467289719626, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.4532710280373832, (double)n2 * 0.40654205607476634, (double)n3 * 0.4532710280373832, (double)n2 * 0.40654205607476634, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.40654205607476634, (double)n3 * 0.43457943925233644, (double)n2 * 0.411214953271028, (double)n3 * 0.4252336448598131, (double)n2 * 0.411214953271028, (double)n3 * 0.4252336448598131);
                generalPath.lineTo((double)n2 * 0.2850467289719626, (double)n3 * 0.4252336448598131);
                generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.4252336448598131, (double)n2 * 0.27102803738317754, (double)n3 * 0.4252336448598131, (double)n2 * 0.26635514018691586, (double)n3 * 0.4392523364485981);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.5560747663551402);
                generalPath.curveTo((double)n2 * 0.27102803738317754, (double)n3 * 0.5700934579439252, (double)n2 * 0.2850467289719626, (double)n3 * 0.5700934579439252, (double)n2 * 0.2850467289719626, (double)n3 * 0.5700934579439252);
                generalPath.lineTo((double)n2 * 0.411214953271028, (double)n3 * 0.5700934579439252);
                generalPath.curveTo((double)n2 * 0.411214953271028, (double)n3 * 0.5700934579439252, (double)n2 * 0.40654205607476634, (double)n3 * 0.5607476635514018, (double)n2 * 0.40654205607476634, (double)n3 * 0.5420560747663551);
                generalPath.curveTo((double)n2 * 0.40654205607476634, (double)n3 * 0.5420560747663551, (double)n2 * 0.2850467289719626, (double)n3 * 0.5420560747663551, (double)n2 * 0.2850467289719626, (double)n3 * 0.5420560747663551);
                generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.5420560747663551, (double)n2 * 0.26635514018691586, (double)n3 * 0.5420560747663551, (double)n2 * 0.26635514018691586, (double)n3 * 0.5560747663551402);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.4953271028037383);
                generalPath.curveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.514018691588785, (double)n2 * 0.2850467289719626, (double)n3 * 0.514018691588785, (double)n2 * 0.2850467289719626, (double)n3 * 0.514018691588785);
                generalPath.lineTo((double)n2 * 0.40654205607476634, (double)n3 * 0.514018691588785);
                generalPath.lineTo((double)n2 * 0.40654205607476634, (double)n3 * 0.48130841121495327);
                generalPath.lineTo((double)n2 * 0.2850467289719626, (double)n3 * 0.48130841121495327);
                generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.48130841121495327, (double)n2 * 0.27102803738317754, (double)n3 * 0.48130841121495327, (double)n2 * 0.26635514018691586, (double)n3 * 0.4953271028037383);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.27102803738317754, (double)n3 * 0.3691588785046729);
                generalPath.curveTo((double)n2 * 0.27102803738317754, (double)n3 * 0.38317757009345793, (double)n2 * 0.2850467289719626, (double)n3 * 0.38317757009345793, (double)n2 * 0.2850467289719626, (double)n3 * 0.38317757009345793);
                generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.38317757009345793, (double)n2 * 0.42990654205607476, (double)n3 * 0.38317757009345793, (double)n2 * 0.42990654205607476, (double)n3 * 0.38317757009345793);
                generalPath.curveTo((double)n2 * 0.4485981308411215, (double)n3 * 0.3598130841121495, (double)n2 * 0.4672897196261682, (double)n3 * 0.35514018691588783, (double)n2 * 0.4672897196261682, (double)n3 * 0.35514018691588783);
                generalPath.lineTo((double)n2 * 0.2850467289719626, (double)n3 * 0.35514018691588783);
                generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.35514018691588783, (double)n2 * 0.27102803738317754, (double)n3 * 0.35514018691588783, (double)n2 * 0.27102803738317754, (double)n3 * 0.3691588785046729);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.27102803738317754, (double)n3 * 0.6261682242990654);
                generalPath.curveTo((double)n2 * 0.27102803738317754, (double)n3 * 0.6401869158878505, (double)n2 * 0.2850467289719626, (double)n3 * 0.6401869158878505, (double)n2 * 0.2850467289719626, (double)n3 * 0.6401869158878505);
                generalPath.lineTo((double)n2 * 0.4672897196261682, (double)n3 * 0.6401869158878505);
                generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.6401869158878505, (double)n2 * 0.4485981308411215, (double)n3 * 0.6355140186915887, (double)n2 * 0.42990654205607476, (double)n3 * 0.6121495327102804);
                generalPath.curveTo((double)n2 * 0.42990654205607476, (double)n3 * 0.6121495327102804, (double)n2 * 0.2850467289719626, (double)n3 * 0.6121495327102804, (double)n2 * 0.2850467289719626, (double)n3 * 0.6121495327102804);
                generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.6121495327102804, (double)n2 * 0.27102803738317754, (double)n3 * 0.6121495327102804, (double)n2 * 0.27102803738317754, (double)n3 * 0.6261682242990654);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.5467289719626168, (double)n3 * 0.38317757009345793);
                generalPath.curveTo((double)n2 * 0.5934579439252337, (double)n3 * 0.38317757009345793, (double)n2 * 0.705607476635514, (double)n3 * 0.4252336448598131, (double)n2 * 0.705607476635514, (double)n3 * 0.4953271028037383);
                generalPath.curveTo((double)n2 * 0.705607476635514, (double)n3 * 0.5747663551401869, (double)n2 * 0.5934579439252337, (double)n3 * 0.6121495327102804, (double)n2 * 0.5467289719626168, (double)n3 * 0.6121495327102804);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.6121495327102804, (double)n2 * 0.4766355140186916, (double)n3 * 0.6121495327102804, (double)n2 * 0.4766355140186916, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.3878504672897196, (double)n2 * 0.5327102803738317, (double)n3 * 0.38317757009345793, (double)n2 * 0.5467289719626168, (double)n3 * 0.38317757009345793);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.5373831775700935, (double)n3 * 0.35514018691588783);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.35514018691588783, (double)n2 * 0.4439252336448598, (double)n3 * 0.3598130841121495, (double)n2 * 0.4439252336448598, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4439252336448598, (double)n3 * 0.6448598130841121, (double)n2 * 0.5186915887850467, (double)n3 * 0.6401869158878505, (double)n2 * 0.5373831775700935, (double)n3 * 0.6401869158878505);
                generalPath.curveTo((double)n2 * 0.5981308411214953, (double)n3 * 0.6401869158878505, (double)n2 * 0.7336448598130841, (double)n3 * 0.5934579439252337, (double)n2 * 0.7336448598130841, (double)n3 * 0.4953271028037383);
                generalPath.curveTo((double)n2 * 0.7336448598130841, (double)n3 * 0.40654205607476634, (double)n2 * 0.5981308411214953, (double)n3 * 0.35514018691588783, (double)n2 * 0.5373831775700935, (double)n3 * 0.35514018691588783);
                generalPath.closePath();
                break;
            }
            case LOW_BEAM: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.4953271028037383);
                generalPath.curveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.514018691588785, (double)n2 * 0.2850467289719626, (double)n3 * 0.5093457943925234, (double)n2 * 0.2850467289719626, (double)n3 * 0.5093457943925234);
                generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.5093457943925234, (double)n2 * 0.40654205607476634, (double)n3 * 0.4719626168224299, (double)n2 * 0.40654205607476634, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.40654205607476634, (double)n3 * 0.4532710280373832, (double)n2 * 0.411214953271028, (double)n3 * 0.4392523364485981, (double)n2 * 0.411214953271028, (double)n3 * 0.4392523364485981);
                generalPath.lineTo((double)n2 * 0.2850467289719626, (double)n3 * 0.4766355140186916);
                generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.4766355140186916, (double)n2 * 0.27102803738317754, (double)n3 * 0.48130841121495327, (double)n2 * 0.26635514018691586, (double)n3 * 0.4953271028037383);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.616822429906542);
                generalPath.curveTo((double)n2 * 0.27102803738317754, (double)n3 * 0.6308411214953271, (double)n2 * 0.2850467289719626, (double)n3 * 0.6261682242990654, (double)n2 * 0.2850467289719626, (double)n3 * 0.6261682242990654);
                generalPath.lineTo((double)n2 * 0.411214953271028, (double)n3 * 0.5887850467289719);
                generalPath.curveTo((double)n2 * 0.411214953271028, (double)n3 * 0.5887850467289719, (double)n2 * 0.40654205607476634, (double)n3 * 0.5794392523364486, (double)n2 * 0.40654205607476634, (double)n3 * 0.5607476635514018);
                generalPath.curveTo((double)n2 * 0.40654205607476634, (double)n3 * 0.5607476635514018, (double)n2 * 0.2850467289719626, (double)n3 * 0.5981308411214953, (double)n2 * 0.2850467289719626, (double)n3 * 0.5981308411214953);
                generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.5981308411214953, (double)n2 * 0.26635514018691586, (double)n3 * 0.602803738317757, (double)n2 * 0.26635514018691586, (double)n3 * 0.616822429906542);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.5560747663551402);
                generalPath.curveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.5700934579439252, (double)n2 * 0.2850467289719626, (double)n3 * 0.5654205607476636, (double)n2 * 0.2850467289719626, (double)n3 * 0.5654205607476636);
                generalPath.lineTo((double)n2 * 0.40654205607476634, (double)n3 * 0.5280373831775701);
                generalPath.lineTo((double)n2 * 0.40654205607476634, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.2850467289719626, (double)n3 * 0.5373831775700935);
                generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.5373831775700935, (double)n2 * 0.27102803738317754, (double)n3 * 0.5420560747663551, (double)n2 * 0.26635514018691586, (double)n3 * 0.5560747663551402);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.27102803738317754, (double)n3 * 0.42990654205607476);
                generalPath.curveTo((double)n2 * 0.27102803738317754, (double)n3 * 0.4439252336448598, (double)n2 * 0.2850467289719626, (double)n3 * 0.4392523364485981, (double)n2 * 0.2850467289719626, (double)n3 * 0.4392523364485981);
                generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.4392523364485981, (double)n2 * 0.42990654205607476, (double)n3 * 0.3925233644859813, (double)n2 * 0.42990654205607476, (double)n3 * 0.3925233644859813);
                generalPath.curveTo((double)n2 * 0.4485981308411215, (double)n3 * 0.3644859813084112, (double)n2 * 0.4672897196261682, (double)n3 * 0.35514018691588783, (double)n2 * 0.4672897196261682, (double)n3 * 0.35514018691588783);
                generalPath.lineTo((double)n2 * 0.2850467289719626, (double)n3 * 0.40654205607476634);
                generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.40654205607476634, (double)n2 * 0.27102803738317754, (double)n3 * 0.411214953271028, (double)n2 * 0.27102803738317754, (double)n3 * 0.42990654205607476);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.27102803738317754, (double)n3 * 0.6822429906542056);
                generalPath.curveTo((double)n2 * 0.27102803738317754, (double)n3 * 0.7009345794392523, (double)n2 * 0.2850467289719626, (double)n3 * 0.6962616822429907, (double)n2 * 0.2850467289719626, (double)n3 * 0.6962616822429907);
                generalPath.lineTo((double)n2 * 0.4672897196261682, (double)n3 * 0.6401869158878505);
                generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.6401869158878505, (double)n2 * 0.4485981308411215, (double)n3 * 0.6401869158878505, (double)n2 * 0.42990654205607476, (double)n3 * 0.6214953271028038);
                generalPath.curveTo((double)n2 * 0.42990654205607476, (double)n3 * 0.6214953271028038, (double)n2 * 0.2850467289719626, (double)n3 * 0.6682242990654206, (double)n2 * 0.2850467289719626, (double)n3 * 0.6682242990654206);
                generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.6682242990654206, (double)n2 * 0.27102803738317754, (double)n3 * 0.6682242990654206, (double)n2 * 0.27102803738317754, (double)n3 * 0.6822429906542056);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.5467289719626168, (double)n3 * 0.38317757009345793);
                generalPath.curveTo((double)n2 * 0.5934579439252337, (double)n3 * 0.38317757009345793, (double)n2 * 0.705607476635514, (double)n3 * 0.4252336448598131, (double)n2 * 0.705607476635514, (double)n3 * 0.4953271028037383);
                generalPath.curveTo((double)n2 * 0.705607476635514, (double)n3 * 0.5747663551401869, (double)n2 * 0.5934579439252337, (double)n3 * 0.6121495327102804, (double)n2 * 0.5467289719626168, (double)n3 * 0.6121495327102804);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.6121495327102804, (double)n2 * 0.4766355140186916, (double)n3 * 0.6121495327102804, (double)n2 * 0.4766355140186916, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.3878504672897196, (double)n2 * 0.5327102803738317, (double)n3 * 0.38317757009345793, (double)n2 * 0.5467289719626168, (double)n3 * 0.38317757009345793);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.5373831775700935, (double)n3 * 0.35514018691588783);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.35514018691588783, (double)n2 * 0.4439252336448598, (double)n3 * 0.3598130841121495, (double)n2 * 0.4439252336448598, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4439252336448598, (double)n3 * 0.6448598130841121, (double)n2 * 0.5186915887850467, (double)n3 * 0.6401869158878505, (double)n2 * 0.5373831775700935, (double)n3 * 0.6401869158878505);
                generalPath.curveTo((double)n2 * 0.5981308411214953, (double)n3 * 0.6401869158878505, (double)n2 * 0.7336448598130841, (double)n3 * 0.5934579439252337, (double)n2 * 0.7336448598130841, (double)n3 * 0.4953271028037383);
                generalPath.curveTo((double)n2 * 0.7336448598130841, (double)n3 * 0.40654205607476634, (double)n2 * 0.5981308411214953, (double)n3 * 0.35514018691588783, (double)n2 * 0.5373831775700935, (double)n3 * 0.35514018691588783);
                generalPath.closePath();
                break;
            }
            case FOG_LIGHT: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5607476635514018, (double)n3 * 0.5794392523364486);
                generalPath.curveTo((double)n2 * 0.5607476635514018, (double)n3 * 0.5887850467289719, (double)n2 * 0.5700934579439252, (double)n3 * 0.5934579439252337, (double)n2 * 0.5747663551401869, (double)n3 * 0.5934579439252337);
                generalPath.curveTo((double)n2 * 0.5747663551401869, (double)n3 * 0.5934579439252337, (double)n2 * 0.5934579439252337, (double)n3 * 0.5934579439252337, (double)n2 * 0.5934579439252337, (double)n3 * 0.5934579439252337);
                generalPath.curveTo((double)n2 * 0.5981308411214953, (double)n3 * 0.6121495327102804, (double)n2 * 0.6121495327102804, (double)n3 * 0.6214953271028038, (double)n2 * 0.6121495327102804, (double)n3 * 0.6214953271028038);
                generalPath.lineTo((double)n2 * 0.6355140186915887, (double)n3 * 0.6074766355140186);
                generalPath.curveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.6074766355140186, (double)n2 * 0.6214953271028038, (double)n3 * 0.602803738317757, (double)n2 * 0.616822429906542, (double)n3 * 0.5934579439252337);
                generalPath.curveTo((double)n2 * 0.616822429906542, (double)n3 * 0.5934579439252337, (double)n2 * 0.6682242990654206, (double)n3 * 0.5934579439252337, (double)n2 * 0.6682242990654206, (double)n3 * 0.5934579439252337);
                generalPath.curveTo((double)n2 * 0.677570093457944, (double)n3 * 0.5934579439252337, (double)n2 * 0.6822429906542056, (double)n3 * 0.5887850467289719, (double)n2 * 0.6822429906542056, (double)n3 * 0.5794392523364486);
                generalPath.curveTo((double)n2 * 0.6822429906542056, (double)n3 * 0.5747663551401869, (double)n2 * 0.677570093457944, (double)n3 * 0.5654205607476636, (double)n2 * 0.6682242990654206, (double)n3 * 0.5654205607476636);
                generalPath.curveTo((double)n2 * 0.6682242990654206, (double)n3 * 0.5654205607476636, (double)n2 * 0.6121495327102804, (double)n3 * 0.5654205607476636, (double)n2 * 0.6121495327102804, (double)n3 * 0.5654205607476636);
                generalPath.curveTo((double)n2 * 0.6214953271028038, (double)n3 * 0.5514018691588785, (double)n2 * 0.6448598130841121, (double)n3 * 0.5280373831775701, (double)n2 * 0.6495327102803738, (double)n3 * 0.5093457943925234);
                generalPath.curveTo((double)n2 * 0.6495327102803738, (double)n3 * 0.5093457943925234, (double)n2 * 0.6682242990654206, (double)n3 * 0.5093457943925234, (double)n2 * 0.6682242990654206, (double)n3 * 0.5093457943925234);
                generalPath.curveTo((double)n2 * 0.677570093457944, (double)n3 * 0.5093457943925234, (double)n2 * 0.6822429906542056, (double)n3 * 0.5046728971962616, (double)n2 * 0.6822429906542056, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.6822429906542056, (double)n3 * 0.49065420560747663, (double)n2 * 0.677570093457944, (double)n3 * 0.48598130841121495, (double)n2 * 0.6682242990654206, (double)n3 * 0.48598130841121495);
                generalPath.curveTo((double)n2 * 0.6682242990654206, (double)n3 * 0.48598130841121495, (double)n2 * 0.6542056074766355, (double)n3 * 0.48598130841121495, (double)n2 * 0.6542056074766355, (double)n3 * 0.48598130841121495);
                generalPath.curveTo((double)n2 * 0.6448598130841121, (double)n3 * 0.4672897196261682, (double)n2 * 0.6261682242990654, (double)n3 * 0.4532710280373832, (double)n2 * 0.616822429906542, (double)n3 * 0.4392523364485981);
                generalPath.curveTo((double)n2 * 0.616822429906542, (double)n3 * 0.4392523364485981, (double)n2 * 0.6682242990654206, (double)n3 * 0.4392523364485981, (double)n2 * 0.6682242990654206, (double)n3 * 0.4392523364485981);
                generalPath.curveTo((double)n2 * 0.677570093457944, (double)n3 * 0.4392523364485981, (double)n2 * 0.6822429906542056, (double)n3 * 0.42990654205607476, (double)n2 * 0.6822429906542056, (double)n3 * 0.4252336448598131);
                generalPath.curveTo((double)n2 * 0.6822429906542056, (double)n3 * 0.4158878504672897, (double)n2 * 0.677570093457944, (double)n3 * 0.411214953271028, (double)n2 * 0.6682242990654206, (double)n3 * 0.411214953271028);
                generalPath.curveTo((double)n2 * 0.6682242990654206, (double)n3 * 0.411214953271028, (double)n2 * 0.6121495327102804, (double)n3 * 0.411214953271028, (double)n2 * 0.6121495327102804, (double)n3 * 0.411214953271028);
                generalPath.curveTo((double)n2 * 0.6214953271028038, (double)n3 * 0.397196261682243, (double)n2 * 0.6308411214953271, (double)n3 * 0.3925233644859813, (double)n2 * 0.6308411214953271, (double)n3 * 0.3925233644859813);
                generalPath.lineTo((double)n2 * 0.616822429906542, (double)n3 * 0.37850467289719625);
                generalPath.curveTo((double)n2 * 0.616822429906542, (double)n3 * 0.37850467289719625, (double)n2 * 0.5981308411214953, (double)n3 * 0.3925233644859813, (double)n2 * 0.5887850467289719, (double)n3 * 0.411214953271028);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.411214953271028, (double)n2 * 0.5747663551401869, (double)n3 * 0.411214953271028, (double)n2 * 0.5747663551401869, (double)n3 * 0.411214953271028);
                generalPath.curveTo((double)n2 * 0.5700934579439252, (double)n3 * 0.411214953271028, (double)n2 * 0.5607476635514018, (double)n3 * 0.4158878504672897, (double)n2 * 0.5607476635514018, (double)n3 * 0.4252336448598131);
                generalPath.curveTo((double)n2 * 0.5607476635514018, (double)n3 * 0.42990654205607476, (double)n2 * 0.5700934579439252, (double)n3 * 0.4392523364485981, (double)n2 * 0.5747663551401869, (double)n3 * 0.4392523364485981);
                generalPath.curveTo((double)n2 * 0.5747663551401869, (double)n3 * 0.4392523364485981, (double)n2 * 0.5934579439252337, (double)n3 * 0.4392523364485981, (double)n2 * 0.5934579439252337, (double)n3 * 0.4392523364485981);
                generalPath.curveTo((double)n2 * 0.5981308411214953, (double)n3 * 0.4532710280373832, (double)n2 * 0.616822429906542, (double)n3 * 0.4672897196261682, (double)n2 * 0.6261682242990654, (double)n3 * 0.48598130841121495);
                generalPath.curveTo((double)n2 * 0.6261682242990654, (double)n3 * 0.48598130841121495, (double)n2 * 0.5747663551401869, (double)n3 * 0.48598130841121495, (double)n2 * 0.5747663551401869, (double)n3 * 0.48598130841121495);
                generalPath.curveTo((double)n2 * 0.5700934579439252, (double)n3 * 0.48598130841121495, (double)n2 * 0.5607476635514018, (double)n3 * 0.49065420560747663, (double)n2 * 0.5607476635514018, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5607476635514018, (double)n3 * 0.5046728971962616, (double)n2 * 0.5700934579439252, (double)n3 * 0.5093457943925234, (double)n2 * 0.5747663551401869, (double)n3 * 0.5093457943925234);
                generalPath.curveTo((double)n2 * 0.5747663551401869, (double)n3 * 0.5093457943925234, (double)n2 * 0.6261682242990654, (double)n3 * 0.5093457943925234, (double)n2 * 0.6261682242990654, (double)n3 * 0.5093457943925234);
                generalPath.curveTo((double)n2 * 0.616822429906542, (double)n3 * 0.5280373831775701, (double)n2 * 0.5981308411214953, (double)n3 * 0.5467289719626168, (double)n2 * 0.5887850467289719, (double)n3 * 0.5654205607476636);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.5654205607476636, (double)n2 * 0.5747663551401869, (double)n3 * 0.5654205607476636, (double)n2 * 0.5747663551401869, (double)n3 * 0.5654205607476636);
                generalPath.curveTo((double)n2 * 0.5700934579439252, (double)n3 * 0.5654205607476636, (double)n2 * 0.5607476635514018, (double)n3 * 0.5747663551401869, (double)n2 * 0.5607476635514018, (double)n3 * 0.5794392523364486);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.38317757009345793);
                generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.38317757009345793, (double)n2 * 0.5280373831775701, (double)n3 * 0.3878504672897196, (double)n2 * 0.5280373831775701, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.6121495327102804, (double)n2 * 0.48598130841121495, (double)n3 * 0.6121495327102804, (double)n2 * 0.4719626168224299, (double)n3 * 0.6121495327102804);
                generalPath.curveTo((double)n2 * 0.43457943925233644, (double)n3 * 0.6121495327102804, (double)n2 * 0.34579439252336447, (double)n3 * 0.5747663551401869, (double)n2 * 0.34579439252336447, (double)n3 * 0.4953271028037383);
                generalPath.curveTo((double)n2 * 0.34579439252336447, (double)n3 * 0.4252336448598131, (double)n2 * 0.43457943925233644, (double)n3 * 0.38317757009345793, (double)n2 * 0.4719626168224299, (double)n3 * 0.38317757009345793);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.35514018691588783);
                generalPath.curveTo((double)n2 * 0.43457943925233644, (double)n3 * 0.35514018691588783, (double)n2 * 0.32242990654205606, (double)n3 * 0.40654205607476634, (double)n2 * 0.32242990654205606, (double)n3 * 0.4953271028037383);
                generalPath.curveTo((double)n2 * 0.32242990654205606, (double)n3 * 0.5934579439252337, (double)n2 * 0.43457943925233644, (double)n3 * 0.6401869158878505, (double)n2 * 0.48130841121495327, (double)n3 * 0.6401869158878505);
                generalPath.curveTo((double)n2 * 0.4953271028037383, (double)n3 * 0.6401869158878505, (double)n2 * 0.5514018691588785, (double)n3 * 0.6448598130841121, (double)n2 * 0.5514018691588785, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5514018691588785, (double)n3 * 0.3598130841121495, (double)n2 * 0.4953271028037383, (double)n3 * 0.35514018691588783, (double)n2 * 0.48130841121495327, (double)n3 * 0.35514018691588783);
                generalPath.closePath();
                break;
            }
            case BATTERY: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.3037383177570093, (double)n3 * 0.4252336448598131);
                generalPath.curveTo((double)n2 * 0.3037383177570093, (double)n3 * 0.4205607476635514, (double)n2 * 0.308411214953271, (double)n3 * 0.4158878504672897, (double)n2 * 0.3177570093457944, (double)n3 * 0.4158878504672897);
                generalPath.curveTo((double)n2 * 0.3177570093457944, (double)n3 * 0.4158878504672897, (double)n2 * 0.6822429906542056, (double)n3 * 0.4158878504672897, (double)n2 * 0.6822429906542056, (double)n3 * 0.4158878504672897);
                generalPath.curveTo((double)n2 * 0.6915887850467289, (double)n3 * 0.4158878504672897, (double)n2 * 0.6962616822429907, (double)n3 * 0.4205607476635514, (double)n2 * 0.6962616822429907, (double)n3 * 0.4252336448598131);
                generalPath.curveTo((double)n2 * 0.6962616822429907, (double)n3 * 0.4252336448598131, (double)n2 * 0.6962616822429907, (double)n3 * 0.6214953271028038, (double)n2 * 0.6962616822429907, (double)n3 * 0.6214953271028038);
                generalPath.curveTo((double)n2 * 0.6962616822429907, (double)n3 * 0.6308411214953271, (double)n2 * 0.6915887850467289, (double)n3 * 0.6355140186915887, (double)n2 * 0.6822429906542056, (double)n3 * 0.6355140186915887);
                generalPath.curveTo((double)n2 * 0.6822429906542056, (double)n3 * 0.6355140186915887, (double)n2 * 0.3177570093457944, (double)n3 * 0.6355140186915887, (double)n2 * 0.3177570093457944, (double)n3 * 0.6355140186915887);
                generalPath.curveTo((double)n2 * 0.308411214953271, (double)n3 * 0.6355140186915887, (double)n2 * 0.3037383177570093, (double)n3 * 0.6308411214953271, (double)n2 * 0.3037383177570093, (double)n3 * 0.6214953271028038);
                generalPath.curveTo((double)n2 * 0.3037383177570093, (double)n3 * 0.6214953271028038, (double)n2 * 0.3037383177570093, (double)n3 * 0.4252336448598131, (double)n2 * 0.3037383177570093, (double)n3 * 0.4252336448598131);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.32710280373831774, (double)n3 * 0.35514018691588783);
                generalPath.curveTo((double)n2 * 0.32710280373831774, (double)n3 * 0.35514018691588783, (double)n2 * 0.32710280373831774, (double)n3 * 0.37850467289719625, (double)n2 * 0.32710280373831774, (double)n3 * 0.37850467289719625);
                generalPath.curveTo((double)n2 * 0.32710280373831774, (double)n3 * 0.37850467289719625, (double)n2 * 0.2897196261682243, (double)n3 * 0.37850467289719625, (double)n2 * 0.2897196261682243, (double)n3 * 0.37850467289719625);
                generalPath.curveTo((double)n2 * 0.2757009345794392, (double)n3 * 0.37850467289719625, (double)n2 * 0.26635514018691586, (double)n3 * 0.3878504672897196, (double)n2 * 0.26635514018691586, (double)n3 * 0.40186915887850466);
                generalPath.curveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.40186915887850466, (double)n2 * 0.26635514018691586, (double)n3 * 0.6448598130841121, (double)n2 * 0.26635514018691586, (double)n3 * 0.6448598130841121);
                generalPath.curveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.6588785046728972, (double)n2 * 0.2757009345794392, (double)n3 * 0.6728971962616822, (double)n2 * 0.2897196261682243, (double)n3 * 0.6728971962616822);
                generalPath.curveTo((double)n2 * 0.2897196261682243, (double)n3 * 0.6728971962616822, (double)n2 * 0.7102803738317757, (double)n3 * 0.6728971962616822, (double)n2 * 0.7102803738317757, (double)n3 * 0.6728971962616822);
                generalPath.curveTo((double)n2 * 0.7242990654205608, (double)n3 * 0.6728971962616822, (double)n2 * 0.7336448598130841, (double)n3 * 0.6588785046728972, (double)n2 * 0.7336448598130841, (double)n3 * 0.6448598130841121);
                generalPath.curveTo((double)n2 * 0.7336448598130841, (double)n3 * 0.6448598130841121, (double)n2 * 0.7336448598130841, (double)n3 * 0.40186915887850466, (double)n2 * 0.7336448598130841, (double)n3 * 0.40186915887850466);
                generalPath.curveTo((double)n2 * 0.7336448598130841, (double)n3 * 0.3878504672897196, (double)n2 * 0.7242990654205608, (double)n3 * 0.37850467289719625, (double)n2 * 0.7102803738317757, (double)n3 * 0.37850467289719625);
                generalPath.curveTo((double)n2 * 0.7102803738317757, (double)n3 * 0.37850467289719625, (double)n2 * 0.6728971962616822, (double)n3 * 0.37850467289719625, (double)n2 * 0.6728971962616822, (double)n3 * 0.37850467289719625);
                generalPath.curveTo((double)n2 * 0.6728971962616822, (double)n3 * 0.37850467289719625, (double)n2 * 0.6728971962616822, (double)n3 * 0.35514018691588783, (double)n2 * 0.6728971962616822, (double)n3 * 0.35514018691588783);
                generalPath.curveTo((double)n2 * 0.6728971962616822, (double)n3 * 0.3411214953271028, (double)n2 * 0.6588785046728972, (double)n3 * 0.3317757009345794, (double)n2 * 0.6448598130841121, (double)n3 * 0.3317757009345794);
                generalPath.curveTo((double)n2 * 0.6448598130841121, (double)n3 * 0.3317757009345794, (double)n2 * 0.6121495327102804, (double)n3 * 0.3317757009345794, (double)n2 * 0.6121495327102804, (double)n3 * 0.3317757009345794);
                generalPath.curveTo((double)n2 * 0.5981308411214953, (double)n3 * 0.3317757009345794, (double)n2 * 0.5841121495327103, (double)n3 * 0.3411214953271028, (double)n2 * 0.5841121495327103, (double)n3 * 0.35514018691588783);
                generalPath.curveTo((double)n2 * 0.5841121495327103, (double)n3 * 0.35514018691588783, (double)n2 * 0.5841121495327103, (double)n3 * 0.37850467289719625, (double)n2 * 0.5841121495327103, (double)n3 * 0.37850467289719625);
                generalPath.lineTo((double)n2 * 0.4158878504672897, (double)n3 * 0.37850467289719625);
                generalPath.curveTo((double)n2 * 0.4158878504672897, (double)n3 * 0.37850467289719625, (double)n2 * 0.4158878504672897, (double)n3 * 0.35514018691588783, (double)n2 * 0.4158878504672897, (double)n3 * 0.35514018691588783);
                generalPath.curveTo((double)n2 * 0.4158878504672897, (double)n3 * 0.3411214953271028, (double)n2 * 0.40186915887850466, (double)n3 * 0.3317757009345794, (double)n2 * 0.3878504672897196, (double)n3 * 0.3317757009345794);
                generalPath.curveTo((double)n2 * 0.3878504672897196, (double)n3 * 0.3317757009345794, (double)n2 * 0.35514018691588783, (double)n3 * 0.3317757009345794, (double)n2 * 0.35514018691588783, (double)n3 * 0.3317757009345794);
                generalPath.curveTo((double)n2 * 0.3411214953271028, (double)n3 * 0.3317757009345794, (double)n2 * 0.32710280373831774, (double)n3 * 0.3411214953271028, (double)n2 * 0.32710280373831774, (double)n3 * 0.35514018691588783);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.5747663551401869, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.5747663551401869, (double)n3 * 0.514018691588785);
                generalPath.lineTo((double)n2 * 0.6121495327102804, (double)n3 * 0.514018691588785);
                generalPath.lineTo((double)n2 * 0.6121495327102804, (double)n3 * 0.5467289719626168);
                generalPath.lineTo((double)n2 * 0.6214953271028038, (double)n3 * 0.5467289719626168);
                generalPath.lineTo((double)n2 * 0.6214953271028038, (double)n3 * 0.514018691588785);
                generalPath.lineTo((double)n2 * 0.6588785046728972, (double)n3 * 0.514018691588785);
                generalPath.lineTo((double)n2 * 0.6588785046728972, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.6214953271028038, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.6214953271028038, (double)n3 * 0.46261682242990654);
                generalPath.lineTo((double)n2 * 0.6121495327102804, (double)n3 * 0.46261682242990654);
                generalPath.lineTo((double)n2 * 0.6121495327102804, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.5747663551401869, (double)n3 * 0.5);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.32710280373831774, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.32710280373831774, (double)n3 * 0.514018691588785);
                generalPath.lineTo((double)n2 * 0.4158878504672897, (double)n3 * 0.514018691588785);
                generalPath.lineTo((double)n2 * 0.4158878504672897, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.32710280373831774, (double)n3 * 0.5);
                generalPath.closePath();
                break;
            }
            case TEMPERATURE: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.616822429906542, (double)n3 * 0.6121495327102804);
                generalPath.curveTo((double)n2 * 0.6074766355140186, (double)n3 * 0.6121495327102804, (double)n2 * 0.6121495327102804, (double)n3 * 0.602803738317757, (double)n2 * 0.5841121495327103, (double)n3 * 0.602803738317757);
                generalPath.curveTo((double)n2 * 0.5794392523364486, (double)n3 * 0.6074766355140186, (double)n2 * 0.5794392523364486, (double)n3 * 0.6214953271028038, (double)n2 * 0.5887850467289719, (double)n3 * 0.6261682242990654);
                generalPath.curveTo((double)n2 * 0.5981308411214953, (double)n3 * 0.6261682242990654, (double)n2 * 0.6121495327102804, (double)n3 * 0.6355140186915887, (double)n2 * 0.6214953271028038, (double)n3 * 0.6355140186915887);
                generalPath.curveTo((double)n2 * 0.6495327102803738, (double)n3 * 0.6355140186915887, (double)n2 * 0.6588785046728972, (double)n3 * 0.602803738317757, (double)n2 * 0.677570093457944, (double)n3 * 0.602803738317757);
                generalPath.curveTo((double)n2 * 0.7009345794392523, (double)n3 * 0.602803738317757, (double)n2 * 0.6962616822429907, (double)n3 * 0.6355140186915887, (double)n2 * 0.719626168224299, (double)n3 * 0.6355140186915887);
                generalPath.curveTo((double)n2 * 0.7336448598130841, (double)n3 * 0.6355140186915887, (double)n2 * 0.7336448598130841, (double)n3 * 0.6121495327102804, (double)n2 * 0.7242990654205608, (double)n3 * 0.6121495327102804);
                generalPath.curveTo((double)n2 * 0.705607476635514, (double)n3 * 0.6121495327102804, (double)n2 * 0.6962616822429907, (double)n3 * 0.5794392523364486, (double)n2 * 0.677570093457944, (double)n3 * 0.5794392523364486);
                generalPath.curveTo((double)n2 * 0.6542056074766355, (double)n3 * 0.5794392523364486, (double)n2 * 0.6448598130841121, (double)n3 * 0.6121495327102804, (double)n2 * 0.616822429906542, (double)n3 * 0.6121495327102804);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.27102803738317754, (double)n3 * 0.602803738317757);
                generalPath.curveTo((double)n2 * 0.2616822429906542, (double)n3 * 0.6074766355140186, (double)n2 * 0.2616822429906542, (double)n3 * 0.6261682242990654, (double)n2 * 0.27102803738317754, (double)n3 * 0.6261682242990654);
                generalPath.curveTo((double)n2 * 0.3037383177570093, (double)n3 * 0.6261682242990654, (double)n2 * 0.3037383177570093, (double)n3 * 0.602803738317757, (double)n2 * 0.32242990654205606, (double)n3 * 0.602803738317757);
                generalPath.curveTo((double)n2 * 0.35046728971962615, (double)n3 * 0.602803738317757, (double)n2 * 0.35046728971962615, (double)n3 * 0.6261682242990654, (double)n2 * 0.38317757009345793, (double)n3 * 0.6261682242990654);
                generalPath.curveTo((double)n2 * 0.411214953271028, (double)n3 * 0.6261682242990654, (double)n2 * 0.411214953271028, (double)n3 * 0.6214953271028038, (double)n2 * 0.4158878504672897, (double)n3 * 0.6121495327102804);
                generalPath.curveTo((double)n2 * 0.4205607476635514, (double)n3 * 0.602803738317757, (double)n2 * 0.40186915887850466, (double)n3 * 0.5981308411214953, (double)n2 * 0.37850467289719625, (double)n3 * 0.602803738317757);
                generalPath.curveTo((double)n2 * 0.35514018691588783, (double)n3 * 0.602803738317757, (double)n2 * 0.35046728971962615, (double)n3 * 0.5747663551401869, (double)n2 * 0.32242990654205606, (double)n3 * 0.5747663551401869);
                generalPath.curveTo((double)n2 * 0.29906542056074764, (double)n3 * 0.5747663551401869, (double)n2 * 0.2850467289719626, (double)n3 * 0.602803738317757, (double)n2 * 0.27102803738317754, (double)n3 * 0.602803738317757);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.32242990654205606, (double)n3 * 0.6728971962616822);
                generalPath.curveTo((double)n2 * 0.32242990654205606, (double)n3 * 0.6728971962616822, (double)n2 * 0.3130841121495327, (double)n3 * 0.6822429906542056, (double)n2 * 0.3130841121495327, (double)n3 * 0.6915887850467289);
                generalPath.curveTo((double)n2 * 0.3411214953271028, (double)n3 * 0.6915887850467289, (double)n2 * 0.35514018691588783, (double)n3 * 0.7242990654205608, (double)n2 * 0.38317757009345793, (double)n3 * 0.7242990654205608);
                generalPath.curveTo((double)n2 * 0.411214953271028, (double)n3 * 0.7242990654205608, (double)n2 * 0.4205607476635514, (double)n3 * 0.6869158878504673, (double)n2 * 0.4439252336448598, (double)n3 * 0.6869158878504673);
                generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.6869158878504673, (double)n2 * 0.4719626168224299, (double)n3 * 0.7242990654205608, (double)n2 * 0.5046728971962616, (double)n3 * 0.7242990654205608);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.7242990654205608, (double)n2 * 0.5420560747663551, (double)n3 * 0.6869158878504673, (double)n2 * 0.5607476635514018, (double)n3 * 0.6869158878504673);
                generalPath.curveTo((double)n2 * 0.5841121495327103, (double)n3 * 0.6869158878504673, (double)n2 * 0.5887850467289719, (double)n3 * 0.7242990654205608, (double)n2 * 0.6121495327102804, (double)n3 * 0.7242990654205608);
                generalPath.curveTo((double)n2 * 0.6401869158878505, (double)n3 * 0.7242990654205608, (double)n2 * 0.6588785046728972, (double)n3 * 0.6822429906542056, (double)n2 * 0.6915887850467289, (double)n3 * 0.6822429906542056);
                generalPath.curveTo((double)n2 * 0.6915887850467289, (double)n3 * 0.6822429906542056, (double)n2 * 0.6915887850467289, (double)n3 * 0.6728971962616822, (double)n2 * 0.6822429906542056, (double)n3 * 0.6635514018691588);
                generalPath.curveTo((double)n2 * 0.6542056074766355, (double)n3 * 0.6635514018691588, (double)n2 * 0.6355140186915887, (double)n3 * 0.7009345794392523, (double)n2 * 0.6121495327102804, (double)n3 * 0.7009345794392523);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.7009345794392523, (double)n2 * 0.5841121495327103, (double)n3 * 0.6635514018691588, (double)n2 * 0.5607476635514018, (double)n3 * 0.6635514018691588);
                generalPath.curveTo((double)n2 * 0.5420560747663551, (double)n3 * 0.6635514018691588, (double)n2 * 0.5280373831775701, (double)n3 * 0.7009345794392523, (double)n2 * 0.5046728971962616, (double)n3 * 0.7009345794392523);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.7009345794392523, (double)n2 * 0.4719626168224299, (double)n3 * 0.6635514018691588, (double)n2 * 0.4439252336448598, (double)n3 * 0.6635514018691588);
                generalPath.curveTo((double)n2 * 0.4205607476635514, (double)n3 * 0.6635514018691588, (double)n2 * 0.397196261682243, (double)n3 * 0.7009345794392523, (double)n2 * 0.38317757009345793, (double)n3 * 0.7009345794392523);
                generalPath.curveTo((double)n2 * 0.35514018691588783, (double)n3 * 0.7009345794392523, (double)n2 * 0.35514018691588783, (double)n3 * 0.6728971962616822, (double)n2 * 0.32242990654205606, (double)n3 * 0.6728971962616822);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.514018691588785, (double)n3 * 0.37850467289719625);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.37850467289719625, (double)n2 * 0.5747663551401869, (double)n3 * 0.37850467289719625, (double)n2 * 0.5747663551401869, (double)n3 * 0.37850467289719625);
                generalPath.curveTo((double)n2 * 0.5794392523364486, (double)n3 * 0.37850467289719625, (double)n2 * 0.5887850467289719, (double)n3 * 0.3691588785046729, (double)n2 * 0.5887850467289719, (double)n3 * 0.3644859813084112);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.3598130841121495, (double)n2 * 0.5794392523364486, (double)n3 * 0.35046728971962615, (double)n2 * 0.5747663551401869, (double)n3 * 0.35046728971962615);
                generalPath.curveTo((double)n2 * 0.5747663551401869, (double)n3 * 0.35046728971962615, (double)n2 * 0.514018691588785, (double)n3 * 0.35046728971962615, (double)n2 * 0.514018691588785, (double)n3 * 0.35046728971962615);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.35046728971962615, (double)n2 * 0.514018691588785, (double)n3 * 0.29906542056074764, (double)n2 * 0.514018691588785, (double)n3 * 0.29906542056074764);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.2897196261682243, (double)n2 * 0.5046728971962616, (double)n3 * 0.2803738317757009, (double)n2 * 0.4953271028037383, (double)n3 * 0.2803738317757009);
                generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.2803738317757009, (double)n2 * 0.4766355140186916, (double)n3 * 0.2897196261682243, (double)n2 * 0.4766355140186916, (double)n3 * 0.29906542056074764);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.29906542056074764, (double)n2 * 0.4766355140186916, (double)n3 * 0.5700934579439252, (double)n2 * 0.4766355140186916, (double)n3 * 0.5700934579439252);
                generalPath.curveTo((double)n2 * 0.46261682242990654, (double)n3 * 0.5794392523364486, (double)n2 * 0.4532710280373832, (double)n3 * 0.5934579439252337, (double)n2 * 0.4532710280373832, (double)n3 * 0.6121495327102804);
                generalPath.curveTo((double)n2 * 0.4532710280373832, (double)n3 * 0.6355140186915887, (double)n2 * 0.4719626168224299, (double)n3 * 0.6542056074766355, (double)n2 * 0.4953271028037383, (double)n3 * 0.6542056074766355);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.6542056074766355, (double)n2 * 0.5373831775700935, (double)n3 * 0.6355140186915887, (double)n2 * 0.5373831775700935, (double)n3 * 0.6121495327102804);
                generalPath.curveTo((double)n2 * 0.5373831775700935, (double)n3 * 0.5934579439252337, (double)n2 * 0.5280373831775701, (double)n3 * 0.5794392523364486, (double)n2 * 0.514018691588785, (double)n3 * 0.5700934579439252);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.5700934579439252, (double)n2 * 0.514018691588785, (double)n3 * 0.5186915887850467, (double)n2 * 0.514018691588785, (double)n3 * 0.5186915887850467);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.5186915887850467, (double)n2 * 0.5747663551401869, (double)n3 * 0.5186915887850467, (double)n2 * 0.5747663551401869, (double)n3 * 0.5186915887850467);
                generalPath.curveTo((double)n2 * 0.5794392523364486, (double)n3 * 0.5186915887850467, (double)n2 * 0.5887850467289719, (double)n3 * 0.514018691588785, (double)n2 * 0.5887850467289719, (double)n3 * 0.5093457943925234);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.5, (double)n2 * 0.5794392523364486, (double)n3 * 0.4953271028037383, (double)n2 * 0.5747663551401869, (double)n3 * 0.4953271028037383);
                generalPath.curveTo((double)n2 * 0.5747663551401869, (double)n3 * 0.4953271028037383, (double)n2 * 0.514018691588785, (double)n3 * 0.4953271028037383, (double)n2 * 0.514018691588785, (double)n3 * 0.4953271028037383);
                generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.4485981308411215);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.4485981308411215, (double)n2 * 0.5747663551401869, (double)n3 * 0.4485981308411215, (double)n2 * 0.5747663551401869, (double)n3 * 0.4485981308411215);
                generalPath.curveTo((double)n2 * 0.5794392523364486, (double)n3 * 0.4485981308411215, (double)n2 * 0.5887850467289719, (double)n3 * 0.4439252336448598, (double)n2 * 0.5887850467289719, (double)n3 * 0.43457943925233644);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.42990654205607476, (double)n2 * 0.5794392523364486, (double)n3 * 0.4252336448598131, (double)n2 * 0.5747663551401869, (double)n3 * 0.4252336448598131);
                generalPath.curveTo((double)n2 * 0.5747663551401869, (double)n3 * 0.4252336448598131, (double)n2 * 0.514018691588785, (double)n3 * 0.4252336448598131, (double)n2 * 0.514018691588785, (double)n3 * 0.4252336448598131);
                generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.37850467289719625);
                generalPath.closePath();
                break;
            }
            case TURN_LIGHT: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.5700934579439252);
                generalPath.lineTo((double)n2 * 0.48598130841121495, (double)n3 * 0.42990654205607476);
                generalPath.lineTo((double)n2 * 0.411214953271028, (double)n3 * 0.42990654205607476);
                generalPath.lineTo((double)n2 * 0.411214953271028, (double)n3 * 0.35514018691588783);
                generalPath.lineTo((double)n2 * 0.24299065420560748, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.411214953271028, (double)n3 * 0.6495327102803738);
                generalPath.lineTo((double)n2 * 0.411214953271028, (double)n3 * 0.5700934579439252);
                generalPath.lineTo((double)n2 * 0.48598130841121495, (double)n3 * 0.5700934579439252);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5700934579439252);
                generalPath.lineTo((double)n2 * 0.5841121495327103, (double)n3 * 0.5700934579439252);
                generalPath.lineTo((double)n2 * 0.5841121495327103, (double)n3 * 0.6495327102803738);
                generalPath.lineTo((double)n2 * 0.7523364485981309, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.5841121495327103, (double)n3 * 0.35514018691588783);
                generalPath.lineTo((double)n2 * 0.5841121495327103, (double)n3 * 0.42990654205607476);
                generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.42990654205607476);
                generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5700934579439252);
                generalPath.closePath();
                break;
            }
            case GLAZE: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.2897196261682243);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.2897196261682243, (double)n2 * 0.4766355140186916, (double)n3 * 0.34579439252336447, (double)n2 * 0.4766355140186916, (double)n3 * 0.34579439252336447);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.34579439252336447, (double)n2 * 0.4532710280373832, (double)n3 * 0.32242990654205606, (double)n2 * 0.4532710280373832, (double)n3 * 0.32242990654205606);
                generalPath.curveTo((double)n2 * 0.4485981308411215, (double)n3 * 0.3177570093457944, (double)n2 * 0.4392523364485981, (double)n3 * 0.3177570093457944, (double)n2 * 0.43457943925233644, (double)n3 * 0.32242990654205606);
                generalPath.curveTo((double)n2 * 0.4252336448598131, (double)n3 * 0.32710280373831774, (double)n2 * 0.4252336448598131, (double)n3 * 0.3364485981308411, (double)n2 * 0.43457943925233644, (double)n3 * 0.34579439252336447);
                generalPath.curveTo((double)n2 * 0.43457943925233644, (double)n3 * 0.34579439252336447, (double)n2 * 0.4719626168224299, (double)n3 * 0.38317757009345793, (double)n2 * 0.4719626168224299, (double)n3 * 0.38317757009345793);
                generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.38317757009345793, (double)n2 * 0.4766355140186916, (double)n3 * 0.3878504672897196, (double)n2 * 0.4766355140186916, (double)n3 * 0.3878504672897196);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.3878504672897196, (double)n2 * 0.4766355140186916, (double)n3 * 0.46261682242990654, (double)n2 * 0.4766355140186916, (double)n3 * 0.46261682242990654);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.46261682242990654, (double)n2 * 0.4158878504672897, (double)n3 * 0.4205607476635514, (double)n2 * 0.4158878504672897, (double)n3 * 0.4205607476635514);
                generalPath.curveTo((double)n2 * 0.4158878504672897, (double)n3 * 0.4158878504672897, (double)n2 * 0.4158878504672897, (double)n3 * 0.4158878504672897, (double)n2 * 0.4158878504672897, (double)n3 * 0.411214953271028);
                generalPath.curveTo((double)n2 * 0.4158878504672897, (double)n3 * 0.411214953271028, (double)n2 * 0.40654205607476634, (double)n3 * 0.3598130841121495, (double)n2 * 0.40654205607476634, (double)n3 * 0.3598130841121495);
                generalPath.curveTo((double)n2 * 0.40654205607476634, (double)n3 * 0.35046728971962615, (double)n2 * 0.397196261682243, (double)n3 * 0.34579439252336447, (double)n2 * 0.3878504672897196, (double)n3 * 0.34579439252336447);
                generalPath.curveTo((double)n2 * 0.38317757009345793, (double)n3 * 0.34579439252336447, (double)n2 * 0.37850467289719625, (double)n3 * 0.35514018691588783, (double)n2 * 0.37850467289719625, (double)n3 * 0.3644859813084112);
                generalPath.curveTo((double)n2 * 0.37850467289719625, (double)n3 * 0.3644859813084112, (double)n2 * 0.38317757009345793, (double)n3 * 0.397196261682243, (double)n2 * 0.38317757009345793, (double)n3 * 0.397196261682243);
                generalPath.curveTo((double)n2 * 0.38317757009345793, (double)n3 * 0.397196261682243, (double)n2 * 0.3364485981308411, (double)n3 * 0.3644859813084112, (double)n2 * 0.3364485981308411, (double)n3 * 0.3644859813084112);
                generalPath.curveTo((double)n2 * 0.32710280373831774, (double)n3 * 0.35514018691588783, (double)n2 * 0.3130841121495327, (double)n3 * 0.3598130841121495, (double)n2 * 0.308411214953271, (double)n3 * 0.3691588785046729);
                generalPath.curveTo((double)n2 * 0.29906542056074764, (double)n3 * 0.37850467289719625, (double)n2 * 0.3037383177570093, (double)n3 * 0.3925233644859813, (double)n2 * 0.3130841121495327, (double)n3 * 0.397196261682243);
                generalPath.curveTo((double)n2 * 0.3130841121495327, (double)n3 * 0.397196261682243, (double)n2 * 0.3598130841121495, (double)n3 * 0.42990654205607476, (double)n2 * 0.3598130841121495, (double)n3 * 0.42990654205607476);
                generalPath.curveTo((double)n2 * 0.3598130841121495, (double)n3 * 0.42990654205607476, (double)n2 * 0.32710280373831774, (double)n3 * 0.4392523364485981, (double)n2 * 0.32710280373831774, (double)n3 * 0.4392523364485981);
                generalPath.curveTo((double)n2 * 0.3177570093457944, (double)n3 * 0.4392523364485981, (double)n2 * 0.3130841121495327, (double)n3 * 0.4439252336448598, (double)n2 * 0.3130841121495327, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.3177570093457944, (double)n3 * 0.46261682242990654, (double)n2 * 0.32242990654205606, (double)n3 * 0.4672897196261682, (double)n2 * 0.3317757009345794, (double)n3 * 0.46261682242990654);
                generalPath.curveTo((double)n2 * 0.3317757009345794, (double)n3 * 0.46261682242990654, (double)n2 * 0.3878504672897196, (double)n3 * 0.4532710280373832, (double)n2 * 0.3878504672897196, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.3878504672897196, (double)n3 * 0.4532710280373832, (double)n2 * 0.3878504672897196, (double)n3 * 0.4532710280373832, (double)n2 * 0.3925233644859813, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.3925233644859813, (double)n3 * 0.4532710280373832, (double)n2 * 0.46261682242990654, (double)n3 * 0.5046728971962616, (double)n2 * 0.46261682242990654, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.46261682242990654, (double)n3 * 0.5046728971962616, (double)n2 * 0.3925233644859813, (double)n3 * 0.5514018691588785, (double)n2 * 0.3925233644859813, (double)n3 * 0.5514018691588785);
                generalPath.curveTo((double)n2 * 0.3878504672897196, (double)n3 * 0.5514018691588785, (double)n2 * 0.3878504672897196, (double)n3 * 0.5514018691588785, (double)n2 * 0.3878504672897196, (double)n3 * 0.5514018691588785);
                generalPath.curveTo((double)n2 * 0.3878504672897196, (double)n3 * 0.5514018691588785, (double)n2 * 0.3317757009345794, (double)n3 * 0.5420560747663551, (double)n2 * 0.3317757009345794, (double)n3 * 0.5420560747663551);
                generalPath.curveTo((double)n2 * 0.32242990654205606, (double)n3 * 0.5373831775700935, (double)n2 * 0.3177570093457944, (double)n3 * 0.5420560747663551, (double)n2 * 0.3130841121495327, (double)n3 * 0.5514018691588785);
                generalPath.curveTo((double)n2 * 0.3130841121495327, (double)n3 * 0.5607476635514018, (double)n2 * 0.3177570093457944, (double)n3 * 0.5654205607476636, (double)n2 * 0.32710280373831774, (double)n3 * 0.5654205607476636);
                generalPath.curveTo((double)n2 * 0.32710280373831774, (double)n3 * 0.5654205607476636, (double)n2 * 0.3598130841121495, (double)n3 * 0.5747663551401869, (double)n2 * 0.3598130841121495, (double)n3 * 0.5747663551401869);
                generalPath.curveTo((double)n2 * 0.3598130841121495, (double)n3 * 0.5747663551401869, (double)n2 * 0.3130841121495327, (double)n3 * 0.6074766355140186, (double)n2 * 0.3130841121495327, (double)n3 * 0.6074766355140186);
                generalPath.curveTo((double)n2 * 0.3037383177570093, (double)n3 * 0.6121495327102804, (double)n2 * 0.29906542056074764, (double)n3 * 0.6261682242990654, (double)n2 * 0.308411214953271, (double)n3 * 0.6355140186915887);
                generalPath.curveTo((double)n2 * 0.3130841121495327, (double)n3 * 0.6448598130841121, (double)n2 * 0.32710280373831774, (double)n3 * 0.6495327102803738, (double)n2 * 0.3364485981308411, (double)n3 * 0.6401869158878505);
                generalPath.curveTo((double)n2 * 0.3364485981308411, (double)n3 * 0.6401869158878505, (double)n2 * 0.38317757009345793, (double)n3 * 0.6074766355140186, (double)n2 * 0.38317757009345793, (double)n3 * 0.6074766355140186);
                generalPath.curveTo((double)n2 * 0.38317757009345793, (double)n3 * 0.6074766355140186, (double)n2 * 0.37850467289719625, (double)n3 * 0.6401869158878505, (double)n2 * 0.37850467289719625, (double)n3 * 0.6401869158878505);
                generalPath.curveTo((double)n2 * 0.37850467289719625, (double)n3 * 0.6495327102803738, (double)n2 * 0.38317757009345793, (double)n3 * 0.6588785046728972, (double)n2 * 0.3878504672897196, (double)n3 * 0.6588785046728972);
                generalPath.curveTo((double)n2 * 0.397196261682243, (double)n3 * 0.6588785046728972, (double)n2 * 0.40654205607476634, (double)n3 * 0.6542056074766355, (double)n2 * 0.40654205607476634, (double)n3 * 0.6448598130841121);
                generalPath.curveTo((double)n2 * 0.40654205607476634, (double)n3 * 0.6448598130841121, (double)n2 * 0.4158878504672897, (double)n3 * 0.5934579439252337, (double)n2 * 0.4158878504672897, (double)n3 * 0.5934579439252337);
                generalPath.curveTo((double)n2 * 0.4158878504672897, (double)n3 * 0.5887850467289719, (double)n2 * 0.4158878504672897, (double)n3 * 0.5887850467289719, (double)n2 * 0.4158878504672897, (double)n3 * 0.5841121495327103);
                generalPath.curveTo((double)n2 * 0.4158878504672897, (double)n3 * 0.5841121495327103, (double)n2 * 0.4766355140186916, (double)n3 * 0.5420560747663551, (double)n2 * 0.4766355140186916, (double)n3 * 0.5420560747663551);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.5420560747663551, (double)n2 * 0.4766355140186916, (double)n3 * 0.616822429906542, (double)n2 * 0.4766355140186916, (double)n3 * 0.616822429906542);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.616822429906542, (double)n2 * 0.4719626168224299, (double)n3 * 0.6214953271028038, (double)n2 * 0.4719626168224299, (double)n3 * 0.6214953271028038);
                generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.6214953271028038, (double)n2 * 0.43457943925233644, (double)n3 * 0.6588785046728972, (double)n2 * 0.43457943925233644, (double)n3 * 0.6588785046728972);
                generalPath.curveTo((double)n2 * 0.4252336448598131, (double)n3 * 0.6682242990654206, (double)n2 * 0.4252336448598131, (double)n3 * 0.677570093457944, (double)n2 * 0.43457943925233644, (double)n3 * 0.6822429906542056);
                generalPath.curveTo((double)n2 * 0.4392523364485981, (double)n3 * 0.6869158878504673, (double)n2 * 0.4485981308411215, (double)n3 * 0.6869158878504673, (double)n2 * 0.4532710280373832, (double)n3 * 0.6822429906542056);
                generalPath.curveTo((double)n2 * 0.4532710280373832, (double)n3 * 0.6822429906542056, (double)n2 * 0.4766355140186916, (double)n3 * 0.6588785046728972, (double)n2 * 0.4766355140186916, (double)n3 * 0.6588785046728972);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.6588785046728972, (double)n2 * 0.4766355140186916, (double)n3 * 0.7149532710280374, (double)n2 * 0.4766355140186916, (double)n3 * 0.7149532710280374);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.7242990654205608, (double)n2 * 0.48598130841121495, (double)n3 * 0.7383177570093458, (double)n2 * 0.5, (double)n3 * 0.7383177570093458);
                generalPath.curveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.7383177570093458, (double)n2 * 0.5186915887850467, (double)n3 * 0.7242990654205608, (double)n2 * 0.5186915887850467, (double)n3 * 0.7149532710280374);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.7149532710280374, (double)n2 * 0.5186915887850467, (double)n3 * 0.6588785046728972, (double)n2 * 0.5186915887850467, (double)n3 * 0.6588785046728972);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.6588785046728972, (double)n2 * 0.5420560747663551, (double)n3 * 0.6822429906542056, (double)n2 * 0.5420560747663551, (double)n3 * 0.6822429906542056);
                generalPath.curveTo((double)n2 * 0.5467289719626168, (double)n3 * 0.6869158878504673, (double)n2 * 0.5560747663551402, (double)n3 * 0.6869158878504673, (double)n2 * 0.5607476635514018, (double)n3 * 0.6822429906542056);
                generalPath.curveTo((double)n2 * 0.5700934579439252, (double)n3 * 0.677570093457944, (double)n2 * 0.5700934579439252, (double)n3 * 0.6682242990654206, (double)n2 * 0.5607476635514018, (double)n3 * 0.6588785046728972);
                generalPath.curveTo((double)n2 * 0.5607476635514018, (double)n3 * 0.6588785046728972, (double)n2 * 0.5233644859813084, (double)n3 * 0.6214953271028038, (double)n2 * 0.5233644859813084, (double)n3 * 0.6214953271028038);
                generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.6214953271028038, (double)n2 * 0.5186915887850467, (double)n3 * 0.616822429906542, (double)n2 * 0.5186915887850467, (double)n3 * 0.616822429906542);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.616822429906542, (double)n2 * 0.5186915887850467, (double)n3 * 0.5420560747663551, (double)n2 * 0.5186915887850467, (double)n3 * 0.5420560747663551);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5420560747663551, (double)n2 * 0.5794392523364486, (double)n3 * 0.5841121495327103, (double)n2 * 0.5794392523364486, (double)n3 * 0.5841121495327103);
                generalPath.curveTo((double)n2 * 0.5794392523364486, (double)n3 * 0.5887850467289719, (double)n2 * 0.5794392523364486, (double)n3 * 0.5887850467289719, (double)n2 * 0.5794392523364486, (double)n3 * 0.5934579439252337);
                generalPath.curveTo((double)n2 * 0.5794392523364486, (double)n3 * 0.5934579439252337, (double)n2 * 0.5887850467289719, (double)n3 * 0.6448598130841121, (double)n2 * 0.5887850467289719, (double)n3 * 0.6448598130841121);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.6542056074766355, (double)n2 * 0.5981308411214953, (double)n3 * 0.6588785046728972, (double)n2 * 0.6074766355140186, (double)n3 * 0.6588785046728972);
                generalPath.curveTo((double)n2 * 0.6121495327102804, (double)n3 * 0.6588785046728972, (double)n2 * 0.616822429906542, (double)n3 * 0.6495327102803738, (double)n2 * 0.616822429906542, (double)n3 * 0.6401869158878505);
                generalPath.curveTo((double)n2 * 0.616822429906542, (double)n3 * 0.6401869158878505, (double)n2 * 0.6121495327102804, (double)n3 * 0.6074766355140186, (double)n2 * 0.6121495327102804, (double)n3 * 0.6074766355140186);
                generalPath.curveTo((double)n2 * 0.6121495327102804, (double)n3 * 0.6074766355140186, (double)n2 * 0.6588785046728972, (double)n3 * 0.6401869158878505, (double)n2 * 0.6588785046728972, (double)n3 * 0.6401869158878505);
                generalPath.curveTo((double)n2 * 0.6682242990654206, (double)n3 * 0.6495327102803738, (double)n2 * 0.6822429906542056, (double)n3 * 0.6448598130841121, (double)n2 * 0.6869158878504673, (double)n3 * 0.6355140186915887);
                generalPath.curveTo((double)n2 * 0.6962616822429907, (double)n3 * 0.6261682242990654, (double)n2 * 0.6915887850467289, (double)n3 * 0.6121495327102804, (double)n2 * 0.6822429906542056, (double)n3 * 0.6074766355140186);
                generalPath.curveTo((double)n2 * 0.6822429906542056, (double)n3 * 0.6074766355140186, (double)n2 * 0.6355140186915887, (double)n3 * 0.5747663551401869, (double)n2 * 0.6355140186915887, (double)n3 * 0.5747663551401869);
                generalPath.curveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.5747663551401869, (double)n2 * 0.6682242990654206, (double)n3 * 0.5654205607476636, (double)n2 * 0.6682242990654206, (double)n3 * 0.5654205607476636);
                generalPath.curveTo((double)n2 * 0.677570093457944, (double)n3 * 0.5654205607476636, (double)n2 * 0.6822429906542056, (double)n3 * 0.5607476635514018, (double)n2 * 0.6822429906542056, (double)n3 * 0.5514018691588785);
                generalPath.curveTo((double)n2 * 0.677570093457944, (double)n3 * 0.5420560747663551, (double)n2 * 0.6728971962616822, (double)n3 * 0.5373831775700935, (double)n2 * 0.6635514018691588, (double)n3 * 0.5420560747663551);
                generalPath.curveTo((double)n2 * 0.6635514018691588, (double)n3 * 0.5420560747663551, (double)n2 * 0.6074766355140186, (double)n3 * 0.5514018691588785, (double)n2 * 0.6074766355140186, (double)n3 * 0.5514018691588785);
                generalPath.curveTo((double)n2 * 0.6074766355140186, (double)n3 * 0.5514018691588785, (double)n2 * 0.6074766355140186, (double)n3 * 0.5514018691588785, (double)n2 * 0.602803738317757, (double)n3 * 0.5514018691588785);
                generalPath.curveTo((double)n2 * 0.602803738317757, (double)n3 * 0.5514018691588785, (double)n2 * 0.5327102803738317, (double)n3 * 0.5046728971962616, (double)n2 * 0.5327102803738317, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.5046728971962616, (double)n2 * 0.602803738317757, (double)n3 * 0.4532710280373832, (double)n2 * 0.602803738317757, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.6074766355140186, (double)n3 * 0.4532710280373832, (double)n2 * 0.6074766355140186, (double)n3 * 0.4532710280373832, (double)n2 * 0.6074766355140186, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.6074766355140186, (double)n3 * 0.4532710280373832, (double)n2 * 0.6635514018691588, (double)n3 * 0.46261682242990654, (double)n2 * 0.6635514018691588, (double)n3 * 0.46261682242990654);
                generalPath.curveTo((double)n2 * 0.6728971962616822, (double)n3 * 0.4672897196261682, (double)n2 * 0.677570093457944, (double)n3 * 0.46261682242990654, (double)n2 * 0.6822429906542056, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.6822429906542056, (double)n3 * 0.4439252336448598, (double)n2 * 0.677570093457944, (double)n3 * 0.4392523364485981, (double)n2 * 0.6682242990654206, (double)n3 * 0.4392523364485981);
                generalPath.curveTo((double)n2 * 0.6682242990654206, (double)n3 * 0.4392523364485981, (double)n2 * 0.6355140186915887, (double)n3 * 0.42990654205607476, (double)n2 * 0.6355140186915887, (double)n3 * 0.42990654205607476);
                generalPath.curveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.42990654205607476, (double)n2 * 0.6822429906542056, (double)n3 * 0.397196261682243, (double)n2 * 0.6822429906542056, (double)n3 * 0.397196261682243);
                generalPath.curveTo((double)n2 * 0.6915887850467289, (double)n3 * 0.3925233644859813, (double)n2 * 0.6962616822429907, (double)n3 * 0.37850467289719625, (double)n2 * 0.6869158878504673, (double)n3 * 0.3691588785046729);
                generalPath.curveTo((double)n2 * 0.6822429906542056, (double)n3 * 0.3598130841121495, (double)n2 * 0.6682242990654206, (double)n3 * 0.35514018691588783, (double)n2 * 0.6588785046728972, (double)n3 * 0.3644859813084112);
                generalPath.curveTo((double)n2 * 0.6588785046728972, (double)n3 * 0.3644859813084112, (double)n2 * 0.6121495327102804, (double)n3 * 0.397196261682243, (double)n2 * 0.6121495327102804, (double)n3 * 0.397196261682243);
                generalPath.curveTo((double)n2 * 0.6121495327102804, (double)n3 * 0.397196261682243, (double)n2 * 0.616822429906542, (double)n3 * 0.3644859813084112, (double)n2 * 0.616822429906542, (double)n3 * 0.3644859813084112);
                generalPath.curveTo((double)n2 * 0.616822429906542, (double)n3 * 0.35514018691588783, (double)n2 * 0.6121495327102804, (double)n3 * 0.34579439252336447, (double)n2 * 0.6074766355140186, (double)n3 * 0.34579439252336447);
                generalPath.curveTo((double)n2 * 0.5981308411214953, (double)n3 * 0.34579439252336447, (double)n2 * 0.5887850467289719, (double)n3 * 0.35046728971962615, (double)n2 * 0.5887850467289719, (double)n3 * 0.3598130841121495);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.3598130841121495, (double)n2 * 0.5794392523364486, (double)n3 * 0.411214953271028, (double)n2 * 0.5794392523364486, (double)n3 * 0.411214953271028);
                generalPath.curveTo((double)n2 * 0.5794392523364486, (double)n3 * 0.4158878504672897, (double)n2 * 0.5794392523364486, (double)n3 * 0.4158878504672897, (double)n2 * 0.5794392523364486, (double)n3 * 0.4205607476635514);
                generalPath.curveTo((double)n2 * 0.5794392523364486, (double)n3 * 0.4205607476635514, (double)n2 * 0.5186915887850467, (double)n3 * 0.46261682242990654, (double)n2 * 0.5186915887850467, (double)n3 * 0.46261682242990654);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.46261682242990654, (double)n2 * 0.5186915887850467, (double)n3 * 0.3878504672897196, (double)n2 * 0.5186915887850467, (double)n3 * 0.3878504672897196);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.3878504672897196, (double)n2 * 0.5233644859813084, (double)n3 * 0.38317757009345793, (double)n2 * 0.5233644859813084, (double)n3 * 0.38317757009345793);
                generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.38317757009345793, (double)n2 * 0.5607476635514018, (double)n3 * 0.34579439252336447, (double)n2 * 0.5607476635514018, (double)n3 * 0.34579439252336447);
                generalPath.curveTo((double)n2 * 0.5700934579439252, (double)n3 * 0.3364485981308411, (double)n2 * 0.5700934579439252, (double)n3 * 0.32710280373831774, (double)n2 * 0.5607476635514018, (double)n3 * 0.32242990654205606);
                generalPath.curveTo((double)n2 * 0.5560747663551402, (double)n3 * 0.3177570093457944, (double)n2 * 0.5467289719626168, (double)n3 * 0.3177570093457944, (double)n2 * 0.5420560747663551, (double)n3 * 0.32242990654205606);
                generalPath.curveTo((double)n2 * 0.5420560747663551, (double)n3 * 0.32242990654205606, (double)n2 * 0.5186915887850467, (double)n3 * 0.34579439252336447, (double)n2 * 0.5186915887850467, (double)n3 * 0.34579439252336447);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.34579439252336447, (double)n2 * 0.5186915887850467, (double)n3 * 0.2897196261682243, (double)n2 * 0.5186915887850467, (double)n3 * 0.2897196261682243);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.2803738317757009, (double)n2 * 0.5093457943925234, (double)n3 * 0.27102803738317754, (double)n2 * 0.5, (double)n3 * 0.27102803738317754);
                generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.27102803738317754, (double)n2 * 0.4766355140186916, (double)n3 * 0.2803738317757009, (double)n2 * 0.4766355140186916, (double)n3 * 0.2897196261682243);
                generalPath.closePath();
                break;
            }
            case BREAK: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.35046728971962615, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.35046728971962615, (double)n3 * 0.4205607476635514, (double)n2 * 0.4205607476635514, (double)n3 * 0.35046728971962615, (double)n2 * 0.5046728971962616, (double)n3 * 0.35046728971962615);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.35046728971962615, (double)n2 * 0.6542056074766355, (double)n3 * 0.4205607476635514, (double)n2 * 0.6542056074766355, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.6542056074766355, (double)n3 * 0.5841121495327103, (double)n2 * 0.5887850467289719, (double)n3 * 0.6542056074766355, (double)n2 * 0.5046728971962616, (double)n3 * 0.6542056074766355);
                generalPath.curveTo((double)n2 * 0.4205607476635514, (double)n3 * 0.6542056074766355, (double)n2 * 0.35046728971962615, (double)n3 * 0.5841121495327103, (double)n2 * 0.35046728971962615, (double)n3 * 0.5046728971962616);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.32242990654205606, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.32242990654205606, (double)n3 * 0.602803738317757, (double)n2 * 0.40186915887850466, (double)n3 * 0.6822429906542056, (double)n2 * 0.5046728971962616, (double)n3 * 0.6822429906542056);
                generalPath.curveTo((double)n2 * 0.602803738317757, (double)n3 * 0.6822429906542056, (double)n2 * 0.6822429906542056, (double)n3 * 0.602803738317757, (double)n2 * 0.6822429906542056, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.6822429906542056, (double)n3 * 0.40186915887850466, (double)n2 * 0.602803738317757, (double)n3 * 0.32242990654205606, (double)n2 * 0.5046728971962616, (double)n3 * 0.32242990654205606);
                generalPath.curveTo((double)n2 * 0.40186915887850466, (double)n3 * 0.32242990654205606, (double)n2 * 0.32242990654205606, (double)n3 * 0.40186915887850466, (double)n2 * 0.32242990654205606, (double)n3 * 0.5046728971962616);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5747663551401869);
                generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5934579439252337, (double)n2 * 0.48598130841121495, (double)n3 * 0.6074766355140186, (double)n2 * 0.5046728971962616, (double)n3 * 0.6074766355140186);
                generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.6074766355140186, (double)n2 * 0.5373831775700935, (double)n3 * 0.5934579439252337, (double)n2 * 0.5373831775700935, (double)n3 * 0.5747663551401869);
                generalPath.curveTo((double)n2 * 0.5373831775700935, (double)n3 * 0.5560747663551402, (double)n2 * 0.5233644859813084, (double)n3 * 0.5420560747663551, (double)n2 * 0.5046728971962616, (double)n3 * 0.5420560747663551);
                generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.5420560747663551, (double)n2 * 0.4719626168224299, (double)n3 * 0.5560747663551402, (double)n2 * 0.4719626168224299, (double)n3 * 0.5747663551401869);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.37850467289719625);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.5233644859813084);
                generalPath.lineTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5233644859813084);
                generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.37850467289719625);
                generalPath.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.37850467289719625);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.6588785046728972, (double)n3 * 0.3364485981308411);
                generalPath.curveTo((double)n2 * 0.6401869158878505, (double)n3 * 0.3317757009345794, (double)n2 * 0.6355140186915887, (double)n3 * 0.3411214953271028, (double)n2 * 0.6355140186915887, (double)n3 * 0.35514018691588783);
                generalPath.curveTo((double)n2 * 0.6822429906542056, (double)n3 * 0.3925233644859813, (double)n2 * 0.705607476635514, (double)n3 * 0.4439252336448598, (double)n2 * 0.705607476635514, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.705607476635514, (double)n3 * 0.5514018691588785, (double)n2 * 0.6822429906542056, (double)n3 * 0.602803738317757, (double)n2 * 0.6448598130841121, (double)n3 * 0.6448598130841121);
                generalPath.curveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.6635514018691588, (double)n2 * 0.6495327102803738, (double)n3 * 0.6682242990654206, (double)n2 * 0.6588785046728972, (double)n3 * 0.6635514018691588);
                generalPath.curveTo((double)n2 * 0.6915887850467289, (double)n3 * 0.6448598130841121, (double)n2 * 0.7336448598130841, (double)n3 * 0.5700934579439252, (double)n2 * 0.7336448598130841, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.7336448598130841, (double)n3 * 0.4252336448598131, (double)n2 * 0.6962616822429907, (double)n3 * 0.3691588785046729, (double)n2 * 0.6588785046728972, (double)n3 * 0.3364485981308411);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.34579439252336447, (double)n3 * 0.3364485981308411);
                generalPath.curveTo((double)n2 * 0.308411214953271, (double)n3 * 0.3691588785046729, (double)n2 * 0.26635514018691586, (double)n3 * 0.4252336448598131, (double)n2 * 0.26635514018691586, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.5700934579439252, (double)n2 * 0.3130841121495327, (double)n3 * 0.6448598130841121, (double)n2 * 0.3411214953271028, (double)n3 * 0.6635514018691588);
                generalPath.curveTo((double)n2 * 0.35514018691588783, (double)n3 * 0.6682242990654206, (double)n2 * 0.3644859813084112, (double)n3 * 0.6635514018691588, (double)n2 * 0.3598130841121495, (double)n3 * 0.6448598130841121);
                generalPath.curveTo((double)n2 * 0.3177570093457944, (double)n3 * 0.602803738317757, (double)n2 * 0.29906542056074764, (double)n3 * 0.5514018691588785, (double)n2 * 0.29906542056074764, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.29906542056074764, (double)n3 * 0.4439252336448598, (double)n2 * 0.32242990654205606, (double)n3 * 0.3925233644859813, (double)n2 * 0.3644859813084112, (double)n3 * 0.35514018691588783);
                generalPath.curveTo((double)n2 * 0.3691588785046729, (double)n3 * 0.3411214953271028, (double)n2 * 0.3598130841121495, (double)n3 * 0.3317757009345794, (double)n2 * 0.34579439252336447, (double)n3 * 0.3364485981308411);
                generalPath.closePath();
                break;
            }
            case ABS: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.35046728971962615, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.35046728971962615, (double)n3 * 0.4205607476635514, (double)n2 * 0.4205607476635514, (double)n3 * 0.35046728971962615, (double)n2 * 0.5046728971962616, (double)n3 * 0.35046728971962615);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.35046728971962615, (double)n2 * 0.6542056074766355, (double)n3 * 0.4205607476635514, (double)n2 * 0.6542056074766355, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.6542056074766355, (double)n3 * 0.5841121495327103, (double)n2 * 0.5887850467289719, (double)n3 * 0.6542056074766355, (double)n2 * 0.5046728971962616, (double)n3 * 0.6542056074766355);
                generalPath.curveTo((double)n2 * 0.4205607476635514, (double)n3 * 0.6542056074766355, (double)n2 * 0.35046728971962615, (double)n3 * 0.5841121495327103, (double)n2 * 0.35046728971962615, (double)n3 * 0.5046728971962616);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.32242990654205606, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.32242990654205606, (double)n3 * 0.602803738317757, (double)n2 * 0.40186915887850466, (double)n3 * 0.6822429906542056, (double)n2 * 0.5046728971962616, (double)n3 * 0.6822429906542056);
                generalPath.curveTo((double)n2 * 0.602803738317757, (double)n3 * 0.6822429906542056, (double)n2 * 0.6822429906542056, (double)n3 * 0.602803738317757, (double)n2 * 0.6822429906542056, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.6822429906542056, (double)n3 * 0.40186915887850466, (double)n2 * 0.602803738317757, (double)n3 * 0.32242990654205606, (double)n2 * 0.5046728971962616, (double)n3 * 0.32242990654205606);
                generalPath.curveTo((double)n2 * 0.40186915887850466, (double)n3 * 0.32242990654205606, (double)n2 * 0.32242990654205606, (double)n3 * 0.40186915887850466, (double)n2 * 0.32242990654205606, (double)n3 * 0.5046728971962616);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.5841121495327103, (double)n3 * 0.5420560747663551);
                generalPath.curveTo((double)n2 * 0.5981308411214953, (double)n3 * 0.5420560747663551, (double)n2 * 0.602803738317757, (double)n3 * 0.5420560747663551, (double)n2 * 0.6121495327102804, (double)n3 * 0.5373831775700935);
                generalPath.curveTo((double)n2 * 0.616822429906542, (double)n3 * 0.5327102803738317, (double)n2 * 0.616822429906542, (double)n3 * 0.5233644859813084, (double)n2 * 0.616822429906542, (double)n3 * 0.5186915887850467);
                generalPath.curveTo((double)n2 * 0.616822429906542, (double)n3 * 0.514018691588785, (double)n2 * 0.616822429906542, (double)n3 * 0.5093457943925234, (double)n2 * 0.616822429906542, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.6121495327102804, (double)n3 * 0.5, (double)n2 * 0.6121495327102804, (double)n3 * 0.5, (double)n2 * 0.6074766355140186, (double)n3 * 0.4953271028037383);
                generalPath.curveTo((double)n2 * 0.602803738317757, (double)n3 * 0.4953271028037383, (double)n2 * 0.5981308411214953, (double)n3 * 0.49065420560747663, (double)n2 * 0.5887850467289719, (double)n3 * 0.49065420560747663);
                generalPath.curveTo((double)n2 * 0.5794392523364486, (double)n3 * 0.48598130841121495, (double)n2 * 0.5747663551401869, (double)n3 * 0.48598130841121495, (double)n2 * 0.5747663551401869, (double)n3 * 0.48130841121495327);
                generalPath.curveTo((double)n2 * 0.5747663551401869, (double)n3 * 0.48130841121495327, (double)n2 * 0.5747663551401869, (double)n3 * 0.48130841121495327, (double)n2 * 0.5747663551401869, (double)n3 * 0.4766355140186916);
                generalPath.curveTo((double)n2 * 0.5747663551401869, (double)n3 * 0.4766355140186916, (double)n2 * 0.5747663551401869, (double)n3 * 0.4719626168224299, (double)n2 * 0.5747663551401869, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.5794392523364486, (double)n3 * 0.4719626168224299, (double)n2 * 0.5794392523364486, (double)n3 * 0.4719626168224299, (double)n2 * 0.5841121495327103, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.4719626168224299, (double)n2 * 0.5934579439252337, (double)n3 * 0.4719626168224299, (double)n2 * 0.5934579439252337, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.5981308411214953, (double)n3 * 0.4719626168224299, (double)n2 * 0.5981308411214953, (double)n3 * 0.4766355140186916, (double)n2 * 0.5981308411214953, (double)n3 * 0.48130841121495327);
                generalPath.curveTo((double)n2 * 0.5981308411214953, (double)n3 * 0.48130841121495327, (double)n2 * 0.616822429906542, (double)n3 * 0.48130841121495327, (double)n2 * 0.616822429906542, (double)n3 * 0.48130841121495327);
                generalPath.curveTo((double)n2 * 0.616822429906542, (double)n3 * 0.4719626168224299, (double)n2 * 0.616822429906542, (double)n3 * 0.46261682242990654, (double)n2 * 0.6074766355140186, (double)n3 * 0.45794392523364486);
                generalPath.curveTo((double)n2 * 0.602803738317757, (double)n3 * 0.4532710280373832, (double)n2 * 0.5981308411214953, (double)n3 * 0.4532710280373832, (double)n2 * 0.5841121495327103, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.5794392523364486, (double)n3 * 0.4532710280373832, (double)n2 * 0.5747663551401869, (double)n3 * 0.4532710280373832, (double)n2 * 0.5700934579439252, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.5654205607476636, (double)n3 * 0.45794392523364486, (double)n2 * 0.5607476635514018, (double)n3 * 0.45794392523364486, (double)n2 * 0.5560747663551402, (double)n3 * 0.46261682242990654);
                generalPath.curveTo((double)n2 * 0.5560747663551402, (double)n3 * 0.4672897196261682, (double)n2 * 0.5560747663551402, (double)n3 * 0.4719626168224299, (double)n2 * 0.5560747663551402, (double)n3 * 0.4766355140186916);
                generalPath.curveTo((double)n2 * 0.5560747663551402, (double)n3 * 0.48130841121495327, (double)n2 * 0.5560747663551402, (double)n3 * 0.48598130841121495, (double)n2 * 0.5560747663551402, (double)n3 * 0.49065420560747663);
                generalPath.curveTo((double)n2 * 0.5607476635514018, (double)n3 * 0.4953271028037383, (double)n2 * 0.5607476635514018, (double)n3 * 0.4953271028037383, (double)n2 * 0.5654205607476636, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5700934579439252, (double)n3 * 0.5, (double)n2 * 0.5747663551401869, (double)n3 * 0.5046728971962616, (double)n2 * 0.5794392523364486, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.5093457943925234, (double)n2 * 0.5934579439252337, (double)n3 * 0.5093457943925234, (double)n2 * 0.5934579439252337, (double)n3 * 0.5093457943925234);
                generalPath.curveTo((double)n2 * 0.5981308411214953, (double)n3 * 0.5093457943925234, (double)n2 * 0.5981308411214953, (double)n3 * 0.514018691588785, (double)n2 * 0.5981308411214953, (double)n3 * 0.514018691588785);
                generalPath.curveTo((double)n2 * 0.5981308411214953, (double)n3 * 0.514018691588785, (double)n2 * 0.5981308411214953, (double)n3 * 0.514018691588785, (double)n2 * 0.5981308411214953, (double)n3 * 0.5186915887850467);
                generalPath.curveTo((double)n2 * 0.5981308411214953, (double)n3 * 0.5186915887850467, (double)n2 * 0.5981308411214953, (double)n3 * 0.5233644859813084, (double)n2 * 0.5981308411214953, (double)n3 * 0.5233644859813084);
                generalPath.curveTo((double)n2 * 0.5934579439252337, (double)n3 * 0.5233644859813084, (double)n2 * 0.5887850467289719, (double)n3 * 0.5233644859813084, (double)n2 * 0.5841121495327103, (double)n3 * 0.5233644859813084);
                generalPath.curveTo((double)n2 * 0.5747663551401869, (double)n3 * 0.5233644859813084, (double)n2 * 0.5700934579439252, (double)n3 * 0.5233644859813084, (double)n2 * 0.5700934579439252, (double)n3 * 0.514018691588785);
                generalPath.curveTo((double)n2 * 0.5700934579439252, (double)n3 * 0.514018691588785, (double)n2 * 0.5514018691588785, (double)n3 * 0.514018691588785, (double)n2 * 0.5514018691588785, (double)n3 * 0.514018691588785);
                generalPath.curveTo((double)n2 * 0.5560747663551402, (double)n3 * 0.5327102803738317, (double)n2 * 0.5654205607476636, (double)n3 * 0.5420560747663551, (double)n2 * 0.5841121495327103, (double)n3 * 0.5420560747663551);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5420560747663551);
                generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5420560747663551, (double)n2 * 0.4953271028037383, (double)n3 * 0.5420560747663551, (double)n2 * 0.4953271028037383, (double)n3 * 0.5420560747663551);
                generalPath.curveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5420560747663551, (double)n2 * 0.514018691588785, (double)n3 * 0.5420560747663551, (double)n2 * 0.5186915887850467, (double)n3 * 0.5420560747663551);
                generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.5420560747663551, (double)n2 * 0.5280373831775701, (double)n3 * 0.5373831775700935, (double)n2 * 0.5327102803738317, (double)n3 * 0.5327102803738317);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.5280373831775701, (double)n2 * 0.5373831775700935, (double)n3 * 0.5233644859813084, (double)n2 * 0.5373831775700935, (double)n3 * 0.5186915887850467);
                generalPath.curveTo((double)n2 * 0.5373831775700935, (double)n3 * 0.514018691588785, (double)n2 * 0.5327102803738317, (double)n3 * 0.5093457943925234, (double)n2 * 0.5327102803738317, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.5, (double)n2 * 0.5280373831775701, (double)n3 * 0.5, (double)n2 * 0.5233644859813084, (double)n3 * 0.4953271028037383);
                generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.4953271028037383, (double)n2 * 0.5280373831775701, (double)n3 * 0.49065420560747663, (double)n2 * 0.5327102803738317, (double)n3 * 0.48598130841121495);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.48598130841121495, (double)n2 * 0.5373831775700935, (double)n3 * 0.48130841121495327, (double)n2 * 0.5373831775700935, (double)n3 * 0.4766355140186916);
                generalPath.curveTo((double)n2 * 0.5373831775700935, (double)n3 * 0.4719626168224299, (double)n2 * 0.5327102803738317, (double)n3 * 0.4672897196261682, (double)n2 * 0.5327102803738317, (double)n3 * 0.46261682242990654);
                generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.45794392523364486, (double)n2 * 0.5280373831775701, (double)n3 * 0.45794392523364486, (double)n2 * 0.5233644859813084, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4532710280373832, (double)n2 * 0.514018691588785, (double)n3 * 0.4532710280373832, (double)n2 * 0.5046728971962616, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.4532710280373832, (double)n2 * 0.4719626168224299, (double)n3 * 0.4532710280373832, (double)n2 * 0.4719626168224299, (double)n3 * 0.4532710280373832);
                generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5420560747663551);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.4953271028037383, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.4719626168224299, (double)n2 * 0.5093457943925234, (double)n3 * 0.4719626168224299, (double)n2 * 0.5093457943925234, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.4719626168224299, (double)n2 * 0.514018691588785, (double)n3 * 0.4719626168224299, (double)n2 * 0.514018691588785, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4766355140186916, (double)n2 * 0.5186915887850467, (double)n3 * 0.4766355140186916, (double)n2 * 0.5186915887850467, (double)n3 * 0.48130841121495327);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.48130841121495327, (double)n2 * 0.514018691588785, (double)n3 * 0.48598130841121495, (double)n2 * 0.514018691588785, (double)n3 * 0.48598130841121495);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.48598130841121495, (double)n2 * 0.5093457943925234, (double)n3 * 0.48598130841121495, (double)n2 * 0.5093457943925234, (double)n3 * 0.48598130841121495);
                generalPath.curveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.49065420560747663, (double)n2 * 0.5046728971962616, (double)n3 * 0.49065420560747663, (double)n2 * 0.5, (double)n3 * 0.49065420560747663);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.49065420560747663, (double)n2 * 0.49065420560747663, (double)n3 * 0.49065420560747663, (double)n2 * 0.49065420560747663, (double)n3 * 0.49065420560747663);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.4719626168224299, (double)n2 * 0.4953271028037383, (double)n3 * 0.4719626168224299, (double)n2 * 0.4953271028037383, (double)n3 * 0.4719626168224299);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.5046728971962616, (double)n2 * 0.5093457943925234, (double)n3 * 0.5093457943925234, (double)n2 * 0.5093457943925234, (double)n3 * 0.5093457943925234);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.5093457943925234, (double)n2 * 0.514018691588785, (double)n3 * 0.5093457943925234, (double)n2 * 0.514018691588785, (double)n3 * 0.5093457943925234);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.514018691588785, (double)n2 * 0.5186915887850467, (double)n3 * 0.514018691588785, (double)n2 * 0.5186915887850467, (double)n3 * 0.514018691588785);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5186915887850467, (double)n2 * 0.5186915887850467, (double)n3 * 0.5186915887850467, (double)n2 * 0.514018691588785, (double)n3 * 0.5233644859813084);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.5233644859813084, (double)n2 * 0.514018691588785, (double)n3 * 0.5233644859813084, (double)n2 * 0.514018691588785, (double)n3 * 0.5233644859813084);
                generalPath.curveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5233644859813084, (double)n2 * 0.5046728971962616, (double)n3 * 0.5233644859813084, (double)n2 * 0.5, (double)n3 * 0.5233644859813084);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.5233644859813084, (double)n2 * 0.49065420560747663, (double)n3 * 0.5233644859813084, (double)n2 * 0.49065420560747663, (double)n3 * 0.5233644859813084);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.5046728971962616, (double)n2 * 0.5, (double)n3 * 0.5046728971962616, (double)n2 * 0.5, (double)n3 * 0.5046728971962616);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.43457943925233644, (double)n3 * 0.4532710280373832);
                generalPath.lineTo((double)n2 * 0.4158878504672897, (double)n3 * 0.4532710280373832);
                generalPath.lineTo((double)n2 * 0.3878504672897196, (double)n3 * 0.5420560747663551);
                generalPath.lineTo((double)n2 * 0.40654205607476634, (double)n3 * 0.5420560747663551);
                generalPath.lineTo((double)n2 * 0.411214953271028, (double)n3 * 0.5233644859813084);
                generalPath.lineTo((double)n2 * 0.4392523364485981, (double)n3 * 0.5233644859813084);
                generalPath.lineTo((double)n2 * 0.4439252336448598, (double)n3 * 0.5420560747663551);
                generalPath.lineTo((double)n2 * 0.46261682242990654, (double)n3 * 0.5420560747663551);
                generalPath.lineTo((double)n2 * 0.43457943925233644, (double)n3 * 0.4532710280373832);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.4158878504672897, (double)n3 * 0.5046728971962616);
                generalPath.lineTo((double)n2 * 0.4252336448598131, (double)n3 * 0.4719626168224299);
                generalPath.lineTo((double)n2 * 0.43457943925233644, (double)n3 * 0.5046728971962616);
                generalPath.lineTo((double)n2 * 0.4158878504672897, (double)n3 * 0.5046728971962616);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.6588785046728972, (double)n3 * 0.3364485981308411);
                generalPath.curveTo((double)n2 * 0.6401869158878505, (double)n3 * 0.3317757009345794, (double)n2 * 0.6355140186915887, (double)n3 * 0.3411214953271028, (double)n2 * 0.6355140186915887, (double)n3 * 0.35514018691588783);
                generalPath.curveTo((double)n2 * 0.6822429906542056, (double)n3 * 0.3925233644859813, (double)n2 * 0.705607476635514, (double)n3 * 0.4439252336448598, (double)n2 * 0.705607476635514, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.705607476635514, (double)n3 * 0.5514018691588785, (double)n2 * 0.6822429906542056, (double)n3 * 0.602803738317757, (double)n2 * 0.6448598130841121, (double)n3 * 0.6448598130841121);
                generalPath.curveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.6635514018691588, (double)n2 * 0.6495327102803738, (double)n3 * 0.6682242990654206, (double)n2 * 0.6588785046728972, (double)n3 * 0.6635514018691588);
                generalPath.curveTo((double)n2 * 0.6915887850467289, (double)n3 * 0.6448598130841121, (double)n2 * 0.7336448598130841, (double)n3 * 0.5700934579439252, (double)n2 * 0.7336448598130841, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.7336448598130841, (double)n3 * 0.4252336448598131, (double)n2 * 0.6962616822429907, (double)n3 * 0.3691588785046729, (double)n2 * 0.6588785046728972, (double)n3 * 0.3364485981308411);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.34579439252336447, (double)n3 * 0.3364485981308411);
                generalPath.curveTo((double)n2 * 0.308411214953271, (double)n3 * 0.3691588785046729, (double)n2 * 0.26635514018691586, (double)n3 * 0.4252336448598131, (double)n2 * 0.26635514018691586, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.5700934579439252, (double)n2 * 0.3130841121495327, (double)n3 * 0.6448598130841121, (double)n2 * 0.3411214953271028, (double)n3 * 0.6635514018691588);
                generalPath.curveTo((double)n2 * 0.35514018691588783, (double)n3 * 0.6682242990654206, (double)n2 * 0.3644859813084112, (double)n3 * 0.6635514018691588, (double)n2 * 0.3598130841121495, (double)n3 * 0.6448598130841121);
                generalPath.curveTo((double)n2 * 0.3177570093457944, (double)n3 * 0.602803738317757, (double)n2 * 0.29906542056074764, (double)n3 * 0.5514018691588785, (double)n2 * 0.29906542056074764, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.29906542056074764, (double)n3 * 0.4439252336448598, (double)n2 * 0.32242990654205606, (double)n3 * 0.3925233644859813, (double)n2 * 0.3644859813084112, (double)n3 * 0.35514018691588783);
                generalPath.curveTo((double)n2 * 0.3691588785046729, (double)n3 * 0.3411214953271028, (double)n2 * 0.3598130841121495, (double)n3 * 0.3317757009345794, (double)n2 * 0.34579439252336447, (double)n3 * 0.3364485981308411);
                generalPath.closePath();
                break;
            }
            case ESP: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.35046728971962615, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.35046728971962615, (double)n3 * 0.4205607476635514, (double)n2 * 0.4205607476635514, (double)n3 * 0.35046728971962615, (double)n2 * 0.5046728971962616, (double)n3 * 0.35046728971962615);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.35046728971962615, (double)n2 * 0.6542056074766355, (double)n3 * 0.4205607476635514, (double)n2 * 0.6542056074766355, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.6542056074766355, (double)n3 * 0.5841121495327103, (double)n2 * 0.5887850467289719, (double)n3 * 0.6542056074766355, (double)n2 * 0.5046728971962616, (double)n3 * 0.6542056074766355);
                generalPath.curveTo((double)n2 * 0.4205607476635514, (double)n3 * 0.6542056074766355, (double)n2 * 0.35046728971962615, (double)n3 * 0.5841121495327103, (double)n2 * 0.35046728971962615, (double)n3 * 0.5046728971962616);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.32242990654205606, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.32242990654205606, (double)n3 * 0.602803738317757, (double)n2 * 0.40186915887850466, (double)n3 * 0.6822429906542056, (double)n2 * 0.5046728971962616, (double)n3 * 0.6822429906542056);
                generalPath.curveTo((double)n2 * 0.602803738317757, (double)n3 * 0.6822429906542056, (double)n2 * 0.6822429906542056, (double)n3 * 0.602803738317757, (double)n2 * 0.6822429906542056, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.6822429906542056, (double)n3 * 0.40186915887850466, (double)n2 * 0.602803738317757, (double)n3 * 0.32242990654205606, (double)n2 * 0.5046728971962616, (double)n3 * 0.32242990654205606);
                generalPath.curveTo((double)n2 * 0.40186915887850466, (double)n3 * 0.32242990654205606, (double)n2 * 0.32242990654205606, (double)n3 * 0.40186915887850466, (double)n2 * 0.32242990654205606, (double)n3 * 0.5046728971962616);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.5747663551401869, (double)n3 * 0.5420560747663551);
                generalPath.lineTo((double)n2 * 0.5747663551401869, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.5747663551401869, (double)n3 * 0.5046728971962616, (double)n2 * 0.5794392523364486, (double)n3 * 0.5046728971962616, (double)n2 * 0.5794392523364486, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.5046728971962616, (double)n2 * 0.5934579439252337, (double)n3 * 0.5046728971962616, (double)n2 * 0.5981308411214953, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.602803738317757, (double)n3 * 0.5046728971962616, (double)n2 * 0.602803738317757, (double)n3 * 0.5, (double)n2 * 0.6074766355140186, (double)n3 * 0.4953271028037383);
                generalPath.curveTo((double)n2 * 0.6074766355140186, (double)n3 * 0.49065420560747663, (double)n2 * 0.6074766355140186, (double)n3 * 0.48598130841121495, (double)n2 * 0.6074766355140186, (double)n3 * 0.48130841121495327);
                generalPath.curveTo((double)n2 * 0.6074766355140186, (double)n3 * 0.4719626168224299, (double)n2 * 0.6074766355140186, (double)n3 * 0.4672897196261682, (double)n2 * 0.6074766355140186, (double)n3 * 0.46261682242990654);
                generalPath.curveTo((double)n2 * 0.602803738317757, (double)n3 * 0.45794392523364486, (double)n2 * 0.5981308411214953, (double)n3 * 0.4532710280373832, (double)n2 * 0.5934579439252337, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.5934579439252337, (double)n3 * 0.4532710280373832, (double)n2 * 0.5841121495327103, (double)n3 * 0.4532710280373832, (double)n2 * 0.5794392523364486, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.5794392523364486, (double)n3 * 0.4532710280373832, (double)n2 * 0.5560747663551402, (double)n3 * 0.4532710280373832, (double)n2 * 0.5560747663551402, (double)n3 * 0.4532710280373832);
                generalPath.lineTo((double)n2 * 0.5560747663551402, (double)n3 * 0.5420560747663551);
                generalPath.lineTo((double)n2 * 0.5747663551401869, (double)n3 * 0.5420560747663551);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.5794392523364486, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.5841121495327103, (double)n3 * 0.4719626168224299, (double)n2 * 0.5841121495327103, (double)n3 * 0.4719626168224299, (double)n2 * 0.5841121495327103, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.4719626168224299, (double)n2 * 0.5887850467289719, (double)n3 * 0.4719626168224299, (double)n2 * 0.5887850467289719, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.4766355140186916, (double)n2 * 0.5887850467289719, (double)n3 * 0.4766355140186916, (double)n2 * 0.5887850467289719, (double)n3 * 0.48130841121495327);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.48130841121495327, (double)n2 * 0.5887850467289719, (double)n3 * 0.48130841121495327, (double)n2 * 0.5887850467289719, (double)n3 * 0.48598130841121495);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.48598130841121495, (double)n2 * 0.5887850467289719, (double)n3 * 0.48598130841121495, (double)n2 * 0.5841121495327103, (double)n3 * 0.48598130841121495);
                generalPath.curveTo((double)n2 * 0.5841121495327103, (double)n3 * 0.48598130841121495, (double)n2 * 0.5841121495327103, (double)n3 * 0.49065420560747663, (double)n2 * 0.5794392523364486, (double)n3 * 0.49065420560747663);
                generalPath.curveTo((double)n2 * 0.5794392523364486, (double)n3 * 0.49065420560747663, (double)n2 * 0.5747663551401869, (double)n3 * 0.49065420560747663, (double)n2 * 0.5747663551401869, (double)n3 * 0.49065420560747663);
                generalPath.lineTo((double)n2 * 0.5747663551401869, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.5747663551401869, (double)n3 * 0.4719626168224299, (double)n2 * 0.5794392523364486, (double)n3 * 0.4719626168224299, (double)n2 * 0.5794392523364486, (double)n3 * 0.4719626168224299);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5420560747663551);
                generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.5420560747663551, (double)n2 * 0.5327102803738317, (double)n3 * 0.5420560747663551, (double)n2 * 0.5373831775700935, (double)n3 * 0.5373831775700935);
                generalPath.curveTo((double)n2 * 0.5420560747663551, (double)n3 * 0.5327102803738317, (double)n2 * 0.5467289719626168, (double)n3 * 0.5233644859813084, (double)n2 * 0.5467289719626168, (double)n3 * 0.5186915887850467);
                generalPath.curveTo((double)n2 * 0.5467289719626168, (double)n3 * 0.514018691588785, (double)n2 * 0.5420560747663551, (double)n3 * 0.5093457943925234, (double)n2 * 0.5420560747663551, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.5373831775700935, (double)n3 * 0.5, (double)n2 * 0.5373831775700935, (double)n3 * 0.5, (double)n2 * 0.5327102803738317, (double)n3 * 0.4953271028037383);
                generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.4953271028037383, (double)n2 * 0.5233644859813084, (double)n3 * 0.49065420560747663, (double)n2 * 0.514018691588785, (double)n3 * 0.49065420560747663);
                generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.48598130841121495, (double)n2 * 0.5, (double)n3 * 0.48598130841121495, (double)n2 * 0.5, (double)n3 * 0.48130841121495327);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.48130841121495327, (double)n2 * 0.5, (double)n3 * 0.48130841121495327, (double)n2 * 0.5, (double)n3 * 0.4766355140186916);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.4766355140186916, (double)n2 * 0.5, (double)n3 * 0.4719626168224299, (double)n2 * 0.5, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.4719626168224299, (double)n2 * 0.5093457943925234, (double)n3 * 0.4719626168224299, (double)n2 * 0.514018691588785, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.4719626168224299, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299, (double)n2 * 0.5233644859813084, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.4719626168224299, (double)n2 * 0.5233644859813084, (double)n3 * 0.4766355140186916, (double)n2 * 0.5280373831775701, (double)n3 * 0.48130841121495327);
                generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.48130841121495327, (double)n2 * 0.5467289719626168, (double)n3 * 0.48130841121495327, (double)n2 * 0.5467289719626168, (double)n3 * 0.48130841121495327);
                generalPath.curveTo((double)n2 * 0.5467289719626168, (double)n3 * 0.4719626168224299, (double)n2 * 0.5420560747663551, (double)n3 * 0.46261682242990654, (double)n2 * 0.5373831775700935, (double)n3 * 0.45794392523364486);
                generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.4532710280373832, (double)n2 * 0.5233644859813084, (double)n3 * 0.4532710280373832, (double)n2 * 0.514018691588785, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.4532710280373832, (double)n2 * 0.5, (double)n3 * 0.4532710280373832, (double)n2 * 0.4953271028037383, (double)n3 * 0.4532710280373832);
                generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.45794392523364486, (double)n2 * 0.48598130841121495, (double)n3 * 0.45794392523364486, (double)n2 * 0.48598130841121495, (double)n3 * 0.46261682242990654);
                generalPath.curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.4672897196261682, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299, (double)n2 * 0.48130841121495327, (double)n3 * 0.4766355140186916);
                generalPath.curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.48130841121495327, (double)n2 * 0.48130841121495327, (double)n3 * 0.48598130841121495, (double)n2 * 0.48130841121495327, (double)n3 * 0.49065420560747663);
                generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.4953271028037383, (double)n2 * 0.48598130841121495, (double)n3 * 0.4953271028037383, (double)n2 * 0.49065420560747663, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4953271028037383, (double)n3 * 0.5, (double)n2 * 0.5, (double)n3 * 0.5046728971962616, (double)n2 * 0.5046728971962616, (double)n3 * 0.5046728971962616);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.5093457943925234, (double)n2 * 0.5186915887850467, (double)n3 * 0.5093457943925234, (double)n2 * 0.5233644859813084, (double)n3 * 0.5093457943925234);
                generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.5093457943925234, (double)n2 * 0.5233644859813084, (double)n3 * 0.514018691588785, (double)n2 * 0.5233644859813084, (double)n3 * 0.514018691588785);
                generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.514018691588785, (double)n2 * 0.5280373831775701, (double)n3 * 0.514018691588785, (double)n2 * 0.5280373831775701, (double)n3 * 0.5186915887850467);
                generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.5186915887850467, (double)n2 * 0.5233644859813084, (double)n3 * 0.5233644859813084, (double)n2 * 0.5233644859813084, (double)n3 * 0.5233644859813084);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5233644859813084, (double)n2 * 0.514018691588785, (double)n3 * 0.5233644859813084, (double)n2 * 0.514018691588785, (double)n3 * 0.5233644859813084);
                generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.5233644859813084, (double)n2 * 0.5, (double)n3 * 0.5233644859813084, (double)n2 * 0.4953271028037383, (double)n3 * 0.514018691588785);
                generalPath.curveTo((double)n2 * 0.4953271028037383, (double)n3 * 0.514018691588785, (double)n2 * 0.4766355140186916, (double)n3 * 0.514018691588785, (double)n2 * 0.4766355140186916, (double)n3 * 0.514018691588785);
                generalPath.curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.5327102803738317, (double)n2 * 0.49065420560747663, (double)n3 * 0.5420560747663551, (double)n2 * 0.5093457943925234, (double)n3 * 0.5420560747663551);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.46261682242990654, (double)n3 * 0.5420560747663551);
                generalPath.lineTo((double)n2 * 0.46261682242990654, (double)n3 * 0.5233644859813084);
                generalPath.lineTo((double)n2 * 0.4252336448598131, (double)n3 * 0.5233644859813084);
                generalPath.lineTo((double)n2 * 0.4252336448598131, (double)n3 * 0.5046728971962616);
                generalPath.lineTo((double)n2 * 0.46261682242990654, (double)n3 * 0.5046728971962616);
                generalPath.lineTo((double)n2 * 0.46261682242990654, (double)n3 * 0.49065420560747663);
                generalPath.lineTo((double)n2 * 0.4252336448598131, (double)n3 * 0.49065420560747663);
                generalPath.lineTo((double)n2 * 0.4252336448598131, (double)n3 * 0.4719626168224299);
                generalPath.lineTo((double)n2 * 0.46261682242990654, (double)n3 * 0.4719626168224299);
                generalPath.lineTo((double)n2 * 0.46261682242990654, (double)n3 * 0.4532710280373832);
                generalPath.lineTo((double)n2 * 0.40654205607476634, (double)n3 * 0.4532710280373832);
                generalPath.lineTo((double)n2 * 0.40654205607476634, (double)n3 * 0.5420560747663551);
                generalPath.lineTo((double)n2 * 0.46261682242990654, (double)n3 * 0.5420560747663551);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.6588785046728972, (double)n3 * 0.3364485981308411);
                generalPath.curveTo((double)n2 * 0.6401869158878505, (double)n3 * 0.3317757009345794, (double)n2 * 0.6355140186915887, (double)n3 * 0.3411214953271028, (double)n2 * 0.6355140186915887, (double)n3 * 0.35514018691588783);
                generalPath.curveTo((double)n2 * 0.6822429906542056, (double)n3 * 0.3925233644859813, (double)n2 * 0.705607476635514, (double)n3 * 0.4439252336448598, (double)n2 * 0.705607476635514, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.705607476635514, (double)n3 * 0.5514018691588785, (double)n2 * 0.6822429906542056, (double)n3 * 0.602803738317757, (double)n2 * 0.6448598130841121, (double)n3 * 0.6448598130841121);
                generalPath.curveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.6635514018691588, (double)n2 * 0.6495327102803738, (double)n3 * 0.6682242990654206, (double)n2 * 0.6588785046728972, (double)n3 * 0.6635514018691588);
                generalPath.curveTo((double)n2 * 0.6915887850467289, (double)n3 * 0.6448598130841121, (double)n2 * 0.7336448598130841, (double)n3 * 0.5700934579439252, (double)n2 * 0.7336448598130841, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.7336448598130841, (double)n3 * 0.4252336448598131, (double)n2 * 0.6962616822429907, (double)n3 * 0.3691588785046729, (double)n2 * 0.6588785046728972, (double)n3 * 0.3364485981308411);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.34579439252336447, (double)n3 * 0.3364485981308411);
                generalPath.curveTo((double)n2 * 0.308411214953271, (double)n3 * 0.3691588785046729, (double)n2 * 0.26635514018691586, (double)n3 * 0.4252336448598131, (double)n2 * 0.26635514018691586, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.5700934579439252, (double)n2 * 0.3130841121495327, (double)n3 * 0.6448598130841121, (double)n2 * 0.3411214953271028, (double)n3 * 0.6635514018691588);
                generalPath.curveTo((double)n2 * 0.35514018691588783, (double)n3 * 0.6682242990654206, (double)n2 * 0.3644859813084112, (double)n3 * 0.6635514018691588, (double)n2 * 0.3598130841121495, (double)n3 * 0.6448598130841121);
                generalPath.curveTo((double)n2 * 0.3177570093457944, (double)n3 * 0.602803738317757, (double)n2 * 0.29906542056074764, (double)n3 * 0.5514018691588785, (double)n2 * 0.29906542056074764, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.29906542056074764, (double)n3 * 0.4439252336448598, (double)n2 * 0.32242990654205606, (double)n3 * 0.3925233644859813, (double)n2 * 0.3644859813084112, (double)n3 * 0.35514018691588783);
                generalPath.curveTo((double)n2 * 0.3691588785046729, (double)n3 * 0.3411214953271028, (double)n2 * 0.3598130841121495, (double)n3 * 0.3317757009345794, (double)n2 * 0.34579439252336447, (double)n3 * 0.3364485981308411);
                generalPath.closePath();
                break;
            }
            case ATTENTION: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.6962616822429907, (double)n3 * 0.6401869158878505);
                generalPath.lineTo((double)n2 * 0.3037383177570093, (double)n3 * 0.6401869158878505);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.2850467289719626);
                generalPath.lineTo((double)n2 * 0.6962616822429907, (double)n3 * 0.6401869158878505);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.7336448598130841, (double)n3 * 0.6635514018691588);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.24299065420560748);
                generalPath.lineTo((double)n2 * 0.26635514018691586, (double)n3 * 0.6635514018691588);
                generalPath.lineTo((double)n2 * 0.7336448598130841, (double)n3 * 0.6635514018691588);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.5841121495327103);
                generalPath.lineTo((double)n2 * 0.411214953271028, (double)n3 * 0.5841121495327103);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.411214953271028);
                generalPath.lineTo((double)n2 * 0.5887850467289719, (double)n3 * 0.5841121495327103);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.6074766355140186);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.3644859813084112);
                generalPath.lineTo((double)n2 * 0.3644859813084112, (double)n3 * 0.6074766355140186);
                generalPath.lineTo((double)n2 * 0.6355140186915887, (double)n3 * 0.6074766355140186);
                generalPath.closePath();
                break;
            }
            case WIPER: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.42990654205607476, (double)n3 * 0.5794392523364486);
                generalPath.curveTo((double)n2 * 0.42990654205607476, (double)n3 * 0.5794392523364486, (double)n2 * 0.29906542056074764, (double)n3 * 0.43457943925233644, (double)n2 * 0.29906542056074764, (double)n3 * 0.43457943925233644);
                generalPath.curveTo((double)n2 * 0.40654205607476634, (double)n3 * 0.3364485981308411, (double)n2 * 0.5934579439252337, (double)n3 * 0.3364485981308411, (double)n2 * 0.705607476635514, (double)n3 * 0.43457943925233644);
                generalPath.curveTo((double)n2 * 0.705607476635514, (double)n3 * 0.43457943925233644, (double)n2 * 0.5747663551401869, (double)n3 * 0.5794392523364486, (double)n2 * 0.5747663551401869, (double)n3 * 0.5794392523364486);
                generalPath.curveTo((double)n2 * 0.5514018691588785, (double)n3 * 0.5560747663551402, (double)n2 * 0.514018691588785, (double)n3 * 0.5514018691588785, (double)n2 * 0.4766355140186916, (double)n3 * 0.5560747663551402);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.5560747663551402, (double)n2 * 0.40186915887850466, (double)n3 * 0.4158878504672897, (double)n2 * 0.40186915887850466, (double)n3 * 0.4158878504672897);
                generalPath.curveTo((double)n2 * 0.40186915887850466, (double)n3 * 0.411214953271028, (double)n2 * 0.3925233644859813, (double)n3 * 0.40654205607476634, (double)n2 * 0.3878504672897196, (double)n3 * 0.411214953271028);
                generalPath.curveTo((double)n2 * 0.37850467289719625, (double)n3 * 0.4158878504672897, (double)n2 * 0.37850467289719625, (double)n3 * 0.4252336448598131, (double)n2 * 0.38317757009345793, (double)n3 * 0.42990654205607476);
                generalPath.curveTo((double)n2 * 0.38317757009345793, (double)n3 * 0.42990654205607476, (double)n2 * 0.4532710280373832, (double)n3 * 0.5654205607476636, (double)n2 * 0.4532710280373832, (double)n3 * 0.5654205607476636);
                generalPath.curveTo((double)n2 * 0.4439252336448598, (double)n3 * 0.5700934579439252, (double)n2 * 0.43457943925233644, (double)n3 * 0.5747663551401869, (double)n2 * 0.42990654205607476, (double)n3 * 0.5794392523364486);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.4205607476635514, (double)n3 * 0.602803738317757);
                generalPath.curveTo((double)n2 * 0.43457943925233644, (double)n3 * 0.5934579439252337, (double)n2 * 0.4485981308411215, (double)n3 * 0.5841121495327103, (double)n2 * 0.46261682242990654, (double)n3 * 0.5794392523364486);
                generalPath.curveTo((double)n2 * 0.46261682242990654, (double)n3 * 0.5794392523364486, (double)n2 * 0.48130841121495327, (double)n3 * 0.616822429906542, (double)n2 * 0.48130841121495327, (double)n3 * 0.616822429906542);
                generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.6261682242990654, (double)n2 * 0.4719626168224299, (double)n3 * 0.6355140186915887, (double)n2 * 0.4766355140186916, (double)n3 * 0.6495327102803738);
                generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.6635514018691588, (double)n2 * 0.5046728971962616, (double)n3 * 0.6682242990654206, (double)n2 * 0.5186915887850467, (double)n3 * 0.6588785046728972);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.6542056074766355, (double)n2 * 0.5373831775700935, (double)n3 * 0.6355140186915887, (double)n2 * 0.5327102803738317, (double)n3 * 0.6214953271028038);
                generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.6121495327102804, (double)n2 * 0.514018691588785, (double)n3 * 0.602803738317757, (double)n2 * 0.5046728971962616, (double)n3 * 0.602803738317757);
                generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.602803738317757, (double)n2 * 0.48598130841121495, (double)n3 * 0.5747663551401869, (double)n2 * 0.48598130841121495, (double)n3 * 0.5747663551401869);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5700934579439252, (double)n2 * 0.5514018691588785, (double)n3 * 0.5794392523364486, (double)n2 * 0.5794392523364486, (double)n3 * 0.602803738317757);
                generalPath.curveTo((double)n2 * 0.5794392523364486, (double)n3 * 0.602803738317757, (double)n2 * 0.7336448598130841, (double)n3 * 0.42990654205607476, (double)n2 * 0.7336448598130841, (double)n3 * 0.42990654205607476);
                generalPath.curveTo((double)n2 * 0.5981308411214953, (double)n3 * 0.308411214953271, (double)n2 * 0.40186915887850466, (double)n3 * 0.3130841121495327, (double)n2 * 0.26635514018691586, (double)n3 * 0.42990654205607476);
                generalPath.curveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.42990654205607476, (double)n2 * 0.4205607476635514, (double)n3 * 0.602803738317757, (double)n2 * 0.4205607476635514, (double)n3 * 0.602803738317757);
                generalPath.closePath();
                break;
            }
            case AIRBAG: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5467289719626168, (double)n3 * 0.4953271028037383);
                generalPath.curveTo((double)n2 * 0.5420560747663551, (double)n3 * 0.5, (double)n2 * 0.5420560747663551, (double)n3 * 0.5046728971962616, (double)n2 * 0.5420560747663551, (double)n3 * 0.514018691588785);
                generalPath.curveTo((double)n2 * 0.5420560747663551, (double)n3 * 0.5186915887850467, (double)n2 * 0.5747663551401869, (double)n3 * 0.5607476635514018, (double)n2 * 0.5794392523364486, (double)n3 * 0.5607476635514018);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.5560747663551402, (double)n2 * 0.602803738317757, (double)n3 * 0.5280373831775701, (double)n2 * 0.6214953271028038, (double)n3 * 0.49065420560747663);
                generalPath.curveTo((double)n2 * 0.6261682242990654, (double)n3 * 0.4719626168224299, (double)n2 * 0.6308411214953271, (double)n3 * 0.4392523364485981, (double)n2 * 0.6074766355140186, (double)n3 * 0.43457943925233644);
                generalPath.curveTo((double)n2 * 0.5794392523364486, (double)n3 * 0.43457943925233644, (double)n2 * 0.5467289719626168, (double)n3 * 0.49065420560747663, (double)n2 * 0.5467289719626168, (double)n3 * 0.4953271028037383);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.4485981308411215);
                generalPath.curveTo((double)n2 * 0.6401869158878505, (double)n3 * 0.4672897196261682, (double)n2 * 0.6355140186915887, (double)n3 * 0.4766355140186916, (double)n2 * 0.6355140186915887, (double)n3 * 0.48130841121495327);
                generalPath.curveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.48598130841121495, (double)n2 * 0.6308411214953271, (double)n3 * 0.49065420560747663, (double)n2 * 0.6308411214953271, (double)n3 * 0.49065420560747663);
                generalPath.curveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.5, (double)n2 * 0.6542056074766355, (double)n3 * 0.49065420560747663, (double)n2 * 0.6542056074766355, (double)n3 * 0.49065420560747663);
                generalPath.curveTo((double)n2 * 0.6869158878504673, (double)n3 * 0.4672897196261682, (double)n2 * 0.7289719626168224, (double)n3 * 0.4439252336448598, (double)n2 * 0.7289719626168224, (double)n3 * 0.4439252336448598);
                generalPath.curveTo((double)n2 * 0.7336448598130841, (double)n3 * 0.4439252336448598, (double)n2 * 0.7383177570093458, (double)n3 * 0.4205607476635514, (double)n2 * 0.7242990654205608, (double)n3 * 0.411214953271028);
                generalPath.curveTo((double)n2 * 0.719626168224299, (double)n3 * 0.40186915887850466, (double)n2 * 0.6962616822429907, (double)n3 * 0.4158878504672897, (double)n2 * 0.6869158878504673, (double)n3 * 0.4205607476635514);
                generalPath.curveTo((double)n2 * 0.6635514018691588, (double)n3 * 0.42990654205607476, (double)n2 * 0.6355140186915887, (double)n3 * 0.4485981308411215, (double)n2 * 0.6355140186915887, (double)n3 * 0.4485981308411215);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.514018691588785);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.5233644859813084, (double)n2 * 0.4719626168224299, (double)n3 * 0.5373831775700935, (double)n2 * 0.48130841121495327, (double)n3 * 0.5514018691588785);
                generalPath.curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.5514018691588785, (double)n2 * 0.5046728971962616, (double)n3 * 0.616822429906542, (double)n2 * 0.5420560747663551, (double)n3 * 0.677570093457944);
                generalPath.curveTo((double)n2 * 0.5420560747663551, (double)n3 * 0.677570093457944, (double)n2 * 0.5700934579439252, (double)n3 * 0.7102803738317757, (double)n2 * 0.5981308411214953, (double)n3 * 0.6962616822429907);
                generalPath.curveTo((double)n2 * 0.6308411214953271, (double)n3 * 0.6728971962616822, (double)n2 * 0.616822429906542, (double)n3 * 0.6448598130841121, (double)n2 * 0.6121495327102804, (double)n3 * 0.6308411214953271);
                generalPath.curveTo((double)n2 * 0.5981308411214953, (double)n3 * 0.602803738317757, (double)n2 * 0.5233644859813084, (double)n3 * 0.5186915887850467, (double)n2 * 0.514018691588785, (double)n3 * 0.514018691588785);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.514018691588785, (double)n2 * 0.5, (double)n3 * 0.5093457943925234, (double)n2 * 0.48598130841121495, (double)n3 * 0.514018691588785);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.45794392523364486, (double)n3 * 0.5467289719626168);
                generalPath.curveTo((double)n2 * 0.4532710280373832, (double)n3 * 0.5467289719626168, (double)n2 * 0.4392523364485981, (double)n3 * 0.5420560747663551, (double)n2 * 0.411214953271028, (double)n3 * 0.5560747663551402);
                generalPath.curveTo((double)n2 * 0.40186915887850466, (double)n3 * 0.5607476635514018, (double)n2 * 0.38317757009345793, (double)n3 * 0.5841121495327103, (double)n2 * 0.35514018691588783, (double)n3 * 0.6214953271028038);
                generalPath.curveTo((double)n2 * 0.3364485981308411, (double)n3 * 0.6448598130841121, (double)n2 * 0.3130841121495327, (double)n3 * 0.6822429906542056, (double)n2 * 0.3130841121495327, (double)n3 * 0.6869158878504673);
                generalPath.curveTo((double)n2 * 0.308411214953271, (double)n3 * 0.7009345794392523, (double)n2 * 0.3177570093457944, (double)n3 * 0.7149532710280374, (double)n2 * 0.3364485981308411, (double)n3 * 0.7149532710280374);
                generalPath.curveTo((double)n2 * 0.35046728971962615, (double)n3 * 0.7149532710280374, (double)n2 * 0.397196261682243, (double)n3 * 0.6588785046728972, (double)n2 * 0.397196261682243, (double)n3 * 0.6588785046728972);
                generalPath.curveTo((double)n2 * 0.397196261682243, (double)n3 * 0.6588785046728972, (double)n2 * 0.4158878504672897, (double)n3 * 0.6261682242990654, (double)n2 * 0.4485981308411215, (double)n3 * 0.6074766355140186);
                generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5981308411214953, (double)n2 * 0.48598130841121495, (double)n3 * 0.5981308411214953, (double)n2 * 0.48598130841121495, (double)n3 * 0.5981308411214953);
                generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.5981308411214953, (double)n2 * 0.4766355140186916, (double)n3 * 0.5654205607476636, (double)n2 * 0.45794392523364486, (double)n3 * 0.5467289719626168);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.5654205607476636, (double)n3 * 0.3598130841121495);
                generalPath.curveTo((double)n2 * 0.5654205607476636, (double)n3 * 0.3878504672897196, (double)n2 * 0.5887850467289719, (double)n3 * 0.411214953271028, (double)n2 * 0.6214953271028038, (double)n3 * 0.411214953271028);
                generalPath.curveTo((double)n2 * 0.6495327102803738, (double)n3 * 0.411214953271028, (double)n2 * 0.6728971962616822, (double)n3 * 0.3878504672897196, (double)n2 * 0.6728971962616822, (double)n3 * 0.3598130841121495);
                generalPath.curveTo((double)n2 * 0.6728971962616822, (double)n3 * 0.32710280373831774, (double)n2 * 0.6495327102803738, (double)n3 * 0.3037383177570093, (double)n2 * 0.6214953271028038, (double)n3 * 0.3037383177570093);
                generalPath.curveTo((double)n2 * 0.5887850467289719, (double)n3 * 0.3037383177570093, (double)n2 * 0.5654205607476636, (double)n3 * 0.32710280373831774, (double)n2 * 0.5654205607476636, (double)n3 * 0.3598130841121495);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.40654205607476634);
                generalPath.curveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.4766355140186916, (double)n2 * 0.32242990654205606, (double)n3 * 0.5327102803738317, (double)n2 * 0.3925233644859813, (double)n3 * 0.5327102803738317);
                generalPath.curveTo((double)n2 * 0.46261682242990654, (double)n3 * 0.5327102803738317, (double)n2 * 0.5186915887850467, (double)n3 * 0.4766355140186916, (double)n2 * 0.5186915887850467, (double)n3 * 0.40654205607476634);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.3364485981308411, (double)n2 * 0.46261682242990654, (double)n3 * 0.2803738317757009, (double)n2 * 0.3925233644859813, (double)n3 * 0.2803738317757009);
                generalPath.curveTo((double)n2 * 0.32242990654205606, (double)n3 * 0.2803738317757009, (double)n2 * 0.26635514018691586, (double)n3 * 0.3364485981308411, (double)n2 * 0.26635514018691586, (double)n3 * 0.40654205607476634);
                generalPath.closePath();
                break;
            }
            case SEATBELT: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.2897196261682243, (double)n3 * 0.719626168224299);
                generalPath.curveTo((double)n2 * 0.29439252336448596, (double)n3 * 0.7242990654205608, (double)n2 * 0.3037383177570093, (double)n3 * 0.7242990654205608, (double)n2 * 0.3130841121495327, (double)n3 * 0.719626168224299);
                generalPath.curveTo((double)n2 * 0.3130841121495327, (double)n3 * 0.719626168224299, (double)n2 * 0.3644859813084112, (double)n3 * 0.6682242990654206, (double)n2 * 0.3644859813084112, (double)n3 * 0.6682242990654206);
                generalPath.curveTo((double)n2 * 0.3644859813084112, (double)n3 * 0.6682242990654206, (double)n2 * 0.3644859813084112, (double)n3 * 0.6635514018691588, (double)n2 * 0.3691588785046729, (double)n3 * 0.6635514018691588);
                generalPath.curveTo((double)n2 * 0.3691588785046729, (double)n3 * 0.6635514018691588, (double)n2 * 0.3691588785046729, (double)n3 * 0.6635514018691588, (double)n2 * 0.3691588785046729, (double)n3 * 0.6635514018691588);
                generalPath.lineTo((double)n2 * 0.3644859813084112, (double)n3 * 0.6635514018691588);
                generalPath.lineTo((double)n2 * 0.3644859813084112, (double)n3 * 0.6495327102803738);
                generalPath.lineTo((double)n2 * 0.3644859813084112, (double)n3 * 0.6261682242990654);
                generalPath.lineTo((double)n2 * 0.3644859813084112, (double)n3 * 0.616822429906542);
                generalPath.curveTo((double)n2 * 0.3644859813084112, (double)n3 * 0.616822429906542, (double)n2 * 0.2897196261682243, (double)n3 * 0.6915887850467289, (double)n2 * 0.2897196261682243, (double)n3 * 0.6915887850467289);
                generalPath.curveTo((double)n2 * 0.2803738317757009, (double)n3 * 0.7009345794392523, (double)n2 * 0.2803738317757009, (double)n3 * 0.7102803738317757, (double)n2 * 0.2897196261682243, (double)n3 * 0.719626168224299);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.616822429906542, (double)n3 * 0.6869158878504673);
                generalPath.curveTo((double)n2 * 0.6261682242990654, (double)n3 * 0.6962616822429907, (double)n2 * 0.6355140186915887, (double)n3 * 0.7102803738317757, (double)n2 * 0.6401869158878505, (double)n3 * 0.719626168224299);
                generalPath.curveTo((double)n2 * 0.6401869158878505, (double)n3 * 0.719626168224299, (double)n2 * 0.6682242990654206, (double)n3 * 0.705607476635514, (double)n2 * 0.6682242990654206, (double)n3 * 0.705607476635514);
                generalPath.curveTo((double)n2 * 0.6588785046728972, (double)n3 * 0.6869158878504673, (double)n2 * 0.6495327102803738, (double)n3 * 0.6682242990654206, (double)n2 * 0.6355140186915887, (double)n3 * 0.6542056074766355);
                generalPath.curveTo((double)n2 * 0.6308411214953271, (double)n3 * 0.6682242990654206, (double)n2 * 0.6261682242990654, (double)n3 * 0.677570093457944, (double)n2 * 0.616822429906542, (double)n3 * 0.6869158878504673);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.5607476635514018, (double)n3 * 0.4719626168224299);
                generalPath.lineTo((double)n2 * 0.5607476635514018, (double)n3 * 0.4719626168224299);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.5420560747663551, (double)n3 * 0.45794392523364486);
                generalPath.curveTo((double)n2 * 0.5467289719626168, (double)n3 * 0.46261682242990654, (double)n2 * 0.5514018691588785, (double)n3 * 0.4672897196261682, (double)n2 * 0.5607476635514018, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.5607476635514018, (double)n3 * 0.4719626168224299, (double)n2 * 0.6214953271028038, (double)n3 * 0.411214953271028, (double)n2 * 0.6214953271028038, (double)n3 * 0.411214953271028);
                generalPath.curveTo((double)n2 * 0.6261682242990654, (double)n3 * 0.40186915887850466, (double)n2 * 0.6261682242990654, (double)n3 * 0.3925233644859813, (double)n2 * 0.6214953271028038, (double)n3 * 0.38317757009345793);
                generalPath.curveTo((double)n2 * 0.6121495327102804, (double)n3 * 0.37850467289719625, (double)n2 * 0.602803738317757, (double)n3 * 0.37850467289719625, (double)n2 * 0.5934579439252337, (double)n3 * 0.38317757009345793);
                generalPath.curveTo((double)n2 * 0.5934579439252337, (double)n3 * 0.38317757009345793, (double)n2 * 0.5327102803738317, (double)n3 * 0.4439252336448598, (double)n2 * 0.5327102803738317, (double)n3 * 0.4439252336448598);
                generalPath.curveTo((double)n2 * 0.5373831775700935, (double)n3 * 0.4485981308411215, (double)n2 * 0.5373831775700935, (double)n3 * 0.4532710280373832, (double)n2 * 0.5420560747663551, (double)n3 * 0.45794392523364486);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.3691588785046729, (double)n3 * 0.6635514018691588);
                generalPath.curveTo((double)n2 * 0.37383177570093457, (double)n3 * 0.6869158878504673, (double)n2 * 0.397196261682243, (double)n3 * 0.705607476635514, (double)n2 * 0.4252336448598131, (double)n3 * 0.705607476635514);
                generalPath.curveTo((double)n2 * 0.4252336448598131, (double)n3 * 0.705607476635514, (double)n2 * 0.5747663551401869, (double)n3 * 0.705607476635514, (double)n2 * 0.5747663551401869, (double)n3 * 0.705607476635514);
                generalPath.curveTo((double)n2 * 0.5934579439252337, (double)n3 * 0.705607476635514, (double)n2 * 0.6074766355140186, (double)n3 * 0.6962616822429907, (double)n2 * 0.616822429906542, (double)n3 * 0.6869158878504673);
                generalPath.curveTo((double)n2 * 0.5841121495327103, (double)n3 * 0.6495327102803738, (double)n2 * 0.5327102803738317, (double)n3 * 0.6261682242990654, (double)n2 * 0.48130841121495327, (double)n3 * 0.6261682242990654);
                generalPath.curveTo((double)n2 * 0.4392523364485981, (double)n3 * 0.6261682242990654, (double)n2 * 0.397196261682243, (double)n3 * 0.6401869158878505, (double)n2 * 0.3691588785046729, (double)n3 * 0.6635514018691588);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.6542056074766355);
                generalPath.curveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.6542056074766355, (double)n2 * 0.6355140186915887, (double)n3 * 0.6495327102803738, (double)n2 * 0.6355140186915887, (double)n3 * 0.6495327102803738);
                generalPath.curveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.6495327102803738, (double)n2 * 0.6355140186915887, (double)n3 * 0.5327102803738317, (double)n2 * 0.6355140186915887, (double)n3 * 0.5327102803738317);
                generalPath.curveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.5, (double)n2 * 0.6074766355140186, (double)n3 * 0.4719626168224299, (double)n2 * 0.5747663551401869, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.5747663551401869, (double)n3 * 0.4719626168224299, (double)n2 * 0.5700934579439252, (double)n3 * 0.4719626168224299, (double)n2 * 0.5607476635514018, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.5607476635514018, (double)n3 * 0.4719626168224299, (double)n2 * 0.42990654205607476, (double)n3 * 0.5981308411214953, (double)n2 * 0.42990654205607476, (double)n3 * 0.5981308411214953);
                generalPath.curveTo((double)n2 * 0.4439252336448598, (double)n3 * 0.5934579439252337, (double)n2 * 0.46261682242990654, (double)n3 * 0.5934579439252337, (double)n2 * 0.48130841121495327, (double)n3 * 0.5934579439252337);
                generalPath.curveTo((double)n2 * 0.5373831775700935, (double)n3 * 0.5934579439252337, (double)n2 * 0.5934579439252337, (double)n3 * 0.616822429906542, (double)n2 * 0.6355140186915887, (double)n3 * 0.6542056074766355);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.3644859813084112, (double)n3 * 0.616822429906542);
                generalPath.curveTo((double)n2 * 0.3644859813084112, (double)n3 * 0.616822429906542, (double)n2 * 0.5327102803738317, (double)n3 * 0.4439252336448598, (double)n2 * 0.5327102803738317, (double)n3 * 0.4439252336448598);
                generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.42990654205607476, (double)n2 * 0.5327102803738317, (double)n3 * 0.411214953271028, (double)n2 * 0.5327102803738317, (double)n3 * 0.411214953271028);
                generalPath.curveTo((double)n2 * 0.5420560747663551, (double)n3 * 0.40186915887850466, (double)n2 * 0.5514018691588785, (double)n3 * 0.38317757009345793, (double)n2 * 0.5560747663551402, (double)n3 * 0.3691588785046729);
                generalPath.curveTo((double)n2 * 0.5560747663551402, (double)n3 * 0.3691588785046729, (double)n2 * 0.5560747663551402, (double)n3 * 0.3691588785046729, (double)n2 * 0.5560747663551402, (double)n3 * 0.3691588785046729);
                generalPath.curveTo((double)n2 * 0.5607476635514018, (double)n3 * 0.3691588785046729, (double)n2 * 0.5654205607476636, (double)n3 * 0.34579439252336447, (double)n2 * 0.5654205607476636, (double)n3 * 0.34579439252336447);
                generalPath.curveTo((double)n2 * 0.5654205607476636, (double)n3 * 0.3411214953271028, (double)n2 * 0.5654205607476636, (double)n3 * 0.3364485981308411, (double)n2 * 0.5607476635514018, (double)n3 * 0.3317757009345794);
                generalPath.curveTo((double)n2 * 0.5560747663551402, (double)n3 * 0.2897196261682243, (double)n2 * 0.5280373831775701, (double)n3 * 0.2570093457943925, (double)n2 * 0.4953271028037383, (double)n3 * 0.2570093457943925);
                generalPath.curveTo((double)n2 * 0.46261682242990654, (double)n3 * 0.2570093457943925, (double)n2 * 0.43457943925233644, (double)n3 * 0.2897196261682243, (double)n2 * 0.42990654205607476, (double)n3 * 0.3317757009345794);
                generalPath.curveTo((double)n2 * 0.4252336448598131, (double)n3 * 0.3364485981308411, (double)n2 * 0.4252336448598131, (double)n3 * 0.3411214953271028, (double)n2 * 0.4252336448598131, (double)n3 * 0.34579439252336447);
                generalPath.curveTo((double)n2 * 0.4252336448598131, (double)n3 * 0.34579439252336447, (double)n2 * 0.4252336448598131, (double)n3 * 0.3691588785046729, (double)n2 * 0.43457943925233644, (double)n3 * 0.3691588785046729);
                generalPath.curveTo((double)n2 * 0.43457943925233644, (double)n3 * 0.3691588785046729, (double)n2 * 0.43457943925233644, (double)n3 * 0.3691588785046729, (double)n2 * 0.43457943925233644, (double)n3 * 0.3691588785046729);
                generalPath.curveTo((double)n2 * 0.4392523364485981, (double)n3 * 0.38317757009345793, (double)n2 * 0.4485981308411215, (double)n3 * 0.40186915887850466, (double)n2 * 0.45794392523364486, (double)n3 * 0.411214953271028);
                generalPath.curveTo((double)n2 * 0.45794392523364486, (double)n3 * 0.411214953271028, (double)n2 * 0.4672897196261682, (double)n3 * 0.4439252336448598, (double)n2 * 0.4485981308411215, (double)n3 * 0.46261682242990654);
                generalPath.curveTo((double)n2 * 0.4392523364485981, (double)n3 * 0.4719626168224299, (double)n2 * 0.4252336448598131, (double)n3 * 0.4719626168224299, (double)n2 * 0.4252336448598131, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.3925233644859813, (double)n3 * 0.4719626168224299, (double)n2 * 0.3644859813084112, (double)n3 * 0.5, (double)n2 * 0.3644859813084112, (double)n3 * 0.5327102803738317);
                generalPath.curveTo((double)n2 * 0.3644859813084112, (double)n3 * 0.5327102803738317, (double)n2 * 0.3644859813084112, (double)n3 * 0.616822429906542, (double)n2 * 0.3644859813084112, (double)n3 * 0.616822429906542);
                generalPath.closePath();
                break;
            }
            case AIR_CONDITION: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.4953271028037383, (double)n3 * 0.4766355140186916);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4766355140186916, (double)n2 * 0.5327102803738317, (double)n3 * 0.49065420560747663, (double)n2 * 0.5327102803738317, (double)n3 * 0.514018691588785);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.5327102803738317, (double)n2 * 0.5186915887850467, (double)n3 * 0.5514018691588785, (double)n2 * 0.4953271028037383, (double)n3 * 0.5514018691588785);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.5514018691588785, (double)n2 * 0.45794392523364486, (double)n3 * 0.5327102803738317, (double)n2 * 0.45794392523364486, (double)n3 * 0.514018691588785);
                generalPath.curveTo((double)n2 * 0.45794392523364486, (double)n3 * 0.49065420560747663, (double)n2 * 0.4766355140186916, (double)n3 * 0.4766355140186916, (double)n2 * 0.4953271028037383, (double)n3 * 0.4766355140186916);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.42990654205607476, (double)n3 * 0.5233644859813084);
                generalPath.curveTo((double)n2 * 0.42990654205607476, (double)n3 * 0.5233644859813084, (double)n2 * 0.411214953271028, (double)n3 * 0.5280373831775701, (double)n2 * 0.411214953271028, (double)n3 * 0.5280373831775701);
                generalPath.curveTo((double)n2 * 0.38317757009345793, (double)n3 * 0.5280373831775701, (double)n2 * 0.37850467289719625, (double)n3 * 0.5, (double)n2 * 0.3317757009345794, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.3130841121495327, (double)n3 * 0.5046728971962616, (double)n2 * 0.29439252336448596, (double)n3 * 0.514018691588785, (double)n2 * 0.27102803738317754, (double)n3 * 0.5420560747663551);
                generalPath.curveTo((double)n2 * 0.2570093457943925, (double)n3 * 0.5700934579439252, (double)n2 * 0.27102803738317754, (double)n3 * 0.6869158878504673, (double)n2 * 0.38317757009345793, (double)n3 * 0.6869158878504673);
                generalPath.curveTo((double)n2 * 0.38317757009345793, (double)n3 * 0.6869158878504673, (double)n2 * 0.4532710280373832, (double)n3 * 0.6915887850467289, (double)n2 * 0.4766355140186916, (double)n3 * 0.6214953271028038);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.6214953271028038, (double)n2 * 0.48598130841121495, (double)n3 * 0.602803738317757, (double)n2 * 0.48598130841121495, (double)n3 * 0.5794392523364486);
                generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.5794392523364486, (double)n2 * 0.49065420560747663, (double)n3 * 0.5794392523364486, (double)n2 * 0.4953271028037383, (double)n3 * 0.5794392523364486);
                generalPath.curveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5794392523364486, (double)n2 * 0.5186915887850467, (double)n3 * 0.5794392523364486, (double)n2 * 0.5233644859813084, (double)n3 * 0.5747663551401869);
                generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.5747663551401869, (double)n2 * 0.5280373831775701, (double)n3 * 0.5887850467289719, (double)n2 * 0.5280373831775701, (double)n3 * 0.5887850467289719);
                generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.616822429906542, (double)n2 * 0.5, (double)n3 * 0.6214953271028038, (double)n2 * 0.5, (double)n3 * 0.6728971962616822);
                generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.6915887850467289, (double)n2 * 0.514018691588785, (double)n3 * 0.705607476635514, (double)n2 * 0.5420560747663551, (double)n3 * 0.7289719626168224);
                generalPath.curveTo((double)n2 * 0.5747663551401869, (double)n3 * 0.7429906542056075, (double)n2 * 0.6915887850467289, (double)n3 * 0.7289719626168224, (double)n2 * 0.6915887850467289, (double)n3 * 0.616822429906542);
                generalPath.curveTo((double)n2 * 0.6915887850467289, (double)n3 * 0.616822429906542, (double)n2 * 0.6915887850467289, (double)n3 * 0.5467289719626168, (double)n2 * 0.6214953271028038, (double)n3 * 0.5233644859813084);
                generalPath.curveTo((double)n2 * 0.6214953271028038, (double)n3 * 0.5233644859813084, (double)n2 * 0.5981308411214953, (double)n3 * 0.5046728971962616, (double)n2 * 0.5654205607476636, (double)n3 * 0.5093457943925234);
                generalPath.curveTo((double)n2 * 0.5654205607476636, (double)n3 * 0.5, (double)n2 * 0.5607476635514018, (double)n3 * 0.49065420560747663, (double)n2 * 0.5560747663551402, (double)n3 * 0.48598130841121495);
                generalPath.curveTo((double)n2 * 0.5654205607476636, (double)n3 * 0.48130841121495327, (double)n2 * 0.5794392523364486, (double)n3 * 0.4766355140186916, (double)n2 * 0.5934579439252337, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.616822429906542, (double)n3 * 0.4719626168224299, (double)n2 * 0.6214953271028038, (double)n3 * 0.5, (double)n2 * 0.6728971962616822, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.6915887850467289, (double)n3 * 0.4953271028037383, (double)n2 * 0.7102803738317757, (double)n3 * 0.48598130841121495, (double)n2 * 0.7289719626168224, (double)n3 * 0.45794392523364486);
                generalPath.curveTo((double)n2 * 0.7429906542056075, (double)n3 * 0.42990654205607476, (double)n2 * 0.7289719626168224, (double)n3 * 0.3130841121495327, (double)n2 * 0.616822429906542, (double)n3 * 0.3130841121495327);
                generalPath.curveTo((double)n2 * 0.616822429906542, (double)n3 * 0.3130841121495327, (double)n2 * 0.5514018691588785, (double)n3 * 0.308411214953271, (double)n2 * 0.5233644859813084, (double)n3 * 0.37850467289719625);
                generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.37850467289719625, (double)n2 * 0.5046728971962616, (double)n3 * 0.411214953271028, (double)n2 * 0.5093457943925234, (double)n3 * 0.4485981308411215);
                generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.4485981308411215, (double)n2 * 0.5, (double)n3 * 0.4485981308411215, (double)n2 * 0.4953271028037383, (double)n3 * 0.4485981308411215);
                generalPath.curveTo((double)n2 * 0.4953271028037383, (double)n3 * 0.4485981308411215, (double)n2 * 0.49065420560747663, (double)n3 * 0.4485981308411215, (double)n2 * 0.48598130841121495, (double)n3 * 0.4485981308411215);
                generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.4392523364485981, (double)n2 * 0.4766355140186916, (double)n3 * 0.4252336448598131, (double)n2 * 0.4766355140186916, (double)n3 * 0.411214953271028);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.38317757009345793, (double)n2 * 0.5, (double)n3 * 0.37850467289719625, (double)n2 * 0.5, (double)n3 * 0.32710280373831774);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.308411214953271, (double)n2 * 0.48598130841121495, (double)n3 * 0.29439252336448596, (double)n2 * 0.45794392523364486, (double)n3 * 0.27102803738317754);
                generalPath.curveTo((double)n2 * 0.42990654205607476, (double)n3 * 0.2570093457943925, (double)n2 * 0.3130841121495327, (double)n3 * 0.27102803738317754, (double)n2 * 0.3130841121495327, (double)n3 * 0.38317757009345793);
                generalPath.curveTo((double)n2 * 0.3130841121495327, (double)n3 * 0.38317757009345793, (double)n2 * 0.3130841121495327, (double)n3 * 0.4532710280373832, (double)n2 * 0.37850467289719625, (double)n3 * 0.4766355140186916);
                generalPath.curveTo((double)n2 * 0.37850467289719625, (double)n3 * 0.4766355140186916, (double)n2 * 0.40186915887850466, (double)n3 * 0.49065420560747663, (double)n2 * 0.43457943925233644, (double)n3 * 0.49065420560747663);
                generalPath.curveTo((double)n2 * 0.42990654205607476, (double)n3 * 0.5, (double)n2 * 0.42990654205607476, (double)n3 * 0.5046728971962616, (double)n2 * 0.42990654205607476, (double)n3 * 0.514018691588785);
                generalPath.curveTo((double)n2 * 0.42990654205607476, (double)n3 * 0.5186915887850467, (double)n2 * 0.42990654205607476, (double)n3 * 0.5186915887850467, (double)n2 * 0.42990654205607476, (double)n3 * 0.5233644859813084);
                generalPath.closePath();
                break;
            }
            case SLICKNESS: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.677570093457944, (double)n3 * 0.5467289719626168);
                generalPath.lineTo((double)n2 * 0.6355140186915887, (double)n3 * 0.5467289719626168);
                generalPath.curveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.5467289719626168, (double)n2 * 0.6822429906542056, (double)n3 * 0.5700934579439252, (double)n2 * 0.677570093457944, (double)n3 * 0.5981308411214953);
                generalPath.curveTo((double)n2 * 0.677570093457944, (double)n3 * 0.6261682242990654, (double)n2 * 0.5233644859813084, (double)n3 * 0.6355140186915887, (double)n2 * 0.5233644859813084, (double)n3 * 0.6728971962616822);
                generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.705607476635514, (double)n2 * 0.5841121495327103, (double)n3 * 0.7242990654205608, (double)n2 * 0.5841121495327103, (double)n3 * 0.7242990654205608);
                generalPath.lineTo((double)n2 * 0.6355140186915887, (double)n3 * 0.7242990654205608);
                generalPath.curveTo((double)n2 * 0.6355140186915887, (double)n3 * 0.7242990654205608, (double)n2 * 0.5747663551401869, (double)n3 * 0.6962616822429907, (double)n2 * 0.5747663551401869, (double)n3 * 0.6728971962616822);
                generalPath.curveTo((double)n2 * 0.5700934579439252, (double)n3 * 0.6495327102803738, (double)n2 * 0.7336448598130841, (double)n3 * 0.6308411214953271, (double)n2 * 0.7289719626168224, (double)n3 * 0.5981308411214953);
                generalPath.curveTo((double)n2 * 0.7289719626168224, (double)n3 * 0.5700934579439252, (double)n2 * 0.677570093457944, (double)n3 * 0.5467289719626168, (double)n2 * 0.677570093457944, (double)n3 * 0.5467289719626168);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.4205607476635514, (double)n3 * 0.5467289719626168);
                generalPath.lineTo((double)n2 * 0.37850467289719625, (double)n3 * 0.5467289719626168);
                generalPath.curveTo((double)n2 * 0.37850467289719625, (double)n3 * 0.5467289719626168, (double)n2 * 0.4205607476635514, (double)n3 * 0.5700934579439252, (double)n2 * 0.4205607476635514, (double)n3 * 0.5981308411214953);
                generalPath.curveTo((double)n2 * 0.4205607476635514, (double)n3 * 0.6261682242990654, (double)n2 * 0.26635514018691586, (double)n3 * 0.6355140186915887, (double)n2 * 0.26635514018691586, (double)n3 * 0.6728971962616822);
                generalPath.curveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.705607476635514, (double)n2 * 0.32710280373831774, (double)n3 * 0.7242990654205608, (double)n2 * 0.32710280373831774, (double)n3 * 0.7242990654205608);
                generalPath.lineTo((double)n2 * 0.37850467289719625, (double)n3 * 0.7242990654205608);
                generalPath.curveTo((double)n2 * 0.37850467289719625, (double)n3 * 0.7242990654205608, (double)n2 * 0.3177570093457944, (double)n3 * 0.6962616822429907, (double)n2 * 0.3130841121495327, (double)n3 * 0.6728971962616822);
                generalPath.curveTo((double)n2 * 0.3130841121495327, (double)n3 * 0.6495327102803738, (double)n2 * 0.4719626168224299, (double)n3 * 0.6308411214953271, (double)n2 * 0.4719626168224299, (double)n3 * 0.5981308411214953);
                generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5700934579439252, (double)n2 * 0.4205607476635514, (double)n3 * 0.5467289719626168, (double)n2 * 0.4205607476635514, (double)n3 * 0.5467289719626168);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.42990654205607476, (double)n3 * 0.3411214953271028);
                generalPath.lineTo((double)n2 * 0.42990654205607476, (double)n3 * 0.3317757009345794);
                generalPath.lineTo((double)n2 * 0.46261682242990654, (double)n3 * 0.3130841121495327);
                generalPath.lineTo((double)n2 * 0.5747663551401869, (double)n3 * 0.3130841121495327);
                generalPath.lineTo((double)n2 * 0.6074766355140186, (double)n3 * 0.3317757009345794);
                generalPath.lineTo((double)n2 * 0.6074766355140186, (double)n3 * 0.3411214953271028);
                generalPath.lineTo((double)n2 * 0.42990654205607476, (double)n3 * 0.3411214953271028);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.397196261682243, (double)n3 * 0.37383177570093457);
                generalPath.lineTo((double)n2 * 0.6448598130841121, (double)n3 * 0.37383177570093457);
                generalPath.lineTo((double)n2 * 0.6448598130841121, (double)n3 * 0.3925233644859813);
                generalPath.lineTo((double)n2 * 0.6074766355140186, (double)n3 * 0.3925233644859813);
                generalPath.lineTo((double)n2 * 0.6074766355140186, (double)n3 * 0.4158878504672897);
                generalPath.lineTo((double)n2 * 0.6588785046728972, (double)n3 * 0.4158878504672897);
                generalPath.lineTo((double)n2 * 0.6588785046728972, (double)n3 * 0.4532710280373832);
                generalPath.lineTo((double)n2 * 0.3878504672897196, (double)n3 * 0.4532710280373832);
                generalPath.lineTo((double)n2 * 0.3878504672897196, (double)n3 * 0.4158878504672897);
                generalPath.lineTo((double)n2 * 0.4392523364485981, (double)n3 * 0.4158878504672897);
                generalPath.lineTo((double)n2 * 0.4392523364485981, (double)n3 * 0.3925233644859813);
                generalPath.lineTo((double)n2 * 0.397196261682243, (double)n3 * 0.3925233644859813);
                generalPath.lineTo((double)n2 * 0.397196261682243, (double)n3 * 0.37383177570093457);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.3598130841121495, (double)n3 * 0.5280373831775701);
                generalPath.lineTo((double)n2 * 0.40186915887850466, (double)n3 * 0.5280373831775701);
                generalPath.lineTo((double)n2 * 0.40186915887850466, (double)n3 * 0.5046728971962616);
                generalPath.lineTo((double)n2 * 0.4252336448598131, (double)n3 * 0.49065420560747663);
                generalPath.lineTo((double)n2 * 0.6261682242990654, (double)n3 * 0.49065420560747663);
                generalPath.lineTo((double)n2 * 0.6495327102803738, (double)n3 * 0.5046728971962616);
                generalPath.lineTo((double)n2 * 0.6495327102803738, (double)n3 * 0.5280373831775701);
                generalPath.lineTo((double)n2 * 0.6869158878504673, (double)n3 * 0.5280373831775701);
                generalPath.lineTo((double)n2 * 0.6869158878504673, (double)n3 * 0.37850467289719625);
                generalPath.lineTo((double)n2 * 0.719626168224299, (double)n3 * 0.3691588785046729);
                generalPath.lineTo((double)n2 * 0.7102803738317757, (double)n3 * 0.35046728971962615);
                generalPath.lineTo((double)n2 * 0.6682242990654206, (double)n3 * 0.35046728971962615);
                generalPath.lineTo((double)n2 * 0.602803738317757, (double)n3 * 0.2803738317757009);
                generalPath.lineTo((double)n2 * 0.4392523364485981, (double)n3 * 0.2803738317757009);
                generalPath.lineTo((double)n2 * 0.38317757009345793, (double)n3 * 0.35046728971962615);
                generalPath.lineTo((double)n2 * 0.3364485981308411, (double)n3 * 0.35046728971962615);
                generalPath.lineTo((double)n2 * 0.32710280373831774, (double)n3 * 0.3691588785046729);
                generalPath.lineTo((double)n2 * 0.3598130841121495, (double)n3 * 0.37383177570093457);
                generalPath.lineTo((double)n2 * 0.3598130841121495, (double)n3 * 0.5280373831775701);
                generalPath.closePath();
                break;
            }
            case ARROW_NORTH: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.616822429906542 * (double)n2, 0.6962616822429907 * (double)n3);
                generalPath.lineTo(0.3878504672897196 * (double)n2, 0.6962616822429907 * (double)n3);
                generalPath.lineTo(0.3878504672897196 * (double)n2, 0.5794392523364486 * (double)n3);
                generalPath.lineTo(0.26635514018691586 * (double)n2, 0.5794392523364486 * (double)n3);
                generalPath.lineTo(0.5046728971962616 * (double)n2, 0.3130841121495327 * (double)n3);
                generalPath.lineTo(0.7336448598130841 * (double)n2, 0.5794392523364486 * (double)n3);
                generalPath.lineTo(0.616822429906542 * (double)n2, 0.5794392523364486 * (double)n3);
                generalPath.lineTo(0.616822429906542 * (double)n2, 0.6962616822429907 * (double)n3);
                generalPath.closePath();
                break;
            }
            case ARROW_NORTH_EAST: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.49065420560747663 * (double)n2, 0.6822429906542056 * (double)n3);
                generalPath.lineTo(0.32710280373831774 * (double)n2, 0.5186915887850467 * (double)n3);
                generalPath.lineTo(0.411214953271028 * (double)n2, 0.43457943925233644 * (double)n3);
                generalPath.lineTo(0.32710280373831774 * (double)n2, 0.35046728971962615 * (double)n3);
                generalPath.lineTo(0.6728971962616822 * (double)n2, 0.32242990654205606 * (double)n3);
                generalPath.lineTo(0.6542056074766355 * (double)n2, 0.6822429906542056 * (double)n3);
                generalPath.lineTo(0.5747663551401869 * (double)n2, 0.5981308411214953 * (double)n3);
                generalPath.lineTo(0.49065420560747663 * (double)n2, 0.6822429906542056 * (double)n3);
                generalPath.closePath();
                break;
            }
            case ARROW_EAST: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.308411214953271 * (double)n2, 0.616822429906542 * (double)n3);
                generalPath.lineTo(0.308411214953271 * (double)n2, 0.3878504672897196 * (double)n3);
                generalPath.lineTo(0.4252336448598131 * (double)n2, 0.3878504672897196 * (double)n3);
                generalPath.lineTo(0.4252336448598131 * (double)n2, 0.26635514018691586 * (double)n3);
                generalPath.lineTo(0.6915887850467289 * (double)n2, 0.4953271028037383 * (double)n3);
                generalPath.lineTo(0.4252336448598131 * (double)n2, 0.7336448598130841 * (double)n3);
                generalPath.lineTo(0.4252336448598131 * (double)n2, 0.616822429906542 * (double)n3);
                generalPath.lineTo(0.308411214953271 * (double)n2, 0.616822429906542 * (double)n3);
                generalPath.closePath();
                break;
            }
            case ARROW_SOUTH_EAST: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.32242990654205606 * (double)n2, 0.49065420560747663 * (double)n3);
                generalPath.lineTo(0.48598130841121495 * (double)n2, 0.3317757009345794 * (double)n3);
                generalPath.lineTo(0.5654205607476636 * (double)n2, 0.411214953271028 * (double)n3);
                generalPath.lineTo(0.6495327102803738 * (double)n2, 0.32710280373831774 * (double)n3);
                generalPath.lineTo(0.677570093457944 * (double)n2, 0.677570093457944 * (double)n3);
                generalPath.lineTo(0.32242990654205606 * (double)n2, 0.6588785046728972 * (double)n3);
                generalPath.lineTo(0.40654205607476634 * (double)n2, 0.5747663551401869 * (double)n3);
                generalPath.lineTo(0.32242990654205606 * (double)n2, 0.49065420560747663 * (double)n3);
                generalPath.closePath();
                break;
            }
            case ARROW_SOUTH: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.616822429906542 * (double)n2, 0.3130841121495327 * (double)n3);
                generalPath.lineTo(0.3878504672897196 * (double)n2, 0.3130841121495327 * (double)n3);
                generalPath.lineTo(0.3878504672897196 * (double)n2, 0.42990654205607476 * (double)n3);
                generalPath.lineTo(0.26635514018691586 * (double)n2, 0.42990654205607476 * (double)n3);
                generalPath.lineTo(0.5046728971962616 * (double)n2, 0.6962616822429907 * (double)n3);
                generalPath.lineTo(0.7336448598130841 * (double)n2, 0.42990654205607476 * (double)n3);
                generalPath.lineTo(0.616822429906542 * (double)n2, 0.42990654205607476 * (double)n3);
                generalPath.lineTo(0.616822429906542 * (double)n2, 0.3130841121495327 * (double)n3);
                generalPath.closePath();
                break;
            }
            case ARROW_SOUTH_WEST: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.677570093457944 * (double)n2, 0.49065420560747663 * (double)n3);
                generalPath.lineTo(0.514018691588785 * (double)n2, 0.3317757009345794 * (double)n3);
                generalPath.lineTo(0.43457943925233644 * (double)n2, 0.411214953271028 * (double)n3);
                generalPath.lineTo(0.35046728971962615 * (double)n2, 0.32710280373831774 * (double)n3);
                generalPath.lineTo(0.32242990654205606 * (double)n2, 0.677570093457944 * (double)n3);
                generalPath.lineTo(0.677570093457944 * (double)n2, 0.6588785046728972 * (double)n3);
                generalPath.lineTo(0.5934579439252337 * (double)n2, 0.5747663551401869 * (double)n3);
                generalPath.lineTo(0.677570093457944 * (double)n2, 0.49065420560747663 * (double)n3);
                generalPath.closePath();
                break;
            }
            case ARROW_WEST: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.6915887850467289 * (double)n2, 0.616822429906542 * (double)n3);
                generalPath.lineTo(0.6915887850467289 * (double)n2, 0.3878504672897196 * (double)n3);
                generalPath.lineTo(0.5747663551401869 * (double)n2, 0.3878504672897196 * (double)n3);
                generalPath.lineTo(0.5747663551401869 * (double)n2, 0.26635514018691586 * (double)n3);
                generalPath.lineTo(0.3130841121495327 * (double)n2, 0.4953271028037383 * (double)n3);
                generalPath.lineTo(0.5747663551401869 * (double)n2, 0.7336448598130841 * (double)n3);
                generalPath.lineTo(0.5747663551401869 * (double)n2, 0.616822429906542 * (double)n3);
                generalPath.lineTo(0.6915887850467289 * (double)n2, 0.616822429906542 * (double)n3);
                generalPath.closePath();
                break;
            }
            case ARROW_NORTH_WEST: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.5093457943925234 * (double)n2, 0.6822429906542056 * (double)n3);
                generalPath.lineTo(0.6728971962616822 * (double)n2, 0.5186915887850467 * (double)n3);
                generalPath.lineTo(0.5887850467289719 * (double)n2, 0.43457943925233644 * (double)n3);
                generalPath.lineTo(0.6728971962616822 * (double)n2, 0.35046728971962615 * (double)n3);
                generalPath.lineTo(0.32710280373831774 * (double)n2, 0.32710280373831774 * (double)n3);
                generalPath.lineTo(0.34579439252336447 * (double)n2, 0.6822429906542056 * (double)n3);
                generalPath.lineTo(0.4252336448598131 * (double)n2, 0.5981308411214953 * (double)n3);
                generalPath.lineTo(0.5093457943925234 * (double)n2, 0.6822429906542056 * (double)n3);
                generalPath.closePath();
                break;
            }
            default: {
                generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.40654205607476634, (double)n3 * 0.5654205607476636);
                generalPath.curveTo((double)n2 * 0.40654205607476634, (double)n3 * 0.5514018691588785, (double)n2 * 0.4205607476635514, (double)n3 * 0.5420560747663551, (double)n2 * 0.4485981308411215, (double)n3 * 0.5327102803738317);
                generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5233644859813084, (double)n2 * 0.5, (double)n3 * 0.5186915887850467, (double)n2 * 0.5327102803738317, (double)n3 * 0.5186915887850467);
                generalPath.curveTo((double)n2 * 0.5607476635514018, (double)n3 * 0.5186915887850467, (double)n2 * 0.5934579439252337, (double)n3 * 0.5233644859813084, (double)n2 * 0.6121495327102804, (double)n3 * 0.5327102803738317);
                generalPath.curveTo((double)n2 * 0.6401869158878505, (double)n3 * 0.5420560747663551, (double)n2 * 0.6542056074766355, (double)n3 * 0.5514018691588785, (double)n2 * 0.6542056074766355, (double)n3 * 0.5654205607476636);
                generalPath.curveTo((double)n2 * 0.6542056074766355, (double)n3 * 0.5887850467289719, (double)n2 * 0.5981308411214953, (double)n3 * 0.6121495327102804, (double)n2 * 0.5327102803738317, (double)n3 * 0.6121495327102804);
                generalPath.curveTo((double)n2 * 0.46261682242990654, (double)n3 * 0.6121495327102804, (double)n2 * 0.40654205607476634, (double)n3 * 0.5887850467289719, (double)n2 * 0.40654205607476634, (double)n3 * 0.5654205607476636);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.677570093457944, (double)n3 * 0.5654205607476636);
                generalPath.curveTo((double)n2 * 0.677570093457944, (double)n3 * 0.5514018691588785, (double)n2 * 0.6728971962616822, (double)n3 * 0.5420560747663551, (double)n2 * 0.6588785046728972, (double)n3 * 0.5327102803738317);
                generalPath.curveTo((double)n2 * 0.6915887850467289, (double)n3 * 0.5046728971962616, (double)n2 * 0.7242990654205608, (double)n3 * 0.5327102803738317, (double)n2 * 0.7242990654205608, (double)n3 * 0.5327102803738317);
                generalPath.lineTo((double)n2 * 0.7383177570093458, (double)n3 * 0.5327102803738317);
                generalPath.lineTo((double)n2 * 0.7383177570093458, (double)n3 * 0.46261682242990654);
                generalPath.lineTo((double)n2 * 0.7242990654205608, (double)n3 * 0.46261682242990654);
                generalPath.curveTo((double)n2 * 0.7242990654205608, (double)n3 * 0.46261682242990654, (double)n2 * 0.705607476635514, (double)n3 * 0.48598130841121495, (double)n2 * 0.6542056074766355, (double)n3 * 0.48598130841121495);
                generalPath.curveTo((double)n2 * 0.6214953271028038, (double)n3 * 0.48598130841121495, (double)n2 * 0.5981308411214953, (double)n3 * 0.48598130841121495, (double)n2 * 0.5981308411214953, (double)n3 * 0.48598130841121495);
                generalPath.lineTo((double)n2 * 0.5981308411214953, (double)n3 * 0.4439252336448598);
                generalPath.lineTo((double)n2 * 0.5747663551401869, (double)n3 * 0.4439252336448598);
                generalPath.lineTo((double)n2 * 0.5747663551401869, (double)n3 * 0.48598130841121495);
                generalPath.lineTo((double)n2 * 0.5420560747663551, (double)n3 * 0.48598130841121495);
                generalPath.lineTo((double)n2 * 0.5420560747663551, (double)n3 * 0.4439252336448598);
                generalPath.lineTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4439252336448598);
                generalPath.lineTo((double)n2 * 0.5186915887850467, (double)n3 * 0.48598130841121495);
                generalPath.lineTo((double)n2 * 0.48598130841121495, (double)n3 * 0.48598130841121495);
                generalPath.lineTo((double)n2 * 0.48598130841121495, (double)n3 * 0.4439252336448598);
                generalPath.lineTo((double)n2 * 0.46261682242990654, (double)n3 * 0.4439252336448598);
                generalPath.curveTo((double)n2 * 0.46261682242990654, (double)n3 * 0.4439252336448598, (double)n2 * 0.46261682242990654, (double)n3 * 0.48130841121495327, (double)n2 * 0.46261682242990654, (double)n3 * 0.48598130841121495);
                generalPath.curveTo((double)n2 * 0.3037383177570093, (double)n3 * 0.48598130841121495, (double)n2 * 0.2803738317757009, (double)n3 * 0.3644859813084112, (double)n2 * 0.2803738317757009, (double)n3 * 0.3644859813084112);
                generalPath.lineTo((double)n2 * 0.27102803738317754, (double)n3 * 0.3644859813084112);
                generalPath.lineTo((double)n2 * 0.27102803738317754, (double)n3 * 0.6401869158878505);
                generalPath.lineTo((double)n2 * 0.2850467289719626, (double)n3 * 0.6401869158878505);
                generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.6401869158878505, (double)n2 * 0.29439252336448596, (double)n3 * 0.5327102803738317, (double)n2 * 0.3925233644859813, (double)n3 * 0.5327102803738317);
                generalPath.curveTo((double)n2 * 0.3925233644859813, (double)n3 * 0.5327102803738317, (double)n2 * 0.40186915887850466, (double)n3 * 0.5327102803738317, (double)n2 * 0.40186915887850466, (double)n3 * 0.5327102803738317);
                generalPath.curveTo((double)n2 * 0.3878504672897196, (double)n3 * 0.5420560747663551, (double)n2 * 0.38317757009345793, (double)n3 * 0.5514018691588785, (double)n2 * 0.38317757009345793, (double)n3 * 0.5654205607476636);
                generalPath.curveTo((double)n2 * 0.38317757009345793, (double)n3 * 0.602803738317757, (double)n2 * 0.4485981308411215, (double)n3 * 0.6355140186915887, (double)n2 * 0.5327102803738317, (double)n3 * 0.6355140186915887);
                generalPath.curveTo((double)n2 * 0.6121495327102804, (double)n3 * 0.6355140186915887, (double)n2 * 0.677570093457944, (double)n3 * 0.602803738317757, (double)n2 * 0.677570093457944, (double)n3 * 0.5654205607476636);
                generalPath.closePath();
                break;
            }
        }
        if (colorDef == ColorDef.CUSTOM && customColorDef != null) {
            color3 = customColorDef.LIGHT;
            color2 = this.UTIL.setAlpha(customColorDef.DARK, 0.5f);
            color = customColorDef.LIGHT;
        } else {
            color3 = colorDef.LIGHT;
            color2 = this.UTIL.setAlpha(colorDef.DARK, 0.5f);
            color = colorDef.LIGHT;
        }
        if (bl) {
            if (this.clipImageSymbol != null) {
                this.clipImageSymbol.flush();
            }
            this.clipImageSymbol = this.SHADOW.createSoftClipImage(generalPath, color3);
            double d = 0.12 * (double)n2;
            graphics2D.translate(-d, -d);
            graphics2D.drawImage((Image)Shadow.INSTANCE.createDropShadow(this.clipImageSymbol, 0, 0.65f, (int)d, 315, color), generalPath.getBounds().x, generalPath.getBounds().y, null);
            graphics2D.translate(d, d);
        } else {
            graphics2D.setPaint(color3);
            graphics2D.fill(generalPath);
            graphics2D.setStroke(new BasicStroke(0.5f));
            graphics2D.setColor(color2);
            graphics2D.draw(generalPath);
        }
        graphics2D.dispose();
        this.widthBuffer = n;
        this.symbolTypeBuffer = symbolType;
        this.symbolColorBuffer = colorDef;
        this.customSymbolColorBuffer = customColorDef;
        return this.symbolImageBuffer;
    }
}

