/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.trigger;

import com.rusefi.trigger.TriggerSignal;
import com.rusefi.trigger.TriggerSignalReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class TriggerWheelInfo {
    private static final String TRIGGERTYPE = "TRIGGERTYPE";
    static final String DEFAULT_WORK_FOLDER = ".." + File.separator + "unit_tests";
    private final int id;
    private final boolean isSecondWheelCam;
    private final double tdcPosition;
    private final String triggerName;
    private final List<TriggerSignal> signals;
    private final boolean isCrankBased;
    private final boolean hasSecondChannel;
    private final boolean knownOperationMode;
    private final TriggerGaps gaps;
    private final String syncEdge;

    public TriggerWheelInfo(int id, double tdcPosition, String triggerName, List<TriggerSignal> signals, boolean isCrankBased, boolean isSecondWheelCam, boolean hasSecondChannel, boolean knownOperationMode, TriggerGaps gaps, String syncEdge) {
        this.id = id;
        this.isSecondWheelCam = isSecondWheelCam;
        this.tdcPosition = tdcPosition;
        this.triggerName = triggerName;
        this.signals = signals;
        this.isCrankBased = isCrankBased;
        this.hasSecondChannel = hasSecondChannel;
        this.knownOperationMode = knownOperationMode;
        this.gaps = gaps;
        this.syncEdge = syncEdge;
    }

    private static TriggerWheelInfo readTriggerWheelInfo(String line, BufferedReader reader) throws IOException {
        String[] tokens = line.split(" ");
        String idStr = tokens[1];
        int eventCount = Integer.parseInt(tokens[2]);
        String triggerName = tokens[3];
        System.out.println("Processing " + line + " " + idStr);
        int id = Integer.parseInt(idStr);
        double tdcPosition = Double.parseDouble(tokens[4]);
        System.out.println("id=" + id + ", count=" + eventCount + ", name=" + triggerName);
        boolean isCrankBased = false;
        boolean isSecondWheelCam = false;
        boolean hasSecondChannel = false;
        boolean knownOperationMode = false;
        TriggerGaps gaps = null;
        String syncEdge = null;
        block20: while ((line = reader.readLine()) != null && !line.trim().startsWith("#")) {
            String[] keyValue = line.split("=");
            if (keyValue.length != 2) {
                throw new IllegalStateException("Key/value lines expected: [" + line + "]");
            }
            String key = keyValue[0];
            String value = keyValue[1];
            if (key.startsWith("gapFrom")) {
                int index = TriggerWheelInfo.getIndex(key);
                gaps.gapFrom[index] = Double.parseDouble(value);
                continue;
            }
            if (key.startsWith("gapTo")) {
                int index = TriggerWheelInfo.getIndex(key);
                gaps.gapTo[index] = Double.parseDouble(value);
                continue;
            }
            switch (key) {
                case "gapsCount": {
                    int gapTrackingLength = Integer.parseInt(value);
                    gaps = new TriggerGaps(gapTrackingLength);
                    continue block20;
                }
                case "crankBased": {
                    isCrankBased = Boolean.parseBoolean(value);
                    continue block20;
                }
                case "cycleDuration": {
                    continue block20;
                }
                case "isSecondWheelCam": {
                    isSecondWheelCam = Boolean.parseBoolean(value);
                    continue block20;
                }
                case "hasSecondChannel": {
                    hasSecondChannel = Boolean.parseBoolean(value);
                    continue block20;
                }
                case "knownOperationMode": {
                    knownOperationMode = Boolean.parseBoolean(value);
                    continue block20;
                }
                case "isSynchronizationNeeded": {
                    continue block20;
                }
                case "syncEdge": {
                    syncEdge = value;
                    continue block20;
                }
            }
            throw new IllegalStateException("Unexpected key/value: " + line);
        }
        List<TriggerSignal> signals = TriggerSignalReader.readSignals(reader, eventCount);
        return new TriggerWheelInfo(id, tdcPosition, triggerName, signals, isCrankBased, isSecondWheelCam, hasSecondChannel, knownOperationMode, gaps, syncEdge);
    }

    private static int getIndex(String key) {
        return Integer.parseInt(key.split("\\.")[1]);
    }

    static void readWheels(String workingFolder, TriggerWheelInfoConsumer consumer) {
        String fileName = workingFolder + File.separator + "triggers.txt";
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            System.out.println("Reading " + fileName);
            while ((line = br.readLine()) != null) {
                if (line.trim().startsWith("#") || !line.startsWith(TRIGGERTYPE)) continue;
                TriggerWheelInfo triggerWheelInfo = TriggerWheelInfo.readTriggerWheelInfo(line, br);
                consumer.onWheel(triggerWheelInfo);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @NotNull
    public List<TriggerSignal> getFirstWheeTriggerSignals() {
        List<TriggerSignal> firstWheel = this.getTriggerSignals(0);
        if (this.isCrankBased) {
            return this.takeFirstHalf(firstWheel);
        }
        return TriggerWheelInfo.compressAngle(firstWheel);
    }

    public double getTdcPositionIn360() {
        return this.isCrankBased ? this.getTdcPosition() : TriggerWheelInfo.getCompressedAngle(this.getTdcPosition());
    }

    @NotNull
    private List<TriggerSignal> getTriggerSignals(int index) {
        return this.getSignals().stream().filter(signal -> signal.getWaveIndex() == index).collect(Collectors.toList());
    }

    @NotNull
    private List<TriggerSignal> takeFirstHalf(List<TriggerSignal> wheel) {
        return wheel.stream().filter(triggerSignal -> triggerSignal.getAngle() < 360.0).collect(Collectors.toList());
    }

    @NotNull
    private static List<TriggerSignal> compressAngle(List<TriggerSignal> wheel) {
        return wheel.stream().map(triggerSignal -> {
            double compressAngle = TriggerWheelInfo.getCompressedAngle(triggerSignal.getAngle());
            return new TriggerSignal(triggerSignal.getWaveIndex(), triggerSignal.getState(), compressAngle, triggerSignal.getGap());
        }).collect(Collectors.toList());
    }

    private static double getCompressedAngle(double angle) {
        return angle / 2.0;
    }

    public List<TriggerSignal> getSecondWheeTriggerSignals() {
        List<TriggerSignal> secondWheel = this.getTriggerSignals(1);
        if (this.isSecondWheelCam) {
            return TriggerWheelInfo.compressAngle(secondWheel);
        }
        return this.takeFirstHalf(secondWheel);
    }

    public int getId() {
        return this.id;
    }

    public double getTdcPosition() {
        return this.tdcPosition;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public List<TriggerSignal> getSignals() {
        return this.signals;
    }

    public boolean isCrankBased() {
        return this.isCrankBased;
    }

    public boolean isHasSecondChannel() {
        return this.hasSecondChannel;
    }

    public boolean isKnownOperationMode() {
        return this.knownOperationMode;
    }

    public TriggerGaps getGaps() {
        return this.gaps;
    }

    public String getSyncEdge() {
        return this.syncEdge;
    }

    static class TriggerGaps {
        public double[] gapFrom;
        public double[] gapTo;

        public TriggerGaps(int gapTrackingLength) {
            this.gapFrom = new double[gapTrackingLength];
            this.gapTo = new double[gapTrackingLength];
        }

        public String toString() {
            return "TriggerGaps{gapFrom=" + Arrays.toString(this.gapFrom) + ", gapTo=" + Arrays.toString(this.gapTo) + "}";
        }
    }

    public static interface TriggerWheelInfoConsumer {
        public void onWheel(TriggerWheelInfo var1);
    }
}

