/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.Timer;

public class TrafficLight2
extends JComponent
implements ActionListener {
    public static final String RED_PROPERTY = "red";
    public static final String YELLOW_PROPERTY = "yellow";
    public static final String GREEN_PROPERTY = "green";
    private boolean blink;
    private boolean blinking;
    private boolean redOn;
    private boolean redBlinkEnabled;
    private boolean yellowVisible;
    private boolean yellowOn;
    private boolean yellowBlinkEnabled;
    private boolean greenOn;
    private boolean greenBlinkEnabled;
    private PropertyChangeSupport propertySupport;
    private final Rectangle INNER_BOUNDS = new Rectangle(0, 0, 80, 200);
    private final Point2D CENTER;
    private BufferedImage housingImage;
    private BufferedImage greenOnImage;
    private BufferedImage greenOffImage;
    private BufferedImage yellowOnImage;
    private BufferedImage yellowOffImage;
    private BufferedImage redOnImage;
    private BufferedImage redOffImage;
    private boolean square;
    private final Timer TIMER;
    private int timerPeriod;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            int n = TrafficLight2.this.getWidth() <= TrafficLight2.this.getHeight() ? TrafficLight2.this.getWidth() : TrafficLight2.this.getHeight();
            Container container = TrafficLight2.this.getParent();
            if (container != null && container.getLayout() == null) {
                if (n < TrafficLight2.this.getMinimumSize().width || n < TrafficLight2.this.getMinimumSize().height) {
                    TrafficLight2.this.setSize(TrafficLight2.this.getMinimumSize());
                } else if (TrafficLight2.this.square) {
                    TrafficLight2.this.setSize(n, n);
                } else {
                    TrafficLight2.this.setSize(TrafficLight2.this.getWidth(), TrafficLight2.this.getHeight());
                }
            } else if (n < TrafficLight2.this.getMinimumSize().width || n < TrafficLight2.this.getMinimumSize().height) {
                TrafficLight2.this.setPreferredSize(TrafficLight2.this.getMinimumSize());
            } else if (TrafficLight2.this.square) {
                TrafficLight2.this.setPreferredSize(new Dimension(n, n));
            } else {
                TrafficLight2.this.setPreferredSize(new Dimension(TrafficLight2.this.getWidth(), TrafficLight2.this.getHeight()));
            }
            TrafficLight2.this.calcInnerBounds();
            TrafficLight2.this.init(((TrafficLight2)TrafficLight2.this).getInnerBounds().width, ((TrafficLight2)TrafficLight2.this).getInnerBounds().height);
        }
    };

    public TrafficLight2() {
        this.addComponentListener(this.COMPONENT_LISTENER);
        this.propertySupport = new PropertyChangeSupport(this);
        this.CENTER = new Point2D.Double();
        this.timerPeriod = 1000;
        this.TIMER = new Timer(this.timerPeriod, this);
        this.housingImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.greenOnImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.greenOffImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.yellowOnImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.yellowOffImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.redOnImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.redOffImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.blink = false;
        this.blinking = false;
        this.redOn = false;
        this.redBlinkEnabled = false;
        this.yellowVisible = true;
        this.yellowOn = false;
        this.yellowBlinkEnabled = false;
        this.greenOn = false;
        this.greenBlinkEnabled = false;
        this.square = false;
    }

    public final void init(int n, int n2) {
        if (n <= 1 || n2 <= 1) {
            return;
        }
        if (this.housingImage != null) {
            this.housingImage.flush();
        }
        BufferedImage bufferedImage = this.housingImage = this.yellowVisible ? this.create3LightsHousingImage(n, n2) : this.create2LightsHousingImage(n, n2);
        if (this.greenOnImage != null) {
            this.greenOnImage.flush();
        }
        BufferedImage bufferedImage2 = this.greenOnImage = this.yellowVisible ? this.create3LightsGreenImage(n, n2, true) : this.create2LightsGreenImage(n, n2, true);
        if (this.greenOffImage != null) {
            this.greenOffImage.flush();
        }
        BufferedImage bufferedImage3 = this.greenOffImage = this.yellowVisible ? this.create3LightsGreenImage(n, n2, false) : this.create2LightsGreenImage(n, n2, false);
        if (this.yellowOnImage != null) {
            this.yellowOnImage.flush();
        }
        this.yellowOnImage = this.create3LightsYellowImage(n, n2, true);
        if (this.yellowOffImage != null) {
            this.yellowOffImage.flush();
        }
        this.yellowOffImage = this.create3LightsYellowImage(n, n2, false);
        if (this.redOnImage != null) {
            this.redOnImage.flush();
        }
        BufferedImage bufferedImage4 = this.redOnImage = this.yellowVisible ? this.create3LightsRedImage(n, n2, true) : this.create2LightsRedImage(n, n2, true);
        if (this.redOffImage != null) {
            this.redOffImage.flush();
        }
        this.redOffImage = this.yellowVisible ? this.create3LightsRedImage(n, n2, false) : this.create2LightsRedImage(n, n2, false);
        this.CENTER.setLocation((double)n / 2.0, (double)n2 / 2.0);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        graphics2D.drawImage((Image)this.housingImage, 0, 0, null);
        if (this.greenOn) {
            graphics2D.drawImage((Image)this.greenOnImage, 0, 0, null);
        } else {
            graphics2D.drawImage((Image)this.greenOffImage, 0, 0, null);
        }
        if (this.yellowVisible) {
            if (this.yellowOn) {
                graphics2D.drawImage((Image)this.yellowOnImage, 0, 0, null);
            } else {
                graphics2D.drawImage((Image)this.yellowOffImage, 0, 0, null);
            }
        }
        if (this.redOn) {
            graphics2D.drawImage((Image)this.redOnImage, 0, 0, null);
        } else {
            graphics2D.drawImage((Image)this.redOffImage, 0, 0, null);
        }
        graphics2D.dispose();
    }

    public boolean isBlinking() {
        return this.blinking;
    }

    public void setBlinking(boolean bl) {
        this.blinking = bl;
        if (this.blinking) {
            this.TIMER.start();
        } else {
            this.TIMER.stop();
        }
    }

    public boolean isRedOn() {
        return this.redOn;
    }

    public void setRedOn(boolean bl) {
        boolean bl2 = this.redOn;
        this.redOn = bl;
        this.propertySupport.firePropertyChange(RED_PROPERTY, bl2, this.redOn);
        this.repaint(this.getInnerBounds());
    }

    public boolean isRedBlinkEnabled() {
        return this.redBlinkEnabled;
    }

    public void setRedBlinkEnabled(boolean bl) {
        this.redOn = this.redBlinkEnabled = bl;
    }

    public boolean isYellowVisible() {
        return this.yellowVisible;
    }

    public void setYellowVisible(boolean bl) {
        this.yellowVisible = bl;
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isYellowOn() {
        return this.yellowOn;
    }

    public void setYellowOn(boolean bl) {
        boolean bl2 = this.yellowOn;
        this.yellowOn = bl;
        this.propertySupport.firePropertyChange(YELLOW_PROPERTY, bl2, this.yellowOn);
        this.repaint(this.getInnerBounds());
    }

    public boolean isYellowBlinkEnabled() {
        return this.yellowBlinkEnabled;
    }

    public void setYellowBlinkEnabled(boolean bl) {
        this.yellowOn = this.yellowBlinkEnabled = bl;
    }

    public boolean isGreenOn() {
        return this.greenOn;
    }

    public void setGreenOn(boolean bl) {
        boolean bl2 = this.greenOn;
        this.greenOn = bl;
        this.propertySupport.firePropertyChange(GREEN_PROPERTY, bl2, this.greenOn);
        this.repaint(this.getInnerBounds());
    }

    public boolean isGreenBlinkEnabled() {
        return this.greenBlinkEnabled;
    }

    public void setGreenBlinkEnabled(boolean bl) {
        this.greenOn = this.greenBlinkEnabled = bl;
    }

    public int getTimerPeriod() {
        return this.timerPeriod;
    }

    public void setTimerPeriod(int n) {
        this.timerPeriod = n < 100 ? 100 : (n > 10000 ? 10000 : n);
        this.TIMER.setDelay(this.timerPeriod);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.isShowing()) {
            this.propertySupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void calcInnerBounds() {
        Insets insets = this.getInsets();
        if (this.yellowVisible) {
            int n = this.getWidth() < (int)((double)this.getHeight() * 0.4) ? (int)((double)this.getWidth() * 2.5) : this.getHeight();
            this.INNER_BOUNDS.setBounds(insets.left, insets.top, (int)((double)n * 0.4) - insets.left - insets.right, n - insets.top - insets.bottom);
        } else {
            int n = this.getWidth() < (int)((double)this.getHeight() * 0.5714285714) ? (int)((double)this.getWidth() * 1.75) : this.getHeight();
            this.INNER_BOUNDS.setBounds(insets.left, insets.top, (int)((double)n * 0.5714285714) - insets.left - insets.right, n - insets.top - insets.bottom);
        }
    }

    private Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        int n;
        int n2 = n = dimension.width <= dimension.height ? dimension.width : dimension.height;
        if (this.square) {
            super.setPreferredSize(new Dimension(n, n));
        } else {
            super.setPreferredSize(dimension);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(int n, int n2) {
        int n3;
        int n4 = n3 = n <= n2 ? n : n2;
        if (this.square) {
            super.setSize(n3, n3);
        } else {
            super.setSize(n, n2);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(Dimension dimension) {
        int n;
        int n2 = n = dimension.width <= dimension.height ? dimension.width : dimension.height;
        if (this.square) {
            super.setSize(new Dimension(n, n));
        } else {
            super.setSize(dimension);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        int n;
        int n2 = n = rectangle.width <= rectangle.height ? rectangle.width : rectangle.height;
        if (this.square) {
            super.setBounds(rectangle.x, rectangle.y, n, n);
        } else {
            super.setBounds(rectangle);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n5 = n3 <= n4 ? n3 : n4;
        if (this.square) {
            super.setBounds(n, n2, n5, n5);
        } else {
            super.setBounds(n, n2, n3, n4);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    private BufferedImage createImage(int n, int n2, int n3) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, n3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, n3);
        return bufferedImage;
    }

    public BufferedImage create2LightsHousingImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo(0.125 * (double)n3, 0.2857142857142857 * (double)n4);
        generalPath.curveTo(0.125 * (double)n3, 0.16428571428571428 * (double)n4, 0.2875 * (double)n3, 0.07142857142857142 * (double)n4, 0.5 * (double)n3, 0.07142857142857142 * (double)n4);
        generalPath.curveTo(0.7125 * (double)n3, 0.07142857142857142 * (double)n4, 0.875 * (double)n3, 0.16428571428571428 * (double)n4, 0.875 * (double)n3, 0.2857142857142857 * (double)n4);
        generalPath.curveTo(0.875 * (double)n3, 0.2857142857142857 * (double)n4, 0.875 * (double)n3, 0.7142857142857143 * (double)n4, 0.875 * (double)n3, 0.7142857142857143 * (double)n4);
        generalPath.curveTo(0.875 * (double)n3, 0.8357142857142857 * (double)n4, 0.7125 * (double)n3, 0.9285714285714286 * (double)n4, 0.5 * (double)n3, 0.9285714285714286 * (double)n4);
        generalPath.curveTo(0.2875 * (double)n3, 0.9285714285714286 * (double)n4, 0.125 * (double)n3, 0.8357142857142857 * (double)n4, 0.125 * (double)n3, 0.7142857142857143 * (double)n4);
        generalPath.curveTo(0.125 * (double)n3, 0.7142857142857143 * (double)n4, 0.125 * (double)n3, 0.2857142857142857 * (double)n4, 0.125 * (double)n3, 0.2857142857142857 * (double)n4);
        generalPath.closePath();
        generalPath.moveTo(0.0 * (double)n3, 0.2857142857142857 * (double)n4);
        generalPath.curveTo(0.0 * (double)n3, 0.2857142857142857 * (double)n4, 0.0 * (double)n3, 0.7142857142857143 * (double)n4, 0.0 * (double)n3, 0.7142857142857143 * (double)n4);
        generalPath.curveTo(0.0 * (double)n3, 0.8714285714285714 * (double)n4, 0.225 * (double)n3, 1.0 * (double)n4, 0.5 * (double)n3, 1.0 * (double)n4);
        generalPath.curveTo(0.775 * (double)n3, 1.0 * (double)n4, 1.0 * (double)n3, 0.8714285714285714 * (double)n4, 1.0 * (double)n3, 0.7142857142857143 * (double)n4);
        generalPath.curveTo(1.0 * (double)n3, 0.7142857142857143 * (double)n4, 1.0 * (double)n3, 0.2857142857142857 * (double)n4, 1.0 * (double)n3, 0.2857142857142857 * (double)n4);
        generalPath.curveTo(1.0 * (double)n3, 0.12857142857142856 * (double)n4, 0.775 * (double)n3, 0.0 * (double)n4, 0.5 * (double)n3, 0.0 * (double)n4);
        generalPath.curveTo(0.225 * (double)n3, 0.0 * (double)n4, 0.0 * (double)n3, 0.12857142857142856 * (double)n4, 0.0 * (double)n3, 0.2857142857142857 * (double)n4);
        generalPath.closePath();
        graphics2D.setPaint(new Color(0.2f, 0.2f, 0.2f, 0.5f));
        graphics2D.fill(generalPath);
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.125 * (double)n3, 0.07142857142857142 * (double)n4, 0.75 * (double)n3, 0.8571428571428571 * (double)n4, 0.75 * (double)n3, 0.42857142857142855 * (double)n4);
        graphics2D.setPaint(new Color(0.8f, 0.8f, 0.8f, 0.5f));
        graphics2D.fill(double_);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage create2LightsGreenImage(int n, int n2, boolean bl) {
        Ellipse2D.Double double_;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (!bl) {
            double_ = new Ellipse2D.Double(0.1875 * (double)n3, 0.5285714285714286 * (double)n4, 0.625 * (double)n3, 0.35714285714285715 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.8214285714285714 * (double)n4), 0.59375f * (float)n3, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.09803922f, 0.3372549f, 0.0f, 1.0f), new Color(0.0f, 0.0039215684f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f)}));
            graphics2D.fill(double_);
            Ellipse2D.Double double_2 = new Ellipse2D.Double(0.2625 * (double)n3, 0.5357142857142857 * (double)n4, 0.4625 * (double)n3, 0.14285714285714285 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.5642857142857143 * (double)n4), 0.2125f * (float)n3, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.22352941f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f)}));
            graphics2D.fill(double_2);
        } else {
            double_ = new Ellipse2D.Double(0.0 * (double)n3, 0.42857142857142855 * (double)n4, 1.0 * (double)n3, 0.5714285714285714 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.7142857142857143 * (double)n4), 0.5f * (float)n3, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.0f, 1.0f, 0.0f, 1.0f), new Color(0.0f, 1.0f, 0.0f, 0.0f), new Color(0.0f, 1.0f, 0.0f, 0.0f), new Color(0.0f, 1.0f, 0.0f, 0.0f)}));
            graphics2D.fill(double_);
            Ellipse2D.Double double_3 = new Ellipse2D.Double(0.1875 * (double)n3, 0.5285714285714286 * (double)n4, 0.625 * (double)n3, 0.35714285714285715 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.8214285714285714 * (double)n4), 0.59375f * (float)n3, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.0f, 1.0f, 0.0f, 1.0f), new Color(0.1254902f, 0.2784314f, 0.14117648f, 1.0f), new Color(0.1254902f, 0.27058825f, 0.14117648f, 1.0f), new Color(0.1254902f, 0.27058825f, 0.14117648f, 1.0f)}));
            graphics2D.fill(double_3);
            Ellipse2D.Double double_4 = new Ellipse2D.Double(0.2625 * (double)n3, 0.5357142857142857 * (double)n4, 0.4625 * (double)n3, 0.14285714285714285 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.5642857142857143 * (double)n4), 0.2125f * (float)n3, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.6745098f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f)}));
            graphics2D.fill(double_4);
        }
        double_ = new Ellipse2D.Double(0.1875 * (double)n3, 0.5285714285714286 * (double)n4, 0.625 * (double)n3, 0.35714285714285715 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.7071428571428572 * (double)n4), 0.3125f * (float)n3, new float[]{0.0f, 0.55f, 0.5501f, 0.78f, 0.79f, 1.0f}, new Color[]{new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.12156863f), new Color(0.0f, 0.0f, 0.0f, 0.12941177f), new Color(0.0f, 0.0f, 0.0f, 0.49803922f)}));
        graphics2D.fill(double_);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage create2LightsRedImage(int n, int n2, boolean bl) {
        Ellipse2D.Double double_;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (!bl) {
            double_ = new Ellipse2D.Double(0.1875 * (double)n3, 0.11428571428571428 * (double)n4, 0.625 * (double)n3, 0.35714285714285715 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.40714285714285714 * (double)n4), 0.59375f * (float)n3, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.3019608f, 0.0f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f)}));
            graphics2D.fill(double_);
            Ellipse2D.Double double_2 = new Ellipse2D.Double(0.2625 * (double)n3, 0.12142857142857143 * (double)n4, 0.4625 * (double)n3, 0.14285714285714285 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.15 * (double)n4), 0.2125f * (float)n3, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.22352941f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f)}));
            graphics2D.fill(double_2);
        } else {
            double_ = new Ellipse2D.Double(0.0 * (double)n3, 0.0 * (double)n4, 1.0 * (double)n3, 0.5714285714285714 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.2857142857142857 * (double)n4), 0.5f * (float)n3, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(1.0f, 0.0f, 0.0f, 0.0f), new Color(1.0f, 0.0f, 0.0f, 0.0f), new Color(1.0f, 0.0f, 0.0f, 0.0f)}));
            graphics2D.fill(double_);
            Ellipse2D.Double double_3 = new Ellipse2D.Double(0.1875 * (double)n3, 0.11428571428571428 * (double)n4, 0.625 * (double)n3, 0.35714285714285715 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.40714285714285714 * (double)n4), 0.59375f * (float)n3, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(0.25490198f, 0.0f, 0.0f, 1.0f), new Color(0.24705882f, 0.0f, 0.0f, 1.0f), new Color(0.24705882f, 0.0f, 0.0f, 1.0f)}));
            graphics2D.fill(double_3);
            GeneralPath generalPath = new GeneralPath();
            generalPath.setWindingRule(0);
            generalPath.moveTo(0.2625 * (double)n3, 0.18571428571428572 * (double)n4);
            generalPath.curveTo(0.2625 * (double)n3, 0.17142857142857143 * (double)n4, 0.375 * (double)n3, 0.12142857142857143 * (double)n4, 0.5 * (double)n3, 0.12142857142857143 * (double)n4);
            generalPath.curveTo(0.625 * (double)n3, 0.12142857142857143 * (double)n4, 0.725 * (double)n3, 0.16428571428571428 * (double)n4, 0.725 * (double)n3, 0.18571428571428572 * (double)n4);
            generalPath.curveTo(0.725 * (double)n3, 0.22857142857142856 * (double)n4, 0.625 * (double)n3, 0.2642857142857143 * (double)n4, 0.5 * (double)n3, 0.2642857142857143 * (double)n4);
            generalPath.curveTo(0.375 * (double)n3, 0.2642857142857143 * (double)n4, 0.2625 * (double)n3, 0.2357142857142857 * (double)n4, 0.2625 * (double)n3, 0.18571428571428572 * (double)n4);
            generalPath.closePath();
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.15 * (double)n4), 0.2125f * (float)n3, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.6745098f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f)}));
            graphics2D.fill(generalPath);
        }
        double_ = new Ellipse2D.Double(0.1875 * (double)n3, 0.11428571428571428 * (double)n4, 0.625 * (double)n3, 0.35714285714285715 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.29285714285714287 * (double)n4), 0.3125f * (float)n3, new float[]{0.0f, 0.55f, 0.5501f, 0.78f, 0.79f, 1.0f}, new Color[]{new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.12156863f), new Color(0.0f, 0.0f, 0.0f, 0.12941177f), new Color(0.0f, 0.0f, 0.0f, 0.49803922f)}));
        graphics2D.fill(double_);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage create3LightsHousingImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.125 * (double)n3, 0.055 * (double)n4, 0.75 * (double)n3, 0.9 * (double)n4, 0.75 * (double)n3, 0.3 * (double)n4);
        graphics2D.setPaint(new Color(0.8f, 0.8f, 0.8f, 0.5f));
        graphics2D.fill(double_);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo(0.125 * (double)n3, 0.205 * (double)n4);
        generalPath.curveTo(0.125 * (double)n3, 0.12 * (double)n4, 0.2875 * (double)n3, 0.055 * (double)n4, 0.5 * (double)n3, 0.055 * (double)n4);
        generalPath.curveTo(0.7125 * (double)n3, 0.055 * (double)n4, 0.875 * (double)n3, 0.12 * (double)n4, 0.875 * (double)n3, 0.205 * (double)n4);
        generalPath.curveTo(0.875 * (double)n3, 0.205 * (double)n4, 0.875 * (double)n3, 0.805 * (double)n4, 0.875 * (double)n3, 0.805 * (double)n4);
        generalPath.curveTo(0.875 * (double)n3, 0.89 * (double)n4, 0.7125 * (double)n3, 0.955 * (double)n4, 0.5 * (double)n3, 0.955 * (double)n4);
        generalPath.curveTo(0.2875 * (double)n3, 0.955 * (double)n4, 0.125 * (double)n3, 0.89 * (double)n4, 0.125 * (double)n3, 0.805 * (double)n4);
        generalPath.curveTo(0.125 * (double)n3, 0.805 * (double)n4, 0.125 * (double)n3, 0.205 * (double)n4, 0.125 * (double)n3, 0.205 * (double)n4);
        generalPath.closePath();
        generalPath.moveTo(0.0 * (double)n3, 0.2 * (double)n4);
        generalPath.curveTo(0.0 * (double)n3, 0.2 * (double)n4, 0.0 * (double)n3, 0.8 * (double)n4, 0.0 * (double)n3, 0.8 * (double)n4);
        generalPath.curveTo(0.0 * (double)n3, 0.91 * (double)n4, 0.225 * (double)n3, 1.0 * (double)n4, 0.5 * (double)n3, 1.0 * (double)n4);
        generalPath.curveTo(0.775 * (double)n3, 1.0 * (double)n4, 1.0 * (double)n3, 0.91 * (double)n4, 1.0 * (double)n3, 0.8 * (double)n4);
        generalPath.curveTo(1.0 * (double)n3, 0.8 * (double)n4, 1.0 * (double)n3, 0.2 * (double)n4, 1.0 * (double)n3, 0.2 * (double)n4);
        generalPath.curveTo(1.0 * (double)n3, 0.09 * (double)n4, 0.775 * (double)n3, 0.0 * (double)n4, 0.5 * (double)n3, 0.0 * (double)n4);
        generalPath.curveTo(0.225 * (double)n3, 0.0 * (double)n4, 0.0 * (double)n3, 0.09 * (double)n4, 0.0 * (double)n3, 0.2 * (double)n4);
        generalPath.closePath();
        graphics2D.setPaint(new Color(0.2f, 0.2f, 0.2f, 0.5f));
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage create3LightsGreenImage(int n, int n2, boolean bl) {
        Ellipse2D.Double double_;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (!bl) {
            double_ = new Ellipse2D.Double(0.1875 * (double)n3, 0.68 * (double)n4, 0.625 * (double)n3, 0.25 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.885 * (double)n4), 0.59375f * (float)n3, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.09803922f, 0.3372549f, 0.0f, 1.0f), new Color(0.0f, 0.0039215684f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f)}));
            graphics2D.fill(double_);
            Ellipse2D.Double double_2 = new Ellipse2D.Double(0.2625 * (double)n3, 0.685 * (double)n4, 0.4625 * (double)n3, 0.1 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.705 * (double)n4), 0.2125f * (float)n3, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.22352941f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f)}));
            graphics2D.fill(double_2);
        } else {
            double_ = new Ellipse2D.Double(0.0 * (double)n3, 0.6 * (double)n4, 1.0 * (double)n3, 0.4 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.8 * (double)n4), 0.5f * (float)n3, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.0f, 1.0f, 0.0f, 1.0f), new Color(0.0f, 1.0f, 0.0f, 0.0f), new Color(0.0f, 1.0f, 0.0f, 0.0f), new Color(0.0f, 1.0f, 0.0f, 0.0f)}));
            graphics2D.fill(double_);
            Ellipse2D.Double double_3 = new Ellipse2D.Double(0.1875 * (double)n3, 0.68 * (double)n4, 0.625 * (double)n3, 0.25 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.885 * (double)n4), 0.59375f * (float)n3, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.0f, 1.0f, 0.0f, 1.0f), new Color(0.1254902f, 0.2784314f, 0.14117648f, 1.0f), new Color(0.1254902f, 0.27058825f, 0.14117648f, 1.0f), new Color(0.1254902f, 0.27058825f, 0.14117648f, 1.0f)}));
            graphics2D.fill(double_3);
            Ellipse2D.Double double_4 = new Ellipse2D.Double(0.2625 * (double)n3, 0.685 * (double)n4, 0.4625 * (double)n3, 0.1 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.705 * (double)n4), 0.2125f * (float)n3, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.6745098f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f)}));
            graphics2D.fill(double_4);
        }
        double_ = new Ellipse2D.Double(0.1875 * (double)n3, 0.68 * (double)n4, 0.625 * (double)n3, 0.25 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.805 * (double)n4), 0.3125f * (float)n3, new float[]{0.0f, 0.55f, 0.5501f, 0.78f, 0.79f, 1.0f}, new Color[]{new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.12156863f), new Color(0.0f, 0.0f, 0.0f, 0.12941177f), new Color(0.0f, 0.0f, 0.0f, 0.49803922f)}));
        graphics2D.fill(double_);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage create3LightsYellowImage(int n, int n2, boolean bl) {
        Ellipse2D.Double double_;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (!bl) {
            double_ = new Ellipse2D.Double(0.1875 * (double)n3, 0.38 * (double)n4, 0.625 * (double)n3, 0.25 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.585 * (double)n4), 0.59375f * (float)n3, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.3254902f, 0.33333334f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f)}));
            graphics2D.fill(double_);
            Ellipse2D.Double double_2 = new Ellipse2D.Double(0.2625 * (double)n3, 0.385 * (double)n4, 0.4625 * (double)n3, 0.1 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.405 * (double)n4), 0.2125f * (float)n3, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.22352941f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f)}));
            graphics2D.fill(double_2);
        } else {
            double_ = new Ellipse2D.Double(0.0 * (double)n3, 0.3 * (double)n4, 1.0 * (double)n3, 0.4 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.5 * (double)n4), 0.5f * (float)n3, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 0.0f, 1.0f), new Color(1.0f, 1.0f, 0.0f, 0.0f), new Color(1.0f, 1.0f, 0.0f, 0.0f), new Color(1.0f, 1.0f, 0.0f, 0.0f)}));
            graphics2D.fill(double_);
            Ellipse2D.Double double_3 = new Ellipse2D.Double(0.1875 * (double)n3, 0.38 * (double)n4, 0.625 * (double)n3, 0.25 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.585 * (double)n4), 0.59375f * (float)n3, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 0.0f, 1.0f), new Color(0.33333334f, 0.34117648f, 0.0f, 1.0f), new Color(0.3254902f, 0.33333334f, 0.0f, 1.0f), new Color(0.3254902f, 0.33333334f, 0.0f, 1.0f)}));
            graphics2D.fill(double_3);
            Ellipse2D.Double double_4 = new Ellipse2D.Double(0.2625 * (double)n3, 0.385 * (double)n4, 0.4625 * (double)n3, 0.1 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.405 * (double)n4), 0.2125f * (float)n3, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.6745098f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f)}));
            graphics2D.fill(double_4);
        }
        double_ = new Ellipse2D.Double(0.1875 * (double)n3, 0.38 * (double)n4, 0.625 * (double)n3, 0.25 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.505 * (double)n4), 0.3125f * (float)n3, new float[]{0.0f, 0.55f, 0.5501f, 0.78f, 0.79f, 1.0f}, new Color[]{new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.12156863f), new Color(0.0f, 0.0f, 0.0f, 0.12941177f), new Color(0.0f, 0.0f, 0.0f, 0.49803922f)}));
        graphics2D.fill(double_);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage create3LightsRedImage(int n, int n2, boolean bl) {
        Ellipse2D.Double double_;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (!bl) {
            double_ = new Ellipse2D.Double(0.1875 * (double)n3, 0.08 * (double)n4, 0.625 * (double)n3, 0.25 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.285 * (double)n4), 0.59375f * (float)n3, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.3019608f, 0.0f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f)}));
            graphics2D.fill(double_);
            Ellipse2D.Double double_2 = new Ellipse2D.Double(0.2625 * (double)n3, 0.085 * (double)n4, 0.4625 * (double)n3, 0.1 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.105 * (double)n4), 0.2125f * (float)n3, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.22352941f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f)}));
            graphics2D.fill(double_2);
        } else {
            double_ = new Ellipse2D.Double(0.0 * (double)n3, 0.0 * (double)n4, 1.0 * (double)n3, 0.4 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.2 * (double)n4), 0.5f * (float)n3, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(1.0f, 0.0f, 0.0f, 0.0f), new Color(1.0f, 0.0f, 0.0f, 0.0f), new Color(1.0f, 0.0f, 0.0f, 0.0f)}));
            graphics2D.fill(double_);
            Ellipse2D.Double double_3 = new Ellipse2D.Double(0.1875 * (double)n3, 0.08 * (double)n4, 0.625 * (double)n3, 0.25 * (double)n4);
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.285 * (double)n4), 0.59375f * (float)n3, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(0.25490198f, 0.0f, 0.0f, 1.0f), new Color(0.24705882f, 0.0f, 0.0f, 1.0f), new Color(0.24705882f, 0.0f, 0.0f, 1.0f)}));
            graphics2D.fill(double_3);
            GeneralPath generalPath = new GeneralPath();
            generalPath.setWindingRule(0);
            generalPath.moveTo(0.2625 * (double)n3, 0.13 * (double)n4);
            generalPath.curveTo(0.2625 * (double)n3, 0.12 * (double)n4, 0.375 * (double)n3, 0.085 * (double)n4, 0.5 * (double)n3, 0.085 * (double)n4);
            generalPath.curveTo(0.625 * (double)n3, 0.085 * (double)n4, 0.725 * (double)n3, 0.115 * (double)n4, 0.725 * (double)n3, 0.13 * (double)n4);
            generalPath.curveTo(0.725 * (double)n3, 0.16 * (double)n4, 0.625 * (double)n3, 0.185 * (double)n4, 0.5 * (double)n3, 0.185 * (double)n4);
            generalPath.curveTo(0.375 * (double)n3, 0.185 * (double)n4, 0.2625 * (double)n3, 0.165 * (double)n4, 0.2625 * (double)n3, 0.13 * (double)n4);
            generalPath.closePath();
            graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.105 * (double)n4), 0.2125f * (float)n3, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.6745098f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f)}));
            graphics2D.fill(generalPath);
        }
        double_ = new Ellipse2D.Double(0.1875 * (double)n3, 0.08 * (double)n4, 0.625 * (double)n3, 0.25 * (double)n4);
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.205 * (double)n4), 0.3125f * (float)n3, new float[]{0.0f, 0.55f, 0.5501f, 0.78f, 0.79f, 1.0f}, new Color[]{new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.12156863f), new Color(0.0f, 0.0f, 0.0f, 0.12941177f), new Color(0.0f, 0.0f, 0.0f, 0.49803922f)}));
        graphics2D.fill(double_);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.blink ^= true;
        this.redOn = this.redBlinkEnabled ? this.blink : this.redOn;
        this.yellowOn = this.yellowBlinkEnabled ? this.blink : this.yellowOn;
        this.greenOn = this.greenBlinkEnabled ? this.blink : this.greenOn;
        this.repaint(this.INNER_BOUNDS);
    }

    @Override
    public String toString() {
        return "Trafficlight2";
    }
}

