/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.maintenance.ExecHelper;
import com.rusefi.maintenance.StLinkFlasher;
import com.rusefi.maintenance.StatusAnimation;
import com.rusefi.ui.StatusWindow;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;

public class EraseChip {
    private static final String FLASH_SIZE = "0x0100000";
    private static final String ERASE_COMMAND_SUFFIX = " -c init -c targets -c \"halt\" -c \"flash erase_address 0x08000000 0x0100000\" -c shutdown";
    private final JButton button = new JButton("ST-LINK Erase Chip", AutoupdateUtil.loadIcon("erase.png"));
    private final StatusWindow wnd = new StatusWindow();

    public EraseChip() {
        this.button.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int dialogResult = JOptionPane.showConfirmDialog(EraseChip.this.button, "Do you really want to reset stm32 chip and all settings? Please disconnect battery before erasing.", "Please disconnect from vehicle", 0);
                if (dialogResult != 0) {
                    return;
                }
                EraseChip.this.wnd.showFrame("rusEFI ST-LINK Firmware Flasher");
                StatusAnimation sa = new StatusAnimation(EraseChip.this.wnd);
                ExecHelper.submitAction(() -> {
                    try {
                        StLinkFlasher.executeOpenOCDCommand(EraseChip.this.getEraseCommand(), EraseChip.this.wnd);
                    }
                    catch (FileNotFoundException ex) {
                        EraseChip.this.wnd.append(ex.toString());
                        EraseChip.this.wnd.error();
                    }
                    sa.stop();
                    EraseChip.this.wnd.setStatus("DONE!");
                }, EraseChip.this.getClass() + " extProcessThread");
            }
        });
    }

    @NotNull
    private String getEraseCommand() {
        return StLinkFlasher.getOpenocdCommand() + ERASE_COMMAND_SUFFIX;
    }

    public JButton getButton() {
        return this.button;
    }
}

