/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.livedocs;

import com.rusefi.config.Field;
import com.rusefi.core.SensorCentral;
import com.rusefi.enums.live_data_e;
import com.rusefi.io.commands.ByteRange;
import com.rusefi.ldmp.StateDictionary;
import com.rusefi.ui.livedocs.LiveDocHolder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public enum LiveDocsRegistry {
    INSTANCE;

    private final List<LiveDocHolder> liveDocs = new ArrayList<LiveDocHolder>();

    public void register(LiveDocHolder holder) {
        this.liveDocs.add(holder);
    }

    public void refresh(LiveDataProvider liveDataProvider) {
        for (LiveDocHolder holder : this.liveDocs) {
            boolean visible = holder.isVisible();
            if (!visible) continue;
            live_data_e context = holder.getId();
            this.refresh(holder, context, liveDataProvider);
        }
    }

    private void refresh(LiveDocHolder holder, live_data_e context, LiveDataProvider liveDataProvider) {
        byte[] response = liveDataProvider.provide(context);
        if (response == null) {
            return;
        }
        holder.update(response);
    }

    @NotNull
    public static LiveDataProvider getLiveDataProvider() {
        return context -> {
            Field[] values = StateDictionary.INSTANCE.getFields(context);
            int size = Field.getStructureSize(values);
            byte[] packet = new byte[4];
            int offset = context.ordinal();
            ByteRange.packOffsetAndSize(offset, size, packet);
            int structOffset = StateDictionary.INSTANCE.getOffset(context);
            byte[] overallOutputs = SensorCentral.getInstance().getResponse();
            byte[] response = new byte[size];
            System.arraycopy(overallOutputs, structOffset, overallOutputs, 0, size);
            return response;
        };
    }

    public static interface LiveDataProvider {
        public byte[] provide(live_data_e var1);
    }
}

