/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.GradientWrapper;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;

public class EllipticGradientPaint
implements Paint {
    private final Point2D CENTER;
    private final Point2D RADIUS_X_Y;
    private final float[] FRACTIONS;
    private final Color[] COLORS;
    private final GradientWrapper COLOR_LOOKUP;

    public EllipticGradientPaint(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray) {
        if (point2D2.distance(0.0, 0.0) <= 0.0) {
            throw new IllegalArgumentException("Radius must be greater than 0.");
        }
        if (fArray.length != colorArray.length) {
            throw new IllegalArgumentException("Fractions and colors must be equal in size");
        }
        this.CENTER = point2D;
        this.RADIUS_X_Y = point2D2;
        this.FRACTIONS = (float[])fArray.clone();
        this.COLORS = (Color[])colorArray.clone();
        this.COLOR_LOOKUP = new GradientWrapper(new Point2D.Double(0.0, 0.0), new Point2D.Double(100.0, 0.0), this.FRACTIONS, this.COLORS);
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        Point2D point2D = affineTransform.transform(this.CENTER, null);
        Point2D point2D2 = affineTransform.deltaTransform(this.RADIUS_X_Y, null);
        return new OvalGradientContext(point2D, point2D2, this.FRACTIONS, this.COLORS);
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    private final class OvalGradientContext
    implements PaintContext {
        private final Point2D CENTER;
        private final Ellipse2D.Double ELLIPSE;
        private final Line2D.Double LINE;
        private Map<Double, Double> lookup;
        private double R;

        public OvalGradientContext(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray) {
            this.CENTER = point2D;
            double d = point2D.getX() - point2D2.getX();
            double d2 = point2D.getY() - point2D2.getY();
            double d3 = 2.0 * point2D2.getX();
            double d4 = 2.0 * point2D2.getY();
            this.ELLIPSE = new Ellipse2D.Double(d, d2, d3, d4);
            this.LINE = new Line2D.Double();
            this.R = Point2D.distance(0.0, 0.0, point2D2.getX(), point2D2.getY());
            this.initLookup();
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        @Override
        public Raster getRaster(int n, int n2, int n3, int n4) {
            WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
            int[] nArray = new int[n3 * n4 * 4];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    double d6 = this.CENTER.distance(n + j, n2 + i);
                    float f = (float)(d6 / (d5 = this.lookup.get(d4 = (double)Math.round(Math.toDegrees(d3 = Math.atan2(d2 = (double)(n2 + i) - this.CENTER.getY(), d = (double)(n + j) - this.CENTER.getX())))).doubleValue()));
                    if (Float.compare(f, 1.0f) > 0) {
                        f = 1.0f;
                    }
                    int n5 = (i * n3 + j) * 4;
                    nArray[n5 + 0] = EllipticGradientPaint.this.COLOR_LOOKUP.getColorAt(f).getRed();
                    nArray[n5 + 1] = EllipticGradientPaint.this.COLOR_LOOKUP.getColorAt(f).getGreen();
                    nArray[n5 + 2] = EllipticGradientPaint.this.COLOR_LOOKUP.getColorAt(f).getBlue();
                    nArray[n5 + 3] = EllipticGradientPaint.this.COLOR_LOOKUP.getColorAt(f).getAlpha();
                }
            }
            writableRaster.setPixels(0, 0, n3, n4, nArray);
            return writableRaster;
        }

        private void initLookup() {
            this.lookup = new HashMap<Double, Double>(360);
            for (int i = -180; i <= 180; ++i) {
                Double d = i;
                double d2 = Math.toRadians(i);
                double d3 = this.CENTER.getX() + this.R * Math.cos(d2);
                double d4 = this.CENTER.getY() + this.R * Math.sin(d2);
                this.LINE.setLine(this.CENTER.getX(), this.CENTER.getY(), d3, d4);
                Double d5 = this.getRadius();
                this.lookup.put(d, d5);
            }
            this.lookup.put(0.0, this.getRadius());
        }

        private double getRadius() {
            double[] dArray = new double[6];
            Point2D.Double double_ = new Point2D.Double();
            double d = Double.MAX_VALUE;
            PathIterator pathIterator = this.ELLIPSE.getPathIterator(null, 0.005);
            while (!pathIterator.isDone()) {
                int n = pathIterator.currentSegment(dArray);
                switch (n) {
                    case 0: 
                    case 1: 
                    case 4: {
                        break;
                    }
                }
                double d2 = this.LINE.ptSegDist(dArray[0], dArray[1]);
                if (d2 < d) {
                    d = d2;
                    double_.x = dArray[0];
                    double_.y = dArray[1];
                }
                pathIterator.next();
            }
            return this.CENTER.distance(double_);
        }
    }
}

