/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.wizard;

import com.devexperts.logging.Logging;
import com.efiAnalytics.plugin.ecu.ControllerAccess;
import com.efiAnalytics.plugin.ecu.ControllerException;
import com.efiAnalytics.plugin.ecu.ControllerParameter;
import com.efiAnalytics.plugin.ecu.MathException;
import com.efiAnalytics.plugin.ecu.OutputChannelClient;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.wizard.TsReflectionHelper;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class BackgroundWizard {
    private static final String ECU_VIN_EMPTY = "vinIsEmpty";
    private static final Logging log = Logging.getLogging(BackgroundWizard.class);
    private static final int CURRENT_STATE_UNKNOWN = -1;
    private static final int CURRENT_STATE_OFFLINE = 0;
    private static final int CURRENT_STATE_ONLINE = 1;
    private static final String BASE_ENGINE_SETTINGS_TITLE = "Base Engine Settings";
    private static final String BASE_ENGINE_BUTTON_TITLE = "Base engine";
    static OutputChannelClient onlineListener = new EcuOnlineListener();
    private static Supplier<ControllerAccess> controllerAccessSupplier;
    private static int currentState;
    private static int lastState;
    private static boolean pluginEnabled;
    private static boolean WizardVinToggle;

    public static void start(Supplier<ControllerAccess> controllerAccessSupplier) {
        BackgroundWizard.controllerAccessSupplier = controllerAccessSupplier;
        try {
            BackgroundWizard.controllerAccessSupplier.get().getOutputChannelServer().subscribe("AppEvent", "controllerOnline", onlineListener);
        }
        catch (Exception e) {
            log.error("error on onlineListener " + e, e);
        }
        Thread thread = new Thread(() -> {
            while (true) {
                try {
                    BackgroundWizard.periodicWizardLogic();
                }
                catch (Throwable e) {
                    log.error("error " + e, e);
                }
                BinaryProtocol.sleep(300L);
            }
        });
        thread.setName("wizard-thread");
        thread.setDaemon(true);
        thread.start();
    }

    private static void periodicWizardLogic() throws ControllerException, MathException {
        if (currentState != lastState) {
            if (currentState == -1) {
                log.info("ECU is not connected / no updates from TS");
            } else if (currentState == 0) {
                log.info("ECU is offline");
            } else if (currentState == 1) {
                log.info("ECU is online");
                WizardVinToggle = true;
            }
            lastState = currentState;
        }
        if (currentState == 1 && pluginEnabled && WizardVinToggle) {
            log.info("ECU is online and we can run the wizard");
            String mainConfigName = controllerAccessSupplier.get().getEcuConfigurationNames()[0];
            ControllerParameter currentVin = controllerAccessSupplier.get().getControllerParameterServer().getControllerParameter(mainConfigName, ECU_VIN_EMPTY);
            String ecuVinEmpty = currentVin.getStringValue();
            if (ecuVinEmpty.contains("true") || ecuVinEmpty.contains("yes")) {
                BackgroundWizard.launchVinUI();
            }
            WizardVinToggle = false;
        }
    }

    private static void launchVinUI() {
        log.info("Launching VIN UI");
        try {
            Frame mainFrame = TsReflectionHelper.findTsMainFrame(10L, TimeUnit.SECONDS);
            if (mainFrame == null) {
                throw new IllegalStateException("Could not find TunerStudio frame to launch wizard");
            }
            List<AbstractButton> topButtons = TsReflectionHelper.findTopLevelButtons(mainFrame);
            if (topButtons.isEmpty()) {
                throw new IllegalStateException("no TS top-level buttons");
            }
            ArrayList<AbstractButton> buttonsToTry = new ArrayList<AbstractButton>(topButtons);
            int attempts = Math.max(1, buttonsToTry.size() + 1);
            for (int i = 0; i < attempts; ++i) {
                JMenuItem engineMetaItem;
                AbstractButton topButton;
                AbstractButton abstractButton = topButton = i < buttonsToTry.size() ? (AbstractButton)buttonsToTry.get(i) : null;
                if (topButton != null) {
                    try {
                        SwingUtilities.invokeAndWait(topButton::doClick);
                        BinaryProtocol.sleep(200L);
                    }
                    catch (Exception e) {
                        log.info("Unable to click top-level menu: " + e);
                    }
                }
                if ((engineMetaItem = TsReflectionHelper.findMenuItem(mainFrame, BASE_ENGINE_BUTTON_TITLE)) == null) continue;
                try {
                    SwingUtilities.invokeAndWait(engineMetaItem::doClick);
                    BinaryProtocol.sleep(200L);
                    JDialog dialog = TsReflectionHelper.waitForDialogWithTitle(BASE_ENGINE_SETTINGS_TITLE, 3L, TimeUnit.SECONDS);
                    if (dialog == null) continue;
                    TsReflectionHelper.bringToFront(dialog);
                    log.info("Base Engine Settings dialog opened");
                    return;
                }
                catch (Exception e) {
                    log.info("Failed to invokeBase Engine Settings" + e);
                }
            }
        }
        catch (Throwable t) {
            log.error("Error launching VIN UI: " + t, t);
        }
    }

    public static boolean displayPlugin(String serialSignature) {
        boolean signatureValid;
        boolean bl = signatureValid = serialSignature != null && !serialSignature.isEmpty();
        if (signatureValid) {
            pluginEnabled = serialSignature.contains("hd81");
        } else {
            log.info("ECU signature invalid for this plugin: " + serialSignature);
        }
        return pluginEnabled;
    }

    static {
        currentState = -1;
        lastState = -1;
        pluginEnabled = false;
        WizardVinToggle = true;
    }

    static class EcuOnlineListener
    implements OutputChannelClient {
        EcuOnlineListener() {
        }

        @Override
        public void setCurrentOutputChannelValue(String string, double d) {
            int newState = (int)d;
            if (currentState == 0 ^ newState == 0) {
                currentState = newState;
            }
        }
    }
}

