/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.devexperts.logging.Logging;
import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.EnumIniField;
import com.opensr5.ini.field.IniField;
import com.opensr5.ini.field.ScalarIniField;
import com.opensr5.ini.field.StringIniField;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.migration.IniFieldMigrationUtils;
import com.rusefi.maintenance.migration.migrators.DefaultEnumIniFieldMigrator;
import java.util.Objects;
import java.util.Optional;

enum DefaultIniFieldMigrationStrategy {
    INSTANCE;

    private static final Logging log;

    Optional<String> tryMigrateValue(IniField prevField, IniField newField, String prevValue, UpdateOperationCallbacks callbacks) {
        Optional<String> result = Optional.empty();
        String prevFieldName = prevField.getName();
        if (prevField instanceof ScalarIniField) {
            if (newField instanceof ScalarIniField) {
                if (DefaultIniFieldMigrationStrategy.canScalarValueBeMigrated((ScalarIniField)prevField, (ScalarIniField)newField, callbacks)) {
                    result = Optional.of(prevValue);
                }
            } else {
                callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because it is no is no longer scalar in new .ini file", prevFieldName));
            }
        } else if (prevField instanceof StringIniField) {
            if (newField instanceof StringIniField) {
                result = Optional.of(prevValue);
            } else {
                callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because it is no longer string in new .ini file", prevFieldName));
            }
        } else if (prevField instanceof EnumIniField) {
            if (newField instanceof EnumIniField) {
                result = DefaultEnumIniFieldMigrator.INSTANCE.tryMigrateValue((EnumIniField)prevField, (EnumIniField)newField, prevValue, callbacks);
            } else {
                callbacks.logLine(String.format("WARNING! `%s` cannot be migrated because it is no longer enum in new .ini file", prevFieldName));
            }
        } else if (prevField instanceof ArrayIniField) {
            if (newField instanceof ArrayIniField) {
                if (DefaultIniFieldMigrationStrategy.canArrayValueBeMigrated((ArrayIniField)prevField, (ArrayIniField)newField, callbacks)) {
                    result = Optional.of(prevValue);
                }
            } else {
                callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because it is no longer array in new .ini file", prevFieldName));
            }
        } else {
            log.error(String.format("Unexpected field type: %s", prevField.getClass()));
        }
        return result;
    }

    private static boolean canScalarValueBeMigrated(ScalarIniField prevField, ScalarIniField newField, UpdateOperationCallbacks callbacks) {
        boolean result = false;
        if (!IniFieldMigrationUtils.checkIfUnitsCanBeMigrated(prevField.getUnits(), newField.getUnits())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because units are updated: `%s` -> `%s`", prevField.getName(), prevField, newField));
        } else if (!IniFieldMigrationUtils.checkIfTypeCanBeMigrated(prevField.getType(), newField.getType())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because type is updated: `%s` -> `%s`", prevField.getName(), prevField, newField));
        } else {
            result = true;
        }
        return result;
    }

    private static boolean canArrayValueBeMigrated(ArrayIniField prevField, ArrayIniField newField, UpdateOperationCallbacks callbacks) {
        boolean result = false;
        if (!IniFieldMigrationUtils.checkIfTypeCanBeMigrated(prevField.getType(), newField.getType())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because type is updated: `%s` -> `%s`", new Object[]{prevField.getName(), prevField.getType(), newField.getType()}));
        } else if (!Objects.equals(prevField.getCols(), newField.getCols())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because column count is updated: `%s` -> `%s`", prevField.getName(), prevField.getCols(), newField.getCols()));
        } else if (!Objects.equals(prevField.getRows(), newField.getRows())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because row count is updated: `%s` -> `%s`", prevField.getName(), prevField.getRows(), newField.getRows()));
        } else {
            result = true;
        }
        return result;
    }

    static {
        log = Logging.getLogging(DefaultIniFieldMigrationStrategy.class);
    }
}

