/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.pinout;

import com.devexperts.logging.Logging;
import com.rusefi.pinout.BoardInputs;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class FileSystemBoardInputsReaderImpl
implements BoardInputs {
    private static final Logging log = Logging.getLogging(FileSystemBoardInputsReaderImpl.class);
    protected final String boardName;
    private final List<File> boardYamlFiles;
    public static String PREFIX = "";

    public FileSystemBoardInputsReaderImpl(String boardName) {
        this.boardName = boardName;
        String dirPath = boardName + "/connectors";
        File dirName = new File(dirPath);
        FilenameFilter filter = (f, name) -> name.endsWith(".yaml");
        Object[] boardYamlFilesArray = dirName.listFiles(filter);
        if (boardYamlFilesArray == null) {
            log.info("No yaml files in " + dirPath);
            this.boardYamlFiles = Collections.emptyList();
            return;
        }
        Arrays.sort(boardYamlFilesArray);
        log.info(boardName + ": " + Arrays.toString(boardYamlFilesArray));
        this.boardYamlFiles = Arrays.asList(boardYamlFilesArray);
    }

    @Override
    public List<? extends File> getBoardYamlKeys() {
        return this.boardYamlFiles;
    }

    @Override
    public Reader getReader(File yamlKey) throws FileNotFoundException {
        return new FileReader(yamlKey);
    }

    @Override
    public String getName() {
        return this.boardName;
    }

    @Override
    public List<String> getInputFiles() {
        ArrayList<String> result = new ArrayList<String>();
        for (File yamlFile : this.boardYamlFiles) {
            result.add(this.boardName + "/connectors" + File.separator + yamlFile.getName());
        }
        return result;
    }

    @Override
    public List<String> getBoardMeta(String boardMetaFileName) {
        try {
            String fileName = PREFIX + boardMetaFileName;
            System.out.printf("Reading from " + new File(fileName).getAbsolutePath(), new Object[0]);
            return Files.readAllLines(Paths.get(fileName, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

