/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public class GradientWrapper
implements Paint {
    private final LinearGradientPaint GRADIENT;
    private float[] fractions;
    private Color[] colors;

    public GradientWrapper(float f, float f2, float f3, float f4, float[] fArray, Color[] colorArray) {
        this.GRADIENT = new LinearGradientPaint(new Point2D.Float(f, f2), new Point2D.Float(f3, f4), fArray, colorArray, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        this.copyArrays(fArray, colorArray);
    }

    public GradientWrapper(float f, float f2, float f3, float f4, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethod cycleMethod) {
        this.GRADIENT = new LinearGradientPaint(new Point2D.Float(f, f2), new Point2D.Float(f3, f4), fArray, colorArray, cycleMethod);
        this.copyArrays(fArray, colorArray);
    }

    public GradientWrapper(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray) {
        this.GRADIENT = new LinearGradientPaint(point2D, point2D2, fArray, colorArray, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        this.copyArrays(fArray, colorArray);
    }

    public GradientWrapper(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethod cycleMethod) {
        this.GRADIENT = new LinearGradientPaint(point2D, point2D2, fArray, colorArray, cycleMethod, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform());
        this.copyArrays(fArray, colorArray);
    }

    public GradientWrapper(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethod cycleMethod, MultipleGradientPaint.ColorSpaceType colorSpaceType, AffineTransform affineTransform) {
        this.GRADIENT = new LinearGradientPaint(point2D, point2D2, fArray, colorArray, cycleMethod, colorSpaceType, affineTransform);
        this.copyArrays(fArray, colorArray);
    }

    public Point2D getStartPoint() {
        return this.GRADIENT.getStartPoint();
    }

    public Point2D getEndPoint() {
        return this.GRADIENT.getEndPoint();
    }

    public Color getColorAt(float f) {
        float f2 = f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
        float f3 = 0.0f;
        int n = 0;
        float f4 = 1.0f;
        int n2 = 1;
        int n3 = 0;
        for (float f5 : this.fractions) {
            if (Float.compare(f5, f2) < 0) {
                f3 = f5;
                n = n3;
            }
            if (Float.compare(f5, f2) == 0) {
                return this.colors[n3];
            }
            if (Float.compare(f5, f2) > 0) {
                f4 = f5;
                n2 = n3;
                break;
            }
            ++n3;
        }
        float f6 = (f2 - f3) / (f4 - f3);
        return this.interpolateColor(this.colors[n], this.colors[n2], f6);
    }

    public LinearGradientPaint getGradient() {
        return this.GRADIENT;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        return this.GRADIENT.createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
    }

    @Override
    public int getTransparency() {
        return this.GRADIENT.getTransparency();
    }

    private void copyArrays(float[] fArray, Color[] colorArray) {
        this.fractions = new float[fArray.length];
        System.arraycopy(fArray, 0, this.fractions, 0, fArray.length);
        this.colors = (Color[])colorArray.clone();
    }

    private Color interpolateColor(Color color, Color color2, float f) {
        assert (Float.compare(f, 0.0f) >= 0 && Float.compare(f, 1.0f) <= 0);
        float f2 = (float)color.getRed() * 0.003921569f;
        float f3 = (float)color.getGreen() * 0.003921569f;
        float f4 = (float)color.getBlue() * 0.003921569f;
        float f5 = (float)color.getAlpha() * 0.003921569f;
        float f6 = (float)color2.getRed() * 0.003921569f;
        float f7 = (float)color2.getGreen() * 0.003921569f;
        float f8 = (float)color2.getBlue() * 0.003921569f;
        float f9 = (float)color2.getAlpha() * 0.003921569f;
        float f10 = f6 - f2;
        float f11 = f7 - f3;
        float f12 = f8 - f4;
        float f13 = f9 - f5;
        float f14 = f2 + f10 * f;
        float f15 = f3 + f11 * f;
        float f16 = f4 + f12 * f;
        float f17 = f5 + f13 * f;
        float f18 = f14 < 0.0f ? 0.0f : (f14 = f14 > 1.0f ? 1.0f : f14);
        float f19 = f15 < 0.0f ? 0.0f : (f15 = f15 > 1.0f ? 1.0f : f15);
        float f20 = f16 < 0.0f ? 0.0f : (f16 = f16 > 1.0f ? 1.0f : f16);
        f17 = f17 < 0.0f ? 0.0f : (f17 > 1.0f ? 1.0f : f17);
        return new Color(f14, f15, f16, f17);
    }
}

