/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.Util;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public enum Shadow {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;

    public BufferedImage createImageFromShape(Shape SHAPE, Paint PAINT, Color COLOR, boolean FILLED, Stroke STROKE, Color STROKE_COLOR) {
        BufferedImage IMAGE = this.UTIL.createImage(SHAPE.getBounds().width, SHAPE.getBounds().height, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.translate(-SHAPE.getBounds2D().getX(), -SHAPE.getBounds2D().getY());
        if (PAINT != null) {
            G2.setPaint(PAINT);
            if (FILLED) {
                G2.fill(SHAPE);
            } else {
                G2.draw(SHAPE);
            }
        }
        if (COLOR != null) {
            G2.setColor(COLOR);
            if (FILLED) {
                G2.fill(SHAPE);
            } else {
                G2.draw(SHAPE);
            }
        }
        if (STROKE != null) {
            if (STROKE_COLOR != null) {
                G2.setColor(STROKE_COLOR);
            }
            G2.setStroke(STROKE);
            if (!FILLED) {
                G2.draw(SHAPE);
            }
        }
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createDropShadow(BufferedImage SRC_IMAGE, int DISTANCE, float ALPHA, int SOFTNESS, int ANGLE, Color SHADOW_COLOR) {
        float TRANSLATE_X = (float)((double)DISTANCE * Math.cos(Math.toRadians(360 - ANGLE)));
        float TRANSLATE_Y = (float)((double)DISTANCE * Math.sin(Math.toRadians(360 - ANGLE)));
        BufferedImage SHADOW_IMAGE = this.renderDropShadow(SRC_IMAGE, SOFTNESS, ALPHA, SHADOW_COLOR);
        BufferedImage RESULT = new BufferedImage(SHADOW_IMAGE.getWidth(), SHADOW_IMAGE.getHeight(), 2);
        Graphics2D G2 = RESULT.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.translate(TRANSLATE_X, TRANSLATE_Y);
        G2.drawImage((Image)SHADOW_IMAGE, 0, 0, null);
        G2.translate(-TRANSLATE_X, -TRANSLATE_Y);
        G2.translate(SOFTNESS, SOFTNESS);
        G2.drawImage((Image)SRC_IMAGE, 0, 0, null);
        G2.dispose();
        return RESULT;
    }

    public BufferedImage createDropShadow(Shape SHAPE, Paint PAINT, Color COLOR, boolean FILLED, Stroke STROKE, Color STROKE_COLOR, int DISTANCE, float ALPHA, int SOFTNESS, int ANGLE, Color SHADOW_COLOR) {
        float TRANSLATE_X = (float)((double)DISTANCE * Math.cos(Math.toRadians(360 - ANGLE)));
        float TRANSLATE_Y = (float)((double)DISTANCE * Math.sin(Math.toRadians(360 - ANGLE)));
        BufferedImage SHAPE_IMAGE = this.createImageFromShape(SHAPE, PAINT, COLOR, FILLED, STROKE, STROKE_COLOR);
        BufferedImage SHADOW_IMAGE = this.renderDropShadow(SHAPE_IMAGE, SOFTNESS, ALPHA, SHADOW_COLOR);
        BufferedImage RESULT = new BufferedImage(SHADOW_IMAGE.getWidth(), SHADOW_IMAGE.getHeight(), 2);
        Graphics2D G2 = RESULT.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.translate(TRANSLATE_X, TRANSLATE_Y);
        G2.drawImage((Image)SHADOW_IMAGE, 0, 0, null);
        G2.translate(-TRANSLATE_X, -TRANSLATE_Y);
        G2.translate(SOFTNESS, SOFTNESS);
        G2.drawImage((Image)SHAPE_IMAGE, 0, 0, null);
        G2.dispose();
        return RESULT;
    }

    public BufferedImage createInnerShadow(BufferedImage SOFT_CLIP_IMAGE, Shape SHAPE, int DISTANCE, float ALPHA, Color SHADOW_COLOR, int SOFTNESS, int ANGLE) {
        float COLOR_CONSTANT = 0.003921569f;
        float RED = 0.003921569f * (float)SHADOW_COLOR.getRed();
        float GREEN = 0.003921569f * (float)SHADOW_COLOR.getGreen();
        float BLUE = 0.003921569f * (float)SHADOW_COLOR.getBlue();
        float MAX_STROKE_WIDTH = SOFTNESS * 2;
        float ALPHA_STEP = 1.0f / (float)(2 * SOFTNESS + 2) * ALPHA;
        float TRANSLATE_X = (float)((double)DISTANCE * Math.cos(Math.toRadians(ANGLE)));
        float TRANSLATE_Y = (float)((double)DISTANCE * Math.sin(Math.toRadians(ANGLE)));
        Graphics2D G2 = SOFT_CLIP_IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.translate(-SHAPE.getBounds2D().getX(), -SHAPE.getBounds2D().getY());
        G2.setColor(new Color(RED, GREEN, BLUE, ALPHA_STEP));
        G2.setComposite(AlphaComposite.SrcAtop);
        G2.translate(TRANSLATE_X, -TRANSLATE_Y);
        for (float strokeWidth = (float)SOFTNESS; strokeWidth >= 1.0f; strokeWidth -= 1.0f) {
            G2.setStroke(new BasicStroke((float)((double)MAX_STROKE_WIDTH * Math.pow(0.85, strokeWidth))));
            G2.draw(SHAPE);
        }
        G2.dispose();
        return SOFT_CLIP_IMAGE;
    }

    public BufferedImage createInnerShadow(Shape SHAPE, Paint SHAPE_PAINT, int DISTANCE, float ALPHA, Color SHADOW_COLOR, int SOFTNESS, int ANGLE) {
        float COLOR_CONSTANT = 0.003921569f;
        float RED = 0.003921569f * (float)SHADOW_COLOR.getRed();
        float GREEN = 0.003921569f * (float)SHADOW_COLOR.getGreen();
        float BLUE = 0.003921569f * (float)SHADOW_COLOR.getBlue();
        float MAX_STROKE_WIDTH = SOFTNESS * 2;
        float ALPHA_STEP = 1.0f / (float)(2 * SOFTNESS + 2) * ALPHA;
        float TRANSLATE_X = (float)((double)DISTANCE * Math.cos(Math.toRadians(ANGLE)));
        float TRANSLATE_Y = (float)((double)DISTANCE * Math.sin(Math.toRadians(ANGLE)));
        BufferedImage IMAGE = this.createSoftClipImage(SHAPE, SHAPE_PAINT, 0, 0, 0);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.translate(-SHAPE.getBounds2D().getX(), -SHAPE.getBounds2D().getY());
        G2.setColor(new Color(RED, GREEN, BLUE, ALPHA_STEP));
        G2.setComposite(AlphaComposite.SrcAtop);
        G2.translate(TRANSLATE_X, -TRANSLATE_Y);
        for (float strokeWidth = (float)SOFTNESS; strokeWidth >= 1.0f; strokeWidth -= 1.0f) {
            G2.setStroke(new BasicStroke((float)((double)MAX_STROKE_WIDTH * Math.pow(0.85, strokeWidth))));
            G2.draw(SHAPE);
        }
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createSoftClipImage(Shape SHAPE, Paint SHAPE_PAINT) {
        BufferedImage IMAGE = this.UTIL.createImage(SHAPE.getBounds().width, SHAPE.getBounds().height, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setComposite(AlphaComposite.Clear);
        G2.fillRect(0, 0, IMAGE.getWidth(), IMAGE.getHeight());
        G2.setComposite(AlphaComposite.Src);
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (SHAPE_PAINT != null) {
            G2.setPaint(SHAPE_PAINT);
        }
        G2.translate(-SHAPE.getBounds2D().getX(), -SHAPE.getBounds2D().getY());
        G2.fill(SHAPE);
        return IMAGE;
    }

    public BufferedImage createSoftClipImage(Shape SHAPE, Paint SHAPE_PAINT, int SOFTNESS, int TRANSLATE_X, int TRANSLATE_Y) {
        BufferedImage IMAGE = this.UTIL.createImage(SHAPE.getBounds().width + 2 * SOFTNESS + TRANSLATE_X, SHAPE.getBounds().height + 2 * SOFTNESS + TRANSLATE_Y, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.translate((double)SOFTNESS / 2.0, (double)SOFTNESS / 2.0);
        G2.setComposite(AlphaComposite.Clear);
        G2.fillRect(0, 0, IMAGE.getWidth(), IMAGE.getHeight());
        G2.setComposite(AlphaComposite.Src);
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (SHAPE_PAINT != null) {
            G2.setPaint(SHAPE_PAINT);
        }
        G2.translate(-SHAPE.getBounds2D().getX(), -SHAPE.getBounds2D().getY());
        G2.fill(SHAPE);
        return IMAGE;
    }

    public BufferedImage renderDropShadow(BufferedImage IMAGE, int SOFTNESS, float ALPHA, Color SHADOW_COLOR) {
        int A;
        int a;
        int aSum;
        int historyIdx;
        int SHADOW_SIZE = SOFTNESS * 2;
        int SRC_WIDTH = IMAGE.getWidth();
        int SRC_HEIGHT = IMAGE.getHeight();
        int DST_WIDTH = SRC_WIDTH + SHADOW_SIZE;
        int DST_HEIGHT = SRC_HEIGHT + SHADOW_SIZE;
        int LEFT = SOFTNESS;
        int RIGHT = SHADOW_SIZE - LEFT;
        int Y_STOP = DST_HEIGHT - RIGHT;
        int SHADOW_RGB = SHADOW_COLOR.getRGB() & 0xFFFFFF;
        int[] aHistory = new int[SHADOW_SIZE];
        BufferedImage DST = new BufferedImage(DST_WIDTH, DST_HEIGHT, 2);
        int[] dstBuffer = new int[DST_WIDTH * DST_HEIGHT];
        int[] srcBuffer = new int[SRC_WIDTH * SRC_HEIGHT];
        this.getPixels(IMAGE, 0, 0, SRC_WIDTH, SRC_HEIGHT, srcBuffer);
        int LAST_PIXEL_OFFSET = RIGHT * DST_WIDTH;
        float H_SUM_DIVIDER = 1.0f / (float)SHADOW_SIZE;
        float V_SUM_DIVIDER = ALPHA / (float)SHADOW_SIZE;
        int[] hSumLookup = new int[256 * SHADOW_SIZE];
        int max = hSumLookup.length;
        for (int i = 0; i < max; ++i) {
            hSumLookup[i] = (int)((float)i * H_SUM_DIVIDER);
        }
        int[] vSumLookup = new int[256 * SHADOW_SIZE];
        max = vSumLookup.length;
        for (int i = 0; i < max; ++i) {
            vSumLookup[i] = (int)((float)i * V_SUM_DIVIDER);
        }
        int dstOffset = LEFT * DST_WIDTH;
        for (int srcY = 0; srcY < SRC_HEIGHT; ++srcY) {
            historyIdx = 0;
            while (historyIdx < SHADOW_SIZE) {
                aHistory[historyIdx++] = 0;
            }
            aSum = 0;
            historyIdx = 0;
            int srcOffset = srcY * SRC_WIDTH;
            for (int srcX = 0; srcX < SRC_WIDTH; ++srcX) {
                a = hSumLookup[aSum];
                dstBuffer[dstOffset++] = a << 24;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = srcBuffer[srcOffset + srcX] >>> 24;
                aSum += a;
                if (++historyIdx < SHADOW_SIZE) continue;
                historyIdx -= SHADOW_SIZE;
            }
            for (int i = 0; i < SHADOW_SIZE; ++i) {
                A = hSumLookup[aSum];
                dstBuffer[dstOffset++] = A << 24;
                aSum -= aHistory[historyIdx];
                if (++historyIdx < SHADOW_SIZE) continue;
                historyIdx -= SHADOW_SIZE;
            }
        }
        int x = 0;
        int bufferOffset = 0;
        while (x < DST_WIDTH) {
            aSum = 0;
            historyIdx = 0;
            while (historyIdx < LEFT) {
                aHistory[historyIdx++] = 0;
            }
            int y = 0;
            while (y < RIGHT) {
                A = dstBuffer[bufferOffset] >>> 24;
                aHistory[historyIdx++] = A;
                aSum += A;
                ++y;
                bufferOffset += DST_WIDTH;
            }
            bufferOffset = x;
            historyIdx = 0;
            y = 0;
            while (y < Y_STOP) {
                a = vSumLookup[aSum];
                dstBuffer[bufferOffset] = a << 24 | SHADOW_RGB;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dstBuffer[bufferOffset + LAST_PIXEL_OFFSET] >>> 24;
                aSum += a;
                if (++historyIdx >= SHADOW_SIZE) {
                    historyIdx -= SHADOW_SIZE;
                }
                ++y;
                bufferOffset += DST_WIDTH;
            }
            y = Y_STOP;
            while (y < DST_HEIGHT) {
                A = vSumLookup[aSum];
                dstBuffer[bufferOffset] = A << 24 | SHADOW_RGB;
                aSum -= aHistory[historyIdx];
                if (++historyIdx >= SHADOW_SIZE) {
                    historyIdx -= SHADOW_SIZE;
                }
                ++y;
                bufferOffset += DST_WIDTH;
            }
            bufferOffset = ++x;
        }
        this.setPixels(DST, 0, 0, DST_WIDTH, DST_HEIGHT, dstBuffer);
        return DST;
    }

    public int[] getPixels(BufferedImage IMAGE, int X, int Y, int W, int H, int[] pixels) {
        if (W == 0 || H == 0) {
            return new int[0];
        }
        if (pixels == null) {
            pixels = new int[W * H];
        } else if (pixels.length < W * H) {
            throw new IllegalArgumentException("pixels array must have a length  >= w*h");
        }
        int imageType = IMAGE.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = IMAGE.getRaster();
            return (int[])raster.getDataElements(X, Y, W, H, pixels);
        }
        return IMAGE.getRGB(X, Y, W, H, pixels, 0, W);
    }

    public void setPixels(BufferedImage IMAGE, int X, int Y, int W, int H, int[] pixels) {
        if (pixels == null || W == 0 || H == 0) {
            return;
        }
        if (pixels.length < W * H) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = IMAGE.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = IMAGE.getRaster();
            raster.setDataElements(X, Y, W, H, pixels);
        } else {
            IMAGE.setRGB(X, Y, W, H, pixels, 0, W);
        }
    }

    public void addInnerShadow(Graphics2D G2, Shape SHAPE, Color SHADOW_COLOR, int DISTANCE, float ALPHA, int SOFTNESS, int ANGLE) {
        float COLOR_CONSTANT = 0.003921569f;
        float RED = 0.003921569f * (float)SHADOW_COLOR.getRed();
        float GREEN = 0.003921569f * (float)SHADOW_COLOR.getGreen();
        float BLUE = 0.003921569f * (float)SHADOW_COLOR.getBlue();
        float MAX_STROKE_WIDTH = SOFTNESS * 2;
        float ALPHA_STEP = 1.0f / (float)(2 * SOFTNESS + 2) * ALPHA;
        float TRANSLATE_X = (float)((double)DISTANCE * Math.cos(Math.toRadians(ANGLE)));
        float TRANSLATE_Y = (float)((double)DISTANCE * Math.sin(Math.toRadians(ANGLE)));
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape OLD_CLIP = G2.getClip();
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        Stroke OLD_STROKE = G2.getStroke();
        Paint OLD_PAINT = G2.getPaint();
        G2.setColor(new Color(RED, GREEN, BLUE, ALPHA_STEP));
        G2.setComposite(AlphaComposite.SrcAtop);
        G2.translate(TRANSLATE_X, -TRANSLATE_Y);
        G2.setClip(SHAPE);
        for (float strokeWidth = (float)SOFTNESS; strokeWidth >= 1.0f; strokeWidth -= 1.0f) {
            G2.setStroke(new BasicStroke((float)((double)MAX_STROKE_WIDTH * Math.pow(0.85, strokeWidth))));
            G2.draw(SHAPE);
        }
        G2.setTransform(OLD_TRANSFORM);
        G2.setClip(OLD_CLIP);
        G2.setStroke(OLD_STROKE);
        G2.setPaint(OLD_PAINT);
    }

    public void addGlow(Graphics2D G2, Rectangle CANVAS, Shape SHAPE, Paint SHAPE_PAINT, Color GLOW_COLOR, float ALPHA, int SOFTNESS) {
        float COLOR_CONSTANT = 0.003921569f;
        float RED = 0.003921569f * (float)GLOW_COLOR.getRed();
        float GREEN = 0.003921569f * (float)GLOW_COLOR.getGreen();
        float BLUE = 0.003921569f * (float)GLOW_COLOR.getBlue();
        float MAX_STROKE_WIDTH = SOFTNESS * 2;
        float ALPHA_STEP = 1.0f / (float)(2 * SOFTNESS + 2) * ALPHA;
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape OLD_CLIP = G2.getClip();
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        Stroke OLD_STROKE = G2.getStroke();
        Paint OLD_PAINT = G2.getPaint();
        G2.setColor(new Color(RED, GREEN, BLUE, ALPHA_STEP));
        for (float strokeWidth = (float)SOFTNESS; strokeWidth >= 1.0f; strokeWidth -= 1.0f) {
            G2.setStroke(new BasicStroke((float)((double)MAX_STROKE_WIDTH * Math.pow(0.85, strokeWidth))));
            G2.draw(SHAPE);
        }
        G2.setTransform(OLD_TRANSFORM);
        G2.setClip(OLD_CLIP);
        G2.setStroke(OLD_STROKE);
        G2.setPaint(SHAPE_PAINT);
        G2.fill(SHAPE);
        G2.setPaint(OLD_PAINT);
    }
}

