/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import java.util.Optional;

public enum UpdateMode {
    DFU_AUTO("Auto DFU Update"),
    DFU_MANUAL("Manual DFU Update"),
    INSTALL_OPENBLT("Install OpenBLT"),
    ST_LINK("ST-LINK Update"),
    DFU_SWITCH("Switch to DFU Mode"),
    OPENBLT_SWITCH("Switch to OpenBLT Mode"),
    OPENBLT_CAN("OpenBLT via CAN"),
    OPENBLT_MANUAL("Manual OpenBLT Update"),
    OPENBLT_AUTO("Auto OpenBLT Update"),
    DFU_ERASE("Full DFU Erase");

    final String displayText;

    private UpdateMode(String displayText) {
        this.displayText = displayText;
    }

    static Optional<UpdateMode> parseDisplayText(String persistedValue) {
        for (UpdateMode value : UpdateMode.values()) {
            String valuePersistedValue = value.displayText;
            if (valuePersistedValue == null || !valuePersistedValue.equals(persistedValue)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.displayText;
    }
}

