/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.server;

import com.rusefi.tools.online.HttpUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;

public class ControllerInfo {
    public static final String VEHICLE_NAME = "vehicleName";
    public static final String ENGINE_MAKE = "engineMake";
    public static final String ENGINE_CODE = "engineCode";
    public static final String SIGNATURE = "signature";
    private final String vehicleName;
    private final String engineMake;
    private final String engineCode;
    private final String signature;

    public ControllerInfo(String vehicleName, String engineCode, String engineMake, String signature) {
        Objects.requireNonNull(vehicleName);
        Objects.requireNonNull(engineMake);
        Objects.requireNonNull(engineCode);
        this.vehicleName = vehicleName;
        this.engineCode = engineCode;
        this.engineMake = engineMake;
        this.signature = signature;
    }

    public String toString() {
        return "ControllerInfo{vehicleName='" + this.vehicleName + '\'' + ", engineMake='" + this.engineMake + '\'' + ", engineCode='" + this.engineCode + '\'' + ", signature='" + this.signature + '\'' + '}';
    }

    public String getVehicleName() {
        return this.vehicleName;
    }

    public String getEngineMake() {
        return this.engineMake;
    }

    public String getEngineCode() {
        return this.engineCode;
    }

    public String getSignature() {
        return this.signature;
    }

    @NotNull
    public static ControllerInfo valueOf(String jsonString) {
        JSONObject jsonObject = HttpUtil.parse(jsonString);
        return ControllerInfo.valueOf(jsonObject);
    }

    @NotNull
    public static ControllerInfo valueOf(JSONObject jsonObject) {
        String vehicleName = (String)jsonObject.get(VEHICLE_NAME);
        String engineMake = (String)jsonObject.get(ENGINE_MAKE);
        String engineCode = (String)jsonObject.get(ENGINE_CODE);
        String signature = (String)jsonObject.get(SIGNATURE);
        return new ControllerInfo(vehicleName, engineCode, engineMake, signature);
    }

    public String toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(ENGINE_MAKE, this.engineMake);
        jsonObject.put(ENGINE_CODE, this.engineCode);
        jsonObject.put(VEHICLE_NAME, this.vehicleName);
        jsonObject.put(SIGNATURE, this.signature);
        return jsonObject.toJSONString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ControllerInfo that = (ControllerInfo)o;
        return this.vehicleName.equals(that.vehicleName) && this.engineMake.equals(that.engineMake) && this.engineCode.equals(that.engineCode) && this.signature.equals(that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.vehicleName, this.engineMake, this.engineCode, this.signature);
    }
}

