/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.ForegroundType;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public enum ForegroundImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private int radWidth = 0;
    private boolean radWithCenterKnob = true;
    private ForegroundType radType = ForegroundType.FG_TYPE1;
    private BufferedImage radForegroundImage = this.UTIL.createImage(1, 1, 3);
    private int linWidth = 0;
    private int linHeight = 0;
    private boolean linWithCenterKnob = false;
    private BufferedImage linForegroundImage = this.UTIL.createImage(1, 1, 3);

    public BufferedImage createRadialForeground(int WIDTH) {
        return this.createRadialForeground(WIDTH, true, ForegroundType.FG_TYPE1);
    }

    public BufferedImage createRadialForeground(int WIDTH, boolean WITH_CENTER_KNOB) {
        return this.createRadialForeground(WIDTH, WITH_CENTER_KNOB, ForegroundType.FG_TYPE1);
    }

    public BufferedImage createRadialForeground(int WIDTH, boolean WITH_CENTER_KNOB, ForegroundType TYPE) {
        return this.createRadialForeground(WIDTH, WITH_CENTER_KNOB, TYPE, null);
    }

    public BufferedImage createRadialForeground(int WIDTH, boolean WITH_CENTER_KNOB, ForegroundType TYPE, BufferedImage FOREGROUND_IMAGE) {
        if (WIDTH <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.radWidth == WIDTH && this.radWithCenterKnob == WITH_CENTER_KNOB && this.radType == TYPE) {
            if (FOREGROUND_IMAGE != null) {
                Graphics2D G2 = FOREGROUND_IMAGE.createGraphics();
                G2.drawImage((Image)this.radForegroundImage, 0, 0, null);
                G2.dispose();
            }
            return this.radForegroundImage;
        }
        this.radForegroundImage.flush();
        this.radForegroundImage = this.UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = this.radForegroundImage.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = WIDTH;
        int IMAGE_HEIGHT = WIDTH;
        if (WITH_CENTER_KNOB) {
            Ellipse2D.Double E_CENTER_KNOB_FRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4579439163208008, (double)IMAGE_HEIGHT * 0.4579439163208008, (double)IMAGE_WIDTH * 0.08411216735839844, (double)IMAGE_HEIGHT * 0.08411216735839844);
            Point2D.Double E_CENTER_KNOB_FRAME_START = new Point2D.Double(0.0, E_CENTER_KNOB_FRAME.getBounds2D().getMinY());
            Point2D.Double E_CENTER_KNOB_FRAME_STOP = new Point2D.Double(0.0, E_CENTER_KNOB_FRAME.getBounds2D().getMaxY());
            float[] E_CENTER_KNOB_FRAME_FRACTIONS = new float[]{0.0f, 0.46f, 1.0f};
            Color[] E_CENTER_KNOB_FRAME_COLORS = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
            LinearGradientPaint E_CENTER_KNOB_FRAME_GRADIENT = new LinearGradientPaint(E_CENTER_KNOB_FRAME_START, E_CENTER_KNOB_FRAME_STOP, E_CENTER_KNOB_FRAME_FRACTIONS, E_CENTER_KNOB_FRAME_COLORS);
            G2.setPaint(E_CENTER_KNOB_FRAME_GRADIENT);
            G2.fill(E_CENTER_KNOB_FRAME);
            Ellipse2D.Double E_CENTER_KNOB_MAIN = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4672897160053253, (double)IMAGE_HEIGHT * 0.4672897160053253, (double)IMAGE_WIDTH * 0.06542053818702698, (double)IMAGE_HEIGHT * 0.06542053818702698);
            Point2D.Double E_CENTER_KNOB_MAIN_START = new Point2D.Double(0.0, E_CENTER_KNOB_MAIN.getBounds2D().getMinY());
            Point2D.Double E_CENTER_KNOB_MAIN_STOP = new Point2D.Double(0.0, E_CENTER_KNOB_MAIN.getBounds2D().getMaxY());
            float[] E_CENTER_KNOB_MAIN_FRACTIONS = new float[]{0.0f, 1.0f};
            Color[] E_CENTER_KNOB_MAIN_COLORS = new Color[]{new Color(217, 217, 217, 255), new Color(191, 191, 191, 255)};
            LinearGradientPaint E_CENTER_KNOB_MAIN_GRADIENT = new LinearGradientPaint(E_CENTER_KNOB_MAIN_START, E_CENTER_KNOB_MAIN_STOP, E_CENTER_KNOB_MAIN_FRACTIONS, E_CENTER_KNOB_MAIN_COLORS);
            G2.setPaint(E_CENTER_KNOB_MAIN_GRADIENT);
            G2.fill(E_CENTER_KNOB_MAIN);
            Ellipse2D.Double E_CENTER_KNOB_INNERSHADOW = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4672897160053253, (double)IMAGE_HEIGHT * 0.4672897160053253, (double)IMAGE_WIDTH * 0.06542053818702698, (double)IMAGE_HEIGHT * 0.06542053818702698);
            Point2D.Double E_CENTER_KNOB_INNERSHADOW_CENTER = new Point2D.Double(0.4953271028037383 * (double)IMAGE_WIDTH, 0.49065420560747663 * (double)IMAGE_HEIGHT);
            float[] E_CENTER_KNOB_INNERSHADOW_FRACTIONS = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
            Color[] E_CENTER_KNOB_INNERSHADOW_COLORS = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
            RadialGradientPaint E_CENTER_KNOB_INNERSHADOW_GRADIENT = new RadialGradientPaint(E_CENTER_KNOB_INNERSHADOW_CENTER, (float)(0.03271028037383177 * (double)IMAGE_WIDTH), E_CENTER_KNOB_INNERSHADOW_FRACTIONS, E_CENTER_KNOB_INNERSHADOW_COLORS);
            G2.setPaint(E_CENTER_KNOB_INNERSHADOW_GRADIENT);
            G2.fill(E_CENTER_KNOB_INNERSHADOW);
        }
        GeneralPath HIGHLIGHT = new GeneralPath();
        Point2D.Double HIGHLIGHT_START = new Point2D.Double();
        Point2D.Double HIGHLIGHT_STOP = new Point2D.Double();
        float[] HIGHLIGHT_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] HIGHLIGHT_COLORS = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.2f), new Color(1.0f, 1.0f, 1.0f, 0.05f)};
        switch (TYPE) {
            case FG_TYPE1: {
                HIGHLIGHT.setWindingRule(0);
                HIGHLIGHT.moveTo((double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.49065420560747663);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.5093457943925234);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.20093457943925233, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.32710280373831774, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.4158878504672897);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.6588785046728972, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.794392523364486, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.514018691588785);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.5046728971962616, (double)IMAGE_WIDTH * 0.9205607476635514, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.49065420560747663);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.2757009345794392, (double)IMAGE_WIDTH * 0.7476635514018691, (double)IMAGE_HEIGHT * 0.08411214953271028, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.08411214953271028);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.2523364485981308, (double)IMAGE_HEIGHT * 0.08411214953271028, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.2803738317757009, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.49065420560747663);
                HIGHLIGHT.closePath();
                ((Point2D)HIGHLIGHT_START).setLocation(0.0, HIGHLIGHT.getBounds2D().getMinY());
                ((Point2D)HIGHLIGHT_STOP).setLocation(0.0, HIGHLIGHT.getBounds2D().getMaxY());
                MultipleGradientPaint HIGHLIGHT_GRADIENT = new LinearGradientPaint(HIGHLIGHT_START, HIGHLIGHT_STOP, HIGHLIGHT_FRACTIONS, HIGHLIGHT_COLORS);
                G2.setPaint(HIGHLIGHT_GRADIENT);
                G2.fill(HIGHLIGHT);
                break;
            }
            case FG_TYPE2: {
                HIGHLIGHT.setWindingRule(0);
                HIGHLIGHT.moveTo((double)IMAGE_WIDTH * 0.13551401869158877, (double)IMAGE_HEIGHT * 0.6962616822429907);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.21495327102803738, (double)IMAGE_HEIGHT * 0.5887850467289719, (double)IMAGE_WIDTH * 0.3177570093457944, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.4252336448598131);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.6121495327102804, (double)IMAGE_HEIGHT * 0.34579439252336447, (double)IMAGE_WIDTH * 0.7336448598130841, (double)IMAGE_HEIGHT * 0.3177570093457944, (double)IMAGE_WIDTH * 0.8738317757009346, (double)IMAGE_HEIGHT * 0.32242990654205606);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.7663551401869159, (double)IMAGE_HEIGHT * 0.11214953271028037, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.02336448598130841, (double)IMAGE_WIDTH * 0.3130841121495327, (double)IMAGE_HEIGHT * 0.1308411214953271);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.09813084112149532, (double)IMAGE_HEIGHT * 0.2383177570093458, (double)IMAGE_WIDTH * 0.028037383177570093, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.13551401869158877, (double)IMAGE_HEIGHT * 0.6962616822429907);
                HIGHLIGHT.closePath();
                ((Point2D)HIGHLIGHT_START).setLocation(0.3130841121495327 * (double)IMAGE_WIDTH, 0.13551401869158877 * (double)IMAGE_HEIGHT);
                ((Point2D)HIGHLIGHT_STOP).setLocation(0.49552889241869635 * (double)IMAGE_WIDTH, 0.4935820611224282 * (double)IMAGE_HEIGHT);
                MultipleGradientPaint HIGHLIGHT_GRADIENT = new LinearGradientPaint(HIGHLIGHT_START, HIGHLIGHT_STOP, HIGHLIGHT_FRACTIONS, HIGHLIGHT_COLORS);
                G2.setPaint(HIGHLIGHT_GRADIENT);
                G2.fill(HIGHLIGHT);
                break;
            }
            case FG_TYPE3: {
                HIGHLIGHT.setWindingRule(0);
                HIGHLIGHT.moveTo((double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.5093457943925234);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.2102803738317757, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.5607476635514018, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5607476635514018);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.5607476635514018, (double)IMAGE_WIDTH * 0.794392523364486, (double)IMAGE_HEIGHT * 0.5607476635514018, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.5093457943925234);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.2757009345794392, (double)IMAGE_WIDTH * 0.7383177570093458, (double)IMAGE_HEIGHT * 0.08411214953271028, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.08411214953271028);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.2616822429906542, (double)IMAGE_HEIGHT * 0.08411214953271028, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.2757009345794392, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.5093457943925234);
                HIGHLIGHT.closePath();
                ((Point2D)HIGHLIGHT_START).setLocation(0.0, HIGHLIGHT.getBounds2D().getMinY());
                ((Point2D)HIGHLIGHT_STOP).setLocation(0.0, HIGHLIGHT.getBounds2D().getMaxY());
                MultipleGradientPaint HIGHLIGHT_GRADIENT = new LinearGradientPaint(HIGHLIGHT_START, HIGHLIGHT_STOP, HIGHLIGHT_FRACTIONS, HIGHLIGHT_COLORS);
                G2.setPaint(HIGHLIGHT_GRADIENT);
                G2.fill(HIGHLIGHT);
                break;
            }
            case FG_TYPE4: {
                HIGHLIGHT.setWindingRule(0);
                HIGHLIGHT.moveTo((double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.24299065420560748);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.7710280373831776, (double)IMAGE_HEIGHT * 0.308411214953271, (double)IMAGE_WIDTH * 0.822429906542056, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.8130841121495327, (double)IMAGE_HEIGHT * 0.5280373831775701);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.6542056074766355, (double)IMAGE_WIDTH * 0.719626168224299, (double)IMAGE_HEIGHT * 0.7570093457943925, (double)IMAGE_WIDTH * 0.5934579439252337, (double)IMAGE_HEIGHT * 0.7990654205607477);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.8317757009345794, (double)IMAGE_WIDTH * 0.3691588785046729, (double)IMAGE_HEIGHT * 0.8084112149532711, (double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.7289719626168224);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.2757009345794392, (double)IMAGE_HEIGHT * 0.719626168224299, (double)IMAGE_WIDTH * 0.2523364485981308, (double)IMAGE_HEIGHT * 0.7149532710280374, (double)IMAGE_WIDTH * 0.2336448598130841, (double)IMAGE_HEIGHT * 0.7289719626168224);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.21495327102803738, (double)IMAGE_HEIGHT * 0.7476635514018691, (double)IMAGE_WIDTH * 0.21962616822429906, (double)IMAGE_HEIGHT * 0.7710280373831776, (double)IMAGE_WIDTH * 0.22897196261682243, (double)IMAGE_HEIGHT * 0.7757009345794392);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.3317757009345794, (double)IMAGE_HEIGHT * 0.8785046728971962, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.9158878504672897, (double)IMAGE_WIDTH * 0.616822429906542, (double)IMAGE_HEIGHT * 0.8691588785046729);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.7710280373831776, (double)IMAGE_HEIGHT * 0.822429906542056, (double)IMAGE_WIDTH * 0.8738317757009346, (double)IMAGE_HEIGHT * 0.6915887850467289, (double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.5327102803738317);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.897196261682243, (double)IMAGE_HEIGHT * 0.3878504672897196, (double)IMAGE_WIDTH * 0.8364485981308412, (double)IMAGE_HEIGHT * 0.2570093457943925, (double)IMAGE_WIDTH * 0.719626168224299, (double)IMAGE_HEIGHT * 0.1822429906542056);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.705607476635514, (double)IMAGE_HEIGHT * 0.17289719626168223, (double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.16355140186915887, (double)IMAGE_WIDTH * 0.6635514018691588, (double)IMAGE_HEIGHT * 0.18691588785046728);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.6542056074766355, (double)IMAGE_HEIGHT * 0.205607476635514, (double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.2383177570093458, (double)IMAGE_WIDTH * 0.677570093457944, (double)IMAGE_HEIGHT * 0.24299065420560748);
                HIGHLIGHT.closePath();
                Point2D.Double HIGHLIGHT_CENTER = new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                float[] HIGHLIGHT_FRACTIONS_4_1 = new float[]{0.0f, 0.82f, 0.83f, 1.0f};
                Color[] HIGHLIGHT_COLORS_4_1 = new Color[]{new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 25)};
                MultipleGradientPaint HIGHLIGHT_GRADIENT = new RadialGradientPaint(HIGHLIGHT_CENTER, (float)(0.3878504672897196 * (double)IMAGE_WIDTH), HIGHLIGHT_FRACTIONS_4_1, HIGHLIGHT_COLORS_4_1);
                G2.setPaint(HIGHLIGHT_GRADIENT);
                G2.fill(HIGHLIGHT);
                GeneralPath HIGHLIGHT_4 = new GeneralPath();
                HIGHLIGHT_4.setWindingRule(0);
                HIGHLIGHT_4.moveTo((double)IMAGE_WIDTH * 0.2616822429906542, (double)IMAGE_HEIGHT * 0.22429906542056074);
                HIGHLIGHT_4.curveTo((double)IMAGE_WIDTH * 0.2850467289719626, (double)IMAGE_HEIGHT * 0.2383177570093458, (double)IMAGE_WIDTH * 0.2523364485981308, (double)IMAGE_HEIGHT * 0.2850467289719626, (double)IMAGE_WIDTH * 0.24299065420560748, (double)IMAGE_HEIGHT * 0.3177570093457944);
                HIGHLIGHT_4.curveTo((double)IMAGE_WIDTH * 0.24299065420560748, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.397196261682243);
                HIGHLIGHT_4.curveTo((double)IMAGE_WIDTH * 0.2757009345794392, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.2616822429906542, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.2383177570093458, (double)IMAGE_HEIGHT * 0.5093457943925234);
                HIGHLIGHT_4.curveTo((double)IMAGE_WIDTH * 0.22429906542056074, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.17757009345794392, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.1588785046728972, (double)IMAGE_HEIGHT * 0.6121495327102804);
                HIGHLIGHT_4.curveTo((double)IMAGE_WIDTH * 0.14485981308411214, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.08878504672897196, (double)IMAGE_HEIGHT * 0.5467289719626168, (double)IMAGE_WIDTH * 0.1308411214953271, (double)IMAGE_HEIGHT * 0.3691588785046729);
                HIGHLIGHT_4.curveTo((double)IMAGE_WIDTH * 0.14018691588785046, (double)IMAGE_HEIGHT * 0.3364485981308411, (double)IMAGE_WIDTH * 0.21495327102803738, (double)IMAGE_HEIGHT * 0.20093457943925233, (double)IMAGE_WIDTH * 0.2616822429906542, (double)IMAGE_HEIGHT * 0.22429906542056074);
                HIGHLIGHT_4.closePath();
                Point2D.Double HIGHLIGHT_4_START = new Point2D.Double(0.1308411214953271 * (double)IMAGE_WIDTH, 0.3691588785046729 * (double)IMAGE_HEIGHT);
                Point2D.Double HIGHLIGHT_4_STOP = new Point2D.Double(0.27383996350849127 * (double)IMAGE_WIDTH, 0.41287801192115686 * (double)IMAGE_HEIGHT);
                float[] HIGHLIGHT_FRACTIONS4_2 = new float[]{0.0f, 1.0f};
                Color[] HIGHLIGHT_FRACTIONS_4_2 = new Color[]{new Color(255, 255, 255, 51), new Color(255, 255, 255, 0)};
                LinearGradientPaint HIGHLIGHT_GRADIENT_4_2 = new LinearGradientPaint(HIGHLIGHT_4_START, HIGHLIGHT_4_STOP, HIGHLIGHT_FRACTIONS4_2, HIGHLIGHT_FRACTIONS_4_2);
                G2.setPaint(HIGHLIGHT_GRADIENT_4_2);
                G2.fill(HIGHLIGHT_4);
                break;
            }
            case FG_TYPE5: {
                HIGHLIGHT.setWindingRule(0);
                HIGHLIGHT.moveTo((double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.5);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.27102803738317754, (double)IMAGE_WIDTH * 0.27102803738317754, (double)IMAGE_HEIGHT * 0.08411214953271028, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.08411214953271028);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.7009345794392523, (double)IMAGE_HEIGHT * 0.08411214953271028, (double)IMAGE_WIDTH * 0.8644859813084113, (double)IMAGE_HEIGHT * 0.22429906542056074, (double)IMAGE_WIDTH * 0.9065420560747663, (double)IMAGE_HEIGHT * 0.411214953271028);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.9112149532710281, (double)IMAGE_HEIGHT * 0.4392523364485981, (double)IMAGE_WIDTH * 0.9112149532710281, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.8457943925233645, (double)IMAGE_HEIGHT * 0.5373831775700935);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.794392523364486, (double)IMAGE_HEIGHT * 0.5467289719626168, (double)IMAGE_WIDTH * 0.5514018691588785, (double)IMAGE_HEIGHT * 0.411214953271028, (double)IMAGE_WIDTH * 0.3925233644859813, (double)IMAGE_HEIGHT * 0.45794392523364486);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.16822429906542055, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.13551401869158877, (double)IMAGE_HEIGHT * 0.7757009345794392, (double)IMAGE_WIDTH * 0.09345794392523364, (double)IMAGE_HEIGHT * 0.5934579439252337);
                HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.08878504672897196, (double)IMAGE_HEIGHT * 0.5607476635514018, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.5);
                HIGHLIGHT.closePath();
                ((Point2D)HIGHLIGHT_START).setLocation(0.0, HIGHLIGHT.getBounds2D().getMinY());
                ((Point2D)HIGHLIGHT_STOP).setLocation(0.0, HIGHLIGHT.getBounds2D().getMaxY());
                MultipleGradientPaint HIGHLIGHT_GRADIENT = new LinearGradientPaint(HIGHLIGHT_START, HIGHLIGHT_STOP, HIGHLIGHT_FRACTIONS, HIGHLIGHT_COLORS);
                G2.setPaint(HIGHLIGHT_GRADIENT);
                G2.fill(HIGHLIGHT);
            }
        }
        G2.dispose();
        if (FOREGROUND_IMAGE != null) {
            Graphics2D G = FOREGROUND_IMAGE.createGraphics();
            G.drawImage((Image)this.radForegroundImage, 0, 0, null);
            G.dispose();
        }
        this.radWidth = WIDTH;
        this.radWithCenterKnob = WITH_CENTER_KNOB;
        this.radType = TYPE;
        return this.radForegroundImage;
    }

    public BufferedImage createLinearForeground(int WIDTH, int HEIGHT) {
        return this.createLinearForeground(WIDTH, HEIGHT, false);
    }

    public BufferedImage createLinearForeground(int WIDTH, int HEIGHT, boolean WITH_CENTER_KNOB) {
        return this.createLinearForeground(WIDTH, HEIGHT, WITH_CENTER_KNOB, null);
    }

    public BufferedImage createLinearForeground(int WIDTH, int HEIGHT, boolean WITH_CENTER_KNOB, BufferedImage FOREGROUND_IMAGE) {
        Point2D.Double GLASSEFFECT_STOP;
        Point2D.Double GLASSEFFECT_START;
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.linWidth == WIDTH && this.linHeight == HEIGHT && this.linWithCenterKnob == WITH_CENTER_KNOB) {
            if (FOREGROUND_IMAGE != null) {
                Graphics2D G2 = FOREGROUND_IMAGE.createGraphics();
                G2.drawImage((Image)this.linForegroundImage, 0, 0, null);
                G2.dispose();
            }
            return this.linForegroundImage;
        }
        this.linForegroundImage.flush();
        this.linForegroundImage = this.UTIL.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = this.linForegroundImage.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = WIDTH;
        int IMAGE_HEIGHT = HEIGHT;
        if (WITH_CENTER_KNOB) {
            Ellipse2D.Double E_CENTER_KNOB_FRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4579439163208008, (double)IMAGE_HEIGHT * 0.4579439163208008, (double)IMAGE_WIDTH * 0.08411216735839844, (double)IMAGE_HEIGHT * 0.08411216735839844);
            Point2D.Double E_CENTER_KNOB_FRAME_START = new Point2D.Double(0.0, E_CENTER_KNOB_FRAME.getBounds2D().getMinY());
            Point2D.Double E_CENTER_KNOB_FRAME_STOP = new Point2D.Double(0.0, E_CENTER_KNOB_FRAME.getBounds2D().getMaxY());
            float[] E_CENTER_KNOB_FRAME_FRACTIONS = new float[]{0.0f, 0.46f, 1.0f};
            Color[] E_CENTER_KNOB_FRAME_COLORS = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
            LinearGradientPaint E_CENTER_KNOB_FRAME_GRADIENT = new LinearGradientPaint(E_CENTER_KNOB_FRAME_START, E_CENTER_KNOB_FRAME_STOP, E_CENTER_KNOB_FRAME_FRACTIONS, E_CENTER_KNOB_FRAME_COLORS);
            G2.setPaint(E_CENTER_KNOB_FRAME_GRADIENT);
            G2.fill(E_CENTER_KNOB_FRAME);
            Ellipse2D.Double E_CENTER_KNOB_MAIN = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4672897160053253, (double)IMAGE_HEIGHT * 0.4672897160053253, (double)IMAGE_WIDTH * 0.06542053818702698, (double)IMAGE_HEIGHT * 0.06542053818702698);
            Point2D.Double E_CENTER_KNOB_MAIN_START = new Point2D.Double(0.0, E_CENTER_KNOB_MAIN.getBounds2D().getMinY());
            Point2D.Double E_CENTER_KNOB_MAIN_STOP = new Point2D.Double(0.0, E_CENTER_KNOB_MAIN.getBounds2D().getMaxY());
            float[] E_CENTER_KNOB_MAIN_FRACTIONS = new float[]{0.0f, 1.0f};
            Color[] E_CENTER_KNOB_MAIN_COLORS = new Color[]{new Color(217, 217, 217, 255), new Color(191, 191, 191, 255)};
            LinearGradientPaint E_CENTER_KNOB_MAIN_GRADIENT = new LinearGradientPaint(E_CENTER_KNOB_MAIN_START, E_CENTER_KNOB_MAIN_STOP, E_CENTER_KNOB_MAIN_FRACTIONS, E_CENTER_KNOB_MAIN_COLORS);
            G2.setPaint(E_CENTER_KNOB_MAIN_GRADIENT);
            G2.fill(E_CENTER_KNOB_MAIN);
            Ellipse2D.Double E_CENTER_KNOB_INNERSHADOW = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4672897160053253, (double)IMAGE_HEIGHT * 0.4672897160053253, (double)IMAGE_WIDTH * 0.06542053818702698, (double)IMAGE_HEIGHT * 0.06542053818702698);
            Point2D.Double E_CENTER_KNOB_INNERSHADOW_CENTER = new Point2D.Double(0.4953271028037383 * (double)IMAGE_WIDTH, 0.49065420560747663 * (double)IMAGE_HEIGHT);
            float[] E_CENTER_KNOB_INNERSHADOW_FRACTIONS = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
            Color[] E_CENTER_KNOB_INNERSHADOW_COLORS = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
            RadialGradientPaint E_CENTER_KNOB_INNERSHADOW_GRADIENT = new RadialGradientPaint(E_CENTER_KNOB_INNERSHADOW_CENTER, (float)(0.03271028037383177 * (double)IMAGE_WIDTH), E_CENTER_KNOB_INNERSHADOW_FRACTIONS, E_CENTER_KNOB_INNERSHADOW_COLORS);
            G2.setPaint(E_CENTER_KNOB_INNERSHADOW_GRADIENT);
            G2.fill(E_CENTER_KNOB_INNERSHADOW);
        }
        GeneralPath GLASSEFFECT = new GeneralPath();
        GLASSEFFECT.setWindingRule(0);
        if (WIDTH >= HEIGHT) {
            GLASSEFFECT.moveTo(18.0f, IMAGE_HEIGHT - 18);
            GLASSEFFECT.lineTo(IMAGE_WIDTH - 18, IMAGE_HEIGHT - 18);
            GLASSEFFECT.curveTo((double)(IMAGE_WIDTH - 18), (double)(IMAGE_HEIGHT - 18), (double)(IMAGE_WIDTH - 27), (double)IMAGE_HEIGHT * 0.7, (double)(IMAGE_WIDTH - 27), (double)IMAGE_HEIGHT * 0.5);
            GLASSEFFECT.curveTo(IMAGE_WIDTH - 27, 27.0f, IMAGE_WIDTH - 18, 18.0f, IMAGE_WIDTH - 18, 18.0f);
            GLASSEFFECT.lineTo(18.0f, 18.0f);
            GLASSEFFECT.curveTo(18.0, 18.0, 27.0, (double)IMAGE_HEIGHT * 0.2857142857142857, 27.0, (double)IMAGE_HEIGHT * 0.5);
            GLASSEFFECT.curveTo(27.0, (double)IMAGE_HEIGHT * 0.7, 18.0, (double)(IMAGE_HEIGHT - 18), 18.0, (double)(IMAGE_HEIGHT - 18));
            GLASSEFFECT.closePath();
            GLASSEFFECT_START = new Point2D.Double(0.0, GLASSEFFECT.getBounds2D().getMaxY());
            GLASSEFFECT_STOP = new Point2D.Double(0.0, GLASSEFFECT.getBounds2D().getMinY());
        } else {
            GLASSEFFECT.setWindingRule(0);
            GLASSEFFECT.moveTo(18.0f, 18.0f);
            GLASSEFFECT.lineTo(18.0f, IMAGE_HEIGHT - 18);
            GLASSEFFECT.curveTo(18.0, (double)(IMAGE_HEIGHT - 18), 27.0, (double)(IMAGE_HEIGHT - 27), (double)IMAGE_WIDTH * 0.5, (double)(IMAGE_HEIGHT - 27));
            GLASSEFFECT.curveTo(IMAGE_WIDTH - 27, IMAGE_HEIGHT - 27, IMAGE_WIDTH - 18, IMAGE_HEIGHT - 18, IMAGE_WIDTH - 18, IMAGE_HEIGHT - 18);
            GLASSEFFECT.lineTo(IMAGE_WIDTH - 18, 18.0f);
            GLASSEFFECT.curveTo((double)(IMAGE_WIDTH - 18), 18.0, (double)(IMAGE_WIDTH - 27), 27.0, (double)IMAGE_WIDTH * 0.5, 27.0);
            GLASSEFFECT.curveTo(27.0f, 27.0f, 18.0f, 18.0f, 18.0f, 18.0f);
            GLASSEFFECT.closePath();
            GLASSEFFECT_START = new Point2D.Double(GLASSEFFECT.getBounds2D().getMinX(), 0.0);
            GLASSEFFECT_STOP = new Point2D.Double(GLASSEFFECT.getBounds2D().getMaxX(), 0.0);
        }
        float[] GLASSEFFECT_FRACTIONS = new float[]{0.0f, 0.06f, 0.07f, 0.12f, 0.17f, 0.1701f, 0.79f, 0.8f, 0.84f, 0.93f, 0.94f, 0.96f, 0.97f, 1.0f};
        Color[] GLASSEFFECT_COLORS = new Color[]{new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 3), new Color(255, 255, 255, 5), new Color(255, 255, 255, 5), new Color(255, 255, 255, 5), new Color(255, 255, 255, 20), new Color(255, 255, 255, 73), new Color(255, 255, 255, 76), new Color(255, 255, 255, 30), new Color(255, 255, 255, 10), new Color(255, 255, 255, 5)};
        LinearGradientPaint GLASSEFFECT_GRADIENT = new LinearGradientPaint(GLASSEFFECT_START, GLASSEFFECT_STOP, GLASSEFFECT_FRACTIONS, GLASSEFFECT_COLORS);
        G2.setPaint(GLASSEFFECT_GRADIENT);
        G2.fill(GLASSEFFECT);
        G2.dispose();
        if (FOREGROUND_IMAGE != null) {
            Graphics2D G = FOREGROUND_IMAGE.createGraphics();
            G.drawImage((Image)this.linForegroundImage, 0, 0, null);
            G.dispose();
        }
        this.linWidth = WIDTH;
        this.linHeight = HEIGHT;
        this.linWithCenterKnob = WITH_CENTER_KNOB;
        return this.linForegroundImage;
    }

    public String toString() {
        return "ForegroundImageFactory";
    }
}

