/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.uds;

import com.rusefi.io.can.PCanHelper;
import com.rusefi.uds.CanConnector;
import org.jetbrains.annotations.NotNull;
import peak.can.basic.PCANBasic;
import peak.can.basic.TPCANMode;
import peak.can.basic.TPCANMsg;
import peak.can.basic.TPCANStatus;

public class PCanConnector {
    @NotNull
    static CanConnector createPCanConnector() {
        final PCANBasic can = PCanHelper.create();
        CanConnector connector = new CanConnector(){

            @Override
            public void send(int id, byte[] payLoad) {
                PCanHelper.send(can, id, payLoad);
            }

            @Override
            public CanConnector.CanPacket read() {
                final TPCANMsg rx = new TPCANMsg(127);
                TPCANStatus status = can.Read(PCanHelper.CHANNEL, rx, null);
                if (status != TPCANStatus.PCAN_ERROR_OK) {
                    return null;
                }
                return new CanConnector.CanPacket(){

                    @Override
                    public int id() {
                        return rx.getID();
                    }

                    @Override
                    public byte[] payload() {
                        return rx.getData();
                    }
                };
            }
        };
        can.FilterMessages(PCanHelper.CHANNEL, 2024, 2024, TPCANMode.PCAN_MODE_STANDARD);
        TPCANStatus status = PCanHelper.init(can);
        if (status != TPCANStatus.PCAN_ERROR_OK) {
            throw new IllegalStateException("Unhappy PCAN " + (Object)((Object)status));
        }
        return connector;
    }
}

