/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.LcdColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Spline;

public final class RadialCounter
extends AbstractRadial {
    private boolean rotateTickmarks = true;
    private double oldValue = 0.0;
    private double rotationAngle = 0.0;
    private final Point2D CENTER;
    private BufferedImage frameImage;
    private BufferedImage backgroundImage;
    private BufferedImage lcdImage;
    private BufferedImage tickmarksImage;
    private BufferedImage overlayImage;
    private BufferedImage pointerImage;
    private BufferedImage foregroundImage;
    private BufferedImage disabledImage;
    private Timeline timeline;
    private final Rectangle2D LCD = new Rectangle2D.Double();
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private double unitStringWidth;
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();

    public RadialCounter() {
        this.CENTER = new Point2D.Double();
        this.timeline = new Timeline(this);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setLcdVisible(true);
    }

    @Override
    public final AbstractGauge init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return this;
        }
        if (this.isDigitalFont()) {
            this.setLcdValueFont(this.getModel().getDigitalBaseFont().deriveFont(0.7f * (float)WIDTH * 0.1f));
        } else {
            this.setLcdValueFont(this.getModel().getStandardBaseFont().deriveFont(0.625f * (float)WIDTH * 0.1f));
        }
        if (this.isCustomLcdUnitFontEnabled()) {
            this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * (float)WIDTH * 0.1f));
        } else {
            this.setLcdUnitFont(this.getModel().getStandardBaseFont().deriveFont(0.25f * (float)WIDTH * 0.1f));
        }
        this.setLcdInfoFont(this.getModel().getStandardInfoFont().deriveFont(0.15f * (float)WIDTH * 0.1f));
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX() - (double)this.getInsets().left, this.getGaugeBounds().getCenterY() - (double)this.getInsets().top);
        if (this.frameImage != null) {
            this.frameImage.flush();
        }
        this.frameImage = this.create_FRAME_Image(WIDTH);
        if (this.backgroundImage != null) {
            this.backgroundImage.flush();
        }
        this.backgroundImage = this.create_BACKGROUND_Image(WIDTH);
        if (this.lcdImage != null) {
            this.lcdImage.flush();
        }
        this.lcdImage = this.create_LCD_Image((int)((double)WIDTH * 0.32), (int)((double)WIDTH * 0.1), this.getLcdColor(), this.getCustomLcdBackground());
        this.LCD.setRect((double)(this.getGaugeBounds().width - this.lcdImage.getWidth()) / 2.0, (double)(this.getGaugeBounds().height - this.lcdImage.getHeight()) / 2.0, (double)WIDTH * 0.32, (double)WIDTH * 0.1);
        if (this.tickmarksImage != null) {
            this.tickmarksImage.flush();
        }
        this.tickmarksImage = this.create_TICKMARKS_Image(WIDTH);
        if (this.overlayImage != null) {
            this.overlayImage.flush();
        }
        this.overlayImage = this.create_OVERLAY_Image(WIDTH);
        if (this.pointerImage != null) {
            this.pointerImage.flush();
        }
        this.pointerImage = this.create_POINTER_Image(WIDTH);
        if (this.foregroundImage != null) {
            this.foregroundImage.flush();
        }
        this.foregroundImage = this.create_FOREGROUND_Image(WIDTH, false, this.getForegroundType());
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(WIDTH);
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        if (this.isFrameVisible()) {
            G2.drawImage((Image)this.frameImage, 0, 0, null);
        }
        if (this.isBackgroundVisible()) {
            G2.drawImage((Image)this.backgroundImage, 0, 0, null);
        }
        if (this.rotateTickmarks) {
            G2.rotate(-this.rotationAngle, this.CENTER.getX(), this.CENTER.getY());
            G2.drawImage((Image)this.tickmarksImage, 0, 0, null);
            G2.setTransform(OLD_TRANSFORM);
        } else {
            G2.drawImage((Image)this.tickmarksImage, 0, 0, null);
        }
        if (!this.rotateTickmarks) {
            G2.rotate(this.rotationAngle, this.CENTER.getX(), this.CENTER.getY());
            G2.drawImage((Image)this.pointerImage, 0, 0, null);
            G2.setTransform(OLD_TRANSFORM);
        } else {
            G2.drawImage((Image)this.pointerImage, 0, 0, null);
        }
        G2.drawImage((Image)this.overlayImage, 0, 0, null);
        if (this.isLcdVisible()) {
            G2.drawImage((Image)this.lcdImage, (int)this.LCD.getX(), (int)this.LCD.getY(), null);
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                G2.setColor(this.getCustomLcdForeground());
            } else {
                G2.setColor(this.getLcdColor().TEXT_COLOR);
            }
            G2.setFont(this.getLcdUnitFont());
            if (this.isLcdUnitStringVisible()) {
                this.unitLayout = new TextLayout(this.getLcdUnitString(), G2.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                G2.drawString(this.getLcdUnitString(), (int)(this.LCD.getX() + (this.LCD.getWidth() - this.UNIT_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.03), (int)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                this.unitStringWidth = this.UNIT_BOUNDARY.getWidth();
            } else {
                this.unitStringWidth = 0.0;
            }
            G2.setFont(this.getLcdValueFont());
            switch (this.getModel().getNumberSystem()) {
                case HEX: {
                    this.valueLayout = new TextLayout(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    G2.drawString(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), (int)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + (double)this.lcdImage.getHeight() * 0.76));
                    break;
                }
                case OCT: {
                    this.valueLayout = new TextLayout(Integer.toOctalString((int)this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    G2.drawString(Integer.toOctalString((int)this.getLcdValue()), (int)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + (double)this.lcdImage.getHeight() * 0.76));
                    break;
                }
                default: {
                    this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    G2.drawString(this.formatLcdValue(this.getLcdValue()), (int)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + (double)this.lcdImage.getHeight() * 0.76));
                }
            }
            if (!this.getLcdInfoString().isEmpty()) {
                G2.setFont(this.getLcdInfoFont());
                this.infoLayout = new TextLayout(this.getLcdInfoString(), G2.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                G2.drawString(this.getLcdInfoString(), this.LCD.getBounds().x + 5, this.LCD.getBounds().y + (int)this.INFO_BOUNDARY.getHeight() + 5);
            }
        }
        if (this.isForegroundVisible()) {
            G2.drawImage((Image)this.foregroundImage, 0, 0, null);
        }
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.dispose();
    }

    @Override
    public double getValue() {
        return this.oldValue;
    }

    @Override
    public void setValue(double VALUE) {
        this.rotationAngle = 0.6283185307179586 * (VALUE % 10.0);
        this.fireStateChanged();
        this.oldValue = VALUE;
        if (this.isValueCoupled()) {
            this.setLcdValue(VALUE);
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setValueAnimated(double VALUE) {
        if (this.timeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.timeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
            this.timeline.abort();
        }
        this.timeline = new Timeline(this);
        this.timeline.addPropertyToInterpolate("value", this.oldValue, VALUE);
        this.timeline.setEase(new Spline(0.5f));
        this.timeline.setDuration(1500L);
        this.timeline.play();
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public double getMaxValue() {
        return 10.0;
    }

    public boolean isRotateTickmarks() {
        return this.rotateTickmarks;
    }

    public void setRotateTickmarks(boolean ROTATE_TICKMARKS) {
        this.rotateTickmarks = ROTATE_TICKMARKS;
        this.setValue(0.0);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] LCD_COLORS) {
        Point2D.Double FOREGROUND_STOP;
        Point2D.Double FOREGROUND_START = new Point2D.Double(0.0, this.LCD.getMinY() + 1.0);
        if (FOREGROUND_START.equals(FOREGROUND_STOP = new Point2D.Double(0.0, this.LCD.getMaxY() - 1.0))) {
            ((Point2D)FOREGROUND_STOP).setLocation(0.0, ((Point2D)FOREGROUND_START).getY() + 1.0);
        }
        float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] FOREGROUND_COLORS = new Color[]{LCD_COLORS[0], LCD_COLORS[1], LCD_COLORS[2], LCD_COLORS[3], LCD_COLORS[4]};
        return new LinearGradientPaint(FOREGROUND_START, FOREGROUND_STOP, FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double(this.getInnerBounds().getCenterX() + (double)this.getInnerBounds().x, this.getInnerBounds().getCenterX() + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getInnerBounds();
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.LCD.getBounds();
    }

    private BufferedImage create_TICKMARKS_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int IMAGE_WIDTH = IMAGE.getWidth();
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        BasicStroke THIN_STROKE = new BasicStroke(0.01f * (float)IMAGE_WIDTH, 1, 2);
        Font FONT = new Font("Verdana", 0, (int)(0.07476635f * (float)IMAGE_WIDTH));
        float TEXT_DISTANCE = 0.1f * (float)IMAGE_WIDTH;
        float MIN_LENGTH = 0.02f * (float)IMAGE_WIDTH;
        float MED_LENGTH = 0.04f * (float)IMAGE_WIDTH;
        float RADIUS = (float)IMAGE_WIDTH * 0.37f;
        this.CENTER.setLocation((float)IMAGE_WIDTH / 2.0f, (float)IMAGE_WIDTH / 2.0f);
        Point2D.Double innerPoint = new Point2D.Double();
        Point2D.Double outerPoint = new Point2D.Double();
        Point2D.Double textPoint = new Point2D.Double();
        int tickCounterFull = 0;
        int tickCounterHalf = 0;
        int counter = 0;
        double sinValue = 0.0;
        double cosValue = 0.0;
        double STEP = 0.3141592653589793;
        if (this.isTickmarkColorFromThemeEnabled()) {
            G2.setColor(this.getBackgroundColor().LABEL_COLOR);
        } else {
            G2.setColor(this.getTickmarkColor());
        }
        for (double alpha = Math.PI * 2; alpha >= 0.0; alpha -= 0.3141592653589793) {
            Line2D.Double tick;
            G2.setStroke(THIN_STROKE);
            sinValue = Math.sin(alpha);
            cosValue = Math.cos(alpha);
            if (tickCounterHalf == 1) {
                G2.setStroke(THIN_STROKE);
                ((Point2D)innerPoint).setLocation(this.CENTER.getX() + (double)(RADIUS - MIN_LENGTH) * sinValue, this.CENTER.getY() + (double)(RADIUS - MIN_LENGTH) * cosValue);
                ((Point2D)outerPoint).setLocation(this.CENTER.getX() + (double)RADIUS * sinValue, this.CENTER.getY() + (double)RADIUS * cosValue);
                tick = new Line2D.Double(((Point2D)innerPoint).getX(), ((Point2D)innerPoint).getY(), ((Point2D)outerPoint).getX(), ((Point2D)outerPoint).getY());
                G2.draw(tick);
                tickCounterHalf = 0;
            }
            if (tickCounterFull == 2) {
                G2.setStroke(THIN_STROKE);
                ((Point2D)innerPoint).setLocation(this.CENTER.getX() + (double)(RADIUS - MED_LENGTH) * sinValue, this.CENTER.getY() + (double)(RADIUS - MED_LENGTH) * cosValue);
                ((Point2D)outerPoint).setLocation(this.CENTER.getX() + (double)RADIUS * sinValue, this.CENTER.getY() + (double)RADIUS * cosValue);
                tick = new Line2D.Double(((Point2D)innerPoint).getX(), ((Point2D)innerPoint).getY(), ((Point2D)outerPoint).getX(), ((Point2D)outerPoint).getY());
                G2.draw(tick);
                tickCounterFull = 0;
            }
            G2.setFont(FONT);
            ((Point2D)textPoint).setLocation(this.CENTER.getX() + (double)(RADIUS - TEXT_DISTANCE) * sinValue, this.CENTER.getY() + (double)(RADIUS - TEXT_DISTANCE) * cosValue);
            if (counter != 20 && counter % 2 == 0) {
                G2.rotate(Math.toRadians(0.0), this.CENTER.getX(), this.CENTER.getY());
                G2.fill(UTIL.rotateTextAroundCenter(G2, String.valueOf(counter / 2), (int)((Point2D)textPoint).getX(), (int)((Point2D)textPoint).getY(), Math.PI * 2 - alpha));
            }
            G2.setTransform(OLD_TRANSFORM);
            ++tickCounterHalf;
            ++tickCounterFull;
            ++counter;
        }
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_OVERLAY_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Ellipse2D.Double OVERLAY_FRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.31308412551879883, (double)IMAGE_HEIGHT * 0.31308412551879883, (double)IMAGE_WIDTH * 0.37383174896240234, (double)IMAGE_HEIGHT * 0.37383174896240234);
        Point2D.Double OVERLAY_FRAME_START = new Point2D.Double(0.0, OVERLAY_FRAME.getBounds2D().getMinY());
        Point2D.Double OVERLAY_FRAME_STOP = new Point2D.Double(0.0, OVERLAY_FRAME.getBounds2D().getMaxY());
        float[] OVERLAY_FRAME_FRACTIONS = new float[]{0.0f, 0.46f, 1.0f};
        Color[] OVERLAY_FRAME_COLORS = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint OVERLAY_FRAME_GRADIENT = new LinearGradientPaint(OVERLAY_FRAME_START, OVERLAY_FRAME_STOP, OVERLAY_FRAME_FRACTIONS, OVERLAY_FRAME_COLORS);
        G2.setPaint(OVERLAY_FRAME_GRADIENT);
        G2.fill(OVERLAY_FRAME);
        Ellipse2D.Double GAUGE_BACKGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.08411215245723724, (double)IMAGE_HEIGHT * 0.08411215245723724, (double)IMAGE_WIDTH * 0.8317756652832031, (double)IMAGE_HEIGHT * 0.8317756652832031);
        Ellipse2D.Double OVERLAY_MAIN = new Ellipse2D.Double((double)IMAGE_WIDTH * (double)0.317757f, (double)IMAGE_HEIGHT * (double)0.317757f, (double)IMAGE_WIDTH * 0.3644859790802002, (double)IMAGE_HEIGHT * 0.3644859790802002);
        Point2D.Double OVERLAY_MAIN_START = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMinY());
        Point2D.Double OVERLAY_MAIN_STOP = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMaxY());
        float[] OVERLAY_MAIN_FRACTIONS = new float[]{0.0f, 0.35f, 1.0f};
        Color[] OVERLAY_MAIN_COLORS = new Color[]{this.getBackgroundColor().GRADIENT_START_COLOR, this.getBackgroundColor().GRADIENT_FRACTION_COLOR, this.getBackgroundColor().GRADIENT_STOP_COLOR};
        LinearGradientPaint OVERLAY_MAIN_GRADIENT = new LinearGradientPaint(OVERLAY_MAIN_START, OVERLAY_MAIN_STOP, OVERLAY_MAIN_FRACTIONS, OVERLAY_MAIN_COLORS);
        G2.setPaint(OVERLAY_MAIN_GRADIENT);
        G2.fill(OVERLAY_MAIN);
        Ellipse2D.Double OVERLAY_EFFECT = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.08411215245723724, (double)IMAGE_HEIGHT * 0.08411215245723724, (double)IMAGE_WIDTH * 0.8317756652832031, (double)IMAGE_HEIGHT * 0.8317756652832031);
        Point2D.Double OVERLAY_EFFECT_CENTER = new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
        float[] OVERLAY_EFFECT_FRACTIONS = new float[]{0.0f, 0.41f, 0.705f, 1.0f};
        Color[] OVERLAY_EFFECT_COLORS = new Color[]{UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 30), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0)};
        RadialGradientPaint OVERLAY_EFFECT_GRADIENT = new RadialGradientPaint(OVERLAY_EFFECT_CENTER, (float)(0.4158878326 * (double)IMAGE_WIDTH), OVERLAY_EFFECT_FRACTIONS, OVERLAY_EFFECT_COLORS);
        G2.setPaint(OVERLAY_EFFECT_GRADIENT);
        G2.fill(OVERLAY_EFFECT);
        G2.dispose();
        return IMAGE;
    }

    @Override
    protected BufferedImage create_POINTER_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath POINTERBACK = new GeneralPath();
        POINTERBACK.setWindingRule(0);
        POINTERBACK.moveTo((double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.9112149532710281);
        POINTERBACK.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.8271028037383178);
        POINTERBACK.lineTo((double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.9112149532710281);
        POINTERBACK.lineTo((double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.9112149532710281);
        POINTERBACK.closePath();
        GeneralPath POINTERFRONT = new GeneralPath();
        POINTERFRONT.setWindingRule(0);
        POINTERFRONT.moveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.9018691588785047);
        POINTERFRONT.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.8457943925233645);
        POINTERFRONT.lineTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.9018691588785047);
        POINTERFRONT.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.9018691588785047);
        POINTERFRONT.closePath();
        Area POINTER = new Area(POINTERBACK);
        POINTER.subtract(new Area(POINTERFRONT));
        Point2D.Double POINTER_START = new Point2D.Double(0.0, POINTER.getBounds2D().getMinY());
        Point2D.Double POINTER_STOP = new Point2D.Double(0.0, POINTER.getBounds2D().getMaxY());
        float[] POINTER_FRACTIONS = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] POINTER_COLORS = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().DARK, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM, this.getPointerColor().DARK} : new Color[]{this.getCustomPointerColorObject().DARK, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().DARK};
        LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
        G2.translate(1, 0);
        G2.setColor(new Color(0.0f, 0.0f, 0.0f, 0.55f));
        G2.fill(POINTER);
        G2.translate(-1, 0);
        G2.setPaint(POINTER_GRADIENT);
        G2.fill(POINTER);
        if (this.getPointerColor() != ColorDef.CUSTOM) {
            G2.setColor(this.getPointerColor().LIGHT);
        } else {
            G2.setColor(this.getCustomPointerColorObject().LIGHT);
        }
        G2.setStroke(new BasicStroke(1.0f, 0, 0));
        G2.draw(POINTER);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public String toString() {
        return "RadialCounter";
    }
}

