/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.config.FieldType;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.MapSamplingValuesConverter;
import com.rusefi.maintenance.migration.migrators.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Objects;
import java.util.Optional;

public enum MapSamplingValuesMigrator implements TuneMigrator
{
    INSTANCE;


    @Override
    public void migrateTune(TuneMigrationContext context) {
        String previousSignature = context.getPrevIniFile().getSignature();
        String updatedSignature = context.getUpdatedIniFile().getSignature();
        Optional<IniField> prevField = context.getPrevIniFile().findIniField("map_samplingAngle");
        if (!prevField.isPresent()) {
            return;
        }
        Optional<IniField> updatedField = context.getUpdatedIniFile().findIniField("map_samplingAngle");
        if (!updatedField.isPresent()) {
            return;
        }
        Optional<ArrayIniField> prevArrayIniField = this.getValidatedTableArrayIniField(prevField.get(), context.getCallbacks());
        Optional<ArrayIniField> updatedArrayIniField = this.getValidatedTableArrayIniField(updatedField.get(), context.getCallbacks());
        if (prevArrayIniField.isPresent() && updatedArrayIniField.isPresent()) {
            ArrayIniField prevTableField = prevArrayIniField.get();
            ArrayIniField updatedTableField = updatedArrayIniField.get();
            if (Objects.equals(prevTableField.getRows(), updatedTableField.getRows()) && Objects.equals(prevTableField.getCols(), updatedTableField.getCols())) {
                Optional<String[][]> migratedValues;
                boolean migrationValid;
                int updatedTableFieldCols = updatedTableField.getCols();
                Constant prevValue = context.getPrevTune().getConstantsAsMap().get("map_samplingAngle");
                boolean bl = migrationValid = previousSignature.contains("lts-25jersey") && !updatedSignature.contains("lts-25jersey");
                if (prevValue != null && migrationValid && (migratedValues = MapSamplingValuesConverter.INSTANCE.convertTableValues(prevTableField.getValues(prevValue.getValue()), context)).isPresent()) {
                    context.addMigration("map_samplingAngle", new Constant("map_samplingAngle", updatedTableField.getUnits(), updatedTableField.formatValue(migratedValues.get()), updatedTableField.getDigits(), Integer.toString(updatedTableField.getRows()), Integer.toString(updatedTableFieldCols)));
                }
            }
        }
    }

    private Optional<ArrayIniField> getValidatedTableArrayIniField(IniField field, UpdateOperationCallbacks callbacks) {
        if (!(field instanceof ArrayIniField)) {
            callbacks.logLine(String.format("WARNING! `%s` ini-field is expected to be `ArrayIniField` instead of %s", "map_samplingAngle", field.getClass().getName()));
            return Optional.empty();
        }
        ArrayIniField arrayField = (ArrayIniField)field;
        FieldType arrayFieldType = arrayField.getType();
        if (arrayFieldType != FieldType.FLOAT) {
            callbacks.logLine(String.format("WARNING! `%s` ini-field is expected to be `FLOAT` instead of `%s`", new Object[]{"map_samplingAngle", arrayFieldType}));
            return Optional.empty();
        }
        return Optional.of(arrayField);
    }
}

