/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini.field;

import com.opensr5.ConfigurationImage;
import com.opensr5.ini.field.IniField;
import com.rusefi.config.Field;
import com.rusefi.config.FieldType;
import com.rusefi.tune.xml.Constant;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Objects;

public class ScalarIniField
extends IniField {
    private final String unit;
    private final FieldType type;
    private final String digits;
    private final double serializationOffset;
    private final double multiplier;

    public ScalarIniField(String name, int offset, String unit, FieldType type, double multiplier, String digits, double serializationOffset) {
        super(name, offset);
        this.unit = unit;
        this.type = type;
        this.digits = digits;
        this.serializationOffset = serializationOffset;
        if (multiplier == 0.0) {
            throw new IllegalArgumentException("Multiplier should not be zero");
        }
        this.multiplier = multiplier;
    }

    @Override
    public String getDigits() {
        return this.digits;
    }

    @Override
    public String getUnits() {
        return this.unit;
    }

    public FieldType getType() {
        return this.type;
    }

    @Override
    public int getSize() {
        return this.type.getStorageSize();
    }

    @Override
    public String getValue(ConfigurationImage image) {
        Field f = new Field(this.getName(), this.getOffset(), this.getType());
        try {
            Double value = f.getValue(image, this.multiplier) + this.serializationOffset;
            return Field.niceToString(value, 5);
        }
        catch (Throwable e) {
            throw new IllegalStateException("While getting " + this.getName(), e);
        }
    }

    @Override
    public void setValue(ConfigurationImage image, Constant constant) {
        Objects.requireNonNull(image, "image for setter");
        Field f = new Field(this.getName(), this.getOffset(), this.getType());
        ByteBuffer wrapped = image.getByteBuffer(this.getOffset(), this.type.getStorageSize());
        ScalarIniField.setValue(wrapped, this.type, constant.getValue(), f.getBitOffset(), this.multiplier, this.serializationOffset);
    }

    public static void setValue(ByteBuffer wrapped, FieldType type, String value, int bitOffset, double multiplier, double serializationOffset) {
        double v = (Double.parseDouble(value) - serializationOffset) / multiplier;
        if (bitOffset != -1) {
            throw new UnsupportedOperationException("For " + value);
        }
        if (type == FieldType.INT8 || type == FieldType.UINT8) {
            wrapped.put((byte)Math.round(v));
        } else if (type == FieldType.INT) {
            wrapped.putInt((int)Math.round(v));
        } else if (type == FieldType.INT16 || type == FieldType.UINT16) {
            wrapped.putShort((short)Math.round(v));
        } else {
            wrapped.putFloat((float)v);
        }
    }

    @Override
    public String toString() {
        return "ScalarIniField{name=" + this.getName() + ", offset=" + this.getOffset() + ", unit='" + this.unit + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static ScalarIniField parse(LinkedList<String> list) {
        String name = list.get(0);
        FieldType type = FieldType.parseTs(list.get(2));
        int offsetWithinConfigurationImage = Integer.parseInt(list.get(3));
        String digits = list.get(9);
        String unit = list.get(4);
        double multiplier = IniField.parseDouble(list.get(5));
        double serializationOffset = IniField.parseDouble(list.get(6));
        return new ScalarIniField(name, offsetWithinConfigurationImage, unit, type, multiplier, digits, serializationOffset);
    }
}

