/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.libopenblt.transport;

import com.devexperts.logging.Logging;
import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortThreadFactory;
import com.rusefi.NamedThreadFactory;
import com.rusefi.libopenblt.transport.IXcpTransport;
import com.rusefi.util.HexBinary;
import java.io.IOException;

public class XcpSerial
implements IXcpTransport {
    private static final Logging log = Logging.getLogging(XcpSerial.class);
    private static final boolean VERBOSE;
    private final Object mLock = new Object();
    private final String mPortName;
    private SerialPort mPort;

    private void checkPort() {
        if (this.mPort == null) {
            throw new IllegalStateException("Port is null");
        }
        if (!this.mPort.isOpen()) {
            throw new IllegalStateException("Port is not open");
        }
    }

    public XcpSerial(String portName) {
        this.mPortName = portName;
        SerialPortThreadFactory.set(new NamedThreadFactory("jSerialComm"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPort != null) {
                throw new IllegalStateException("Cannot connect when already connected");
            }
            SerialPort port = SerialPort.getCommPort(this.mPortName);
            if (!port.openPort()) {
                throw new IOException("Failed to connect to serial port: " + this.mPortName);
            }
            this.mPort = port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPort != null) {
                this.mPort.closePort();
                log.info("disconnect " + this.mPortName);
                this.mPort = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] sendPacket(byte[] request, int timeoutMs, int expectResponseBytes) throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkPort();
            if (VERBOSE) {
                log.info("setComPortTimeouts=" + timeoutMs);
            }
            this.mPort.setComPortTimeouts(272, timeoutMs, timeoutMs);
            byte[] buf = new byte[1 + request.length];
            buf[0] = (byte)request.length;
            System.arraycopy(request, 0, buf, 1, request.length);
            if (VERBOSE) {
                log.info("writeBytes " + HexBinary.printHexBinary(buf));
            }
            int actualWritten = this.mPort.writeBytes(buf, buf.length);
            if (VERBOSE) {
                log.info("actualWritten " + actualWritten);
            }
            if (actualWritten != buf.length) {
                throw new IOException("Cannot write to serial, expected " + buf.length + " turned out " + actualWritten);
            }
            byte[] responseLen = new byte[1];
            int actualRead = this.mPort.readBytes(responseLen, 1);
            if (VERBOSE) {
                log.info("actualRead " + actualRead);
            }
            if (actualRead != 1) {
                throw new IOException("XcpSerial: Cannot read response actual read=" + actualRead + "; request length was " + request.length + ", timeoutMs=" + timeoutMs);
            }
            if (VERBOSE) {
                log.info("actualRead responseLen " + HexBinary.printHexBinary(responseLen));
            }
            byte[] response = new byte[responseLen[0]];
            actualRead = this.mPort.readBytes(response, response.length);
            if (VERBOSE) {
                log.info("actualRead response " + HexBinary.printHexBinary(response));
            }
            return response;
        }
    }

    static {
        String KEY = "XcpSerial.VERBOSE";
        VERBOSE = Boolean.getBoolean(KEY);
        log.info(KEY + "=" + VERBOSE);
    }
}

