/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.binaryprotocol;

import com.devexperts.logging.Logging;
import com.opensr5.ConfigurationImage;
import com.opensr5.ini.IniFileModel;
import com.opensr5.io.ConfigurationImageFile;
import com.opensr5.io.DataListener;
import com.rusefi.ConfigurationImageDiff;
import com.rusefi.NamedThreadFactory;
import com.rusefi.binaryprotocol.BinaryProtocolLogger;
import com.rusefi.binaryprotocol.BinaryProtocolState;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.binaryprotocol.IoHelper;
import com.rusefi.binaryprotocol.MsqFactory;
import com.rusefi.core.FileUtil;
import com.rusefi.core.Pair;
import com.rusefi.core.SensorCentral;
import com.rusefi.core.SignatureHelper;
import com.rusefi.io.CommunicationLoggingListener;
import com.rusefi.io.ConnectionStatusLogic;
import com.rusefi.io.ConnectionStatusValue;
import com.rusefi.io.HeartBeatListeners;
import com.rusefi.io.IoStream;
import com.rusefi.io.LinkManager;
import com.rusefi.io.commands.BurnCommand;
import com.rusefi.io.commands.ByteRange;
import com.rusefi.io.commands.GetOutputsCommand;
import com.rusefi.io.commands.HelloCommand;
import com.rusefi.tune.xml.Msq;
import com.rusefi.ui.livedocs.LiveDocsRegistry;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryProtocol {
    private static final Logging log = Logging.getLogging(BinaryProtocol.class);
    private static final ThreadFactory THREAD_FACTORY = new NamedThreadFactory("ECU text pull", true);
    private static final String USE_PLAIN_PROTOCOL_PROPERTY = "protocol.plain";
    private static final String CONFIGURATION_RUSEFI_BINARY = "current_configuration.rusefi_binary";
    private static final String CONFIGURATION_RUSEFI_XML = "current_configuration.msq";
    public static final boolean PLAIN_PROTOCOL = Boolean.getBoolean("protocol.plain");
    private final LinkManager linkManager;
    private final IoStream stream;
    private final IncomingDataBuffer incomingData;
    private boolean isBurnPending;
    public String signature;
    public boolean isGoodOutputChannels;
    private final BinaryProtocolState state = new BinaryProtocolState();
    private final Object ioLock = new Object();
    private final BinaryProtocolLogger binaryProtocolLogger;
    public static boolean DISABLE_LOCAL_CONFIGURATION_CACHE;
    public boolean isClosed;
    public final CommunicationLoggingListener communicationLoggingListener;

    public static String findCommand(byte command) {
        switch (command) {
            case 80: {
                return "PAGE";
            }
            case 70: {
                return "PROTOCOL";
            }
            case 107: {
                return "CRC_CHECK";
            }
            case 66: {
                return "BURN";
            }
            case 83: {
                return "HELLO";
            }
            case 82: {
                return "READ";
            }
            case 71: {
                return "TS_GET_TEXT";
            }
            case 86: {
                return "GET_FW_VERSION";
            }
            case 67: {
                return "WRITE_CHUNK";
            }
            case 79: {
                return "TS_OUTPUT_COMMAND";
            }
            case 0: {
                return "TS_RESPONSE_OK";
            }
        }
        return "command " + (char)command + "/" + command;
    }

    public IoStream getStream() {
        return this.stream;
    }

    public BinaryProtocol(LinkManager linkManager, IoStream stream) {
        this.linkManager = linkManager;
        this.stream = stream;
        this.communicationLoggingListener = linkManager.messageListener::postMessage;
        this.incomingData = stream.getDataBuffer();
        this.binaryProtocolLogger = new BinaryProtocolLogger(linkManager);
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void doSend(final String command, boolean fireEvent) throws InterruptedException {
        log.info("Sending [" + command + "]");
        if (fireEvent && LinkManager.LOG_LEVEL.isDebugEnabled()) {
            this.communicationLoggingListener.onPortHolderMessage(BinaryProtocol.class, "Sending [" + command + "]");
        }
        Future f = this.linkManager.submit(new Runnable(){

            @Override
            public void run() {
                BinaryProtocol.this.sendTextCommand(command);
            }

            public String toString() {
                return "Runnable for " + command;
            }
        });
        try {
            f.get(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (TimeoutException e) {
            log.error("timeout sending [" + command + "] giving up: " + e);
            return;
        }
        this.linkManager.getCommandQueue().handleConfirmationMessage("confirmation_" + command);
    }

    public static String getSignature(IoStream stream) throws IOException {
        HelloCommand.send(stream);
        return HelloCommand.getHelloResponse(stream.getDataBuffer());
    }

    public String connectAndReadConfiguration(Arguments arguments, DataListener listener) {
        try {
            this.signature = BinaryProtocol.getSignature(this.stream);
            log.info("Got " + this.signature + " signature");
            SignatureHelper.downloadIfNotAvailable(SignatureHelper.getUrl(this.signature));
        }
        catch (IOException e) {
            return "Failed to read signature " + e;
        }
        String errorMessage = this.validateConfigVersion();
        if (errorMessage != null) {
            return errorMessage;
        }
        this.readImage(arguments, 21928);
        if (this.isClosed) {
            return "Failed to read calibration";
        }
        this.startPullThread(listener);
        this.binaryProtocolLogger.start();
        return null;
    }

    private String validateConfigVersion() {
        String msg;
        int requestSize = 4;
        byte[] packet = GetOutputsCommand.createRequest(124, requestSize);
        byte[] response = this.executeCommand('O', packet, msg = "load TS_CONFIG_VERSION");
        if (!IoHelper.checkResponseCode(response) || response.length != requestSize + 1) {
            this.close();
            return "Failed to " + msg;
        }
        int actualVersion = FileUtil.littleEndianWrap(response, 1, requestSize).getInt();
        if (actualVersion != 20230721) {
            String errorMessage = "Incompatible firmware format=" + actualVersion + " while format 20230721 expected\nrecommended fix: use a compatible console version  OR  flash new firmware";
            log.error(errorMessage);
            return errorMessage;
        }
        return null;
    }

    private void startPullThread(final DataListener textListener) {
        if (!this.linkManager.COMMUNICATION_QUEUE.isEmpty()) {
            log.info("Current queue size: " + this.linkManager.COMMUNICATION_QUEUE.size());
        }
        Runnable textPull = new Runnable(){

            @Override
            public void run() {
                while (!BinaryProtocol.this.isClosed) {
                    if (BinaryProtocol.this.linkManager.COMMUNICATION_QUEUE.isEmpty() && BinaryProtocol.this.linkManager.getNeedPullData()) {
                        BinaryProtocol.this.linkManager.submit(new Runnable(){
                            private final boolean verbose = false;

                            @Override
                            public void run() {
                                String text;
                                BinaryProtocol.this.isGoodOutputChannels = BinaryProtocol.this.requestOutputChannels();
                                if (BinaryProtocol.this.isGoodOutputChannels) {
                                    HeartBeatListeners.onDataArrived();
                                }
                                BinaryProtocol.this.binaryProtocolLogger.compositeLogic(BinaryProtocol.this);
                                if (BinaryProtocol.this.linkManager.isNeedPullText() && (text = BinaryProtocol.this.requestPendingTextMessages()) != null) {
                                    textListener.onDataArrived((text + "\r\n").getBytes());
                                }
                                if (BinaryProtocol.this.linkManager.isNeedPullLiveData()) {
                                    LiveDocsRegistry.LiveDataProvider liveDataProvider = LiveDocsRegistry.getLiveDataProvider();
                                    LiveDocsRegistry.INSTANCE.refresh(liveDataProvider);
                                }
                            }
                        });
                    }
                    BinaryProtocol.sleep(100L);
                }
                log.info("Port shutdown: Stopping text pull");
            }
        };
        Thread tr = THREAD_FACTORY.newThread(textPull);
        tr.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropPending() {
        Object object = this.ioLock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.incomingData.dropPending();
        }
    }

    public void uploadChanges(ConfigurationImage newVersion) {
        Pair<Integer, Integer> range;
        ConfigurationImage current = this.getControllerConfiguration();
        newVersion = newVersion.clone();
        int offset = 0;
        while (offset < current.getSize() && (range = ConfigurationImageDiff.findDifferences(current, newVersion, offset)) != null) {
            int size = (Integer)range.second - (Integer)range.first;
            log.info("Need to patch: " + range + ", size=" + size);
            byte[] oldBytes = current.getRange((Integer)range.first, size);
            log.info("old " + Arrays.toString(oldBytes));
            byte[] newBytes = newVersion.getRange((Integer)range.first, size);
            log.info("new " + Arrays.toString(newBytes));
            this.writeData(newVersion.getContent(), 0, (Integer)range.first, size);
            offset = (Integer)range.second;
        }
        this.burn();
        this.setController(newVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] receivePacket(String msg) throws IOException {
        long start = System.currentTimeMillis();
        Object object = this.ioLock;
        synchronized (object) {
            return this.incomingData.getPacket(5000, msg, start);
        }
    }

    public void readImage(Arguments arguments, int size) {
        ConfigurationImage image = this.getAndValidateLocallyCached();
        if (image == null && (image = this.readFullImageFromController(arguments, size)) == null) {
            return;
        }
        this.setController(image);
        log.info("Got configuration from controller " + size + " byte(s)");
        ConnectionStatusLogic.INSTANCE.setValue(ConnectionStatusValue.CONNECTED);
    }

    @Nullable
    private ConfigurationImage readFullImageFromController(Arguments arguments, int size) {
        ConfigurationImage image = new ConfigurationImage(size);
        int offset = 0;
        long start = System.currentTimeMillis();
        log.info("Reading from controller...");
        while (offset < image.getSize() && System.currentTimeMillis() - start < 60000L) {
            if (this.isClosed) {
                return null;
            }
            int remainingSize = image.getSize() - offset;
            int requestSize = Math.min(remainingSize, 750);
            byte[] packet = new byte[4];
            ByteRange.packOffsetAndSize(offset, requestSize, packet);
            byte[] response = this.executeCommand('R', packet, "load image offset=" + offset);
            if (!IoHelper.checkResponseCode(response) || response.length != requestSize + 1) {
                if (BinaryProtocol.extractCode(response) == 132) {
                    throw new IllegalStateException("TS_RESPONSE_OUT_OF_RANGE ECU/console version mismatch?");
                }
                String code = response == null || response.length == 0 ? "empty" : "ERROR_CODE=" + BinaryProtocol.getCode(response);
                String info = response == null ? "NO RESPONSE" : code + " length=" + response.length;
                log.info("readImage: ERROR UNEXPECTED Something is wrong, retrying... " + info);
                continue;
            }
            HeartBeatListeners.onDataArrived();
            ConnectionStatusLogic.INSTANCE.markConnected();
            System.arraycopy(response, 1, image.getContent(), offset, requestSize);
            offset += requestSize;
        }
        if (arguments != null && arguments.saveFile) {
            try {
                ConfigurationImageFile.saveToFile(image, CONFIGURATION_RUSEFI_BINARY);
                Msq tune = MsqFactory.valueOf(image, IniFileModel.getInstance());
                tune.writeXmlFile(CONFIGURATION_RUSEFI_XML);
            }
            catch (Exception e) {
                System.err.println("Ignoring " + e);
            }
        }
        return image;
    }

    private static String getCode(byte[] response) {
        int b = BinaryProtocol.extractCode(response);
        switch (b) {
            case 130: {
                return "CRC_FAILURE";
            }
            case 131: {
                return "UNRECOGNIZED_COMMAND";
            }
            case 132: {
                return "OUT_OF_RANGE";
            }
            case 141: {
                return "FRAMING_ERROR";
            }
            case 128: {
                return "TS_RESPONSE_UNDERRUN";
            }
        }
        return Integer.toString(b);
    }

    private static int extractCode(byte[] response) {
        if (response == null || response.length < 1) {
            return -1;
        }
        return response[0] & 0xFF;
    }

    private ConfigurationImage getAndValidateLocallyCached() {
        ConfigurationImage localCached;
        if (DISABLE_LOCAL_CONFIGURATION_CACHE) {
            return null;
        }
        try {
            localCached = ConfigurationImageFile.readFromFile(CONFIGURATION_RUSEFI_BINARY);
        }
        catch (IOException e) {
            System.err.println("Error reading current_configuration.rusefi_binary: no worries " + e);
            return null;
        }
        if (localCached != null) {
            int crcOfLocallyCachedConfiguration = IoHelper.getCrc32(localCached.getContent());
            log.info(String.format("current_configuration.rusefi_binary Local cache CRC %x\n", crcOfLocallyCachedConfiguration));
            int crcFromController = this.getCrcFromController(localCached.getSize());
            if (crcOfLocallyCachedConfiguration == crcFromController) {
                return localCached;
            }
        }
        return null;
    }

    public int getCrcFromController(int configSize) {
        byte[] packet = BinaryProtocol.createRequestCrcPayload(configSize);
        byte[] response = this.executeCommand('k', packet, "get CRC32");
        if (IoHelper.checkResponseCode(response) && response.length == 5) {
            ByteBuffer bb = ByteBuffer.wrap(response, 1, 4);
            bb.order(ByteOrder.BIG_ENDIAN);
            int crc32FromController = bb.getInt();
            short crc16FromController = (short)crc32FromController;
            log.info(String.format("rusEFI says tune CRC32 0x%x %d\n", crc32FromController, crc32FromController));
            log.info(String.format("rusEFI says tune CRC16 0x%x %d\n", crc16FromController, crc16FromController));
            return crc32FromController;
        }
        return -1;
    }

    private static byte[] createRequestCrcPayload(int size) {
        byte[] packet = new byte[4];
        ByteRange.packOffsetAndSize(0, size, packet);
        return packet;
    }

    public byte[] executeCommand(char opcode, String msg) {
        return this.executeCommand(opcode, null, msg);
    }

    public byte[] executeCommand(char opcode, byte[] packet, String msg) {
        if (this.isClosed) {
            return null;
        }
        byte[] fullRequest = BinaryProtocol.getFullRequest((byte)opcode, packet);
        try {
            this.linkManager.assertCommunicationThread();
            this.dropPending();
            this.sendPacket(fullRequest);
            return this.receivePacket(msg);
        }
        catch (IOException e) {
            log.error(msg + ": executeCommand failed: " + e);
            this.close();
            return null;
        }
    }

    @NotNull
    public static byte[] getFullRequest(byte opcode, byte[] packet) {
        byte[] fullRequest;
        if (packet != null) {
            fullRequest = new byte[packet.length + 1];
            System.arraycopy(packet, 0, fullRequest, 1, packet.length);
        } else {
            fullRequest = new byte[]{opcode};
        }
        return fullRequest;
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.binaryProtocolLogger.close();
        this.stream.close();
    }

    public void writeData(byte[] content, int contentOffset, int ecuOffset, int size) {
        byte[] response;
        this.isBurnPending = true;
        byte[] packet = new byte[4 + size];
        ByteRange.packOffsetAndSize(ecuOffset, size, packet);
        System.arraycopy(content, contentOffset, packet, 4, size);
        long start = System.currentTimeMillis();
        while (!(this.isClosed || System.currentTimeMillis() - start >= 5000L || IoHelper.checkResponseCode(response = this.executeCommand('C', packet, "writeImage")) && response.length == 1)) {
            log.error("writeData: Something is wrong, retrying...");
        }
    }

    public void burn() {
        if (!this.isBurnPending) {
            return;
        }
        log.info("Need to burn");
        while (true) {
            if (this.isClosed) {
                return;
            }
            boolean isGoodBurn = BurnCommand.execute(this);
            if (isGoodBurn) break;
            log.warn("BURN HAS FAILED?! Will retry");
        }
        log.info("BURN OK");
        log.info("DONE");
        this.isBurnPending = false;
    }

    public void setController(ConfigurationImage controller) {
        this.state.setController(controller);
    }

    public ConfigurationImage getControllerConfiguration() {
        return this.state.getControllerConfiguration();
    }

    private void sendPacket(byte[] command) throws IOException {
        this.stream.sendPacket(command);
    }

    private boolean sendTextCommand(String text) {
        byte[] command = BinaryProtocol.getTextCommandBytesOnlyText(text);
        long start = System.currentTimeMillis();
        while (!this.isClosed && System.currentTimeMillis() - start < 5000L) {
            byte[] response = this.executeCommand('E', command, "execute");
            if (!IoHelper.checkResponseCode(response, (byte)7) || response.length != 1) continue;
            return false;
        }
        return true;
    }

    public static byte[] getTextCommandBytes(String text) {
        byte[] asBytes = text.getBytes();
        byte[] command = new byte[asBytes.length + 1];
        command[0] = 69;
        System.arraycopy(asBytes, 0, command, 1, asBytes.length);
        return command;
    }

    public static byte[] getTextCommandBytesOnlyText(String text) {
        return text.getBytes();
    }

    public String requestPendingTextMessages() {
        if (this.isClosed) {
            return null;
        }
        try {
            byte[] response = this.executeCommand('G', "text");
            if (response == null) {
                log.error("ERROR: TS_GET_TEXT failed");
                return null;
            }
            if (response != null && response.length == 1) {
                Thread.sleep(100L);
            }
            return new String(response, 1, response.length - 1);
        }
        catch (InterruptedException e) {
            log.error(e.toString());
            return null;
        }
    }

    public boolean requestOutputChannels() {
        int chunkSize;
        if (this.isClosed) {
            return false;
        }
        byte[] reassemblyBuffer = new byte[1465];
        reassemblyBuffer[0] = 0;
        int reassemblyIdx = 0;
        for (int remaining = 1464; remaining > 0; remaining -= chunkSize) {
            chunkSize = Math.min(remaining, 750);
            byte[] response = this.executeCommand('O', GetOutputsCommand.createRequest(reassemblyIdx, chunkSize), "output channels");
            if (response == null || response.length != chunkSize + 1 || response[0] != 0) {
                return false;
            }
            System.arraycopy(response, 1, reassemblyBuffer, reassemblyIdx + 1, chunkSize);
            reassemblyIdx += chunkSize;
        }
        this.state.setCurrentOutputs(reassemblyBuffer);
        SensorCentral.getInstance().grabSensorValues(reassemblyBuffer);
        return true;
    }

    public BinaryProtocolState getBinaryProtocolState() {
        return this.state;
    }

    public static class Arguments {
        final boolean saveFile;

        public Arguments(boolean saveFile) {
            this.saveFile = saveFile;
        }
    }
}

