/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.jobs;

import com.devexperts.logging.Logging;
import com.rusefi.ConnectivityContext;
import com.rusefi.PortResult;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.CalibrationsHelper;
import com.rusefi.maintenance.jobs.AsyncJobWithContext;
import com.rusefi.maintenance.jobs.ImportTuneJobContext;
import com.rusefi.maintenance.jobs.JobHelper;
import com.rusefi.tune.xml.Msq;
import com.rusefi.ui.basic.SingleAsyncJobExecutor;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBException;

public class ImportTuneJob
extends AsyncJobWithContext<ImportTuneJobContext> {
    private static final Logging log = Logging.getLogging(ImportTuneJob.class);
    private final ConnectivityContext connectivityContext;

    public ImportTuneJob(PortResult port, Msq tuneToImport, ConnectivityContext connectivityContext) {
        super("Load Tune", new ImportTuneJobContext(port, tuneToImport));
        this.connectivityContext = connectivityContext;
    }

    public static void importTuneIntoDevice(PortResult port, JComponent parent, ConnectivityContext connectivityContext, String tuneFileName, SingleAsyncJobExecutor singleAsyncJobExecutor) {
        try {
            Msq tuneToImport = Msq.readTune(tuneFileName);
            singleAsyncJobExecutor.startJob(new ImportTuneJob(port, tuneToImport, connectivityContext), parent);
        }
        catch (JAXBException e) {
            String errorMsg = String.format("Failed to load tune to import from file %s", tuneFileName);
            log.error(errorMsg, e);
            JOptionPane.showMessageDialog(parent, errorMsg, "Error", 0);
        }
    }

    @Override
    public void doJob(UpdateOperationCallbacks callbacks, Runnable onJobFinished) {
        JobHelper.doJob(() -> {
            if (CalibrationsHelper.importTune(((ImportTuneJobContext)this.context).getPort().port, ((ImportTuneJobContext)this.context).getTuneToImport(), callbacks, this.connectivityContext)) {
                callbacks.done();
            } else {
                callbacks.error();
            }
        }, onJobFinished);
    }
}

