/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.stream;

import com.rusefi.composite.CompositeEvent;
import com.rusefi.stream.LogicdataOutputStream;
import com.rusefi.stream.StreamFile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class LogicdataStreamFile
extends StreamFile {
    private static final int frequency = 1000000;
    private static final int frequencyDivided = 100000;
    private static final char magic = '\u007f';
    private static final char version = '\u0013';
    private static final String title = "Data save2";
    private static final int BLOCK = 24;
    private static final int CHANNEL_BLOCK = 22;
    private static final int SUB = 84;
    private static final int FLAG_NOTEMPTY = 2;
    private static final int FLAG_NOTEMPTY_LONG = 3;
    private static final int FLAG_EMPTY = 5;
    private static final long RECORD_FIRST = 1L;
    private static final long RECORD_NEXT = 2L;
    private static final int LOGIC4 = 16637;
    private static final int LOGIC8 = 26427;
    private static final int LOGIC1 = 1981;
    private static final int LOGIC16 = 21311;
    private static final int[] CHANNEL_FLAGS = new int[]{1262987, 255, 41209, 65535, 65280, 0xFF0000, 15736992, 0};
    private static final long SIGN_FLAG = 0x80000000L;
    private static final int numChannels = 16;
    private static final int reservedDurationInSamples = 10;
    private static int realDurationInSamples = 0;
    private static int scaledDurationInSamples = 0;
    private final String fileName;
    private final List<CompositeEvent> eventsBuffer = new ArrayList<CompositeEvent>();
    private static final String[] channelNames = new String[]{"Primary", "Secondary", "Trg", "Sync", "Coil", "Injector", "Channel 6", "Channel 7", "Channel 8", "Channel 9", "Channel 10", "Channel 11", "Channel 12", "Channel 13", "Channel 14", "Channel 15"};

    public LogicdataStreamFile(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void append(List<CompositeEvent> events) {
        try {
            if (this.stream == null) {
                this.stream = new LogicdataOutputStream(Files.newOutputStream(Paths.get(this.fileName, new String[0]), new OpenOption[0]));
                this.writeHeader();
            }
            this.eventsBuffer.addAll(events);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeEvents(List<CompositeEvent> events) throws IOException {
        if (events == null || events.size() < 2) {
            return;
        }
        long firstRecordTs = events.get(0).getTimestamp();
        long lastRecordTs = events.get(events.size() - 1).getTimestamp();
        realDurationInSamples = (int)(lastRecordTs + firstRecordTs);
        scaledDurationInSamples = realDurationInSamples / 4;
        this.writeChannelDataHeader();
        if (events.get(0).getTimestamp() > 0L) {
            events.add(0, new CompositeEvent(0L, false, false, false, false, false, false));
        }
        for (int ch = 0; ch < 16; ++ch) {
            boolean useLongDeltas = false;
            ArrayList<Long> chDeltas = new ArrayList<Long>();
            int chPrevState = -1;
            int chInitialState = -1;
            long prevTs = -1L;
            long initialTs = 0L;
            for (CompositeEvent event : events) {
                int chState = this.getChannelState(ch, event);
                long ts = event.getTimestamp();
                if (chPrevState == -1) {
                    chPrevState = chState;
                }
                if (prevTs == -1L) {
                    prevTs = ts;
                }
                if (chInitialState == -1) {
                    chInitialState = chState;
                    initialTs = ts;
                }
                if (chState == chPrevState) continue;
                long delta = ts - prevTs;
                if (delta > 32767L) {
                    useLongDeltas = true;
                }
                if (chState == 0) {
                    delta |= 0x80000000L;
                }
                chDeltas.add(delta);
                prevTs = ts;
                chPrevState = chState;
            }
            if (useLongDeltas) {
                System.out.println("using long deltas for ch #" + ch);
            }
            this.writeChannelData(ch, chDeltas, chPrevState, (int)prevTs, chInitialState, (int)initialTs, useLongDeltas);
        }
        this.writeChannelDataFooter();
        this.stream.flush();
    }

    private int getChannelState(int ch, CompositeEvent event) {
        switch (ch) {
            case 0: {
                return event.isPrimaryTriggerAsInt();
            }
            case 1: {
                return event.isSecondaryTriggerAsInt();
            }
            case 2: {
                return event.isTrgAsInt();
            }
            case 3: {
                return event.isSyncAsInt();
            }
        }
        if (ch >= 4 && ch < 10) {
            return event.isCoil(ch - 4);
        }
        if (ch >= 10 && ch < 16) {
            return event.isInjector(ch - 10);
        }
        return -1;
    }

    private void writeHeader() throws IOException {
        this.writeByte(127);
        this.stream.writeVarLength(19L);
        this.stream.writeString(title);
        this.stream.flush();
        this.stream.writeVarLength(24L);
        this.stream.writeVarLength(84L);
        this.stream.writeVarLength(1000000L);
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(10L);
        this.stream.writeVarLength(100000L);
        this.write(0, 2);
        this.stream.writeVarLength(16L);
        this.stream.writeVarLength(24L);
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(24L);
        for (int i = 0; i < 16; ++i) {
            this.writeId(i, 1);
        }
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(24L);
        this.writeId(7, 7);
        this.stream.writeVarLength(84L);
        this.stream.writeVarLength(0L);
    }

    private void writeChannelHeader(int ch) throws IOException {
        this.stream.writeVarLength(255L);
        this.stream.writeVarLength(ch);
        this.stream.writeString(channelNames[ch]);
        this.write(0, 2);
        this.stream.writeDouble(1.0);
        this.stream.writeVarLength(0L);
        this.stream.writeDouble(0.0);
        this.stream.writeVarLength(1L);
        this.stream.writeDouble(0.0);
        if (ch == 15) {
            this.stream.writeVarLength(0L);
        } else {
            this.writeId(1 + ch, 1);
            for (int i = 0; i < 3; ++i) {
                this.stream.writeVarLength(CHANNEL_FLAGS[ch & 7] >> i * 8 & 0xFF);
            }
        }
    }

    private void writeChannelDataHeader() throws IOException {
        this.stream.writeVarLength(24L);
        this.stream.writeVarLength(scaledDurationInSamples);
        this.stream.writeVarLength(0L);
        this.write(0, 4);
        this.stream.writeVarLength(16L);
        this.write(0, 3);
        this.writeId(0, 1);
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(24L);
        this.write(0, 3);
        for (int i = 0; i < 16; ++i) {
            this.writeChannelHeader(i);
        }
        this.stream.writeVarLength(24L);
        this.write(new int[]{84, 84, 0, 84, 0, 84});
        this.write(0, 6);
        this.stream.writeVarLength(24L);
        this.write(0, 2);
        this.stream.writeVarLength(10L);
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(84L);
        this.stream.writeVarLength(10L);
        this.stream.writeVarLength(100000L);
        this.write(0, 2);
        this.stream.writeVarLength(84L);
        this.write(0, 2);
        this.stream.writeVarLength(1L);
        this.write(0, 3);
        this.writeId(7, 0);
        this.stream.writeVarLength(24L);
        this.write(new int[]{realDurationInSamples, realDurationInSamples, realDurationInSamples});
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(84L);
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(24L);
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(24L);
        this.write(84, 4);
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(24L);
        this.stream.writeVarLength(1000000L);
        this.write(0, 3);
        this.stream.writeVarLength(1L);
        this.write(0, 3);
        this.writeId(0, 0);
        this.write(new int[]{0, 1, 1, 0, 1, 19});
        this.stream.writeVarLength(84L);
        this.stream.writeVarLength(24L);
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(realDurationInSamples);
        this.write(0, 2);
        this.stream.writeVarLength(16L);
        this.write(new int[]{1, 0, 1});
    }

    private void writeChannelData(int ch, List<Long> chDeltas, int chLastState, int lastRecord, int chInitialState, int initialRecord, boolean useLongDeltas) throws IOException {
        int numEdges = chDeltas.size();
        if (numEdges == 0) {
            initialRecord = 0;
            lastRecord = 0;
        }
        this.stream.writeVarLength(22L);
        if (ch == 0) {
            this.stream.writeVarLength(84L);
            this.stream.writeVarLength(24L);
        }
        this.stream.writeVarLength(ch + 1);
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(realDurationInSamples);
        this.stream.writeVarLength(1L);
        this.stream.writeVarLength(lastRecord);
        int numSamplesLeft = realDurationInSamples - lastRecord;
        this.stream.writeVarLength(numSamplesLeft);
        this.stream.writeVarLength(chLastState);
        int chFlag = numEdges == 0 ? 5 : (useLongDeltas ? 3 : 2);
        this.stream.writeVarLength(chFlag);
        if (ch == 0) {
            this.stream.writeVarLength(0L);
            this.stream.writeVarLength(24L);
            this.write(0, 11);
            if (useLongDeltas) {
                this.stream.writeVarLength(24L);
                this.write(0, 6);
            }
            this.stream.writeVarLength(24L);
        } else {
            this.write(0, 10);
            if (useLongDeltas) {
                this.write(0, 5);
            }
        }
        this.stream.writeVarLength(numEdges);
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(numEdges);
        this.stream.writeVarLength(numEdges >> 15);
        this.stream.writeVarLength(numEdges & Short.MAX_VALUE);
        this.writeEdges(chDeltas, useLongDeltas);
        if (ch == 0) {
            this.stream.writeVarLength(24L);
            this.write(0, 6);
            if (!useLongDeltas) {
                this.stream.writeVarLength(24L);
                this.write(0, 6);
            }
            this.stream.writeVarLength(24L);
        } else {
            this.write(0, 4);
            if (!useLongDeltas) {
                this.write(0, 5);
            }
        }
        if (numEdges == 0) {
            this.write(0, 5);
            return;
        }
        int numRecords = 1;
        this.stream.writeVarLength(numRecords);
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(numRecords);
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(numRecords);
        this.writeRecord(0L, 0L, -1L, chFlag);
    }

    private void writeEdges(List<Long> chDeltas, boolean useLongDeltas) throws IOException {
        for (long d : chDeltas) {
            if (!useLongDeltas && (d & 0x80000000L) == 0x80000000L) {
                d = d & 0x7FFFL | 0x8000L;
            }
            this.writeByte((byte)(d & 0xFFL));
            this.writeByte((byte)(d >> 8 & 0xFFL));
            if (!useLongDeltas) continue;
            this.writeByte((byte)(d >> 16 & 0xFFL));
            this.writeByte((byte)(d >> 24 & 0xFFL));
        }
        this.writeByte(0);
    }

    private void writeByte(int i) throws IOException {
        this.stream.writeByte(i);
    }

    private void writeWord(int d) throws IOException {
        this.writeByte((byte)(d & 0xFF));
        this.writeByte((byte)(d >> 8 & 0xFF));
    }

    private void writeQword(long l) throws IOException {
        for (int i = 7; i >= 0; --i) {
            this.writeByte((byte)(l & 0xFFL));
            l >>= 8;
        }
    }

    private void writeRecord(long record, long idx, long prevIdx, long type) throws IOException {
        this.writeQword(record);
        this.writeQword(idx);
        this.writeQword(prevIdx);
        this.writeQword(type);
    }

    private void writeChannelDataFooter() throws IOException {
        this.write(0, 3);
        this.stream.writeVarLength(1L);
        this.stream.writeVarLength(1L);
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(16L);
    }

    @Override
    protected void writeFooter() throws IOException {
        int i;
        if (this.stream == null) {
            return;
        }
        System.out.println("Writing " + this.eventsBuffer.size() + " event(s)");
        this.writeEvents(this.eventsBuffer);
        this.stream.writeVarLength(24L);
        for (i = 0; i < 16; ++i) {
            this.writeId(i, 1);
        }
        this.stream.writeVarLength(1L);
        this.writeId(16, 24);
        for (i = 0; i < 16; ++i) {
            this.writeId(i, 1);
        }
        this.stream.writeVarLength(1L);
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(1000000L);
        this.write(0, 16);
        this.stream.writeVarLength(1L);
        this.stream.writeVarLength(35L);
        this.stream.writeVarLength(84L);
        this.stream.writeVarLength(24L);
        this.stream.writeVarLength(17L);
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(-1L);
        this.stream.writeVarLength(0xFFFFFFFFL);
        this.stream.writeVarLength(1L);
        this.write(0, 3);
        this.stream.writeVarLength(24L);
        this.stream.writeVarLength(0L);
        this.stream.writeVarLength(24L);
        this.stream.writeVarLength(0L);
        this.stream.writeDouble(1.0);
        this.stream.writeVarLength(84L);
        this.write(0, 6);
        this.stream.writeVarLength(1L);
        this.write(0, 4);
        this.stream.writeVarLength(1L);
        this.stream.writeVarLength(41L);
        this.stream.writeVarLength(84L);
        this.writeTimingMarker();
        this.stream.flush();
        System.out.println("writeFooter " + this.fileName);
    }

    private void writeTimingMarker() throws IOException {
        this.stream.writeVarLength(24L);
        this.stream.writeVarLength(18L);
        this.write(0, 4);
        this.stream.writeString("Timing Marker Pair");
        this.stream.writeString("A1");
        this.stream.writeString("A2");
        this.write(0, 2);
        this.stream.writeVarLength(84L);
        this.write(0, 9);
    }

    private void writeId(int i1, int i2) throws IOException {
        this.stream.writeVarLength(21311L);
        this.stream.writeVarLength(i1);
        this.stream.writeVarLength(i2);
    }

    private void write(int value, int num) throws IOException {
        for (int i = 0; i < num; ++i) {
            this.stream.writeVarLength(value);
        }
    }

    private void write(int[] values) throws IOException {
        for (int value : values) {
            this.stream.writeVarLength(value);
        }
    }

    private void writeRaw(int value, int num) throws IOException {
        for (int i = 0; i < num; ++i) {
            this.writeByte(value);
        }
    }
}

