/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public enum DisabledImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private int radWidth = 0;
    private BufferedImage radDisabledImage = this.UTIL.createImage(1, 1, 3);
    private int linWidth = 0;
    private int linHeight = 0;
    private BufferedImage linDisabledImage = this.UTIL.createImage(1, 1, 3);
    private final Color DISABLED_COLOR = new Color(102, 102, 102, 178);

    public BufferedImage createRadialDisabled(int n) {
        if (n <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.radWidth == n) {
            return this.radDisabledImage;
        }
        this.radDisabledImage.flush();
        this.radDisabledImage = this.UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = this.radDisabledImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = this.radDisabledImage.getWidth();
        int n3 = this.radDisabledImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031);
        graphics2D.setColor(this.DISABLED_COLOR);
        graphics2D.fill(double_);
        graphics2D.dispose();
        this.radWidth = n;
        return this.radDisabledImage;
    }

    public BufferedImage createLinearDisabled(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.linWidth == n && this.linHeight == n2) {
            return this.linDisabledImage;
        }
        this.linDisabledImage.flush();
        this.linDisabledImage = this.UTIL.createImage(n, n2, 3);
        Graphics2D graphics2D = this.linDisabledImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n3 = this.linDisabledImage.getWidth();
        int n4 = this.linDisabledImage.getHeight();
        double d = n3 >= n4 ? (double)n4 * 0.05 : (double)n3 * 0.05;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, n3, n4, d, d);
        double d2 = n3 >= n4 ? d - (((RectangularShape)double_).getHeight() - (double)n4 - 2.0) / 2.0 : d - (((RectangularShape)double_).getWidth() - (double)n3 - 2.0) / 2.0;
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(1.0, 1.0, n3 - 2, n4 - 2, d2, d2);
        double d3 = n3 >= n4 ? (double)n4 * 0.02857143 : (double)n3 * 0.02857143;
        RoundRectangle2D.Double double_3 = new RoundRectangle2D.Double(((RectangularShape)double_2).getX() + 16.0, ((RectangularShape)double_2).getY() + 16.0, ((RectangularShape)double_2).getWidth() - 32.0, ((RectangularShape)double_2).getHeight() - 32.0, d3, d3);
        double d4 = d3 - 1.0;
        RoundRectangle2D.Double double_4 = new RoundRectangle2D.Double(((RectangularShape)double_3).getX() + 1.0, ((RectangularShape)double_3).getY() + 1.0, ((RectangularShape)double_3).getWidth() - 2.0, ((RectangularShape)double_3).getHeight() - 2.0, d4, d4);
        graphics2D.setColor(this.DISABLED_COLOR);
        graphics2D.fill(double_4);
        graphics2D.dispose();
        this.linWidth = n;
        this.linHeight = n2;
        return this.linDisabledImage;
    }

    public String toString() {
        return "DisabledImageFactory";
    }
}

