/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.NumberFormat;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.Section;
import eu.hansolo.steelseries.tools.TicklabelOrientation;
import eu.hansolo.steelseries.tools.TickmarkType;
import eu.hansolo.steelseries.tools.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public enum TickmarkImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private static final BasicStroke MAJOR_TICKMARK_STROKE;
    private static final BasicStroke MEDIUM_TICKMARK_STROKE;
    private static final BasicStroke MINOR_TICKMARK_STROKE;
    private static final int BASE = 10;
    private NumberFormat numberFormat = NumberFormat.STANDARD;
    private BufferedImage imageBufferRad = this.UTIL.createImage(1, 1, 3);
    private int widthBufferRad = 200;
    private double minValueBufferRad = 0.0;
    private double maxValueBufferRad = 100.0;
    private int noOfMinorTicksBufferRad = 0;
    private int noOfMajorTicksBufferRad = 0;
    private double minorTickSpacingBufferRad = 10.0;
    private double majorTickSpacingBufferRad = 10.0;
    private GaugeType gaugeTypeBufferRad = GaugeType.TYPE4;
    private TickmarkType minorTickmarkTypeBufferRad = TickmarkType.LINE;
    private TickmarkType majorTickmarkTypeBufferRad = TickmarkType.LINE;
    private boolean ticksVisibleBufferRad = true;
    private boolean ticklabelsVisibleBufferRad = true;
    private boolean tickmarkSectionsVisibleBufferRad = false;
    private boolean minorTicksVisibleBufferRad = true;
    private boolean majorTicksVisibleBufferRad = true;
    private NumberFormat numberFormatBufferRad = NumberFormat.AUTO;
    private BackgroundColor backgroundColorBufferRad = BackgroundColor.DARK_GRAY;
    private Color tickmarkColorBufferRad;
    private boolean tickmarkColorFromThemeBufferRad;
    private List<Section> tickmarkSectionsBufferRad;
    private boolean sectionTickmarksOnlyBufferRad;
    private List<Section> sectionsBufferRad;
    private float radiusFactorBufferRad;
    private float textDistanceFactorBufferRad;
    private Point2D centerBufferRad;
    private Point2D offsetBufferRad;
    private Orientation orientationBufferRad;
    private TicklabelOrientation ticklabelOrientationBufferRad;
    private boolean niceScaleRad;
    private boolean logScaleRad;
    private BufferedImage imageBufferLin;
    private int widthBufferLin;
    private int heightBufferLin;
    private double minValueBufferLin;
    private double maxValueBufferLin;
    private int noOfMinorTicksBufferLin;
    private int noOfMajorTicksBufferLin;
    private double minorTickSpacingBufferLin;
    private double majorTickSpacingBufferLin;
    private TickmarkType minorTickmarkTypeBufferLin;
    private TickmarkType majorTickmarkTypeBufferLin;
    private boolean ticksVisibleBufferLin;
    private boolean ticklabelsVisibleBufferLin;
    private boolean minorTicksVisibleBufferLin;
    private boolean majorTicksVisibleBufferLin;
    private NumberFormat numberFormatBufferLin;
    private boolean tickmarkSectionsVisibleBufferLin;
    private BackgroundColor backgroundColorBufferLin;
    private Color tickmarkColorBufferLin;
    private boolean tickmarkColorFromThemeBufferLin;
    private List<Section> tickmarkSectionsBufferLin;
    private Point2D offsetBufferLin;
    private Orientation orientationBufferLin;
    private boolean niceScaleLin;
    private boolean logScaleLin;

    private TickmarkImageFactory() {
        this.tickmarkColorBufferRad = this.backgroundColorBufferRad.LABEL_COLOR;
        this.tickmarkColorFromThemeBufferRad = true;
        this.tickmarkSectionsBufferRad = new ArrayList<Section>(10);
        this.sectionTickmarksOnlyBufferRad = false;
        this.sectionsBufferRad = new ArrayList<Section>(10);
        this.radiusFactorBufferRad = 0.38f;
        this.textDistanceFactorBufferRad = 0.09f;
        this.centerBufferRad = new Point2D.Double();
        this.offsetBufferRad = new Point2D.Double();
        this.orientationBufferRad = Orientation.NORTH;
        this.ticklabelOrientationBufferRad = TicklabelOrientation.TANGENT;
        this.niceScaleRad = true;
        this.logScaleRad = false;
        this.imageBufferLin = this.UTIL.createImage(1, 1, 3);
        this.widthBufferLin = 140;
        this.heightBufferLin = 0;
        this.minValueBufferLin = 0.0;
        this.maxValueBufferLin = 100.0;
        this.noOfMinorTicksBufferLin = 0;
        this.noOfMajorTicksBufferLin = 0;
        this.minorTickSpacingBufferLin = 10.0;
        this.majorTickSpacingBufferLin = 10.0;
        this.minorTickmarkTypeBufferLin = TickmarkType.LINE;
        this.majorTickmarkTypeBufferLin = TickmarkType.LINE;
        this.ticksVisibleBufferLin = true;
        this.ticklabelsVisibleBufferLin = true;
        this.minorTicksVisibleBufferLin = true;
        this.majorTicksVisibleBufferLin = true;
        this.numberFormatBufferLin = NumberFormat.AUTO;
        this.tickmarkSectionsVisibleBufferLin = false;
        this.backgroundColorBufferLin = BackgroundColor.DARK_GRAY;
        this.tickmarkColorBufferLin = this.backgroundColorBufferLin.LABEL_COLOR;
        this.tickmarkColorFromThemeBufferLin = true;
        this.tickmarkSectionsBufferLin = new ArrayList<Section>(10);
        this.offsetBufferLin = new Point2D.Double();
        this.orientationBufferLin = Orientation.VERTICAL;
        this.niceScaleLin = true;
        this.logScaleLin = false;
    }

    public BufferedImage create_RADIAL_TICKMARKS_Image(int n, double d, double d2, int n2, int n3, double d3, double d4, GaugeType gaugeType, TickmarkType tickmarkType, TickmarkType tickmarkType2, boolean bl, boolean bl2, boolean bl3, boolean bl4, NumberFormat numberFormat, boolean bl5, BackgroundColor backgroundColor, Color color, boolean bl6, List<Section> list, boolean bl7, List<Section> list2, float f, float f2, Point2D point2D, Point2D point2D2, Orientation orientation, TicklabelOrientation ticklabelOrientation, boolean bl8, boolean bl9, BufferedImage bufferedImage) {
        double d5;
        if (n <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (n == this.widthBufferRad && Double.compare(d, this.minValueBufferRad) == 0 && Double.compare(d2, this.maxValueBufferRad) == 0 && n2 == this.noOfMinorTicksBufferRad && n3 == this.noOfMajorTicksBufferRad && Double.compare(d3, this.minorTickSpacingBufferRad) == 0 && Double.compare(d4, this.majorTickSpacingBufferRad) == 0 && gaugeType == this.gaugeTypeBufferRad && tickmarkType == this.minorTickmarkTypeBufferRad && tickmarkType2 == this.majorTickmarkTypeBufferRad && bl == this.ticksVisibleBufferRad && bl2 == this.ticklabelsVisibleBufferRad && bl3 == this.minorTicksVisibleBufferRad && bl4 == this.majorTicksVisibleBufferRad && bl7 == this.sectionTickmarksOnlyBufferRad && this.sectionsBufferRad.containsAll(list2) && bl5 == this.tickmarkSectionsVisibleBufferRad && numberFormat == this.numberFormatBufferRad && backgroundColor == this.backgroundColorBufferRad && color.equals(this.tickmarkColorBufferRad) && bl6 == this.tickmarkColorFromThemeBufferRad && list.containsAll(this.tickmarkSectionsBufferRad) && Float.compare(f, this.radiusFactorBufferRad) == 0 && Float.compare(f2, this.textDistanceFactorBufferRad) == 0 && point2D.equals(this.centerBufferRad) && point2D2.equals(this.offsetBufferRad) && this.orientationBufferRad == orientation && this.ticklabelOrientationBufferRad == ticklabelOrientation && this.niceScaleRad == bl8 && this.logScaleRad == bl9 && bufferedImage != null) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage((Image)this.imageBufferRad, 0, 0, null);
            graphics2D.dispose();
            return this.imageBufferRad;
        }
        if (this.imageBufferRad != null) {
            this.imageBufferRad.flush();
        }
        this.imageBufferRad = this.UTIL.createImage(n, n, 3);
        this.numberFormat = numberFormat == NumberFormat.AUTO ? (Math.abs(d4) > 1000.0 ? NumberFormat.SCIENTIFIC : (d4 % 1.0 != 0.0 ? NumberFormat.FRACTIONAL : NumberFormat.STANDARD)) : numberFormat;
        Font font = new Font("Verdana", 0, (int)(0.04 * (double)n));
        Font font2 = new Font("Verdana", 0, (int)(0.05 * (double)n));
        int n4 = (int)(f2 * (float)n);
        double d6 = 0.0;
        int n5 = (int)(0.0133333333 * (double)n);
        int n6 = (int)(0.02 * (double)n);
        int n7 = (int)(0.03 * (double)n);
        int n8 = (int)(0.0093457944 * (double)n);
        int n9 = (int)(0.03 * (double)n);
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_3 = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_4 = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_5 = new Point2D.Double(0.0, 0.0);
        Line2D.Double double_6 = new Line2D.Double(0.0, 0.0, 1.0, 1.0);
        Ellipse2D.Double double_7 = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
        GeneralPath generalPath = new GeneralPath();
        double d7 = gaugeType.ROTATION_OFFSET;
        float f3 = (float)n * f;
        double d8 = gaugeType.ANGLE_RANGE / ((d2 - d) / d3);
        double d9 = d;
        int n10 = n2 - 1;
        Graphics2D graphics2D = this.imageBufferRad.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (point2D2 != null) {
            graphics2D.translate(point2D2.getX(), point2D2.getY());
        }
        graphics2D.setFont(font);
        graphics2D.rotate(d7 - Math.PI, point2D.getX(), point2D.getY());
        if (bl6) {
            graphics2D.setColor(backgroundColor.LABEL_COLOR);
        } else {
            graphics2D.setColor(color);
        }
        if (bl7 && list2 != null) {
            d5 = 0.0;
            graphics2D.setFont(font2);
            double d10 = Math.sin(d5);
            double d11 = Math.cos(d5);
            graphics2D.setStroke(MAJOR_TICKMARK_STROKE);
            ((Point2D)double_2).setLocation(point2D.getX() + (double)(f3 - (float)n7) * d10, point2D.getY() + (double)(f3 - (float)n7) * d11);
            ((Point2D)double_3).setLocation(point2D.getX() + (double)f3 * d10, point2D.getY() + (double)f3 * d11);
            ((Point2D)double_).setLocation(point2D.getX() + (double)(f3 - (float)n4) * d10, point2D.getY() + (double)(f3 - (float)n4) * d11);
            this.drawRadialTicks(graphics2D, double_2, double_3, point2D, f3, tickmarkType2, double_6, double_7, generalPath, n7, n9, double_4, double_5, d5);
            graphics2D.fill(this.UTIL.rotateTextAroundCenter(graphics2D, this.numberFormat.format(d), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), Math.PI - gaugeType.ROTATION_OFFSET));
            d5 = -(d2 - d) * d8;
            d10 = Math.sin(d5);
            d11 = Math.cos(d5);
            graphics2D.setStroke(MAJOR_TICKMARK_STROKE);
            ((Point2D)double_2).setLocation(point2D.getX() + (double)(f3 - (float)n7) * d10, point2D.getY() + (double)(f3 - (float)n7) * d11);
            ((Point2D)double_3).setLocation(point2D.getX() + (double)f3 * d10, point2D.getY() + (double)f3 * d11);
            ((Point2D)double_).setLocation(point2D.getX() + (double)(f3 - (float)n4) * d10, point2D.getY() + (double)(f3 - (float)n4) * d11);
            this.drawRadialTicks(graphics2D, double_2, double_3, point2D, f3, tickmarkType2, double_6, double_7, generalPath, n7, n9, double_4, double_5, d5);
            graphics2D.fill(this.UTIL.rotateTextAroundCenter(graphics2D, this.numberFormat.format(d2), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), Math.PI - gaugeType.ROTATION_OFFSET));
            for (Section section : list2) {
                d5 = -(section.getStart() - d) * d8;
                d10 = Math.sin(d5);
                d11 = Math.cos(d5);
                graphics2D.setStroke(MAJOR_TICKMARK_STROKE);
                ((Point2D)double_2).setLocation(point2D.getX() + (double)(f3 - (float)n7) * d10, point2D.getY() + (double)(f3 - (float)n7) * d11);
                ((Point2D)double_3).setLocation(point2D.getX() + (double)f3 * d10, point2D.getY() + (double)f3 * d11);
                ((Point2D)double_).setLocation(point2D.getX() + (double)(f3 - (float)n4) * d10, point2D.getY() + (double)(f3 - (float)n4) * d11);
                this.drawRadialTicks(graphics2D, double_2, double_3, point2D, f3, tickmarkType2, double_6, double_7, generalPath, n7, n9, double_4, double_5, d5);
                graphics2D.fill(this.UTIL.rotateTextAroundCenter(graphics2D, this.numberFormat.format(section.getStart()), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), Math.PI - gaugeType.ROTATION_OFFSET));
                d5 = -(section.getStop() - d) * d8;
                d10 = Math.sin(d5);
                d11 = Math.cos(d5);
                graphics2D.setStroke(MAJOR_TICKMARK_STROKE);
                ((Point2D)double_2).setLocation(point2D.getX() + (double)(f3 - (float)n7) * d10, point2D.getY() + (double)(f3 - (float)n7) * d11);
                ((Point2D)double_3).setLocation(point2D.getX() + (double)f3 * d10, point2D.getY() + (double)f3 * d11);
                ((Point2D)double_).setLocation(point2D.getX() + (double)(f3 - (float)n4) * d10, point2D.getY() + (double)(f3 - (float)n4) * d11);
                this.drawRadialTicks(graphics2D, double_2, double_3, point2D, f3, tickmarkType2, double_6, double_7, generalPath, n7, n9, double_4, double_5, d5);
                graphics2D.fill(this.UTIL.rotateTextAroundCenter(graphics2D, this.numberFormat.format(section.getStop()), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), Math.PI - gaugeType.ROTATION_OFFSET));
            }
        } else if (!bl9) {
            d5 = 0.0;
            double d12 = d;
            while (Double.compare(d12, d2) <= 0) {
                if (list != null && !list.isEmpty()) {
                    if (bl5) {
                        for (Section section : list) {
                            if (Double.compare(d9, section.getStart()) >= 0 && Double.compare(d9, section.getStop()) <= 0) {
                                graphics2D.setColor(Util.INSTANCE.setAlpha(section.getColor(), 1.0f));
                                break;
                            }
                            if (bl6) {
                                graphics2D.setColor(backgroundColor.LABEL_COLOR);
                                continue;
                            }
                            graphics2D.setColor(color);
                        }
                    } else if (bl6) {
                        graphics2D.setColor(backgroundColor.LABEL_COLOR);
                    } else {
                        graphics2D.setColor(color);
                    }
                }
                double d13 = Math.sin(d5);
                double d14 = Math.cos(d5);
                if (++n10 == n2) {
                    graphics2D.setStroke(MAJOR_TICKMARK_STROKE);
                    ((Point2D)double_2).setLocation(point2D.getX() + (double)(f3 - (float)n7) * d13, point2D.getY() + (double)(f3 - (float)n7) * d14);
                    ((Point2D)double_3).setLocation(point2D.getX() + (double)f3 * d13, point2D.getY() + (double)f3 * d14);
                    ((Point2D)double_).setLocation(point2D.getX() + (double)(f3 - (float)n4) * d13, point2D.getY() + (double)(f3 - (float)n4) * d14);
                    if (bl && bl4) {
                        this.drawRadialTicks(graphics2D, double_2, double_3, point2D, f3, tickmarkType2, double_6, double_7, generalPath, n7, n9, double_4, double_5, d5);
                    }
                    if (bl2) {
                        switch (ticklabelOrientation) {
                            case NORMAL: {
                                if (Double.compare(d5, -gaugeType.TICKLABEL_ORIENTATION_CHANGE_ANGLE) > 0) {
                                    graphics2D.fill(this.UTIL.rotateTextAroundCenter(graphics2D, this.numberFormat.format(d9), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), -1.5707963267948966 - d5));
                                    break;
                                }
                                graphics2D.fill(this.UTIL.rotateTextAroundCenter(graphics2D, this.numberFormat.format(d9), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), 1.5707963267948966 - d5));
                                break;
                            }
                            case HORIZONTAL: {
                                double d15 = Orientation.WEST == orientation ? 1.5707963267948966 : (Orientation.EAST == orientation ? -1.5707963267948966 : (Orientation.SOUTH == orientation ? Math.PI : 0.0));
                                graphics2D.fill(this.UTIL.rotateTextAroundCenter(graphics2D, this.numberFormat.format(d9), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), Math.PI - gaugeType.ROTATION_OFFSET + d15));
                                break;
                            }
                            default: {
                                graphics2D.fill(this.UTIL.rotateTextAroundCenter(graphics2D, this.numberFormat.format(d9), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), Math.PI - d5 + d6));
                            }
                        }
                    }
                    d9 += d4;
                    n10 = 0;
                } else {
                    ((Point2D)double_2).setLocation(point2D.getX() + (double)(f3 - (float)n5) * d13, point2D.getY() + (double)(f3 - (float)n5) * d14);
                    ((Point2D)double_3).setLocation(point2D.getX() + (double)f3 * d13, point2D.getY() + (double)f3 * d14);
                    graphics2D.setStroke(MINOR_TICKMARK_STROKE);
                    if (n2 % 2 == 0 && n10 == n2 / 2) {
                        graphics2D.setStroke(MEDIUM_TICKMARK_STROKE);
                        ((Point2D)double_2).setLocation(point2D.getX() + (double)(f3 - (float)n6) * d13, point2D.getY() + (double)(f3 - (float)n6) * d14);
                        ((Point2D)double_3).setLocation(point2D.getX() + (double)f3 * d13, point2D.getY() + (double)f3 * d14);
                    }
                    if (bl && bl3) {
                        this.drawRadialTicks(graphics2D, double_2, double_3, point2D, f3, tickmarkType, double_6, double_7, generalPath, n5, n8, double_4, double_5, d5);
                    }
                }
                d5 -= d8;
                d12 += d3;
            }
        } else {
            d5 = Math.abs(gaugeType.ANGLE_RANGE / this.UTIL.logOfBase(10.0, d2 - d));
            int n11 = 0;
            double d16 = 1.0;
            double d17 = 1.0;
            while (Double.compare(d17, d2) <= 0) {
                if (bl6) {
                    graphics2D.setColor(backgroundColor.LABEL_COLOR);
                } else {
                    graphics2D.setColor(color);
                }
                double d18 = this.UTIL.logOfBase(10.0, Math.abs(d17)) * d5;
                double d19 = Math.sin(-d18);
                double d20 = Math.cos(-d18);
                ((Point2D)double_2).setLocation(point2D.getX() + (double)(f3 - (float)n5) * d19, point2D.getY() + (double)(f3 - (float)n5) * d20);
                ((Point2D)double_3).setLocation(point2D.getX() + (double)f3 * d19, point2D.getY() + (double)f3 * d20);
                graphics2D.setStroke(MINOR_TICKMARK_STROKE);
                if (Double.compare(d17, Math.pow(10.0, n11 + 1)) == 0) {
                    d16 = Math.pow(10.0, ++n11);
                    ((Point2D)double_2).setLocation(point2D.getX() + (double)(f3 - (float)n7) * d19, point2D.getY() + (double)(f3 - (float)n7) * d20);
                    ((Point2D)double_3).setLocation(point2D.getX() + (double)f3 * d19, point2D.getY() + (double)f3 * d20);
                    ((Point2D)double_).setLocation(point2D.getX() + (double)(f3 - (float)n4) * d19, point2D.getY() + (double)(f3 - (float)n4) * d20);
                    if (bl2) {
                        switch (ticklabelOrientation) {
                            case NORMAL: {
                                if (Double.compare(d17, -gaugeType.TICKLABEL_ORIENTATION_CHANGE_ANGLE) > 0) {
                                    graphics2D.fill(this.UTIL.rotateTextAroundCenter(graphics2D, this.numberFormat.format(d17), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), -1.5707963267948966 + d18));
                                    break;
                                }
                                graphics2D.fill(this.UTIL.rotateTextAroundCenter(graphics2D, this.numberFormat.format(d17), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), 1.5707963267948966 + d18));
                                break;
                            }
                            case HORIZONTAL: {
                                double d21 = Orientation.WEST == orientation ? 1.5707963267948966 : (Orientation.EAST == orientation ? -1.5707963267948966 : (Orientation.SOUTH == orientation ? Math.PI : 0.0));
                                graphics2D.fill(this.UTIL.rotateTextAroundCenter(graphics2D, this.numberFormat.format(d17), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), Math.PI - gaugeType.ROTATION_OFFSET + d21));
                                break;
                            }
                            default: {
                                graphics2D.fill(this.UTIL.rotateTextAroundCenter(graphics2D, this.numberFormat.format(d17), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), Math.PI + d18 + d6));
                            }
                        }
                    }
                    graphics2D.setStroke(MAJOR_TICKMARK_STROKE);
                }
                if (bl && bl4 && bl3) {
                    double_6.setLine(double_2, double_3);
                    graphics2D.draw(double_6);
                }
                d17 += d16;
            }
        }
        graphics2D.dispose();
        if (bufferedImage != null) {
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            graphics2D2.drawImage((Image)this.imageBufferRad, 0, 0, null);
            graphics2D2.dispose();
        }
        this.widthBufferRad = n;
        this.minValueBufferRad = d;
        this.maxValueBufferRad = d2;
        this.noOfMinorTicksBufferRad = n2;
        this.noOfMajorTicksBufferRad = n3;
        this.minorTickSpacingBufferRad = d3;
        this.majorTickSpacingBufferRad = d4;
        this.gaugeTypeBufferRad = gaugeType;
        this.minorTickmarkTypeBufferRad = tickmarkType;
        this.majorTickmarkTypeBufferRad = tickmarkType2;
        this.ticksVisibleBufferRad = bl;
        this.ticklabelsVisibleBufferRad = bl2;
        this.minorTicksVisibleBufferRad = bl3;
        this.majorTicksVisibleBufferRad = bl4;
        this.tickmarkSectionsVisibleBufferRad = bl5;
        this.numberFormatBufferRad = numberFormat;
        this.backgroundColorBufferRad = backgroundColor;
        this.tickmarkColorBufferRad = color;
        this.tickmarkColorFromThemeBufferRad = bl6;
        if (list != null) {
            this.tickmarkSectionsBufferRad.clear();
            this.tickmarkSectionsBufferRad.addAll(list);
        }
        if (list2 != null) {
            this.sectionsBufferRad.clear();
            this.sectionsBufferRad.addAll(list2);
        }
        this.sectionTickmarksOnlyBufferRad = bl7;
        this.radiusFactorBufferRad = f;
        this.textDistanceFactorBufferRad = f2;
        this.centerBufferRad.setLocation(point2D);
        if (point2D2 != null) {
            this.offsetBufferRad.setLocation(point2D2);
        }
        this.orientationBufferRad = orientation;
        this.ticklabelOrientationBufferRad = ticklabelOrientation;
        this.niceScaleRad = bl8;
        this.logScaleRad = bl9;
        return this.imageBufferRad;
    }

    private void drawRadialTicks(Graphics2D graphics2D, Point2D point2D, Point2D point2D2, Point2D point2D3, double d, TickmarkType tickmarkType, Line2D line2D, Ellipse2D ellipse2D, GeneralPath generalPath, double d2, double d3, Point2D point2D4, Point2D point2D5, double d4) {
        switch (tickmarkType) {
            case CIRCLE: {
                ellipse2D.setFrame(point2D2.getX() - d3 / 2.0, point2D2.getY() - d3 / 2.0, d3, d3);
                graphics2D.fill(ellipse2D);
                break;
            }
            case TRIANGLE: {
                point2D4.setLocation(point2D3.getX() + d * Math.sin(d4 - Math.toRadians(Math.asin(d2 / 16.0))), point2D3.getY() + d * Math.cos(d4 - Math.toRadians(Math.asin(d2 / 16.0))));
                point2D5.setLocation(point2D3.getX() + d * Math.sin(d4 + Math.toRadians(Math.asin(d2 / 16.0))), point2D3.getY() + d * Math.cos(d4 + Math.toRadians(Math.asin(d2 / 16.0))));
                generalPath.reset();
                generalPath.moveTo(point2D.getX(), point2D.getY());
                generalPath.lineTo(point2D4.getX(), point2D4.getY());
                generalPath.lineTo(point2D5.getX(), point2D5.getY());
                generalPath.closePath();
                graphics2D.fill(generalPath);
                break;
            }
            default: {
                line2D.setLine(point2D, point2D2);
                graphics2D.draw(line2D);
            }
        }
    }

    public BufferedImage create_LINEAR_TICKMARKS_Image(int n, int n2, double d, double d2, int n3, int n4, double d3, double d4, TickmarkType tickmarkType, TickmarkType tickmarkType2, boolean bl, boolean bl2, boolean bl3, boolean bl4, NumberFormat numberFormat, boolean bl5, BackgroundColor backgroundColor, Color color, boolean bl6, List<Section> list, Point2D point2D, Orientation orientation, boolean bl7, boolean bl8, BufferedImage bufferedImage) {
        double d5;
        double d6;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        Rectangle2D.Double double_;
        Font font;
        if (n <= 0 || n2 <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (n == this.widthBufferLin && n2 == this.heightBufferLin && Double.compare(d, this.minValueBufferLin) == 0 && Double.compare(d2, this.maxValueBufferLin) == 0 && n3 == this.noOfMinorTicksBufferLin && n4 == this.noOfMajorTicksBufferLin && Double.compare(d3, this.minorTickSpacingBufferLin) == 0 && Double.compare(d4, this.majorTickSpacingBufferLin) == 0 && tickmarkType == this.minorTickmarkTypeBufferLin && tickmarkType2 == this.majorTickmarkTypeBufferLin && bl == this.ticksVisibleBufferLin && bl3 == this.minorTicksVisibleBufferLin && bl4 == this.majorTicksVisibleBufferLin && bl2 == this.ticklabelsVisibleBufferLin && numberFormat == this.numberFormatBufferLin && bl5 == this.tickmarkSectionsVisibleBufferLin && backgroundColor == this.backgroundColorBufferLin && color.equals(this.tickmarkColorBufferLin) && bl6 == this.tickmarkColorFromThemeBufferLin && list.containsAll(this.tickmarkSectionsBufferLin) && point2D.equals(this.offsetBufferLin) && orientation == this.orientationBufferLin && bl7 == this.niceScaleLin && bl8 == this.logScaleLin && bufferedImage != null) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage((Image)this.imageBufferLin, 0, 0, null);
            graphics2D.dispose();
            return this.imageBufferLin;
        }
        if (this.imageBufferLin != null) {
            this.imageBufferLin.flush();
        }
        this.imageBufferLin = this.UTIL.createImage(n, n2, 3);
        if (numberFormat == NumberFormat.AUTO) {
            if (Math.abs(d4) > 1000.0) {
                this.numberFormat = NumberFormat.SCIENTIFIC;
            } else if (d4 % 1.0 != 0.0) {
                this.numberFormat = NumberFormat.FRACTIONAL;
            }
        } else {
            this.numberFormat = numberFormat;
        }
        if (orientation == Orientation.VERTICAL) {
            font = new Font("Verdana", 0, (int)(0.062 * (double)n));
            double_ = new Rectangle2D.Double(0.0, (double)n2 * 0.12864077669902912, 0.0, (double)n2 * 0.8567961165048543 - (double)n2 * 0.12864077669902912);
            n12 = (int)(0.0186915888 * (double)n);
            n11 = (int)(0.0280373832 * (double)n);
            n10 = (int)(0.34 * (double)n);
            n9 = (int)(0.36 * (double)n);
            n8 = (int)(0.33 * (double)n);
            n7 = (int)(0.36 * (double)n);
            n6 = (int)(0.32 * (double)n);
            n5 = (int)(0.36 * (double)n);
            d6 = ((RectangularShape)double_).getHeight() / (d2 - d);
        } else {
            font = new Font("Verdana", 0, (int)(0.062 * (double)n2));
            double_ = new Rectangle2D.Double((double)n * 0.14285714285714285, 0.0, (double)n * 0.8710124827 - (double)n * 0.14285714285714285, 0.0);
            n12 = (int)(0.0186915888 * (double)n2);
            n11 = (int)(0.0280373832 * (double)n2);
            n10 = (int)(0.65 * (double)n2);
            n9 = (int)(0.63 * (double)n2);
            n8 = (int)(0.66 * (double)n2);
            n7 = (int)(0.63 * (double)n2);
            n6 = (int)(0.67 * (double)n2);
            n5 = (int)(0.63 * (double)n2);
            d6 = ((RectangularShape)double_).getWidth() / (d2 - d);
        }
        Graphics2D graphics2D = this.imageBufferLin.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (point2D != null) {
            graphics2D.translate(point2D.getX(), point2D.getY());
        }
        graphics2D.setFont(font);
        if (bl6) {
            graphics2D.setColor(backgroundColor.LABEL_COLOR);
        } else {
            graphics2D.setColor(color);
        }
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        TextLayout textLayout = new TextLayout(this.numberFormat.format(d2), graphics2D.getFont(), fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        Line2D.Double double_2 = new Line2D.Double(0.0, 0.0, 1.0, 1.0);
        Ellipse2D.Double double_3 = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
        GeneralPath generalPath = new GeneralPath();
        double d7 = d;
        int n13 = n3 - 1;
        if (!bl8) {
            d5 = d;
            double d8 = 0.0;
            while (Float.compare((float)d5, (float)d2) <= 0) {
                if (list != null && !list.isEmpty()) {
                    if (bl5) {
                        for (Section section : list) {
                            if (Double.compare(d8, section.getStart()) >= 0 && Double.compare(d8, section.getStop()) <= 0) {
                                graphics2D.setColor(section.getColor());
                                break;
                            }
                            if (bl6) {
                                graphics2D.setColor(backgroundColor.LABEL_COLOR);
                                continue;
                            }
                            graphics2D.setColor(color);
                        }
                    } else if (bl6) {
                        graphics2D.setColor(backgroundColor.LABEL_COLOR);
                    } else {
                        graphics2D.setColor(color);
                    }
                } else if (bl6) {
                    graphics2D.setColor(backgroundColor.LABEL_COLOR);
                } else {
                    graphics2D.setColor(color);
                }
                double d9 = orientation == Orientation.VERTICAL ? double_.getMaxY() - d8 * d6 : ((RectangularShape)double_).getX() + d8 * d6;
                if (++n13 == n3) {
                    graphics2D.setStroke(MAJOR_TICKMARK_STROKE);
                    if (bl && bl4) {
                        this.drawLinearTicks(graphics2D, n, n2, orientation, d9, tickmarkType2, double_2, double_3, generalPath, n6, n5, n11);
                    }
                    if (bl2) {
                        TextLayout textLayout2 = new TextLayout(this.numberFormat.format(d7), graphics2D.getFont(), fontRenderContext);
                        Rectangle2D rectangle2D2 = textLayout2.getBounds();
                        if (orientation == Orientation.VERTICAL) {
                            float f = (float)(rectangle2D.getWidth() - rectangle2D2.getWidth());
                            graphics2D.drawString(this.numberFormat.format(d7), 0.18f * (float)n + f, (float)(d9 - rectangle2D2.getHeight() / 2.0 + rectangle2D2.getHeight()));
                        } else {
                            graphics2D.drawString(this.numberFormat.format(d7), (float)(d8 * d6 - rectangle2D2.getWidth() / 3.0 + ((RectangularShape)double_).getX()), (float)((double)n2 * 0.68 + 1.5 * rectangle2D2.getHeight()));
                        }
                    }
                    d7 += d4;
                    n13 = 0;
                } else if (bl && bl3) {
                    graphics2D.setStroke(MINOR_TICKMARK_STROKE);
                    if (n3 % 2 == 0 && n13 == n3 / 2) {
                        graphics2D.setStroke(MEDIUM_TICKMARK_STROKE);
                        this.drawLinearTicks(graphics2D, n, n2, orientation, d9, tickmarkType, double_2, double_3, generalPath, n8, n7, n12);
                    } else {
                        this.drawLinearTicks(graphics2D, n, n2, orientation, d9, tickmarkType, double_2, double_3, generalPath, n10, n9, n12);
                    }
                }
                d5 += d3;
                d8 += d3;
            }
        } else if (bl) {
            double d10;
            if (orientation == Orientation.VERTICAL) {
                d5 = double_.getMaxY();
                d10 = double_.getMinY();
            } else {
                d5 = double_.getMinX();
                d10 = double_.getMaxX();
            }
            double d11 = 1.0;
            int n14 = 0;
            double d12 = Math.abs(d10 - d5) / this.UTIL.logOfBase(10.0, d2);
            Line2D.Double double_4 = new Line2D.Double();
            if (bl6) {
                graphics2D.setColor(backgroundColor.LABEL_COLOR);
            } else {
                graphics2D.setColor(color);
            }
            int n15 = 0;
            while ((double)n15 <= d2) {
                double d13;
                graphics2D.setStroke(MEDIUM_TICKMARK_STROKE);
                if (orientation == Orientation.VERTICAL) {
                    d13 = d5 - d12 * this.UTIL.logOfBase(10.0, n15);
                    ((Line2D)double_4).setLine(n8, d13, n7, d13);
                } else {
                    d13 = d12 * this.UTIL.logOfBase(10.0, n15) + d5;
                    ((Line2D)double_4).setLine(d13, n8, d13, n7);
                }
                if (n15 == (int)Math.pow(10.0, n14 + 1)) {
                    d11 = Math.pow(10.0, ++n14);
                    graphics2D.setStroke(MAJOR_TICKMARK_STROKE);
                    if (orientation == Orientation.VERTICAL) {
                        ((Line2D)double_4).setLine(n6, d13, n5, d13);
                    } else {
                        ((Line2D)double_4).setLine(d13, n6, d13, n5);
                    }
                    if (bl2) {
                        TextLayout textLayout3 = new TextLayout(this.numberFormat.format(n15), graphics2D.getFont(), fontRenderContext);
                        Rectangle2D rectangle2D3 = textLayout3.getBounds();
                        if (orientation == Orientation.VERTICAL) {
                            float f = (float)(rectangle2D.getWidth() - rectangle2D3.getWidth());
                            graphics2D.drawString(this.numberFormat.format(n15), 0.18f * (float)n + f, (float)(d13 - rectangle2D3.getHeight() / 2.0 + rectangle2D3.getHeight()));
                        } else {
                            graphics2D.drawString(this.numberFormat.format(n15), (float)(d13 - rectangle2D3.getWidth() / 3.0), (float)((double)n2 * 0.68 + 1.5 * rectangle2D3.getHeight()));
                        }
                    }
                }
                graphics2D.draw(double_4);
                n15 = (int)((double)n15 + d11);
            }
        }
        graphics2D.dispose();
        if (bufferedImage != null) {
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            graphics2D2.drawImage((Image)this.imageBufferLin, 0, 0, null);
            graphics2D2.dispose();
        }
        this.widthBufferLin = n;
        this.heightBufferLin = n2;
        this.minValueBufferLin = d;
        this.maxValueBufferLin = d2;
        this.noOfMinorTicksBufferLin = n3;
        this.noOfMajorTicksBufferLin = n4;
        this.minorTickSpacingBufferLin = d3;
        this.majorTickSpacingBufferLin = d4;
        this.minorTickmarkTypeBufferLin = tickmarkType;
        this.majorTickmarkTypeBufferLin = tickmarkType2;
        this.ticksVisibleBufferLin = bl;
        this.ticklabelsVisibleBufferLin = bl2;
        this.minorTicksVisibleBufferLin = bl3;
        this.majorTicksVisibleBufferLin = bl4;
        this.numberFormatBufferLin = numberFormat;
        this.tickmarkSectionsVisibleBufferLin = bl5;
        this.backgroundColorBufferLin = backgroundColor;
        this.tickmarkColorBufferLin = color;
        this.tickmarkColorFromThemeBufferLin = bl6;
        if (list != null) {
            this.tickmarkSectionsBufferLin.clear();
            this.tickmarkSectionsBufferLin.addAll(list);
        }
        if (point2D != null) {
            this.offsetBufferLin.setLocation(point2D);
        }
        this.orientationBufferLin = orientation;
        this.niceScaleLin = bl7;
        this.logScaleLin = bl8;
        return this.imageBufferLin;
    }

    private void drawLinearTicks(Graphics2D graphics2D, int n, int n2, Orientation orientation, double d, TickmarkType tickmarkType, Line2D line2D, Ellipse2D ellipse2D, GeneralPath generalPath, double d2, double d3, double d4) {
        switch (tickmarkType) {
            case CIRCLE: {
                if (orientation == Orientation.VERTICAL) {
                    ellipse2D.setFrame(d2, d - d4 / 2.0, d4, d4);
                } else {
                    ellipse2D.setFrame(d - d4 / 2.0, d3, d4, d4);
                }
                graphics2D.fill(ellipse2D);
                break;
            }
            case TRIANGLE: {
                generalPath.reset();
                if (orientation == Orientation.VERTICAL) {
                    generalPath.moveTo(d2, d + (double)n * 0.005);
                    generalPath.lineTo(d2, d - (double)n * 0.005);
                    generalPath.lineTo(d3, d);
                    generalPath.closePath();
                } else {
                    generalPath.moveTo(d - (double)n2 * 0.005, d2);
                    generalPath.lineTo(d + (double)n2 * 0.005, d2);
                    generalPath.lineTo(d, d3);
                    generalPath.closePath();
                }
                graphics2D.fill(generalPath);
                break;
            }
            default: {
                if (orientation == Orientation.VERTICAL) {
                    line2D.setLine(d2, d, d3, d);
                } else {
                    line2D.setLine(d, d2, d, d3);
                }
                graphics2D.draw(line2D);
            }
        }
    }

    static {
        MAJOR_TICKMARK_STROKE = new BasicStroke(1.0f, 1, 2);
        MEDIUM_TICKMARK_STROKE = new BasicStroke(0.5f, 1, 2);
        MINOR_TICKMARK_STROKE = new BasicStroke(0.3f, 1, 2);
    }
}

