/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.dfu;

import com.rusefi.dfu.BinaryImage;
import com.rusefi.dfu.DfuCommmand;
import com.rusefi.dfu.DfuConnection;
import com.rusefi.dfu.DfuConnectionUtil;
import com.rusefi.dfu.FlashRange;
import com.rusefi.dfu.commands.DfuCommandAbort;
import com.rusefi.dfu.commands.DfuCommandClearStatus;
import com.rusefi.dfu.commands.DfuCommandGetStatus;
import com.rusefi.dfu.commands.DfuSeCommandErasePage;
import com.rusefi.dfu.commands.DfuSeCommandSetAddress;
import java.nio.ByteBuffer;
import java.util.List;

public class DfuLogic {
    public static final short ST_VENDOR = 1155;
    public static final int ST_DFU_PRODUCT = 57105;
    public static final int USB_CLASS_APP_SPECIFIC = 254;
    public static final byte DFU_SUBCLASS = 1;
    public static final byte USB_DT_DFU = 33;
    public static final String FLASH_TAG = "Flash";

    public static void uploadImage(Logger logger, DfuConnection device, BinaryImage image, FlashRange range) {
        DfuLogic.startup(logger, device);
        DfuLogic.actuallyUploadImage(logger, device, image, range);
        DfuLogic.leaveDFU(logger, device);
    }

    public static void actuallyUploadImage(Logger logger, DfuConnection device, BinaryImage image, FlashRange range) {
        long enter = System.currentTimeMillis();
        List<Integer> erasePages = range.pagesForSize(image.getImageSize());
        int eraseAddress = 0x8000000;
        for (Integer erasePage : erasePages) {
            DfuSeCommandErasePage.execute(logger, device, eraseAddress);
            eraseAddress += erasePage.intValue();
        }
        logger.info(String.format("Erased up to %x", eraseAddress));
        for (int offset = 0; offset < image.getImageSize(); offset += device.getTransferSize()) {
            DfuSeCommandSetAddress.execute(logger, device, device.getFlashRange().getBaseAddress() + offset);
            DfuConnectionUtil.waitStatus(logger, device);
            ByteBuffer buffer = device.allocateBuffer(device.getTransferSize());
            int size = Math.min(device.getTransferSize(), image.getImage().length - offset);
            buffer.put(image.getImage(), offset, size);
            device.sendData(DfuCommmand.DNLOAD, (short)2, buffer);
            DfuConnectionUtil.waitStatus(logger, device);
        }
        logger.info("Uploaded " + image.getImage().length + " bytes in " + (System.currentTimeMillis() - enter) + " ms");
    }

    public static void leaveDFU(Logger logger, DfuConnection device) {
        logger.info("Leaving DFU");
        device.sendData(DfuCommmand.DNLOAD, (short)2, device.allocateBuffer(0));
        DfuConnectionUtil.waitStatus(logger, device);
        logger.info("DONE");
    }

    public static void startup(Logger logger, DfuConnection device) {
        DfuCommandGetStatus.DeviceStatus state = DfuCommandGetStatus.read(logger, device);
        logger.info("DFU state: " + state);
        switch (state.getState()) {
            case DFU_IDLE: {
                logger.info("startup status " + (Object)((Object)state.getStatus()));
                break;
            }
            case DFU_ERROR: {
                DfuCommandClearStatus.execute(device);
                break;
            }
            case DFU_DOWNLOAD_SYNC: 
            case DFU_DOWNLOAD_IDLE: 
            case DFU_UPLOAD_IDLE: 
            case DFU_MANIFEST_SYNC: 
            case DFU_DOWNLOAD_BUSY: 
            case DFU_MANIFEST: {
                DfuCommandAbort.execute(device);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state " + state);
            }
        }
        state = DfuCommandGetStatus.read(logger, device);
        if (state.getState() != DfuCommandGetStatus.State.DFU_IDLE) {
            throw new IllegalStateException("Not idle on start-up: " + (Object)((Object)state.getState()));
        }
    }

    public static interface Logger {
        public static final Logger VOID = message -> {};
        public static final Logger CONSOLE = System.out::println;

        public void info(String var1);
    }
}

