/*
 * Decompiled with CFR 0.152.
 */
package cz.jaybee.intelhex.listeners;

import cz.jaybee.intelhex.DataListener;
import cz.jaybee.intelhex.MemoryRegions;
import cz.jaybee.intelhex.Region;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BinWriter
implements DataListener {
    private final Region outputRegion;
    private final OutputStream destination;
    private final byte[] buffer;
    private final MemoryRegions regions;
    private long maxAddress;
    private final boolean minimize;

    public BinWriter(Region outputRegion, OutputStream destination, boolean minimize) {
        this.outputRegion = outputRegion;
        this.destination = destination;
        this.minimize = minimize;
        this.buffer = new byte[(int)outputRegion.getLength()];
        Arrays.fill(this.buffer, (byte)-1);
        this.regions = new MemoryRegions();
        this.maxAddress = outputRegion.getAddressStart();
    }

    @Override
    public void data(long address, byte[] data) {
        this.regions.add(address, data.length);
        if (address >= this.outputRegion.getAddressStart() && address <= this.outputRegion.getAddressEnd()) {
            int length = data.length;
            if (address + (long)length > this.outputRegion.getAddressEnd()) {
                length = (int)(this.outputRegion.getAddressEnd() - address + 1L);
            }
            System.arraycopy(data, 0, this.buffer, (int)(address - this.outputRegion.getAddressStart()), length);
            if (this.maxAddress < address + (long)data.length - 1L) {
                this.maxAddress = address + (long)data.length - 1L;
            }
        }
    }

    @Override
    public void eof() {
        try {
            if (!this.minimize) {
                this.maxAddress = this.outputRegion.getAddressEnd();
            }
            this.destination.write(this.buffer, 0, (int)(this.maxAddress - this.outputRegion.getAddressStart() + 1L));
        }
        catch (IOException ex) {
            Logger.getLogger(BinWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public MemoryRegions getMemoryRegions() {
        return this.regions;
    }
}

