/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.wizard;

import com.rusefi.wizard.TsAccess;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

final class TsReflectionHelper {
    private TsReflectionHelper() {
    }

    static Frame findTsMainFrame(long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < deadline) {
            for (Frame f : JFrame.getFrames()) {
                try {
                    String title = f.getTitle();
                    if (title == null || !title.contains("TunerStudio")) continue;
                    return f;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Thread.sleep(250L);
        }
        return null;
    }

    static List<AbstractButton> findTopLevelButtons(Frame frame) {
        ArrayList<AbstractButton> result = new ArrayList<AbstractButton>();
        TsReflectionHelper.visitComponents(frame, c -> {
            if (c instanceof AbstractButton) {
                String cn = c.getClass().getName();
                if (TsAccess.getTsTopLevelButtonClass().equals(cn)) {
                    result.add((AbstractButton)c);
                }
            }
        });
        return result;
    }

    static JMenuItem findMenuItem(Frame frame, String text) {
        ArrayList candidates = new ArrayList();
        TsReflectionHelper.visitComponents(frame, c -> {
            if (c instanceof JMenuItem) {
                JMenuItem mi = (JMenuItem)c;
                String cls = c.getClass().getName();
                boolean isTsMenu = cls.endsWith(TsAccess.getTsPopupMainMenuClassSuffix());
                boolean textMatches = Objects.equals(mi.getText(), text);
                if (textMatches && (isTsMenu || candidates.isEmpty())) {
                    candidates.add(mi);
                }
            }
        });
        return candidates.isEmpty() ? null : (JMenuItem)candidates.get(0);
    }

    static JDialog waitForDialogWithTitle(String title, long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < deadline) {
            for (Window w : Dialog.getWindows()) {
                JDialog d;
                if (!(w instanceof JDialog) || !w.isVisible() || !title.equals((d = (JDialog)w).getTitle())) continue;
                return d;
            }
            Thread.sleep(100L);
        }
        return null;
    }

    static void bringToFront(JDialog dialog) {
        SwingUtilities.invokeLater(() -> {
            dialog.setAlwaysOnTop(true);
            dialog.toFront();
            dialog.requestFocus();
            dialog.setVisible(true);
            dialog.setAlwaysOnTop(false);
        });
    }

    private static void visitComponents(Component root, Consumer<Component> visitor) {
        visitor.accept(root);
        if (root instanceof Container) {
            for (Component c : ((Container)root).getComponents()) {
                TsReflectionHelper.visitComponents(c, visitor);
            }
        }
    }
}

