/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.devexperts.logging.Logging;
import com.opensr5.ini.field.EnumIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.BooleanField;
import com.rusefi.maintenance.migration.migrators.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Optional;

public enum BooleanIniFieldMigrator implements TuneMigrator
{
    INSTANCE;

    private static final Logging log;
    public static final String LAUNCH_CONTROL_FIELD_NAME = "launchControlEnabled";
    private static final BooleanField[] fieldsToMigrate;

    @Override
    public void migrateTune(TuneMigrationContext context) {
        for (BooleanField field : fieldsToMigrate) {
            Optional<IniField> prevBooleanIniField = context.getPrevIniFile().findIniField(field.getFieldName());
            Optional<IniField> updatedBooleanIniField = context.getUpdatedIniFile().findIniField(field.getFieldName());
            if (!prevBooleanIniField.isPresent() || !updatedBooleanIniField.isPresent()) continue;
            Constant prevBooleanConst = context.getPrevTune().getConstantsAsMap().get(field.getFieldName());
            Constant updatedBooleanConst = context.getUpdatedTune().getConstantsAsMap().get(field.getFieldName());
            String prevBooleanValue = prevBooleanConst.getValue();
            String updatedBooleanFalse = ((EnumIniField)updatedBooleanIniField.get()).getEnums().get(0);
            if (null == prevBooleanConst || null == updatedBooleanConst) continue;
            Optional<Boolean> shouldMigrate = field.shouldMigrateField(prevBooleanValue, updatedBooleanFalse);
            if (shouldMigrate.isPresent()) {
                if (!shouldMigrate.get().booleanValue()) continue;
                Constant migratedBooleanConst = prevBooleanConst.cloneWithValue(String.valueOf(field.migrateField(prevBooleanValue)));
                context.addMigration(field.getFieldName(), migratedBooleanConst);
                continue;
            }
            log.warn(String.format("Invalid boolean field value on oldTune `%s` neither true/false or `%s`/`%s` :(", field.getFieldName(), field.getTrueValue(), field.getFalseValue()));
        }
    }

    static {
        log = Logging.getLogging(BooleanIniFieldMigrator.class);
        fieldsToMigrate = new BooleanField[]{new BooleanField(LAUNCH_CONTROL_FIELD_NAME, "enabled", "disabled"), new BooleanField("isInjectionEnabled", "enabled", "disabled"), new BooleanField("isIgnitionEnabled", "enabled", "disabled"), new BooleanField("isCylinderCleanupEnabled", "enabled", "disabled"), new BooleanField("isMapAveragingEnabled", "enabled", "disabled"), new BooleanField("isFasterEngineSpinUpEnabled", "enabled", "disabled"), new BooleanField("enableSoftwareKnock", "enabled", "disabled"), new BooleanField("fuelClosedLoopCorrectionEnabled", "enabled", "disabled"), new BooleanField("isSdCardEnabled", "enabled", "disabled"), new BooleanField("isBoostControlEnabled", "enabled", "disabled"), new BooleanField("useSeparateAdvanceForIdle", "enabled", "disabled"), new BooleanField("useSeparateVeForIdle", "enabled", "disabled"), new BooleanField("useSeparateIdleTablesForCrankingTaper", "enabled", "disabled"), new BooleanField("useIacTableForCoasting", "enabled", "disabled"), new BooleanField("nitrousControlEnabled", "enabled", "disabled"), new BooleanField("stftIgnoreErrorMagnitude", "yes", "no"), new BooleanField("enableLaunchRetard", "yes", "no"), new BooleanField("useIdleAdvanceWhileCoasting", "yes", "no"), new BooleanField("launchFuelCutEnable", "yes", "no"), new BooleanField("launchSparkCutEnable", "yes", "no"), new BooleanField("useAdvanceCorrectionsForCranking", "yes", "no")};
    }
}

