/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.config.FieldType;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.AfrLambdaTableValuesConverter;
import com.rusefi.maintenance.migration.migrators.BinsIniFieldMigratorStrategy;
import com.rusefi.maintenance.migration.migrators.TableValuesConverter;
import com.rusefi.maintenance.migration.migrators.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Optional;

public class TableAddColumnsMigrator
implements TuneMigrator {
    public static final String VE_TABLE_FIELD_NAME = "veTable";
    public static final String VE_RPM_BINS_FIELD_NAME = "veRpmBins";
    public static final String LAMBDA_TABLE_FIELD_NAME = "lambdaTable";
    public static final String LAMBDA_RPM_BINS_FIELD_NAME = "lambdaRpmBins";
    public static final String IGNITION_TABLE_FIELD_NAME = "ignitionTable";
    public static final String IGNITION_RPM_BINS_FIELD_NAME = "ignitionRpmBins";
    public static final String INJECTION_PHASE_FIELD_NAME = "injectionPhase";
    public static final String INJECTION_PHASE_RPM_BINS_FIELD_NAME = "injPhaseRpmBins";
    public static final TableAddColumnsMigrator VE_TABLE_MIGRATOR = new TableAddColumnsMigrator("veTable", FieldType.UINT16, "veRpmBins", RetainTableValuesConverter.INSTANCE);
    public static final TableAddColumnsMigrator LAMBDA_TABLE_MIGRATOR = new TableAddColumnsMigrator("lambdaTable", FieldType.UINT8, "lambdaRpmBins", AfrLambdaTableValuesConverter.INSTANCE);
    public static final TableAddColumnsMigrator IGNITION_TABLE_MIGRATOR = new TableAddColumnsMigrator("ignitionTable", FieldType.INT16, "ignitionRpmBins", RetainTableValuesConverter.INSTANCE);
    public static final TableAddColumnsMigrator INJECTION_PHASE_MIGRATOR = new TableAddColumnsMigrator("injectionPhase", FieldType.INT16, "injPhaseRpmBins", RetainTableValuesConverter.INSTANCE);
    private final String tableFieldName;
    private final FieldType tableFieldType;
    private final String columnsBinFieldName;
    private final TableValuesConverter prevTableValueConverter;

    private TableAddColumnsMigrator(String tableIniFieldName, FieldType tableIniFieldType, String columnsIniBinFieldName, TableValuesConverter tableValuesConverter) {
        this.tableFieldName = tableIniFieldName;
        this.tableFieldType = tableIniFieldType;
        this.columnsBinFieldName = columnsIniBinFieldName;
        this.prevTableValueConverter = tableValuesConverter;
    }

    @Override
    public void migrateTune(TuneMigrationContext context) {
        Optional<IniField> prevField = context.getPrevIniFile().findIniField(this.tableFieldName);
        if (!prevField.isPresent()) {
            return;
        }
        Optional<IniField> updatedField = context.getUpdatedIniFile().findIniField(this.tableFieldName);
        if (!updatedField.isPresent()) {
            return;
        }
        Optional<ArrayIniField> prevArrayIniField = this.getValidatedTableArrayIniField(prevField.get(), context.getCallbacks());
        Optional<ArrayIniField> updatedArrayIniField = this.getValidatedTableArrayIniField(updatedField.get(), context.getCallbacks());
        if (prevArrayIniField.isPresent() && updatedArrayIniField.isPresent()) {
            Optional<String[][]> migratedValues;
            Optional<String[][]> convertedPrevValues;
            ArrayIniField prevTableField = prevArrayIniField.get();
            int prevTableFieldCols = prevTableField.getCols();
            ArrayIniField updatedTableField = updatedArrayIniField.get();
            int updatedTableFieldCols = updatedTableField.getCols();
            Constant prevValue = context.getPrevTune().getConstantsAsMap().get(this.tableFieldName);
            if (prevValue != null && (convertedPrevValues = this.prevTableValueConverter.convertTableValues(prevTableField.getValues(prevValue.getValue()), context)).isPresent() && (migratedValues = this.tryMigrateTable(prevTableField, updatedTableField, convertedPrevValues.get(), context.getCallbacks())).isPresent()) {
                context.addMigration(this.tableFieldName, new Constant(this.tableFieldName, updatedTableField.getUnits(), updatedTableField.formatValue(migratedValues.get()), updatedTableField.getDigits(), Integer.toString(updatedTableField.getRows()), Integer.toString(updatedTableFieldCols)));
            }
            this.migrateBins(context, prevTableFieldCols, updatedTableFieldCols);
        }
    }

    private void migrateBins(TuneMigrationContext context, int prevBinsCount, int updatedBinsCount) {
        Constant prevValue = context.getPrevTune().getConstantsAsMap().get(this.columnsBinFieldName);
        if (prevValue != null) {
            Optional<IniField> prevField = context.getPrevIniFile().findIniField(this.columnsBinFieldName);
            if (!prevField.isPresent()) {
                context.getCallbacks().logLine(String.format("WARNING!!! Missed `%s` ini field in previous .ini file.", this.columnsBinFieldName));
                return;
            }
            Optional<IniField> updatedField = context.getUpdatedIniFile().findIniField(this.columnsBinFieldName);
            if (!updatedField.isPresent()) {
                context.getCallbacks().logLine(String.format("WARNING!!! Missed `%s` ini field in updated .ini file.", this.columnsBinFieldName));
                return;
            }
            ArrayIniField updatedBinsField = (ArrayIniField)updatedField.get();
            Optional<String> migratedValue = new BinsIniFieldMigratorStrategy(this.columnsBinFieldName, prevBinsCount, updatedBinsCount).tryMigrateBins(prevField.get(), updatedBinsField, prevValue.getValue(), context.getCallbacks());
            if (migratedValue.isPresent()) {
                context.addMigration(this.columnsBinFieldName, new Constant(this.columnsBinFieldName, updatedBinsField.getUnits(), migratedValue.get(), updatedBinsField.getDigits(), Integer.toString(updatedBinsField.getRows()), Integer.toString(updatedBinsField.getCols())));
            }
        }
    }

    private Optional<String[][]> tryMigrateTable(ArrayIniField prevField, ArrayIniField newField, String[][] prevValues, UpdateOperationCallbacks callbacks) {
        Optional<String[][]> result = Optional.empty();
        int tableFieldRows = prevField.getRows();
        if (newField.getRows() == tableFieldRows) {
            int newTableFieldCols;
            int prevTableFieldCols = prevField.getCols();
            if (prevTableFieldCols < (newTableFieldCols = newField.getCols())) {
                String[][] newValues = new String[tableFieldRows][newTableFieldCols];
                for (int rowIdx = 0; rowIdx < tableFieldRows; ++rowIdx) {
                    int colIdx;
                    for (colIdx = 0; colIdx < prevTableFieldCols; ++colIdx) {
                        newValues[rowIdx][colIdx] = prevValues[rowIdx][colIdx];
                    }
                    for (colIdx = prevTableFieldCols; colIdx < newTableFieldCols; ++colIdx) {
                        newValues[rowIdx][colIdx] = prevValues[rowIdx][prevTableFieldCols - 1];
                    }
                }
                result = Optional.of(newValues);
            }
        } else {
            callbacks.logLine(String.format("WARNING! New `%s` ini-field is expected to contain %d rows as prev ini-field does", this.tableFieldName, tableFieldRows));
        }
        return result;
    }

    private Optional<ArrayIniField> getValidatedTableArrayIniField(IniField field, UpdateOperationCallbacks callbacks) {
        if (!(field instanceof ArrayIniField)) {
            callbacks.logLine(String.format("WARNING! `%s` ini-field is expected to be `ArrayIniField` instead of %s", this.tableFieldName, field.getClass().getName()));
            return Optional.empty();
        }
        ArrayIniField arrayField = (ArrayIniField)field;
        FieldType arrayFieldType = arrayField.getType();
        if (arrayFieldType != this.tableFieldType) {
            callbacks.logLine(String.format("WARNING! `%s` ini-field is expected to be `%s` instead of `%s`", new Object[]{this.tableFieldName, this.tableFieldType, arrayFieldType}));
            return Optional.empty();
        }
        return Optional.of(arrayField);
    }

    private static class RetainTableValuesConverter
    implements TableValuesConverter {
        static RetainTableValuesConverter INSTANCE = new RetainTableValuesConverter();

        private RetainTableValuesConverter() {
        }

        @Override
        public Optional<String[][]> convertTableValues(String[][] prevValues, TuneMigrationContext context) {
            return Optional.of(prevValues);
        }
    }
}

