/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import com.rusefi.core.FileUtil;
import com.rusefi.core.Pair;
import com.rusefi.core.RusEfiSignature;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URL;

public class SignatureHelper {
    private static final String LOCAL_INI = FileUtil.RUSEFI_SETTINGS_FOLDER + File.separator + "ini_database";
    private static final String PREFIX = "rusEFI ";
    private static final char SLASH = '/';

    public static Pair<String, String> getUrl(String signature) {
        RusEfiSignature s = SignatureHelper.parse(signature);
        if (s == null) {
            return null;
        }
        String fileName = s.getHash() + ".ini";
        return new Pair<CallSite, CallSite>((CallSite)((Object)("https://rusefi.com/online/ini/rusefi/" + s.getBranch() + "/" + s.getYear() + "/" + s.getMonth() + "/" + s.getDay() + "/" + s.getBundleTarget() + "/" + fileName)), (CallSite)((Object)fileName));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String downloadIfNotAvailable(Pair<String, String> p) {
        if (p == null) {
            return null;
        }
        new File(LOCAL_INI).mkdirs();
        String localIniFile = LOCAL_INI + File.separator + (String)p.second;
        File file = new File(localIniFile);
        if (file.exists() && file.length() > 10000L) {
            return localIniFile;
        }
        try (BufferedInputStream in = new BufferedInputStream(new URL((String)p.first).openStream());){
            String string;
            try (FileOutputStream fileOutputStream = new FileOutputStream(localIniFile);){
                int bytesRead;
                byte[] dataBuffer = new byte[32768];
                while ((bytesRead = in.read(dataBuffer, 0, dataBuffer.length)) != -1) {
                    fileOutputStream.write(dataBuffer, 0, bytesRead);
                }
                string = localIniFile;
            }
            return string;
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public static RusEfiSignature parse(String signature) {
        if (signature == null || !signature.startsWith(PREFIX)) {
            return null;
        }
        String[] elements = (signature = signature.substring(PREFIX.length()).trim()).split("\\.");
        if (elements.length != 6) {
            return null;
        }
        String branch = elements[0];
        String year = elements[1];
        String month = elements[2];
        String day = elements[3];
        String bundleTarget = elements[4];
        String hash = elements[5];
        return new RusEfiSignature(branch, year, month, day, bundleTarget, hash);
    }
}

