/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io;

import com.rusefi.core.MessagesCentral;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.io.ConnectionStatusValue;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

public class ConnectionStatusLogic {
    @NotNull
    private ConnectionStatusValue value = ConnectionStatusValue.NOT_CONNECTED;
    public static final ConnectionStatusLogic INSTANCE = new ConnectionStatusLogic();
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    public void executeOnceConnected(Runnable r) {
        if (this.isConnected()) {
            r.run();
        } else {
            this.addListener(isConnected -> {
                if (this.getValue() == ConnectionStatusValue.CONNECTED) {
                    r.run();
                }
            });
        }
    }

    private ConnectionStatusLogic() {
        SensorCentral.getInstance().addListener(Sensor.SECONDS, value -> this.markConnected());
        MessagesCentral.getInstance().addListener(new MessagesCentral.MessageListener(){

            @Override
            public void onMessage(Class clazz, String message) {
                if (message.startsWith("CRITICAL")) {
                    ConnectionStatusLogic.this.markConnected();
                }
            }
        });
    }

    public void markConnected() {
        if (this.value == ConnectionStatusValue.NOT_CONNECTED) {
            this.setValue(ConnectionStatusValue.LOADING);
        }
    }

    public void setValue(@NotNull ConnectionStatusValue value) {
        if (value == this.value) {
            return;
        }
        this.value = value;
        for (Listener listener : this.listeners) {
            listener.onConnectionStatus(this.isConnected());
        }
    }

    public boolean isConnected() {
        return this.value != ConnectionStatusValue.NOT_CONNECTED;
    }

    @NotNull
    public ConnectionStatusValue getValue() {
        return this.value;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void onConnectionStatus(boolean var1);
    }
}

