/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.rusefi.FileLog;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.maintenance.DfuFlasher;
import com.rusefi.maintenance.ProgramSelector;
import com.rusefi.maintenance.UpdateStatusWindow;
import com.rusefi.ui.LogoHelper;
import com.rusefi.ui.util.HorizontalLine;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.ToolButtons;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.putgemin.VerticalFlowLayout;

public class BasicStartupFrame {
    private final FrameHelper frame;

    public static void runTool(String[] args) {
        new BasicStartupFrame().runTool();
    }

    public BasicStartupFrame() {
        String title = "rusEFI basic console 20240227";
        this.frame = FrameHelper.createFrame(title);
        JPanel panel = new JPanel(new VerticalFlowLayout());
        if (FileLog.isWindows()) {
            panel.add(ToolButtons.createShowDeviceManagerButton());
            JButton update = ProgramSelector.createUpdateFirmwareButton();
            update.addActionListener(e -> DfuFlasher.doAutoDfu(update, "auto", new UpdateStatusWindow("Update")));
            panel.add(update);
        } else {
            panel.add(new JLabel("Sorry only works on Windows"));
        }
        panel.add(new HorizontalLine());
        JLabel logoLabel = LogoHelper.createLogoLabel();
        if (logoLabel != null) {
            panel.add(logoLabel);
        }
        panel.add(LogoHelper.createUrlLabel());
        this.frame.showFrame(panel, false);
        UiUtils.centerWindow(this.frame.getFrame());
    }

    private void runTool() {
    }
}

