/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.devexperts.logging.Logging;
import com.rusefi.core.io.BundleUtil;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.ui.util.URLLabel;
import java.awt.Cursor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogoHelper {
    private static final Logging log = Logging.getLogging(LogoHelper.class);
    public static final String LINK_TEXT = "rusEFI (c) 2012-2025";
    public static final String URI = "http://rusefi.com/?java_console";

    public static JLabel createLogoLabel() {
        ImageIcon logoIcon = LogoHelper.getBundleSpecificIcon();
        if (logoIcon == null) {
            return null;
        }
        JLabel logo = new JLabel(logoIcon);
        logo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        URLLabel.addUrlAction(logo, URLLabel.createUri(URI));
        logo.setCursor(new Cursor(12));
        return logo;
    }

    @Nullable
    public static ImageIcon getBundleSpecificIcon() {
        String bundle = BundleUtil.readBundleFullNameNotNull().getTarget();
        String logoName = bundle.contains("proteus") ? "/com/rusefi/logo_proteus.png" : (bundle.contains("alphax") ? "/com/rusefi/logo_alphax.png" : (bundle.contains(".mre") ? "/com/rusefi/logo_mre.png" : "/com/rusefi/logo.png"));
        ImageIcon imageIcon = AutoupdateUtil.loadIcon(logoName);
        log.info(imageIcon + " for " + logoName);
        return imageIcon;
    }

    @NotNull
    public static URLLabel createUrlLabel() {
        return new URLLabel(LINK_TEXT, URI);
    }
}

