/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.can.isotp;

import com.devexperts.logging.Logging;
import com.rusefi.util.HexBinary;
import java.util.Arrays;

public class IsoTpCanDecoder {
    public static final byte[] FLOW_CONTROL = new byte[]{48, 0, 0, 0, 0, 0, 0, 0};
    private static final Logging log = Logging.getLogging(IsoTpCanDecoder.class);
    private static final int ISO_TP_FRAME_FLOW_CONTROL = 3;
    private static final int FC_ContinueToSend = 0;
    private final int isoHeaderByteIndex;
    private int waitingForNumBytes = 0;
    private int waitingForFrameIndex = 0;

    public IsoTpCanDecoder() {
        this(0);
    }

    public IsoTpCanDecoder(int isoHeaderByteIndex) {
        this.isoHeaderByteIndex = isoHeaderByteIndex;
    }

    public byte[] decodePacket(byte[] data) {
        int dataOffset;
        int numBytesAvailable;
        int frameType = data[this.isoHeaderByteIndex] >> 4 & 0xF;
        switch (frameType) {
            case 0: {
                numBytesAvailable = data[this.isoHeaderByteIndex] & 0xF;
                dataOffset = this.isoHeaderByteIndex + 1;
                this.waitingForNumBytes = 0;
                if (!log.debugEnabled()) break;
                log.debug("ISO_TP_FRAME_SINGLE " + numBytesAvailable);
                break;
            }
            case 1: {
                this.waitingForNumBytes = (data[this.isoHeaderByteIndex] & 0xF) << 8 | data[this.isoHeaderByteIndex + 1];
                if (log.debugEnabled()) {
                    log.debug("Total expected: " + this.waitingForNumBytes);
                }
                this.waitingForFrameIndex = 1;
                numBytesAvailable = Math.min(this.waitingForNumBytes, 6 - this.isoHeaderByteIndex);
                this.waitingForNumBytes -= numBytesAvailable;
                dataOffset = this.isoHeaderByteIndex + 2;
                this.onTpFirstFrame();
                break;
            }
            case 2: {
                int frameIdx = data[this.isoHeaderByteIndex] & 0xF;
                if (this.waitingForNumBytes < 0 || this.waitingForFrameIndex != frameIdx) {
                    throw new IllegalStateException("ISO_TP_FRAME_CONSECUTIVE: That's an abnormal situation, and we probably should react? waitingForNumBytes=" + this.waitingForNumBytes + " waitingForFrameIndex=" + this.waitingForFrameIndex + " frameIdx=" + frameIdx);
                }
                this.waitingForFrameIndex = this.waitingForFrameIndex + 1 & 0xF;
                numBytesAvailable = Math.min(this.waitingForNumBytes, 7 - this.isoHeaderByteIndex);
                dataOffset = this.isoHeaderByteIndex + 1;
                this.waitingForNumBytes -= numBytesAvailable;
                if (!log.debugEnabled()) break;
                log.debug("ISO_TP_FRAME_CONSECUTIVE Got " + numBytesAvailable + " byte(s), still expecting: " + this.waitingForNumBytes + " byte(s)");
                break;
            }
            case 3: {
                int flowStatus = data[this.isoHeaderByteIndex] & 0xF;
                byte blockSize = data[this.isoHeaderByteIndex + 1];
                byte separationTime = data[this.isoHeaderByteIndex + 2];
                if (flowStatus == 0 && blockSize == 0 && separationTime == 0) {
                    return new byte[0];
                }
                throw new IllegalStateException("ISO_TP_FRAME_FLOW_CONTROL: should we just ignore the FC frame? " + flowStatus + " " + blockSize + " " + separationTime);
            }
            default: {
                throw new IllegalStateException("Unknown frame type");
            }
        }
        byte[] bytes = Arrays.copyOfRange(data, dataOffset, dataOffset + numBytesAvailable);
        if (log.debugEnabled()) {
            log.debug(numBytesAvailable + " bytes(s) arrived in this packet: " + HexBinary.printByteArray(bytes));
        }
        return bytes;
    }

    protected void onTpFirstFrame() {
    }

    static {
        log.configureDebugEnabled(false);
    }
}

