/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration;

import com.devexperts.logging.Logging;
import com.rusefi.CompatibilitySet;
import com.rusefi.config.FieldType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class IniFieldMigrationUtils {
    private static final Logging log = Logging.getLogging(IniFieldMigrationUtils.class);
    private static final List<Set<String>> UNITS_SYNONYMS = Arrays.asList(CompatibilitySet.of("%", "percent"), CompatibilitySet.of("deg c", "c"), CompatibilitySet.of("voltage", "volts"));

    public static boolean checkIfTypeCanBeMigrated(FieldType prevType, FieldType newType) {
        if (Objects.equals((Object)prevType, (Object)newType)) {
            return true;
        }
        switch (prevType) {
            case INT8: {
                switch (newType) {
                    case INT16: 
                    case INT: 
                    case FLOAT: {
                        return true;
                    }
                }
            }
            case INT16: {
                switch (newType) {
                    case INT: 
                    case FLOAT: {
                        return true;
                    }
                }
            }
            case UINT8: {
                switch (newType) {
                    case INT16: 
                    case INT: 
                    case FLOAT: 
                    case UINT16: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean checkIfUnitsCanBeMigrated(@Nullable String prevUnits, @Nullable String newUnits) {
        if (prevUnits == null || prevUnits.isEmpty()) {
            return true;
        }
        if (newUnits != null) {
            String lcNewUnits;
            String lcPrevUnits = prevUnits.toLowerCase();
            if (lcPrevUnits.equals(lcNewUnits = prevUnits.toLowerCase())) {
                return true;
            }
            for (Set<String> synonyms : UNITS_SYNONYMS) {
                if (!synonyms.contains(lcPrevUnits) || !synonyms.contains(lcNewUnits)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkIfDigitsCanBeMigrated(String prevDigits, String newDigits, String name) {
        int newDecimalCount;
        if (Objects.equals(prevDigits, newDigits)) {
            return true;
        }
        if (prevDigits == null) {
            log.warn(name + " no prevDigits");
            return false;
        }
        if (newDigits == null) {
            log.warn(name + " no newDigits");
            return false;
        }
        int prevDecimalCount = Integer.parseInt(prevDigits);
        return prevDecimalCount <= (newDecimalCount = Integer.parseInt(newDigits));
    }
}

