/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.rusefi.AutotestLogging;
import com.rusefi.FileLog;
import com.rusefi.SimulatorExecHelper;
import com.rusefi.core.EngineState;
import com.rusefi.core.ISensorCentral;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.enums.trigger_type_e;
import com.rusefi.io.CommandQueue;
import com.rusefi.io.ConnectionStateListener;
import com.rusefi.io.LinkManager;
import com.rusefi.io.tcp.TcpConnector;
import com.rusefi.waves.EngineReport;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class IoUtil {
    private static final Logging log = Logging.getLogging(IoUtil.class);

    static void sendBlockingCommand(String command, CommandQueue commandQueue) {
        IoUtil.sendBlockingCommand(command, CommandQueue.DEFAULT_TIMEOUT, commandQueue);
    }

    public static String getSetCommand(String settingName) {
        return "set " + settingName;
    }

    public static String getEnableCommand(String settingName) {
        return "enable " + settingName;
    }

    public static String getDisableCommand(String settingName) {
        return "disable " + settingName;
    }

    public static void sendBlockingCommand(String command, int timeoutMs, CommandQueue commandQueue) {
        CountDownLatch responseLatch = new CountDownLatch(1);
        long time = System.currentTimeMillis();
        log.info("Sending command [" + command + "]");
        long begin = System.currentTimeMillis();
        commandQueue.write(command, timeoutMs, () -> {
            responseLatch.countDown();
            log.info("Got confirmation in " + (System.currentTimeMillis() - begin) + "ms");
        });
        IoUtil.wait(responseLatch, timeoutMs);
        if (responseLatch.getCount() > 0L) {
            log.info("No confirmation in " + timeoutMs);
        }
        log.info("Command [" + command + "] executed in " + (System.currentTimeMillis() - time));
    }

    static void wait(CountDownLatch responseLatch, int milliseconds) {
        try {
            responseLatch.await(milliseconds, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void changeRpm(CommandQueue commandQueue, int rpm) {
        log.info("AUTOTEST rpm EN " + rpm);
        IoUtil.sendBlockingCommand("rpm " + rpm, commandQueue);
        long time = System.currentTimeMillis();
        IoUtil.awaitRpm(rpm);
        double actualRpm = SensorCentral.getInstance().getValue(Sensor.RPMValue);
        if (!EngineReport.isCloseEnough(rpm, actualRpm)) {
            throw new IllegalStateException("rpm change did not happen: " + rpm + ", actual " + actualRpm);
        }
        log.info("AUTOTEST RPM change [" + rpm + "] executed in " + (System.currentTimeMillis() - time));
    }

    public static void awaitRpm(int rpm) {
        CountDownLatch rpmLatch = new CountDownLatch(1);
        ISensorCentral.ListenerToken listenerToken = SensorCentral.getInstance().addListener(Sensor.RPMValue, actualRpm -> {
            if (EngineReport.isCloseEnough(rpm, actualRpm)) {
                rpmLatch.countDown();
            }
        });
        try {
            rpmLatch.await(40L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        listenerToken.remove();
    }

    private static void waitForFirstResponse() throws InterruptedException {
        CountDownLatch startup = new CountDownLatch(1);
        long waitStart = System.currentTimeMillis();
        ISensorCentral.ListenerToken listener = SensorCentral.getInstance().addListener(Sensor.RPMValue, value -> startup.countDown());
        boolean haveResponse = startup.await(60L, TimeUnit.SECONDS);
        if (!haveResponse) {
            throw new IllegalStateException("No response from simulator");
        }
        listener.remove();
        AutotestLogging.INSTANCE.logLine("Got first signal in " + (System.currentTimeMillis() - waitStart) + "ms");
    }

    public static void connectToSimulator(LinkManager linkManager, boolean startProcess) throws InterruptedException {
        if (startProcess) {
            if (FileLog.isWindows() && !TcpConnector.getAvailablePorts().isEmpty()) {
                throw new IllegalStateException("Port already binded on startup?");
            }
            SimulatorExecHelper.startSimulator();
        }
        linkManager.startAndConnect("29001", ConnectionStateListener.VOID);
        linkManager.getEngineState().registerStringValueAction("rusEfiVersion", EngineState.ValueCallback.VOID);
        IoUtil.waitForFirstResponse();
    }

    public static void sleepSeconds(int seconds) {
        AutotestLogging.INSTANCE.logLine("Sleeping " + seconds + " seconds");
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void realHardwareConnect(LinkManager linkManager, String port) {
        linkManager.getEngineState().registerStringValueAction("outpin", EngineState.ValueCallback.VOID);
        try {
            linkManager.connect(port, false).await(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Not connected in time");
        }
    }

    @NotNull
    public static String setTriggerType(trigger_type_e triggerType) {
        return "set trigger_type " + triggerType.ordinal();
    }
}

