/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractLinear;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.Orientation;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;

public abstract class AbstractLinearBargraph
extends AbstractLinear {
    public ColorDef getBarGraphColor() {
        return this.getModel().getValueColor();
    }

    public void setBarGraphColor(ColorDef colorDef) {
        this.getModel().setValueColor(colorDef);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Color getCustomBargraphColor() {
        return this.getModel().getCustomValueColor();
    }

    public void setCustomBarGraphColor(Color color) {
        this.getModel().setCustomValueColorObject(new CustomColorDef(color));
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public CustomColorDef getCustomBarGraphColorObject() {
        return this.getModel().getCustomValueColorObject();
    }

    public boolean isPeakValueEnabled() {
        return this.getModel().isPeakValueVisible();
    }

    public void setPeakValueEnabled(boolean bl) {
        this.getModel().setPeakValueVisible(bl);
    }

    protected BufferedImage create_BARGRAPH_LED_Image(int n, int n2, ColorDef colorDef, Color[] colorArray) {
        float f;
        int n3;
        int n4;
        if (n <= 20 || n2 <= 20) {
            return UTIL.createImage(1, 1, 3);
        }
        if (this.getOrientation() == Orientation.VERTICAL) {
            n4 = (int)((double)n * 0.1214285714);
            n3 = (int)((double)n2 * 0.0121359223);
        } else {
            n3 = (int)((double)n * 0.0121359223);
            n4 = (int)((double)n2 * 0.1214285714);
        }
        BufferedImage bufferedImage = UTIL.createImage(n4, n3, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n4, n3);
        Point2D.Double double_2 = new Point2D.Double(double_.getCenterX(), double_.getCenterY());
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray2 = colorArray != null && colorArray.length == 2 ? colorArray : new Color[]{colorDef.LIGHT, colorDef.DARK};
        switch (this.getOrientation()) {
            default: {
                f = (float)(((RectangularShape)double_).getWidth() / 2.0);
                break;
            }
            case HORIZONTAL: {
                f = (float)(((RectangularShape)double_).getHeight() / 2.0);
            }
        }
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_2, f, fArray, colorArray2);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_);
        graphics2D.dispose();
        return bufferedImage;
    }
}

