/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.NotYetBoundException;
import tel.schich.javacan.IsotpCanChannel;
import tel.schich.javacan.IsotpSocketAddress;
import tel.schich.javacan.NetworkDevice;
import tel.schich.javacan.SocketCAN;
import tel.schich.javacan.platform.linux.LinuxNativeOperationException;
import tel.schich.javacan.platform.linux.LinuxNetworkDevice;

final class IsotpCanChannelImpl
extends IsotpCanChannel {
    private NetworkDevice device;
    private IsotpSocketAddress rx;
    private IsotpSocketAddress tx;

    public IsotpCanChannelImpl(int sock) {
        super(sock);
    }

    @Override
    public synchronized IsotpCanChannel bind(NetworkDevice device, IsotpSocketAddress rx, IsotpSocketAddress tx) throws IOException {
        if (this.isBound()) {
            throw new AlreadyBoundException();
        }
        if (!(device instanceof LinuxNetworkDevice)) {
            throw new IllegalArgumentException("Unsupported network device given!");
        }
        try {
            SocketCAN.bindSocket(this.getSocket(), ((LinuxNetworkDevice)device).getIndex(), rx.getId(), tx.getId());
        }
        catch (LinuxNativeOperationException e) {
            throw IsotpCanChannelImpl.checkForClosedChannel(e);
        }
        this.device = device;
        this.rx = rx;
        this.tx = tx;
        return this;
    }

    @Override
    public synchronized boolean isBound() {
        return this.device != null;
    }

    @Override
    public synchronized NetworkDevice getDevice() {
        if (!this.isBound()) {
            throw new NotYetBoundException();
        }
        return this.device;
    }

    @Override
    public synchronized IsotpSocketAddress getRxAddress() {
        if (!this.isBound()) {
            throw new NotYetBoundException();
        }
        return this.rx;
    }

    @Override
    public synchronized IsotpSocketAddress getTxAddress() {
        if (!this.isBound()) {
            throw new NotYetBoundException();
        }
        return this.tx;
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        long bytesRead = this.readSocket(buffer);
        return (int)bytesRead;
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException {
        if (buffer.remaining() > 4095) {
            throw new IllegalArgumentException("Message too long!");
        }
        long bytesRead = this.writeSocket(buffer);
        return (int)bytesRead;
    }
}

