/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io;

import com.devexperts.logging.Logging;
import com.opensr5.io.DataListener;
import com.rusefi.io.serial.AbstractIoStream;
import com.rusefi.io.tcp.BinaryProtocolServer;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public interface ByteReader {
    public static final Logging log = Logging.getLogging(ByteReader.class);

    public static void runReaderLoop(String loggingPrefix, DataListener listener, ByteReader reader, AbstractIoStream ioStream) {
        ExecutorService threadExecutor = Executors.newSingleThreadExecutor(BinaryProtocolServer.getThreadFactory(loggingPrefix + "TCP reader"));
        threadExecutor.execute(() -> {
            log.info(loggingPrefix + "Running TCP connection loop");
            byte[] inputBuffer = new byte[65536];
            while (!ioStream.isClosed()) {
                try {
                    int result = reader.read(inputBuffer);
                    if (result == -1) {
                        throw new IOException("TcpIoStream: End of input?");
                    }
                    listener.onDataArrived(Arrays.copyOf(inputBuffer, result));
                }
                catch (IOException e) {
                    log.error("TcpIoStream: End of connection " + e);
                    ioStream.close();
                    return;
                }
            }
        });
    }

    public int read(byte[] var1) throws IOException;
}

