/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration;

import com.devexperts.logging.Logging;
import com.opensr5.ini.field.ArrayIniField;
import com.rusefi.CompatibilitySet;
import com.rusefi.config.FieldType;
import com.rusefi.tune.xml.Constant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class IniFieldMigrationUtils {
    private static final Logging log = Logging.getLogging(IniFieldMigrationUtils.class);
    private static final List<Set<String>> UNITS_SYNONYMS = Arrays.asList(CompatibilitySet.of("%", "percent"), CompatibilitySet.of("deg c", "c"), CompatibilitySet.of("voltage", "volts"));

    public static boolean checkIfTypeCanBeMigrated(FieldType prevType, FieldType newType) {
        if (Objects.equals((Object)prevType, (Object)newType)) {
            return true;
        }
        return prevType.isNumeric() && newType.isNumeric();
    }

    public static boolean checkIfUnitsCanBeMigrated(@Nullable String prevUnits, @Nullable String newUnits) {
        if (prevUnits == null || prevUnits.isEmpty()) {
            return true;
        }
        if (newUnits != null) {
            String lcNewUnits;
            String lcPrevUnits = prevUnits.toLowerCase();
            if (lcPrevUnits.equals(lcNewUnits = prevUnits.toLowerCase())) {
                return true;
            }
            for (Set<String> synonyms : UNITS_SYNONYMS) {
                if (!synonyms.contains(lcPrevUnits) || !synonyms.contains(lcNewUnits)) continue;
                return true;
            }
        }
        return false;
    }

    public static Constant generateConstant(ArrayIniField iniField, String value) {
        return new Constant(iniField.getName(), iniField.getUnits(), value, iniField.getDigits(), String.valueOf(iniField.getRows()), String.valueOf(iniField.getCols()));
    }
}

