/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.opensr5.ini.field.EnumIniField;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.migration.IniFieldMigrationUtils;
import java.util.Optional;
import javax.management.ObjectName;

public enum DefaultEnumIniFieldMigrator {
    INSTANCE;


    public Optional<String> tryMigrateValue(EnumIniField prevField, EnumIniField newField, String prevValue, UpdateOperationCallbacks callbacks) {
        Optional<String> result = Optional.empty();
        if (!IniFieldMigrationUtils.checkIfTypeCanBeMigrated(prevField.getType(), newField.getType())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because type is updated: `%s` -> `%s`", new Object[]{prevField.getName(), prevField.getType(), newField.getType()}));
        } else {
            EnumIniField.EnumKeyValueMap newFieldKeyValues = newField.getEnums();
            if (newFieldKeyValues.indexOf(prevValue) == -1) {
                if (newFieldKeyValues.isBitField()) {
                    int prevValueOrdinal = prevField.getEnums().indexOf(prevValue);
                    String migratedValue = newFieldKeyValues.get(prevValueOrdinal);
                    if (migratedValue != null) {
                        result = Optional.of(ObjectName.quote(migratedValue));
                    } else {
                        callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because of internal error: new enum doesn't value with ordinal %d", prevField.getName(), prevValueOrdinal));
                    }
                } else {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because value `%s` has disappeared", prevField.getName(), prevValue));
                }
            } else {
                result = Optional.of(prevValue);
            }
        }
        return result;
    }
}

