/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.maintenance.migration.IniFieldMigrationUtils;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.IdleCurveMigrator;
import com.rusefi.maintenance.migration.migrators.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Optional;

public enum MultiplierToTableMigrator implements TuneMigrator
{
    INSTANCE;

    private static final Mapping[] mappings;

    @Override
    public void migrateTune(TuneMigrationContext context) {
        for (Mapping m : mappings) {
            MultiplierToTableMigrator.migrate(context, m);
        }
    }

    private static void migrate(TuneMigrationContext context, Mapping mapping) {
        Optional<IniField> prevMultiplier = context.getPrevIniFile().findIniField(mapping.multiplierFieldName);
        Optional<IniField> updatedMultiplier = context.getUpdatedIniFile().findIniField(mapping.multiplierFieldName);
        Optional<IniField> prevTable = context.getPrevIniFile().findIniField(mapping.tableFieldName);
        Optional<IniField> updatedTable = context.getUpdatedIniFile().findIniField(mapping.updatedFieldName);
        if (!prevMultiplier.isPresent() || updatedMultiplier.isPresent() || !prevTable.isPresent() || !updatedTable.isPresent()) {
            return;
        }
        Constant prevTableConst = context.getPrevTune().getConstantsAsMap().get(mapping.tableFieldName);
        Constant updatedTableConst = context.getUpdatedTune().getConstantsAsMap().get(mapping.updatedFieldName);
        Constant prevMultiplierConst = context.getPrevTune().getConstantsAsMap().get(mapping.multiplierFieldName);
        if (prevTableConst == null || updatedTableConst == null || prevMultiplierConst == null) {
            return;
        }
        ArrayIniField updatedTableField = (ArrayIniField)updatedTable.get();
        String[][] migratedValues = updatedTableField.getValues(prevTableConst.getValue());
        double multiplier = Double.parseDouble(prevMultiplierConst.getValue());
        for (int row = 0; row < migratedValues.length; ++row) {
            for (int column = 0; column < migratedValues[0].length; ++column) {
                double value = Double.parseDouble(migratedValues[row][column]) * multiplier;
                migratedValues[row][column] = MultiplierToTableMigrator.formatArrayValue(value, updatedTableField.getDigits());
            }
        }
        context.addMigration(mapping.updatedFieldName, IniFieldMigrationUtils.generateConstant(updatedTableField, updatedTableField.formatValue(migratedValues)));
    }

    private static String formatArrayValue(double value, String digits) {
        return IdleCurveMigrator.formatArrayValue(value, digits);
    }

    static {
        mappings = new Mapping[]{new Mapping("crankingIACposition", "cltCrankingCorr", "cltCrankingCorr"), new Mapping("cranking_baseFuel", "crankingCycleFuelCoef", "crankingCycleBaseFuel")};
    }

    private static final class Mapping {
        private final String multiplierFieldName;
        private final String tableFieldName;
        private final String updatedFieldName;

        private Mapping(String multiplierFieldName, String tableFieldName, String updatedFieldName) {
            this.multiplierFieldName = multiplierFieldName;
            this.tableFieldName = tableFieldName;
            this.updatedFieldName = updatedFieldName;
        }
    }
}

