/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.tune_manifest;

import com.devexperts.logging.Logging;
import com.rusefi.core.FileUtil;
import com.rusefi.tune_manifest.TuneModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class TuneManifestHelper {
    private static final Logging log = Logging.getLogging(TuneManifestHelper.class);
    private static final String HTTPS = "https";
    private static final String LESS_SAFE_SYMBOLS = "[^a-zA-Z0-9_-]";
    static final String LOCAL_CACHE = FileUtil.RUSEFI_SETTINGS_FOLDER + "tune_manifest" + File.separator;
    static final String MANIFEST_FILE_NAME = "manifest.json";

    static String trimUrlToLocalName(String url) {
        if (url.startsWith(HTTPS)) {
            url = url.substring(HTTPS.length());
        }
        return url.replaceAll(LESS_SAFE_SYMBOLS, "");
    }

    @Nullable
    static String downloadFile(String baseUrl, String fullFileUrl, String localFileName) throws IOException {
        String localFolderForSpecificUrl = TuneManifestHelper.getLocalFolder(baseUrl);
        String fullLocalFileName = localFolderForSpecificUrl + localFileName;
        URL url = new URL(fullFileUrl);
        try (InputStream in = url.openStream();){
            Files.copy(in, Paths.get(fullLocalFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            log.info("File downloaded successfully to " + fullLocalFileName);
        }
        catch (FileNotFoundException e) {
            log.error("File not found: " + fullFileUrl);
            return null;
        }
        return fullLocalFileName;
    }

    @NotNull
    public static String getLocalFolder(String baseUrl) {
        String localCacheForSpecificUrl = LOCAL_CACHE + TuneManifestHelper.trimUrlToLocalName(baseUrl) + File.separator;
        new File(localCacheForSpecificUrl).mkdirs();
        return localCacheForSpecificUrl;
    }

    static List<TuneModel> parseManifest(String localManifest) throws IOException, ParseException {
        ArrayList<TuneModel> tunes = new ArrayList<TuneModel>();
        try {
            JSONParser parser = new JSONParser();
            try (FileReader reader = new FileReader(localManifest);){
                Object obj = parser.parse(reader);
                JSONArray topLevelArray = (JSONArray)obj;
                for (int i = 0; i < topLevelArray.size(); ++i) {
                    JSONObject object = (JSONObject)topLevelArray.get(i);
                    tunes.add(TuneModel.parse(object));
                }
            }
            return tunes;
        }
        catch (ClassCastException e) {
            throw new IOException("JSON error " + e, e);
        }
    }

    public static void downloadAllTunes(String baseUrl, Callback callback) throws IOException, ParseException {
        String localManifest = TuneManifestHelper.downloadFile(baseUrl, baseUrl + MANIFEST_FILE_NAME, MANIFEST_FILE_NAME);
        List<TuneModel> tunes = TuneManifestHelper.parseManifest(localManifest);
        for (TuneModel t : tunes) {
            String localTuneName = t.getSaferLocalFileName();
            String localFile = TuneManifestHelper.downloadFile(baseUrl, t.getUrl(), localTuneName);
            t.setError(localFile == null);
        }
        callback.onDownloaded(tunes);
    }

    public static interface Callback {
        public void onDownloaded(List<TuneModel> var1);
    }
}

