/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.rusefi.ConnectivityContext;
import com.rusefi.PortResult;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.io.DoubleCallbacks;
import com.rusefi.maintenance.DfuFlasher;
import com.rusefi.maintenance.StatusAnimation;
import com.rusefi.tools.TunerStudioHelper;
import com.rusefi.ui.BasicLogoHelper;
import com.rusefi.ui.basic.BasicUpdaterPanel;
import com.rusefi.ui.basic.SingleAsyncJobExecutor;
import com.rusefi.ui.basic.TuneManagementTab;
import com.rusefi.ui.basic.UiHelper;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.StatusPanel;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class BasicStartupFrame {
    private final String whiteLabel = ConnectionAndMeta.getWhiteLabel(ConnectionAndMeta.getProperties());
    private final BasicUpdaterPanel basicUpdaterPanel;
    private final FrameHelper frame = FrameHelper.createFrame(this.whiteLabel + " basic console " + 20251118);
    private final StatusAnimation status;

    public static void main(String[] args) throws InterruptedException, InvocationTargetException {
        BasicStartupFrame.runTool(null);
    }

    public static void runTool(String[] args) throws InterruptedException, InvocationTargetException {
        UiHelper.commonUiStartup();
        SwingUtilities.invokeAndWait(() -> new BasicStartupFrame(ConnectivityContext.INSTANCE));
    }

    private BasicStartupFrame(ConnectivityContext connectivityContext) {
        DfuFlasher.dfuEnabledInCaseOfError = false;
        TunerStudioHelper.maybeCloseTs();
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel firmwareUpdateContent = new JPanel();
        StatusPanel statusPanelFirmwareTab = new StatusPanel(500);
        StatusPanel statusPanelTuneTab = new StatusPanel(250);
        SingleAsyncJobExecutor singleAsyncJobExecutor = new SingleAsyncJobExecutor(new DoubleCallbacks(statusPanelFirmwareTab, statusPanelTuneTab));
        AtomicReference<Optional<PortResult>> ecuPortToUse = new AtomicReference<Optional<PortResult>>(Optional.empty());
        this.basicUpdaterPanel = new BasicUpdaterPanel(connectivityContext, ConnectionAndMeta.isDefaultWhitelabel(this.whiteLabel), statusPanelFirmwareTab, singleAsyncJobExecutor, ecuPortToUse);
        firmwareUpdateContent.add(this.basicUpdaterPanel.getContent());
        firmwareUpdateContent.add(statusPanelFirmwareTab);
        connectivityContext.getSerialPortScanner().addListener(currentHardware -> SwingUtilities.invokeLater(() -> this.onHardwareUpdated()));
        tabbedPane.addTab("Firmware", firmwareUpdateContent);
        tabbedPane.addTab("Tunes", new TuneManagementTab(connectivityContext, ecuPortToUse, this.basicUpdaterPanel.getImportTuneButton().getContent(), singleAsyncJobExecutor, statusPanelTuneTab).getContent());
        BasicLogoHelper.setGenericFrameIcon(this.frame.getFrame());
        this.frame.showFrame(tabbedPane, false);
        UiUtils.centerWindow(this.frame.getFrame());
        this.packFrame();
        this.status = new StatusAnimation(this::updateStatus, "Scanning ports");
    }

    private void packFrame() {
        this.frame.getFrame().pack();
    }

    private void updateStatus(String niceStatus) {
        this.basicUpdaterPanel.updateStatus(niceStatus);
        this.packFrame();
    }

    public void onHardwareUpdated() {
        this.status.stop();
        this.basicUpdaterPanel.onHardwareUpdated();
        this.packFrame();
    }
}

