/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.util;

import com.rusefi.core.ui.ErrorMessageHelper;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class URLLabel
extends JLabel {
    private String text;

    public URLLabel(String text, URI uri) {
        this.setup(text, uri);
    }

    public URLLabel(String uri) {
        this(uri, uri);
    }

    public URLLabel(String text, String uri) {
        this.setup(text, URLLabel.createUri(uri));
    }

    public static URI createUri(String uri) {
        URI oURI;
        try {
            oURI = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return oURI;
    }

    public static void open(String url) {
        try {
            URLLabel.open(new URI(url));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setup(String t, URI u) {
        this.setCursor(new Cursor(12));
        this.text = t;
        this.setText(this.text);
        this.setToolTipText(u.toString());
        URLLabel.addUrlAction(this, u);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                URLLabel.this.setText(URLLabel.this.text, false);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                URLLabel.this.setText(URLLabel.this.text, true);
            }
        });
    }

    public static void addUrlAction(JComponent component, final URI u) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                URLLabel.open(u);
            }
        });
    }

    @Override
    public void setText(String text) {
        this.setText(text, true);
    }

    public void setText(String text, boolean ul) {
        String link = ul ? "<u>" + text + "</u>" : text;
        super.setText("<html><span style=\"color: #000099;\">" + link + "</span></html>");
        this.text = text;
    }

    public static void open(URI uri) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uri);
            }
            catch (IOException e) {
                ErrorMessageHelper.showErrorDialog("Failed to launch the link, your computer is likely misconfigured.", "Cannot Launch Link");
            }
        } else {
            ErrorMessageHelper.showErrorDialog("Java is not able to launch links on your computer.", "Cannot Launch Link");
        }
    }
}

